/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetLong
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_LONG;

    public SetLong() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getProperty("prop_file_string") != null) {
            String string = iSQLCommand.getSql();
            if (!string.matches("^(?i:set\\s+long)\\s+.*$")) {
                return false;
            }
            if ((string = string.trim().replaceAll("^(?i:set\\s+long)\\s+", "").trim()).startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            } else if (string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
            try {
                int n = new Integer(string);
                if (n < 1 || n > 2000000000) {
                    scriptRunnerContext.write("SP2-0267: long option -1 out of range (1 through 2000000000)\n");
                    return true;
                }
                scriptRunnerContext.putProperty("script.runner.setlong", new Integer(string));
            }
            catch (NumberFormatException numberFormatException) {
                scriptRunnerContext.write("SP2-0268: long option not a valid number\n");
                return true;
            }
        }
        return true;
    }
}

