/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetLinesize
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_LINESIZE;

    public SetLinesize() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql();
        String[] stringArray = string.split(" ");
        int n = 0;
        try {
            if (stringArray.length > 3) {
                n = Integer.parseInt(stringArray[2]);
            }
            if (stringArray.length != 3) {
                scriptRunnerContext.write("SP2-0267: linesize option 0 out of range (1 through 32767)\n ");
                return true;
            }
            n = Integer.parseInt(stringArray[2]);
            if (n <= 0 || n > Short.MAX_VALUE) {
                String string2 = ScriptRunnerDbArb.format("ZERO_LNSIZE", new Integer(n).toString());
                this.writeToMain(string2 + "\n", scriptRunnerContext);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            scriptRunnerContext.write("SP2-0268: linesize option not a valid number\n");
            return false;
        }
        scriptRunnerContext.putProperty("script.runner.setlinesize", n);
        return true;
    }

    public void writeToMain(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }
}

