/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetFeedBack
extends CommandListener {
    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)iSQLCommand.getProperty("prop_file_string");
        if (string != null) {
            if (string.equalsIgnoreCase("on")) {
                scriptRunnerContext.setFeedback(-1);
            } else if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                scriptRunnerContext.setFeedback(-2);
            } else {
                try {
                    int n = Integer.parseInt((String)iSQLCommand.getProperty("prop_file_string"));
                    if (n < 0 || n > 50000) {
                        this.writeToMain(MessageFormat.format(Messages.getString("SetFeedback.invalidRange") + "\n", new Integer(n)), scriptRunnerContext);
                        return false;
                    }
                    scriptRunnerContext.setFeedback(n);
                }
                catch (Exception exception) {
                    this.writeToMain(Messages.getString("SetFeedback.invalidValue") + "\n", scriptRunnerContext);
                    return false;
                }
            }
        }
        return true;
    }

    public void writeToMain(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }
}

