/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;

public class SetDDLSettings
extends CommandListener
implements IHelp,
IShowCommand,
IShowPrefixNameNewline {
    private static final Object DDL = "ddl";
    private static final Object ON = "on";
    private static final Object OFF = "off";

    @Override
    public String[] getShowAliases() {
        return new String[]{"DDL"};
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getDDLOptions() != null) {
            Set<String> set = scriptRunnerContext.getDDLOptions().keySet();
            if (scriptRunnerContext.getDDLOptions().get("DEFAULT").equals("ON")) {
                scriptRunnerContext.write("DEFAULT : ON\n");
            } else {
                for (String string : set) {
                    if (string.equals("DEFAULT")) continue;
                    scriptRunnerContext.write(MessageFormat.format("{0} : {1}\n", string, scriptRunnerContext.getDDLOptions().get(string)));
                }
            }
        }
        return true;
    }

    @Override
    public String getCommand() {
        return "DDL";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSQLOrig().toLowerCase().split("\\s+");
        int n = stringArray.length;
        if (n == 3 && stringArray[1].toLowerCase().equals(DDL) && stringArray[2].toLowerCase().equals(OFF)) {
            String string = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,'DEFAULT',true); end;";
            DBUtil dBUtil = DBUtil.getInstance(connection);
            dBUtil.execute(string);
            scriptRunnerContext.setDDLOptions("DEFAULT", "ON");
            scriptRunnerContext.write("DDL default generation reset\n");
            return true;
        }
        if (n == 4) {
            if (stringArray[1].toLowerCase().equals(DDL) && (stringArray[3].toLowerCase().equals(ON) || stringArray[3].toLowerCase().equals(OFF))) {
                String string = stringArray[3].toLowerCase().equals(ON) ? "true" : "false";
                String string2 = stringArray[2].toUpperCase();
                String string3 = "";
                string3 = string.equals("true") ? "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,true); end;" : "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,false); end;";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OPTION", string2);
                try {
                    DBUtil dBUtil = DBUtil.getInstance(connection);
                    dBUtil.execute(string3, hashMap);
                    scriptRunnerContext.write(MessageFormat.format("DDL Option {0} {1}\n", string2, stringArray[3].toLowerCase()));
                    scriptRunnerContext.setDDLOptions(string2, stringArray[3].toUpperCase());
                    if (stringArray[3].toUpperCase().equals("OFF")) {
                        scriptRunnerContext.setDDLOptions("DEFAULT", "OFF");
                    }
                }
                catch (Exception exception) {
                    scriptRunnerContext.write("Not a valid transdorm option\n");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

