/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadAPI;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.util.LogHandler;

public class LoadCommand
extends CommandListener
implements IHelp,
IShowCommand,
Connected {
    private String _filename;
    private String _responseName;
    private Connection _conn;
    private ScriptRunnerContext _ctx;
    private String _schema;
    private String _table;
    private File _loadFile;
    private File _responseFile;
    private FileInputStream _input;
    private OutputStream _output;
    private boolean _doCommit;

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    @Override
    public String getCommand() {
        return "LOAD";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        boolean bl = true;
        this._ctx = scriptRunnerContext;
        String string = iSQLCommand.getSql();
        String[] stringArray = string.split(" ");
        try {
            if (connection != null) {
                this._conn = connection;
                int n = stringArray.length;
                if (n > 3) {
                    return false;
                }
                if (n == 3) {
                    String string2 = stringArray[1];
                    this._filename = scriptRunnerContext.prependCD(stringArray[2]);
                    if (!this.validateTable(string2)) {
                        bl = false;
                        scriptRunnerContext.write(MessageFormat.format(Messages.getString("LOAD_TABLE_ERR"), this._schema + "." + this._table) + "\n");
                    }
                    if (!this.validateFile(this._filename)) {
                        bl = false;
                        scriptRunnerContext.write(MessageFormat.format(Messages.getString("LOAD_FILE_ERR"), this._filename) + "\n");
                    }
                    if (bl) {
                        Long l = (Long)scriptRunnerContext.getProperty("script.runner.autocommit.setting");
                        this._doCommit = l.equals(ScriptRunnerContext.AUTOCOMMITON);
                        this.doLoad(null, null);
                    }
                } else if (n == 2) {
                    scriptRunnerContext.write(this.getHelp());
                } else if (n == 1) {
                    scriptRunnerContext.write(this.getHelp());
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getLocalizedMessage());
            return true;
        }
    }

    private boolean validateFile(String string) {
        this._loadFile = new File(string);
        return this._loadFile.exists() && !this._loadFile.isDirectory();
    }

    private boolean validateTable(String string) {
        this._schema = this.getObjectOwner(string);
        if (this._schema != null && !this._schema.startsWith("\"") && !this._schema.endsWith("\"")) {
            this._schema = this._schema.toUpperCase();
        }
        this._table = this.getObjectName(string);
        if (this._table != null && !this._table.startsWith("\"") && !this._table.endsWith("\"")) {
            this._table = this._table.toUpperCase();
        }
        return true;
    }

    private String getObjectName(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return string;
    }

    private String getObjectOwner(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return stringArray[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExitCode doLoad(ReadParmsDelimitedAPI readParmsDelimitedAPI, LoadParmsAPI loadParmsAPI) {
        String string;
        LogHandler logHandler = null;
        this._responseFile = File.createTempFile("sqlcl_load", ".tmp");
        this._responseFile.deleteOnExit();
        this._input = new FileInputStream(new File(this._filename));
        this._output = new FileOutputStream(this._responseFile);
        String string2 = MessageFormat.format(Messages.getString("LOAD_START"), this._schema + "." + this._table, this._filename);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, string2);
        LoadParmsAPI loadParmsAPI2 = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH).responseFormat(LoadParmsAPI.RESPONSE_FORMAT.RESPONSE_SQL).doCommit(this._doCommit).build();
        LoadAPI loadAPI = new LoadAPI.Builder(this._conn, this._schema, this._table, this._input, this._output).loadParms(loadParmsAPI2).readParms(readParmsDelimitedAPI).logger(Logger.getLogger(this.getClass().getName())).build();
        ExitCode exitCode = loadAPI.load();
        BufferedReader bufferedReader = null;
        try {
            if (this._input != null) {
                this._input.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
        }
        try {
            if (this._output != null) {
                this._output.close();
                bufferedReader = new BufferedReader(new FileReader(this._responseFile));
                while ((string = bufferedReader.readLine()) != null) {
                    this._ctx.write(string + "\n");
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
        }
        try {
            string = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, string);
            if (logHandler != null) {
                logHandler.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
            }
        }
        return exitCode;
        catch (IllegalStateException illegalStateException) {
            String string3;
            ExitCode exitCode2 = ExitCode.EXIT_SEVERE;
            BufferedReader bufferedReader2 = null;
            try {
                if (this._input != null) {
                    this._input.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
            }
            try {
                if (this._output != null) {
                    this._output.close();
                    bufferedReader2 = new BufferedReader(new FileReader(this._responseFile));
                    while ((string3 = bufferedReader2.readLine()) != null) {
                        this._ctx.write(string3 + "\n");
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
            }
            try {
                string3 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, string3);
                if (logHandler != null) {
                    logHandler.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
            }
            finally {
                try {
                    if (bufferedReader2 != null) {
                        bufferedReader2.close();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
                }
            }
            return exitCode2;
        }
        catch (Exception exception) {
            String string4;
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExitCode exitCode3 = ExitCode.EXIT_SEVERE;
            BufferedReader bufferedReader3 = null;
            try {
                if (this._input != null) {
                    this._input.close();
                }
            }
            catch (Exception exception2) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception2.getLocalizedMessage());
            }
            try {
                if (this._output != null) {
                    this._output.close();
                    bufferedReader3 = new BufferedReader(new FileReader(this._responseFile));
                    while ((string4 = bufferedReader3.readLine()) != null) {
                        this._ctx.write(string4 + "\n");
                    }
                }
            }
            catch (Exception exception3) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception3.getLocalizedMessage());
            }
            try {
                string4 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, string4);
                if (logHandler != null) {
                    logHandler.close();
                }
            }
            catch (Exception exception4) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception4.getLocalizedMessage());
            }
            finally {
                try {
                    if (bufferedReader3 != null) {
                        bufferedReader3.close();
                    }
                }
                catch (Exception exception5) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception5.getLocalizedMessage());
                }
            }
            return exitCode3;
            {
                catch (Throwable throwable) {
                    String string5;
                    BufferedReader bufferedReader4 = null;
                    try {
                        if (this._input != null) {
                            this._input.close();
                        }
                    }
                    catch (Exception exception6) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception6.getLocalizedMessage());
                    }
                    try {
                        if (this._output != null) {
                            this._output.close();
                            bufferedReader4 = new BufferedReader(new FileReader(this._responseFile));
                            while ((string5 = bufferedReader4.readLine()) != null) {
                                this._ctx.write(string5 + "\n");
                            }
                        }
                    }
                    catch (Exception exception7) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception7.getLocalizedMessage());
                    }
                    try {
                        string5 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, string5);
                        if (logHandler != null) {
                            logHandler.close();
                        }
                    }
                    catch (Exception exception8) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception8.getLocalizedMessage());
                    }
                    finally {
                        try {
                            if (bufferedReader4 != null) {
                                bufferedReader4.close();
                            }
                        }
                        catch (Exception exception9) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception9.getLocalizedMessage());
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{this.getCommand()};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }
}

