/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.proformatter.CodingStyleSQLOptionsBean;
import oracle.dbtools.raptor.proformatter.FormatHelper;
import oracle.dbtools.raptor.proformatter.ICodingStyleSQLOptions;
import oracle.dbtools.util.Logger;

public class FormatSQLPlusCommand
extends CommandListener
implements IHelp {
    public static int CHUNKSIZE = 1000;

    @Override
    public String getCommand() {
        return "FORMAT";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSQLOrig().split("\\s+");
        String string = null;
        try {
            String[] stringArray2;
            if (scriptRunnerContext.getProperty("script.runner.jline") != null) {
                if (stringArray.length == 2 && stringArray[1].toUpperCase().equals("BUFFER")) {
                    string = scriptRunnerContext.getSQLPlusBuffer().getBufferSafe().getBuffer();
                    CodingStyleSQLOptionsBean codingStyleSQLOptionsBean = (CodingStyleSQLOptionsBean)scriptRunnerContext.getProperty("SQLFORMATRULES");
                    String string2 = scriptRunnerContext.getSQLPlusFormatter().format(codingStyleSQLOptionsBean, string);
                    if (string2 != null) {
                        String[] stringArray3 = string2.split("\n");
                        scriptRunnerContext.getSQLPlusBuffer().getBufferSafe().resetBuffer(Arrays.asList(stringArray3));
                        scriptRunnerContext.write(scriptRunnerContext.getSQLPlusBuffer().getBufferSafe().list());
                        return true;
                    }
                    scriptRunnerContext.write("Buffer not formatted\n");
                    return true;
                }
                if (stringArray.length == 3 && stringArray[1].toUpperCase().equals("RULES")) {
                    String string3 = scriptRunnerContext.prependCD(stringArray[2]);
                    File file = new File(string3);
                    if (file.exists()) {
                        ICodingStyleSQLOptions iCodingStyleSQLOptions = null;
                        FormatHelper.loadFromXML(iCodingStyleSQLOptions, file.toURI().toURL());
                        scriptRunnerContext.putProperty("SQLFORMATRULES", iCodingStyleSQLOptions);
                        scriptRunnerContext.write("Formatter rules loaded");
                    } else {
                        scriptRunnerContext.write(MessageFormat.format("File {0}cannot be opened.", string3));
                    }
                    return true;
                }
            }
            if (iSQLCommand.getSql().split("\n")[0].matches("^(?i)format\\s*-\\s+.*$")) {
                string = iSQLCommand.getSql().substring(iSQLCommand.getSql().indexOf("-") + 1).trim();
            } else {
                stringArray2 = iSQLCommand.getSql().replace("\r\n", " ").replace("\n", " ");
                if (stringArray2.matches("^(?i)format\\s*file\\s+.*$")) {
                    string = stringArray2.substring(iSQLCommand.getSql().toUpperCase().indexOf("F", 2)).trim();
                }
            }
            if (string != null) {
                if (string.toUpperCase().startsWith("FILE")) {
                    stringArray2 = ScriptUtils.executeArgs(string);
                    if (stringArray2.length == 3) {
                        this.doWork(scriptRunnerContext, stringArray2[1], stringArray2[2]);
                    } else {
                        scriptRunnerContext.write(this.getHelp());
                    }
                } else {
                    scriptRunnerContext.write(this.getHelp());
                }
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Logger.severe(this.getClass(), patternSyntaxException.getLocalizedMessage(), patternSyntaxException);
            return true;
        }
        catch (ArgumentQuoteException argumentQuoteException) {
            Logger.severe(this.getClass(), argumentQuoteException.getLocalizedMessage(), argumentQuoteException);
            scriptRunnerContext.write(this.getHelp());
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        scriptRunnerContext.write(this.getHelp());
        return true;
    }

    protected Void doWork(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        if (string != null && string2 != null) {
            string = this.putInDir(scriptRunnerContext, string);
            string2 = this.putInDir(scriptRunnerContext, string2);
        }
        if (string == null || string2 == null || !new File(string).exists()) {
            this.usage(scriptRunnerContext);
            return null;
        }
        boolean bl = new File(string).isDirectory() && (new File(string2).isDirectory() || !new File(string2).exists()) ? this.doDirectory(scriptRunnerContext, string, string2) : this.inputFileToOutputFile(scriptRunnerContext, string, string2);
        if (bl) {
            this.usage(scriptRunnerContext);
        }
        return null;
    }

    private void usage(ScriptRunnerContext scriptRunnerContext) {
        scriptRunnerContext.write(this.getHelp());
    }

    private boolean doDirectory(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        File[] fileArray;
        boolean bl = false;
        if (!new File(string2).isDirectory()) {
            new File(string2).delete();
            if (!new File(string2).mkdir()) {
                this.errorOn(scriptRunnerContext, string, string2);
                return true;
            }
        }
        if ((fileArray = new File(string).listFiles()) != null) {
            for (File file : fileArray) {
                int n = file.getPath().lastIndexOf(File.separator);
                int n2 = file.getPath().lastIndexOf(":");
                if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1 && n2 > n && n2 > 0 && n2 < 4) {
                    n = n2;
                }
                if (n == -1 || file.getPath().endsWith(File.separator)) {
                    this.errorOn(scriptRunnerContext, string, string2);
                    bl = true;
                    continue;
                }
                String string3 = file.getPath();
                if (n != -1) {
                    string3 = file.getPath().substring(n + 1);
                }
                if (file.isDirectory()) {
                    if (!this.doDirectory(scriptRunnerContext, file.getPath(), string2 + File.separator + string3)) continue;
                    bl = true;
                    continue;
                }
                if (!this.inputFileToOutputFile(scriptRunnerContext, file.getPath(), string2 + File.separator + string3)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void errorOn(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        scriptRunnerContext.write(ScriptRunnerDbArb.format("ERRORON", string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputFileToOutputFile(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        block35: {
            boolean bl;
            BufferedWriter bufferedWriter = null;
            BufferedReader bufferedReader = null;
            try {
                if (string == null || string2 == null || !new File(string).exists()) {
                    this.errorOn(scriptRunnerContext, string, string2);
                    boolean bl2 = true;
                    return bl2;
                }
                String string3 = scriptRunnerContext.getEncoding();
                bufferedReader = string3 == null || string3.equals("") ? new BufferedReader(new InputStreamReader(new FileInputStream(string))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string3));
                StringBuffer stringBuffer = new StringBuffer("");
                char[] cArray = new char[CHUNKSIZE];
                int n = 0;
                while ((n = bufferedReader.read(cArray, 0, CHUNKSIZE)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                String string4 = stringBuffer.toString();
                CodingStyleSQLOptionsBean codingStyleSQLOptionsBean = (CodingStyleSQLOptionsBean)scriptRunnerContext.getProperty("SQLFORMATRULES");
                String string5 = scriptRunnerContext.getSQLPlusFormatter().format(codingStyleSQLOptionsBean, string4);
                if (string5 != null) {
                    if (string5.endsWith("\n") && !string5.endsWith("\n")) {
                        string5 = string5 + "\n";
                    }
                    if (string4.endsWith(" ") && !string5.endsWith(" ")) {
                        string5 = string5 + " ";
                    }
                    if (!string5.endsWith("\n")) {
                        string5 = string5 + "\n";
                    }
                    String string6 = "\n";
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
                        string6 = "\r\n";
                    }
                    string5 = string5.replaceAll("\r{0,1}\n", string6);
                    new File(string2).delete();
                    bufferedWriter = string3 == null || string3.equals("") ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string2))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), string3));
                    bufferedWriter.write(string5);
                    break block35;
                }
                scriptRunnerContext.write(ScriptRunnerDbArb.format("OUTPUTNULL", string2));
                bl = true;
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), exception.getStackTrace()[0].toString(), exception);
                this.errorOn(scriptRunnerContext, string, string2);
                boolean bl3 = true;
                return bl3;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public String putInDir(ScriptRunnerContext scriptRunnerContext, String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? n > 0 && n < 4 : string.startsWith("/")) {
            return string;
        }
        String string2 = (String)scriptRunnerContext.getProperty("script.runner.cd_command");
        if (string2 == null) {
            return string;
        }
        if (string2.endsWith(File.separator)) {
            return string2 + string;
        }
        return string2 + File.separator + string;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

