/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleConnection;

public class DescribePrep
extends CommandListener {
    private Connection _conn;

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) && iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE) && (connection == null || connection instanceof OracleConnection)) {
            this._conn = connection;
            if (scriptRunnerContext.getProperty("script.runner.sqlplus.silent") == null) {
                // empty if block
            }
            this.parseDescribe(scriptRunnerContext, iSQLCommand, connection);
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        boolean bl = scriptRunnerContext.getProperties().get("descr.usage") != null ? (Boolean)scriptRunnerContext.getProperties().get("descr.usage") : Boolean.FALSE;
        if (DescribePrep.matches("describe", iSQLCommand.getSql()) && bl) {
            scriptRunnerContext.write(ScriptRunnerDbArb.getString("DESCR_USAGE") + "\n");
            return true;
        }
        return false;
    }

    public void parseDescribe(ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand, Connection connection) {
        String[] stringArray;
        Object object;
        Object object2;
        String[] stringArray2 = new String[]{"", "unknown_table"};
        boolean bl = false;
        String[] stringArray3 = iSQLCommand.getSql().split(" ");
        if (stringArray3.length < 2) {
            scriptRunnerContext.putProperty("descr.usage", Boolean.TRUE);
            return;
        }
        scriptRunnerContext.putProperty("descr.usage", Boolean.FALSE);
        if (iSQLCommand.getSql().contains(".")) {
            object2 = new StringTokenizer(iSQLCommand.getSql(), "\\.");
            object = new StringTokenizer(((StringTokenizer)object2).nextToken(), "\\ ");
            ((StringTokenizer)object).nextToken();
            stringArray2[0] = ((StringTokenizer)object).nextToken();
            stringArray2[1] = ((StringTokenizer)object2).nextToken();
        } else {
            object2 = "\"([^\"]*)\"|(\\S+)";
            object = Pattern.compile((String)object2).matcher(iSQLCommand.getSql());
            ((Matcher)object).find();
            while (((Matcher)object).find()) {
                stringArray2[1] = ((Matcher)object).group();
            }
            bl = true;
        }
        stringArray2[1] = stringArray2[1].replaceAll("\n", "");
        stringArray2[1] = stringArray2[1].replaceAll("\r", "");
        object2 = null;
        object = stringArray2[1];
        String string = this.getObjType(stringArray2[1], stringArray2[0]);
        String string2 = "all";
        if ((string == null || string.length() == 0 && stringArray2[1] != null && stringArray2[1].length() > 0) && (string = this.getObjTypeDBA(stringArray2[1], stringArray2[0])) != null && string.length() > 0) {
            string2 = "dba";
        }
        if (string.indexOf("\n") > -1) {
            string = string.split("\n")[0];
        }
        if (string.equals("SYNONYM")) {
            stringArray = this.getBaseSynonymObj(stringArray2[1], stringArray2[0]);
            string = stringArray[2];
            stringArray2[0] = stringArray[0];
            stringArray2[1] = stringArray[1];
        }
        stringArray = ScriptRunnerDbArb.getString("DISPLAY_NAME");
        String string3 = ScriptRunnerDbArb.getString("DISPLAY_NULL");
        String string4 = ScriptRunnerDbArb.getString("DISPLAY_TYPE");
        String string5 = ScriptRunnerDbArb.getString("DISPLAY_ARGUMENT_NAME");
        String string6 = ScriptRunnerDbArb.getString("DISPLAY_DEFAULT");
        stringArray2[0] = stringArray2[0].indexOf("\"") > -1 || stringArray2[0].indexOf("'") > -1 ? stringArray2[0].replaceAll("\"|'", "") : this.upperCaseLocaleUS(scriptRunnerContext, stringArray2[0].replaceAll("\"|'", ""));
        stringArray2[1] = stringArray2[1].indexOf("\"") > -1 || stringArray2[1].indexOf("'") > -1 ? stringArray2[1].replaceAll("\"|'", "") : this.upperCaseLocaleUS(scriptRunnerContext, stringArray2[1].replaceAll("\"|'", ""));
        string = this.getObjType(stringArray2[1], stringArray2[0]);
        if (string == null || string.length() == 0 && stringArray2[1] != null && stringArray2[1].length() > 0) {
            string = this.getObjTypeDBA(stringArray2[1], stringArray2[0]);
        }
        String string7 = "";
        String[] stringArray4 = DBUtil.resolveDBLink(stringArray2[1]);
        if (stringArray4 != null) {
            string7 = "@" + stringArray4[1];
            if (stringArray2[0].equals("")) {
                stringArray2[0] = this.getDBLinkOwner(stringArray2[1], "");
            }
            stringArray2[1] = stringArray4[0];
        }
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("oracle/dbtools/raptor/newscriptrunner/ScriptParserQueries.xml");
        Query query = null;
        String string8 = null;
        String string9 = null;
        boolean bl2 = true;
        Object[] objectArray = null;
        String string10 = null;
        if (string.equals("TABLE") || string.equals("VIEW") || string.endsWith("MATERIALIZED VIEW")) {
            string10 = "DESC_TABLE_VIEW";
            if (!string7.equals("") && bl) {
                string10 = string10 + "_NO_OWNER";
            }
            objectArray = new Object[]{string7, stringArray, string3, string4, string2, string9};
        } else if (string.startsWith("PACKAGE")) {
            string10 = this.isDefaultDetailsAvailable(string7) ? "DESC_PACKAGE_WITH_ARGS_DEFAULTS" : "DESC_PACKAGE_WITHOUT_ARGS_DEFAULTS";
            if (!string7.equals("") && bl) {
                string10 = string10 + "_NO_OWNER";
            }
            objectArray = new Object[]{string7, string5, string4, string6, string9};
        } else if (string.equals("FUNCTION") || string.equals("PROCEDURE")) {
            string10 = this.isDefaultDetailsAvailable(string7) ? "DESC_PROC_FUNC_WITH_ARGS_DEFAULTS" : "DESC_PROC_FUNC_WITHOUT_ARGS_DEFAULTS";
            if (!string7.equals("") && bl) {
                string10 = string10 + "_NO_OWNER";
            }
            objectArray = new Object[]{string7, string5, string4, string6, string9};
        } else if (string.startsWith("TYPE")) {
            string10 = !this.isUserDefinedTypeCollection(string7, (String)object) ? "DESC_TYPE" : "DESC_TYPE_COLLECTION";
            objectArray = !stringArray2[0].equals("") ? new Object[]{string7, stringArray, string3, string4, " UPPER(owner)= UPPER(:1) and "} : new Object[]{string7, stringArray, string3, string4, ""};
            if (!string7.equals("") && bl) {
                string10 = string10 + "_NO_OWNER";
            }
        } else {
            iSQLCommand.setSql("select '" + ScriptRunnerDbArb.format("CANNOT_DESCRIBE_ERROR", stringArray2[1]) + "' \"ERROR:\"  from dual");
            bl2 = false;
        }
        if (bl2) {
            query = queryXMLSupport.getQuery(string10, connection);
            string8 = query.getSql().replaceAll("'", "''");
            string9 = !stringArray2[0].equals("") ? ":1" : "sys_context('USERENV', 'CURRENT_USER')";
            objectArray[objectArray.length - 1] = string9;
            string8 = MessageFormat.format(string8, objectArray);
            iSQLCommand.setSql(string8);
            if (!stringArray2[0].equals("") && !string10.endsWith("_NO_OWNER")) {
                iSQLCommand.addBind(stringArray2[0]);
                iSQLCommand.addBind(stringArray2[1]);
            } else {
                iSQLCommand.addBind(stringArray2[1]);
            }
        }
        iSQLCommand.setStmtClass(SQLCommand.StmtType.G_C_SQL);
        iSQLCommand.setResultsType(SQLCommand.StmtResultType.G_R_QUERY);
    }

    private String getDBLinkOwner(String string, String string2) {
        String string3;
        String string4;
        String[] stringArray = DBUtil.resolveDBLink(string);
        if (string2.equals("") && (string4 = this.executeQuery(string3 = "select username from all_db_links where db_link=UPPER('" + stringArray[1] + "') AND username IS NOT null")) != null && !string4.equals("")) {
            return string4;
        }
        return string2;
    }

    private String getObjType(String string, String string2) {
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String[] stringArray = DBUtil.resolveDBLink(string);
        if (stringArray != null) {
            if (string2.equals("")) {
                bl = true;
                string2 = this.getDBLinkOwner(string, string2);
            }
            string = stringArray[0];
            string3 = bl ? " select distinct object_type  from sys.user_objects@" + stringArray[1] : " select distinct object_type  from sys.all_objects@" + stringArray[1];
        } else {
            string3 = " select distinct object_type  from sys.all_objects ";
        }
        String string5 = string.replaceAll("\"|'", "");
        string3 = string.startsWith("\"") ? string3 + " where object_name =" + "'" + string5 + "'" : string3 + " where UPPER(object_name) =" + "UPPER('" + string5 + "')";
        String string6 = "";
        if (bl) {
            string6 = string3;
        } else if (string2.equals("")) {
            string6 = string3 + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER'))";
        } else {
            String string7 = string2.replaceAll("\"|'", "");
            string6 = string3 + " and UPPER(owner)= UPPER('" + string7 + "')";
        }
        string6 = string6 + " and object_type != 'INDEX' ";
        string6 = string6 + " and rownum < 100";
        string4 = this.executeQuery(string6);
        if (string4 == null) {
            string4 = "";
        }
        if (string2.equals("") && string4.trim().equals("")) {
            string6 = string3 + "and OBJECT_TYPE ='SYNONYM'";
            string4 = this.executeQuery(string6);
            if (string4 == null) {
                string4 = "";
            } else if (!string4.trim().equals("")) {
                string4 = "SYNONYM";
            }
        }
        if (string4.indexOf("TABLE PARTITION") != -1 || string4.indexOf("TABLE\nINDEX") != -1) {
            string4 = "TABLE";
        }
        return string4;
    }

    private String getObjTypeDBA(String string, String string2) {
        String string3 = null;
        String[] stringArray = DBUtil.resolveDBLink(string);
        if (stringArray != null) {
            string = stringArray[0];
            string3 = " select distinct object_type from sys.user_objects@" + stringArray[1];
        } else {
            string3 = " select distinct object_type from sys.dba_objects ";
        }
        String string4 = string.replaceAll("\"|'", "");
        String string5 = string2.replaceAll("\"|'", "");
        string3 = string.startsWith("\"") ? string3 + " where object_name = '" + string4 + "'" : string3 + " where UPPER(object_name) = UPPER('" + string4 + "')";
        string3 = string2.startsWith("\"") ? string3 + " and owner = '" + string5 + "'" : string3 + " and UPPER(owner) = UPPER('" + string5 + "')";
        String string6 = string3;
        string6 = string6 + " and object_type != 'INDEX' ";
        string6 = string6 + " and rownum < 100";
        String string7 = this.executeQuery(string6);
        if (string7 == null) {
            string7 = "";
        }
        if (string7.indexOf("TABLE PARTITION") != -1 || string7.indexOf("TABLE\nINDEX") != -1) {
            string7 = "TABLE";
        }
        return string7;
    }

    private boolean isDefaultDetailsAvailable(String string) {
        String string2 = "select 'available' from sys.argument$" + string + " where rownum <=1";
        String string3 = this.executeQuery(string2);
        return string3.equals("available");
    }

    private boolean isUserDefinedTypeCollection(String string, String string2) {
        String string3 = !string.equals("") ? "select typecode from sys.all_types@" + string + " where type_name=" : "select typecode from sys.all_types where type_name=";
        string3 = string2.startsWith("\"") ? string3 + "'" + string2.replaceAll("\"|'", "") + "'" : string3 + "UPPER('" + string2 + "')";
        String string4 = this.executeQuery(string3);
        return string4.equals("COLLECTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeQuery(String string) {
        String string2 = "";
        Statement statement = null;
        ResultSet resultSet = null;
        if (this._conn == null) {
            return null;
        }
        try {
            int n;
            statement = this._conn.createStatement();
            resultSet = statement.executeQuery(string);
            resultSet.next();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            if (n2 == 1) {
                string2 = string2 + resultSet.getString(1);
            } else {
                for (n = 1; n <= n2; ++n) {
                    string2 = string2 + resultSet.getString(n) + ":";
                }
            }
            while (resultSet.next()) {
                string2 = string2 + "\n";
                if (n2 == 1) {
                    string2 = string2 + resultSet.getString(1);
                    continue;
                }
                for (n = 1; n <= n2; ++n) {
                    string2 = string2 + resultSet.getString(n) + ":";
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    private String[] getBaseSynonymObj(String string, String string2) {
        String string3;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = "select table_owner ,table_name from all_synonyms where  synonym_name = ";
        String string8 = string.replaceAll("\"", "");
        string7 = string.startsWith("\"") ? string7 + "'" + string8 + "'" : string7 + "UPPER('" + string8 + "')";
        String string9 = string3 = string2 == null ? "" : string2.trim();
        if (string3.length() > 2 && string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (!string3.equals("")) {
            string7 = string7 + " and owner ='" + string3 + "'";
            string6 = this.executeQuery(string7);
        } else {
            string4 = string7 + " and (UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER')) )";
            string5 = string7 + " and ( owner = 'PUBLIC')";
            string6 = this.executeQuery(string4);
            if (string6 == null || string6.trim().equals("")) {
                string6 = this.executeQuery(string5);
            }
        }
        String string10 = "";
        String string11 = "";
        String string12 = "";
        if (string6 == null || string6.trim().equals("")) {
            string6 = "";
        } else {
            string10 = string6.substring(0, string6.indexOf(":"));
            string11 = string6.substring(string6.indexOf(":") + 1);
            string11 = string11.substring(0, string11.length() - 1);
            string12 = this.getObjType(string11, string10);
        }
        String[] stringArray = new String[]{string10, string11, string12};
        return stringArray;
    }

    public String upperCaseLocaleUS(ScriptRunnerContext scriptRunnerContext, String string) {
        String string2 = null;
        string2 = string == null || string.equals("") ? string : string.toUpperCase(Locale.US);
        return string2;
    }
}

