/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class DDLCommand
extends CommandListener
implements IHelp,
Connected {
    protected static final String CMD = "ddl";
    protected static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_DDL;
    protected static final String SAVE_KWD = "SAVE";
    protected static final String BODY = "BODY";
    protected static final String CONSUMER = "CONSUMER";
    protected static final String GROUP = "GROUP";
    protected static final String LOG = "LOG";
    protected static final String MATERIALIZED = "MATERIALIZED";
    protected static final String PARTITION = "PARTITION";
    protected static final String REDO = "REDO";
    protected static final String REF = "REF";
    protected static final String PL_SQL = "PL/SQL";
    protected static final String PLSQL = "PLSQL";
    protected static final String TABLE = "TABLE";
    protected static final String VIEW = "VIEW";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String CONSUMERGROUP = "CONSUMER GROUP";
    protected static final String CONTAINERRMPLAN = "CONTAINERRMPLAN";
    protected static final String DATAFILE = "DATAFILE";
    protected static final String DATABASELINK = "DATABASE LINK";
    protected static final String DB_LINK = "DB_LINK";
    protected static final String DBLINK = "DBLINK";
    protected static final String FUNCTION = "FUNCTION";
    protected static final String INDEX = "INDEX";
    protected static final String MATVIEW = "MATERIALIZED VIEW";
    protected static final String MATVIEWLOG = "MATERIALIZED VIEW LOG";
    protected static final String OBJECT = "OBJECT";
    protected static final String PACKAGE = "PACKAGE";
    protected static final String PACKAGEBODY = "PACKAGE BODY";
    protected static final String PROCEDURE = "PROCEDURE";
    protected static final String PROFILE = "PROFILE";
    protected static final String QUEUE = "QUEUE";
    protected static final String QUEUETABLE = "QUEUE TABLE";
    protected static final String REDOLOGGROUP = "REDO LOG GROUP";
    protected static final String REFCONSTRAINT = "REF CONSTRAINT";
    protected static final String ROLE = "ROLE";
    protected static final String SEQUENCE = "SEQUENCE";
    protected static final String SYNONYM = "SYNONYM";
    protected static final String TABLEPARTITION = "TABLE PARTITION";
    protected static final String TABLESPACE = "TABLESPACE";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TYPE = "TYPE";
    protected static final String USER = "USER";
    protected static String[][] types = new String[][]{{"CONSTRAINT"}, {"CONSUMER", "GROUP"}, {"CONTAINERRMPLAN"}, {"DATAFILE"}, {"DATABASE LINK"}, {"DB_LINK"}, {"DBLINK"}, {"FUNCTION"}, {"INDEX"}, {"MATERIALIZED", "VIEW"}, {"MATERIALIZED", "VIEW", "LOG"}, {"OBJECT"}, {"PACKAGE"}, {"PACKAGE", "BODY"}, {"PROCEDURE"}, {"PROFILE"}, {"QUEUE"}, {"QUEUE", "TABLE"}, {"REDO", "LOG", "GROUP"}, {"REF", "CONSTRAINT"}, {"ROLE"}, {"SEQUENCE"}, {"SYNONYM"}, {"TABLE"}, {"TABLE", "PARTITION"}, {"TABLESPACE"}, {"TRIGGER"}, {"TYPE"}, {"USER"}, {"VIEW"}};
    protected static final String COMMENT = "COMMENT";
    protected static final String PACKAGEWITHBODY = "PACKAGE SPEC+BODY";
    protected static final String TABLE_DDL = "table_ddl";
    protected static final String VIEW_DDL = "view_ddl";
    protected static final String INDEX_DDL = "index_ddl";
    protected static final String CONSTRAINT_DDL = "constraint_ddl";
    protected static final String FUNCTION_DDL = "function_ddl";
    protected static final String CONSUMERGROUP_DDL = "consumergroup_ddl";
    protected static final String CONTAINERRMPLAN_DDL = "containerrmplan_ddl";
    protected static final String DATAFILE_DDL = "datafile_ddl";
    protected static final String DBLINK_DDL = "script_ddl";
    protected static final String MATVIEW_DDL = "matview_ddl";
    protected static final String MATVIEWLOG_DDL = "script_ddl";
    protected static final String OBJECT_DDL = "script_ddl";
    protected static final String PROFILE_DDL = "profile_ddl";
    protected static final String QUEUE_DDL = "queue_ddl";
    protected static final String QUEUETABLE_DDL = "queueTable_ddl";
    protected static final String REDOLOGGROUP_DDL = "redologgroup_ddl";
    protected static final String PROCEDURE_DDL = "procedure_ddl";
    protected static final String PACKAGESPEC_DDL = "packagespec_ddl";
    protected static final String PACKAGEBODY_DDL = "packagebody_ddl";
    protected static final String PACKAGE_DDL = "package_ddl";
    protected static final String SEQUENCE_DDL = "seq_ddl";
    protected static final String SYNONYM_DDL = "syn_ddl";
    protected static final String TABLESPACE_DDL = "tablespace_ddl";
    protected static final String TYPE_DDL = "type_ddl";
    protected static final String USER_DDL = "user_ddl";
    protected static final String ROLE_DDL = "role_ddl";
    protected static final String REFCONSTRAINT_DDL = "script_ddl";
    protected static final String TRIGGER_DDL = "trigger_ddl";
    private Connection _conn = null;
    private ScriptRunnerContext _ctx = null;

    protected String help() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        this.setContext(scriptRunnerContext);
        String string = iSQLCommand.getSql();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.splitArgs(string, arrayList);
        int n = arrayList.size();
        if (n == 1) {
            scriptRunnerContext.write(this.help());
            return true;
        }
        if (connection != null) {
            CharSequence charSequence;
            String string2;
            String string3;
            this.setConn(connection);
            if (n >= 4 && SAVE_KWD.equalsIgnoreCase(arrayList.get(n - 2))) {
                string3 = arrayList.get(n - 1);
                if (string3.lastIndexOf(".") == -1 && (string2 = (String)scriptRunnerContext.getProperty("script.runner.file.suffix")).length() > 0) {
                    string3 = string3 + "." + string2;
                }
                n -= 2;
            } else {
                string3 = null;
            }
            if (n >= 3) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(arrayList.get(2));
                for (int i = 3; i < n; ++i) {
                    ((StringBuilder)charSequence).append(" ");
                    ((StringBuilder)charSequence).append(arrayList.get(i));
                }
                n = 2;
                string2 = ((StringBuilder)charSequence).toString();
            } else {
                string2 = null;
            }
            charSequence = n >= 2 ? arrayList.get(1) : null;
            if (charSequence != null) {
                this.processDDL((String)charSequence, string2, string3);
                return true;
            }
        }
        this.writeToCtx(MessageFormat.format(Messages.getString("DDL_PARSE_ERROR"), new Object[0]));
        scriptRunnerContext.write(this.help());
        return true;
    }

    protected void setContext(ScriptRunnerContext scriptRunnerContext) {
        this._ctx = scriptRunnerContext;
    }

    protected void setConn(Connection connection) {
        this._conn = connection;
    }

    protected boolean splitArgs(String string, ArrayList<String> arrayList) {
        int n = string.length();
        int n2 = n - 1;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c != '\u0000') {
                stringBuilder2.append(c2);
                if (c2 == c) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder2 = new StringBuilder();
                    c = '\u0000';
                }
            } else if (c2 == '\"' || c2 == '\'') {
                stringBuilder2.append(c2);
                c = c2;
            } else if (Character.isWhitespace(c2)) {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
            } else {
                stringBuilder.append(c2);
            }
            if (i != n2 || c == '\u0000') continue;
            stringBuilder.append(c);
            i -= stringBuilder2.length() - 1;
            stringBuilder2 = new StringBuilder();
            c = '\u0000';
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processDDL(String string, String string2, String string3) {
        boolean bl;
        block28: {
            bl = false;
            BufferedWriter bufferedWriter = null;
            try {
                List<DDLObjective> list = this.getObjectives(string, string2);
                if (list == null) break block28;
                File file = null;
                if (string3 != null) {
                    file = new File(string3);
                    if (!file.exists()) {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            this.writeToCtx(MessageFormat.format(Messages.getString("DDL_FILE_NOT_CREATED"), string3, iOException.getLocalizedMessage()));
                            boolean bl2 = bl = false;
                            if (bufferedWriter != null) {
                                try {
                                    bufferedWriter.flush();
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                                try {
                                    bufferedWriter.close();
                                }
                                catch (IOException iOException3) {
                                    // empty catch block
                                }
                            }
                            return bl2;
                        }
                    }
                    bufferedWriter = new BufferedWriter(new FileWriter(file, true));
                }
                this._ctx.getSQLPlusBuffer().clear();
                bl = this.getDDL(bufferedWriter, list);
            }
            catch (IOException iOException) {
                this.writeToCtx(MessageFormat.format(Messages.getString("DDL_FILE_NOT_WRITABLE"), string3, iOException.getLocalizedMessage()));
                bl = false;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    protected List<DDLObjective> getObjectives(String string, String string2) {
        CharSequence charSequence;
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        boolean bl2;
        String string3;
        LinkedList<DDLObjective> linkedList = new LinkedList<DDLObjective>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (string2 != null) {
            switch (string2) {
                case "DB_LINK": 
                case "DBLINK": {
                    string3 = DATABASELINK;
                    bl2 = false;
                    break;
                }
                case "MATERIALIZED VIEW LOG": {
                    string3 = TABLE;
                    linkedList2.add(MATVIEWLOG);
                    bl2 = true;
                    break;
                }
                default: {
                    string3 = string2;
                    bl2 = false;
                    break;
                }
            }
        } else {
            string3 = string2;
            bl2 = false;
        }
        int n = ((LinkedList)(object3 = this.getTypes(string, string3))).size() == 1 && ((ResolvedDBName)((LinkedList)object3).getFirst()).objectId != null ? 1 : 0;
        boolean bl3 = bl = ((LinkedList)object3).size() > 1;
        if (((LinkedList)object3).size() == 2) {
            object2 = (ResolvedDBName)((LinkedList)object3).getFirst();
            object = (ResolvedDBName)((LinkedList)object3).getLast();
            if (PACKAGEBODY.equalsIgnoreCase(((ResolvedDBName)object2).getTopLevelType()) && PACKAGE.equalsIgnoreCase(((ResolvedDBName)object).getTopLevelType())) {
                ((LinkedList)object3).add(((LinkedList)object3).pollFirst());
                object2 = (ResolvedDBName)((LinkedList)object3).getFirst();
                object = (ResolvedDBName)((LinkedList)object3).getLast();
            }
            if (PACKAGE.equalsIgnoreCase(((ResolvedDBName)object2).getTopLevelType()) && PACKAGEBODY.equalsIgnoreCase(((ResolvedDBName)object).getTopLevelType())) {
                n = ((ResolvedDBName)object2).getObjectId() != null ? 1 : 0;
                bl = n == 0;
            }
        } else if (n != 0 && ((LinkedList)object3).size() == 1 && (object = ((ResolvedDBName)(object2 = (ResolvedDBName)((LinkedList)object3).getFirst())).getNamespace()) != null) {
            charSequence = ((ResolvedDBName)object2).getTopLevelType();
            switch (1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$commands$DDLCommand$ObjectNamespace[((Enum)object).ordinal()]) {
                case 1: {
                    if (PL_SQL.equalsIgnoreCase(string3) || PLSQL.equalsIgnoreCase(string3)) {
                        if (!PACKAGE.equalsIgnoreCase((String)charSequence)) break;
                        linkedList2.push(PACKAGEWITHBODY);
                        bl2 = true;
                        break;
                    }
                    if (string3.equalsIgnoreCase((String)charSequence)) break;
                    n = 0;
                    break;
                }
                case 2: {
                    if (string3 == null || string3.equalsIgnoreCase((String)charSequence)) break;
                    n = 0;
                }
            }
        }
        object2 = new DDLObjective(string, string3, linkedList2, bl2);
        if (bl) {
            object = ((DDLObjective)object2).getOrigName();
            charSequence = new StringBuffer();
            Iterator iterator = ((AbstractSequentialList)object3).iterator();
            while (iterator.hasNext()) {
                ResolvedDBName resolvedDBName = (ResolvedDBName)iterator.next();
                if (((StringBuffer)charSequence).length() != 0) {
                    ((StringBuffer)charSequence).append(",");
                }
                ((StringBuffer)charSequence).append(resolvedDBName.getTopLevelType());
            }
            this.writeToCtx(MessageFormat.format(Messages.getString("DDL_OBJECT_NOT_UNIQUE"), object, ((StringBuffer)charSequence).toString()));
            return null;
        }
        if (n == 0) {
            object = ((DDLObjective)object2).getOrigName();
            charSequence = ((DDLObjective)object2).getOrigType();
            if (charSequence != null) {
                this.writeToCtx(MessageFormat.format(Messages.getString("DDL_TYPED_OBJECT_NOT_FOUND"), object, charSequence));
            } else {
                this.writeToCtx(MessageFormat.format(Messages.getString("DDL_OBJECT_NOT_FOUND"), object));
            }
            return null;
        }
        ((DDLObjective)object2).setResolvedDBName((List<ResolvedDBName>)object3);
        linkedList.add((DDLObjective)object2);
        return linkedList;
    }

    protected boolean getDDL(BufferedWriter bufferedWriter, List<DDLObjective> list) throws IOException {
        boolean bl = list.size() > 0;
        Iterator<DDLObjective> iterator = list.iterator();
        while (bl && iterator.hasNext()) {
            DDLObjective dDLObjective = iterator.next();
            bl = this.getDDL(bufferedWriter, dDLObjective);
        }
        return bl;
    }

    protected boolean getDDL(BufferedWriter bufferedWriter, DDLObjective dDLObjective) throws IOException {
        boolean bl = dDLObjective.getResolvedDBNames().size() > 0;
        Iterator<ResolvedDBName> iterator = dDLObjective.getResolvedDBNames().iterator();
        while (bl && iterator.hasNext()) {
            ResolvedDBName resolvedDBName = iterator.next();
            if (!dDLObjective.outputComponentsOnly()) {
                bl = this.getDDL(bufferedWriter, dDLObjective, resolvedDBName.getTopLevelType(), resolvedDBName);
            }
            Iterator<String> iterator2 = dDLObjective.getComponentTypes().iterator();
            while (bl && iterator2.hasNext()) {
                String string = iterator2.next();
                bl = this.getDDL(bufferedWriter, dDLObjective, string, resolvedDBName);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getDDL(BufferedWriter bufferedWriter, DDLObjective dDLObjective, String string, ResolvedDBName resolvedDBName) throws IOException {
        SQLException sQLException;
        boolean bl;
        block74: {
            bl = false;
            sQLException = null;
            try {
                String string2 = "/oracle/dbtools/raptor/console/xml/";
                Query query = null;
                switch (string) {
                    case "TABLE PARTITION": 
                    case "TABLE": {
                        string2 = string2 + "TableSql.xml";
                        query = this.getQueryFromFile(this._conn, TABLE_DDL, string2);
                        break;
                    }
                    case "VIEW": {
                        string2 = string2 + "ViewSql.xml";
                        query = this.getQueryFromFile(this._conn, VIEW_DDL, string2);
                        break;
                    }
                    case "INDEX": {
                        string2 = string2 + "IndexSql.xml";
                        query = this.getQueryFromFile(this._conn, INDEX_DDL, string2);
                        break;
                    }
                    case "CONSTRAINT": {
                        string2 = string2 + "ConstraintSql.xml";
                        query = this.getQueryFromFile(this._conn, CONSTRAINT_DDL, string2);
                        break;
                    }
                    case "FUNCTION": {
                        string2 = string2 + "FunctionSql.xml";
                        query = this.getQueryFromFile(this._conn, FUNCTION_DDL, string2);
                        break;
                    }
                    case "CONSUMER GROUP": {
                        string2 = string2 + "ConsumerGroupSql.xml";
                        query = this.getQueryFromFile(this._conn, CONSUMERGROUP_DDL, string2);
                        break;
                    }
                    case "CONTAINERRMPLAN": {
                        string2 = string2 + "ContainerRMPlanSql.xml";
                        query = this.getQueryFromFile(this._conn, CONTAINERRMPLAN_DDL, string2);
                        break;
                    }
                    case "DATAFILE": {
                        string2 = string2 + "DataFileSql.xml";
                        query = this.getQueryFromFile(this._conn, DATAFILE_DDL, string2);
                        break;
                    }
                    case "DBLINK": {
                        string2 = string2 + "DbLinkSql.xml";
                        query = this.getQueryFromFile(this._conn, "script_ddl", string2);
                        break;
                    }
                    case "MATERIALIZED VIEW": {
                        string2 = string2 + "MatViewSql.xml";
                        query = this.getQueryFromFile(this._conn, MATVIEW_DDL, string2);
                        break;
                    }
                    case "MATERIALIZED VIEW LOG": {
                        string2 = string2 + "MatViewLogSql.xml";
                        query = this.getQueryFromFile(this._conn, "script_ddl", string2);
                        break;
                    }
                    case "OBJECT": {
                        string2 = string2 + "ObjectSql.xml";
                        query = this.getQueryFromFile(this._conn, "script_ddl", string2);
                        break;
                    }
                    case "PROFILE": {
                        string2 = string2 + "ProfileSql.xml";
                        query = this.getQueryFromFile(this._conn, PROFILE_DDL, string2);
                        break;
                    }
                    case "QUEUE": {
                        string2 = string2 + "QueueSql.xml";
                        query = this.getQueryFromFile(this._conn, QUEUE_DDL, string2);
                        break;
                    }
                    case "QUEUE TABLE": {
                        string2 = string2 + "QueueTableSql.xml";
                        query = this.getQueryFromFile(this._conn, QUEUETABLE_DDL, string2);
                        break;
                    }
                    case "REDO LOG GROUP": {
                        string2 = string2 + "RedoLogGroupSql.xml";
                        query = this.getQueryFromFile(this._conn, REDOLOGGROUP_DDL, string2);
                        break;
                    }
                    case "PROCEDURE": {
                        string2 = string2 + "ProcedureSql.xml";
                        query = this.getQueryFromFile(this._conn, PROCEDURE_DDL, string2);
                        break;
                    }
                    case "PACKAGE": {
                        string2 = string2 + "PackageSql.xml";
                        query = this.getQueryFromFile(this._conn, PACKAGESPEC_DDL, string2);
                        break;
                    }
                    case "PACKAGE BODY": {
                        string2 = string2 + "PackageSql.xml";
                        query = this.getQueryFromFile(this._conn, PACKAGEBODY_DDL, string2);
                        break;
                    }
                    case "PACKAGE SPEC+BODY": {
                        string2 = string2 + "PackageSql.xml";
                        query = this.getQueryFromFile(this._conn, PACKAGE_DDL, string2);
                        break;
                    }
                    case "SEQUENCE": {
                        string2 = string2 + "SequenceSql.xml";
                        query = this.getQueryFromFile(this._conn, SEQUENCE_DDL, string2);
                        break;
                    }
                    case "SYNONYM": {
                        string2 = string2 + "SynonymSql.xml";
                        query = this.getQueryFromFile(this._conn, SYNONYM_DDL, string2);
                        break;
                    }
                    case "TABLESPACE": {
                        string2 = string2 + "TableSpaceSql.xml";
                        query = this.getQueryFromFile(this._conn, TABLESPACE_DDL, string2);
                        break;
                    }
                    case "TYPE": {
                        string2 = string2 + "TypeSql.xml";
                        query = this.getQueryFromFile(this._conn, TYPE_DDL, string2);
                        break;
                    }
                    case "USER": {
                        string2 = string2 + "UserSql.xml";
                        query = this.getQueryFromFile(this._conn, USER_DDL, string2);
                        break;
                    }
                    case "ROLE": {
                        string2 = string2 + "RoleSql.xml";
                        query = this.getQueryFromFile(this._conn, ROLE_DDL, string2);
                        break;
                    }
                    case "REF CONSTRAINT": {
                        string2 = string2 + "RefConstraintSql.xml";
                        query = this.getQueryFromFile(this._conn, "script_ddl", string2);
                        break;
                    }
                    case "TRIGGER": {
                        string2 = string2 + "TriggerSql.xml";
                        query = this.getQueryFromFile(this._conn, TRIGGER_DDL, string2);
                        break;
                    }
                }
                Object object = new HashMap();
                object.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
                object.put("NAME", resolvedDBName.getTopLevelName());
                ResultSet resultSet = null;
                DBUtil dBUtil = DBUtil.getInstance(this._conn);
                resultSet = dBUtil.executeQuery(query.getSql(), (Map<String, ?>)object);
                if (resultSet != null) {
                    try {
                        while (resultSet.next()) {
                            String string3 = resultSet.getString(1);
                            String[] stringArray = string3.split("\n");
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i].trim().length() <= 0) continue;
                                this._ctx.getSQLPlusBuffer().add(stringArray[i]);
                                this.writeToCtx(stringArray[i], bufferedWriter);
                            }
                        }
                        bl = true;
                        break block74;
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2) {}
                    }
                }
                sQLException = dBUtil.getLastException();
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
            }
        }
        if (sQLException != null) {
            this.writeToCtx(MessageFormat.format(Messages.getString("DDL_OBJECT_TYPE_NOT_GENERATED"), dDLObjective.getOrigName(), string, sQLException.getLocalizedMessage()));
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<ResolvedDBName> getTypes(String string, String string2) {
        LinkedList<ResolvedDBName> linkedList;
        block28: {
            ResolvedDBName resolvedDBName = null;
            linkedList = new LinkedList<ResolvedDBName>();
            try {
                Object object;
                if (string2 != null && (object = ObjectNamespace.lookup(string2)) != null) {
                    resolvedDBName = this.resolveDBName(string, (ObjectNamespace)((Object)object));
                }
                if (resolvedDBName == null) {
                    resolvedDBName = this.pseudoResolveDBName(string);
                }
                if (resolvedDBName.getTopLevelType() == null) {
                    ResultSet resultSet;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (resolvedDBName.getObjectId() != null) {
                        object = "select object_id,object_type from all_objects where object_id=:OBJECT_ID";
                        hashMap.put("OBJECT_ID", resolvedDBName.getObjectId().toString());
                    } else if (string2 != null) {
                        object = "select object_id,object_type from all_objects where object_name=:OBJECT_NAME and owner=:OWNER and object_type = :OBJECT_TYPE";
                        try {
                            hashMap.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
                            hashMap.put("OBJECT_NAME", resolvedDBName.getTopLevelName());
                            hashMap.put("OBJECT_TYPE", string2);
                        }
                        catch (SQLException sQLException) {
                            resolvedDBName.setObjectType(string2);
                            hashMap = null;
                        }
                    } else {
                        object = "select object_id,object_type from all_objects where object_name=:OBJECT_NAME and owner=:OWNER order by object_type asc";
                        try {
                            hashMap.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
                            hashMap.put("OBJECT_NAME", resolvedDBName.getTopLevelName());
                        }
                        catch (SQLException sQLException) {
                            linkedList.add(resolvedDBName);
                            hashMap = null;
                        }
                    }
                    if (hashMap != null && (resultSet = DBUtil.getInstance(this._conn).executeQuery((String)object, hashMap)) != null) {
                        try {
                            while (resultSet.next()) {
                                Integer n = resultSet.getObject(1) != null ? Integer.valueOf(resultSet.getInt(1)) : null;
                                String string3 = resultSet.getString(2);
                                ResolvedDBName resolvedDBName2 = resolvedDBName.clone();
                                resolvedDBName2.setObjectId(n);
                                resolvedDBName2.setObjectType(string3);
                                linkedList.add(resolvedDBName2);
                            }
                        }
                        catch (SQLException sQLException) {
                        }
                        finally {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                if (linkedList.size() != 0) break block28;
                linkedList.add(resolvedDBName);
            }
            catch (Throwable throwable) {
                if (linkedList.size() == 0) {
                    linkedList.add(resolvedDBName);
                }
                throw throwable;
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TokenizedDBName callTokenizeDBName(String string) throws SQLException {
        if (DBUtil.getConnectionResolver().lock(this._conn)) {
            CallableStatement callableStatement = null;
            try {
                TokenizedDBName tokenizedDBName;
                block12: {
                    try {
                        callableStatement = this._conn.prepareCall("begin SYS.DBMS_UTILITY.NAME_TOKENIZE(?,?,?,?,?,?); end;");
                        callableStatement.setString(1, string);
                        callableStatement.registerOutParameter(2, 12);
                        callableStatement.registerOutParameter(3, 12);
                        callableStatement.registerOutParameter(4, 12);
                        callableStatement.registerOutParameter(5, 12);
                        callableStatement.registerOutParameter(6, 4);
                        callableStatement.execute();
                        String string2 = callableStatement.getString(2);
                        String string3 = callableStatement.getString(3);
                        String string4 = callableStatement.getString(4);
                        String string5 = callableStatement.getString(5);
                        tokenizedDBName = new TokenizedDBName(string2, string3, string4, string5);
                        if (callableStatement == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (callableStatement != null) {
                            try {
                                callableStatement.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return tokenizedDBName;
            }
            finally {
                DBUtil.getConnectionResolver().unlock(this._conn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResolvedDBName callResolveDBName(String string, ObjectNamespace objectNamespace) throws SQLException {
        if (DBUtil.getConnectionResolver().lock(this._conn)) {
            CallableStatement callableStatement = null;
            try {
                ResolvedDBName resolvedDBName;
                block12: {
                    try {
                        callableStatement = this._conn.prepareCall("begin SYS.DBMS_UTILITY.NAME_RESOLVE(?,?,?,?,?,?,?,?); end;");
                        callableStatement.setString(1, string);
                        callableStatement.setInt(2, objectNamespace.getIndex());
                        callableStatement.registerOutParameter(3, 12);
                        callableStatement.registerOutParameter(4, 12);
                        callableStatement.registerOutParameter(5, 12);
                        callableStatement.registerOutParameter(6, 12);
                        callableStatement.registerOutParameter(7, 4);
                        callableStatement.registerOutParameter(8, 4);
                        callableStatement.execute();
                        String string2 = callableStatement.getString(3);
                        String string3 = callableStatement.getString(4);
                        String string4 = callableStatement.getString(5);
                        String string5 = callableStatement.getString(6);
                        Integer n = callableStatement.getObject(7) != null ? Integer.valueOf(callableStatement.getInt(7)) : null;
                        Integer n2 = callableStatement.getObject(8) != null ? Integer.valueOf(callableStatement.getInt(8)) : null;
                        TopLevelType topLevelType = TopLevelType.lookup(n);
                        resolvedDBName = new ResolvedDBName(objectNamespace, string2, string3, string4, string5, topLevelType, n2);
                        if (callableStatement == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (callableStatement != null) {
                            try {
                                callableStatement.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return resolvedDBName;
            }
            finally {
                DBUtil.getConnectionResolver().unlock(this._conn);
            }
        }
        return null;
    }

    protected TokenizedDBName tokenizeDBName(String string) {
        TokenizedDBName tokenizedDBName;
        try {
            tokenizedDBName = this.callTokenizeDBName(string);
        }
        catch (SQLException sQLException) {
            tokenizedDBName = null;
        }
        return tokenizedDBName != null ? tokenizedDBName : new TokenizedDBName(string);
    }

    protected ResolvedDBName pseudoResolveDBName(String string) {
        return this.tokenizeDBName(string).pseudoResolve();
    }

    protected ResolvedDBName resolveDBName(String string, ObjectNamespace objectNamespace) {
        try {
            return this.callResolveDBName(string, objectNamespace);
        }
        catch (SQLException sQLException) {
            return this.pseudoResolveDBName(string);
        }
    }

    protected void writeToCtx(String string, BufferedWriter bufferedWriter) throws IOException {
        if (string != null) {
            this._ctx.write(string);
            this._ctx.write("\n");
        }
        if (bufferedWriter != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
    }

    protected void writeToCtx(String string) {
        try {
            this.writeToCtx(string, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string, this.getQueryFile());
        if (query == null) {
            query = this.getQueryFromFile(connection, string, this.getDefaultQueryFile());
        }
        return query.getSql();
    }

    protected String getQueryFile() {
        return this.getDefaultQueryFile();
    }

    protected Query getQueryFromFile(Connection connection, String string, String string2) {
        URL uRL = this.getClass().getResource(string2);
        MetaResource metaResource = new MetaResource(this.getClass().getClassLoader(), string2);
        if (metaResource.toURL() == null) {
            metaResource.setUrl(uRL);
        }
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport(metaResource);
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    protected String getDefaultQueryFile() {
        return "/oracle/dbtools/raptor/console/xml/ObjectSql.xml";
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public String getCommand() {
        return "DDL";
    }

    @Override
    public String getHelp() {
        return this.help();
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }

    protected static enum TopLevelType {
        TABLE(2),
        VIEW(4),
        SYNONYM(5),
        PROCEDURE(7),
        FUNCTION(8),
        PACKAGE(9);

        private int index;

        private TopLevelType(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public static TopLevelType lookup(int n) {
            switch (n) {
                case 2: {
                    return TABLE;
                }
                case 4: {
                    return VIEW;
                }
                case 5: {
                    return SYNONYM;
                }
                case 7: {
                    return PROCEDURE;
                }
                case 8: {
                    return FUNCTION;
                }
                case 9: {
                    return PACKAGE;
                }
            }
            return null;
        }

        public String getObjectType() {
            return this.toString();
        }
    }

    protected static enum ObjectNamespace {
        TABLE(0),
        PLSQL(1),
        SEQUENCE(2),
        TRIGGER(3),
        TYPE(7),
        INDEX(9);

        private int index;

        private ObjectNamespace(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public static ObjectNamespace lookup(int n) {
            switch (n) {
                case 0: {
                    return TABLE;
                }
                case 1: {
                    return PLSQL;
                }
                case 2: {
                    return SEQUENCE;
                }
                case 3: {
                    return TRIGGER;
                }
                case 7: {
                    return TYPE;
                }
                case 9: {
                    return INDEX;
                }
            }
            return null;
        }

        public static ObjectNamespace lookup(String string) {
            if (string != null) {
                switch (string) {
                    case "TABLE": 
                    case "VIEW": {
                        return TABLE;
                    }
                    case "PL/SQL": 
                    case "PACKAGE": 
                    case "FUNCTION": 
                    case "PROCEDURE": {
                        return PLSQL;
                    }
                }
                try {
                    return ObjectNamespace.valueOf(string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }

        public String getObjectType() {
            switch (this) {
                case PLSQL: 
                case TABLE: {
                    return null;
                }
            }
            return this.toString();
        }
    }

    protected static class ResolvedDBName {
        private final ObjectNamespace namespace;
        private final TokenizedDBName dbName;
        private final TopLevelType part1Type;
        private Integer objectId;
        private String objectType;

        public ResolvedDBName(ObjectNamespace objectNamespace, String string, String string2, String string3, String string4, TopLevelType topLevelType, Integer n) {
            this.namespace = objectNamespace;
            this.dbName = new TokenizedDBName(string, string2, string3, string4);
            this.part1Type = topLevelType;
            this.objectId = n;
            this.objectType = null;
        }

        public ResolvedDBName(String string, String string2, String string3, String string4) {
            this(null, string, string2, string3, string4, null, null);
        }

        public final ObjectNamespace getNamespace() {
            return this.namespace;
        }

        public final String getSchema() {
            return this.dbName.getPartA();
        }

        public final String getPart1() {
            return this.dbName.getPartB();
        }

        public final String getPart2() {
            return this.dbName.getPartC();
        }

        public final String getDbLink() {
            return this.dbName.getDbLink();
        }

        public final TopLevelType getPart1Type() {
            return this.part1Type;
        }

        public final Integer getObjectId() {
            return this.objectId;
        }

        public final void setObjectId(Integer n) {
            this.objectId = n;
        }

        public final String getObjectType() {
            return this.objectType;
        }

        public final void setObjectType(String string) {
            this.objectType = string;
        }

        public final String getTopLevelName() {
            if (this.part1Type != null) {
                switch (this.part1Type) {
                    case FUNCTION: 
                    case PROCEDURE: {
                        return this.getPart2();
                    }
                }
            }
            return this.getPart1();
        }

        public final String getTopLevelType() {
            if (this.objectType != null) {
                return this.objectType;
            }
            if (this.part1Type != null) {
                return this.part1Type.getObjectType();
            }
            if (this.namespace != null) {
                return this.namespace.getObjectType();
            }
            return null;
        }

        protected ResolvedDBName clone() {
            ResolvedDBName resolvedDBName = new ResolvedDBName(this.namespace, this.getSchema(), this.getPart1(), this.getPart2(), this.getDbLink(), this.part1Type, this.objectId);
            resolvedDBName.setObjectType(this.objectType);
            return resolvedDBName;
        }
    }

    protected static class TokenizedDBName {
        private String partA;
        private String partB;
        private String partC;
        private String dbLink;

        public TokenizedDBName(String string, String string2, String string3, String string4) {
            this.partA = string;
            this.partB = string2;
            this.partC = string3;
            this.dbLink = string4;
        }

        public TokenizedDBName(String string) {
            this(string, null, null, null);
        }

        public final String getPartA() {
            return this.partA;
        }

        public final String getPartB() {
            return this.partB;
        }

        public final String getPartC() {
            return this.partC;
        }

        public final String getDbLink() {
            return this.dbLink;
        }

        public ResolvedDBName pseudoResolve() {
            if (this.partB != null) {
                return new ResolvedDBName(this.partA.toUpperCase(), this.partB, this.partC, this.dbLink);
            }
            return new ResolvedDBName(null, this.partA, null, this.dbLink);
        }
    }

    protected static class DDLObjective {
        private LinkedList<ResolvedDBName> resolvedDBNames;
        private final String origName;
        private final String origType;
        private final boolean outputComponentsOnly;
        private final ArrayList<String> componentTypes;

        public DDLObjective(String string, String string2, List<String> list, boolean bl) {
            this.origName = string;
            this.origType = string2;
            this.outputComponentsOnly = bl;
            this.componentTypes = list != null ? new ArrayList<String>(list) : new ArrayList();
            this.resolvedDBNames = new LinkedList();
        }

        public DDLObjective(String string, String string2) {
            this(string, string2, null, false);
        }

        public String getOrigName() {
            return this.origName;
        }

        public String getOrigType() {
            return this.origType;
        }

        public boolean outputComponentsOnly() {
            return this.outputComponentsOnly;
        }

        public List<String> getComponentTypes() {
            return this.componentTypes;
        }

        public List<ResolvedDBName> getResolvedDBNames() {
            return this.resolvedDBNames;
        }

        public void setResolvedDBName(List<ResolvedDBName> list) {
            this.resolvedDBNames = list != null ? new LinkedList<ResolvedDBName>(list) : new LinkedList();
        }
    }
}

