/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.newscriptrunner.Clearable;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleClearScreen;

public class Clear
extends CommandListener
implements IHelp {
    private static final String ALLCLR_PTRN = "(?:\\bcol(?:u|um|umn|umns)?\\b|\\bscr(?:e|ee|een)?\\b|\\bcomp(?:|u|ut|ute|utes)\\b|\\bbre(?:ak|aks)?\\b|\\bbuf(?:f|fe|fer)?\\b|\\bsq(?:l)?\\b)";
    private static final String CLEAR = "CLEAR";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().toLowerCase().trim().replaceAll("\\s+", " ");
        String[] stringArray = string.split(" ");
        String string2 = "";
        boolean bl = false;
        if (stringArray.length > 1) {
            Pattern pattern = null;
            pattern = Pattern.compile(ALLCLR_PTRN, 4);
            if (pattern != null) {
                Matcher matcher = pattern.matcher(string);
                while (matcher.find()) {
                    Object object;
                    String string3 = matcher.group();
                    if (string3.startsWith("col")) {
                        scriptRunnerContext.getStoredFormatCmds().clear();
                        bl = true;
                        scriptRunnerContext.write(Messages.getString("Clear.6"));
                        continue;
                    }
                    if (string3.startsWith("buf")) {
                        if (scriptRunnerContext.getSQLPlusBuffer() == null) continue;
                        scriptRunnerContext.getSQLPlusBuffer().clear();
                        scriptRunnerContext.getSQLPlusBuffer().getBufferSafe().clear();
                        scriptRunnerContext.write("buffer cleared\n");
                        continue;
                    }
                    if (string3.startsWith("sql")) {
                        if (scriptRunnerContext.getSQLPlusBuffer() == null) continue;
                        scriptRunnerContext.getSQLPlusBuffer().clear();
                        scriptRunnerContext.getSQLPlusBuffer().getBufferSafe().clear();
                        scriptRunnerContext.write("sql cleared\n");
                        continue;
                    }
                    if (string3.startsWith("comp")) {
                        scriptRunnerContext.getStoredComputeCmds().clear();
                        scriptRunnerContext.write("computes cleared\n");
                        continue;
                    }
                    if (string3.startsWith("bre")) {
                        scriptRunnerContext.getStoredBreakCmds().clear();
                        scriptRunnerContext.write("breaks cleared\n");
                        continue;
                    }
                    if (!string3.startsWith("scr")) continue;
                    if (scriptRunnerContext.getSQLPlusConsoleReader() != null) {
                        try {
                            object = scriptRunnerContext.getPrompt();
                            IConsoleClearScreen iConsoleClearScreen = (IConsoleClearScreen)scriptRunnerContext.getSQLPlusConsoleReader();
                            iConsoleClearScreen.setPrompt("");
                            iConsoleClearScreen.doClearScreen();
                            iConsoleClearScreen.setPrompt((String)object);
                            bl = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!(scriptRunnerContext.getOutputComponent() instanceof Clearable)) continue;
                    object = (Clearable)scriptRunnerContext.getOutputComponent();
                    SwingUtilities.invokeLater(new Runnable((Clearable)object){
                        final /* synthetic */ Clearable val$clearme;
                        {
                            this.val$clearme = clearable;
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$clearme.clear();
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                    });
                    bl = true;
                }
            }
        } else {
            scriptRunnerContext.write(this.getHelp());
        }
        return bl;
    }

    @Override
    public String getCommand() {
        return CLEAR;
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(CLEAR);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

