/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class CdCommand
extends CommandListener
implements IHelp,
IShowCommand {
    @Override
    public String getCommand() {
        return "CD";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSql().trim().split("[ \t\n]+");
        if (stringArray.length > 0) {
            Object var5_5 = null;
            if (stringArray[0].toLowerCase().equals(this.getCommandName().toLowerCase())) {
                if (stringArray.length == 1) {
                    scriptRunnerContext.getProperties().remove("script.runner.cd_command");
                    scriptRunnerContext.getMap().remove(ScriptRunnerContext.SqlplusVariable._PWD.toString());
                    return this.handleReturn(true);
                }
                if (stringArray.length > 1) {
                    String string = iSQLCommand.getSql().trim().substring(2).trim();
                    if ((string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) && string.length() > 2) {
                        string = string.substring(1, string.length() - 1);
                    }
                    if (System.getProperty("os.name").startsWith("Windows") && string.startsWith("/") && string.length() > 3 && string.substring(2, 3).equals(":")) {
                        string = string.substring(1);
                    }
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        string = string.replace("/", "\\");
                    }
                    if (!System.getProperty("os.name").startsWith("Windows") && string.startsWith("~")) {
                        string = string.replaceFirst("~", System.getProperty("user.home"));
                    }
                    if (string != null && new File(string).isDirectory()) {
                        String string2 = null;
                        try {
                            string2 = new File(string).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        scriptRunnerContext.putProperty("script.runner.cd_command", string2 != null ? string2 : string);
                        scriptRunnerContext.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), string2 != null ? string2 : string);
                    } else {
                        scriptRunnerContext.write(MessageFormat.format(Messages.getString("CDNOTFOUND"), string) + "\n");
                    }
                }
                return this.handleReturn(true);
            }
        }
        return false;
    }

    public String getCommandName() {
        return "CD";
    }

    boolean handleReturn(boolean bl) {
        if (!bl) {
            // empty if block
        }
        return true;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = null;
        string = scriptRunnerContext.getProperties().containsKey("script.runner.cd_command") && scriptRunnerContext.getProperties().get("script.runner.cd_command") != null ? (String)scriptRunnerContext.getProperties().get("script.runner.cd_command") : "Default";
        scriptRunnerContext.write("");
        scriptRunnerContext.write(MessageFormat.format(Messages.getString("CD"), string) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"cd"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

