/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Break
extends CommandListener {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String BREAK = "\\b(?i:br(?:e\\b|ea\\b|eak\\b))";
    private static final String ON = "\\b(?i:(?:on|by|across))\\b";
    private static final String REPORT_ELEMENT = "(?:\\b(?i:report)\\b|\\b(?i:row)\\b|\\b(?!(?i:report)|(?i:row))([\\p{Graph}]+?)\\b)";
    private static final String SKIP1 = "(?i:\\bski(?:|p)\\b)(\\s+\\d+)?";
    private static final String SKIP2 = "((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b)";
    private static final String SKIP = "(?:(?i:\\bski(?:|p)\\b)(\\s+\\d+)?|((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b))";
    private static final String DUP = "(?i:dup(?:|licates))";
    private static final String NODUP = "(?i:no)(?i:dup(?:|licates))";
    private static final String DUP_OR_NODUP = "(?:(?i:dup(?:|licates))|(?i:no)(?i:dup(?:|licates)))";
    private static final String ACTION = "(?:(?:(?i:\\bski(?:|p)\\b)(\\s+\\d+)?|((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b))|(?:(?i:dup(?:|licates))|(?i:no)(?i:dup(?:|licates))))";
    private static final String CMD = "\\b(?i:br(?:e\\b|ea\\b|eak\\b))(\\s+\\b(?i:(?:on|by|across))\\b\\s+(?:\\b(?i:report)\\b|\\b(?i:row)\\b|\\b(?!(?i:report)|(?i:row))([\\p{Graph}]+?)\\b)(\\s+(?:(?:(?i:\\bski(?:|p)\\b)(\\s+\\d+)?|((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b))|(?:(?i:dup(?:|licates))|(?i:no)(?i:dup(?:|licates)))))*)+";
    private static final String CLEAR = "\\b(?i:cl(?:e\\b|ea\\b|ear\\b))\\s+\\b(?i:br(?:e\\b|ea\\b|eak\\b))";

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim();
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = scriptRunnerContext.getStoredBreakCmds();
        Pattern pattern = Pattern.compile(CMD);
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.matches();
        if (bl) {
            String[] stringArray;
            string = string.trim();
            linkedHashMap.clear();
            string = string.replaceFirst("\\b(?i:br(?:e\\b|ea\\b|eak\\b))\\s+", "");
            for (String string2 : stringArray = string.split("(\\s*\\b(?i:(?:on|by|across))\\b\\s*)")) {
                String string3;
                Object object;
                if (string2.length() <= 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string4 = string2.split("\\s+")[0];
                String string5 = string2.replaceFirst(string4, "").replaceFirst("\\s+", "");
                Pattern pattern2 = Pattern.compile(ACTION);
                Matcher matcher2 = pattern2.matcher(string5);
                while (matcher2.find()) {
                    if (matcher2.group().matches(SKIP2)) {
                        arrayList.add("page");
                        continue;
                    }
                    if (matcher2.group().matches(SKIP1)) {
                        if (matcher2.group(1) == null || matcher2.group(1).trim().equals("0")) continue;
                        arrayList.add(matcher2.group());
                        continue;
                    }
                    arrayList.add(matcher2.group());
                }
                if (arrayList.size() == 0) {
                    arrayList.add("nodup");
                } else {
                    object = arrayList.iterator();
                    boolean bl2 = false;
                    while (object.hasNext()) {
                        string3 = (String)object.next();
                        if (!string3.matches(DUP_OR_NODUP)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        arrayList.add("nodup");
                    }
                }
                object = this.getKeyForStr(scriptRunnerContext.getStoredBreakCmds(), string4);
                if (object != null && (string4.equalsIgnoreCase("report") || string4.equalsIgnoreCase("row"))) {
                    scriptRunnerContext.getStoredBreakCmds().put((String)object, arrayList);
                    continue;
                }
                LinkedHashMap<String, ArrayList<String>> linkedHashMap2 = new LinkedHashMap<String, ArrayList<String>>();
                if (string4.equalsIgnoreCase("report")) {
                    linkedHashMap2.put(string4, arrayList);
                    linkedHashMap2.putAll(scriptRunnerContext.getStoredBreakCmds());
                    scriptRunnerContext.setStoredBreakCmds(linkedHashMap2);
                    continue;
                }
                if (string4.equalsIgnoreCase("row")) {
                    linkedHashMap2.putAll(scriptRunnerContext.getStoredBreakCmds());
                    linkedHashMap2.put(string4, arrayList);
                    scriptRunnerContext.setStoredBreakCmds(linkedHashMap2);
                    continue;
                }
                string3 = this.getKeyForStr(scriptRunnerContext.getStoredBreakCmds(), "row");
                if (string3 != null) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    ArrayList<String> arrayList3 = scriptRunnerContext.getStoredBreakCmds().get(string3);
                    arrayList2.addAll(arrayList3);
                    linkedHashMap2.putAll(scriptRunnerContext.getStoredBreakCmds());
                    linkedHashMap2.remove(string3);
                    linkedHashMap2.put(string4, arrayList);
                    linkedHashMap2.put(string3, arrayList2);
                    scriptRunnerContext.setStoredBreakCmds(linkedHashMap2);
                    continue;
                }
                scriptRunnerContext.getStoredBreakCmds().put(string4, arrayList);
            }
        } else if (string.matches(BREAK)) {
            String string6 = "";
            if (linkedHashMap.size() > 0) {
                string6 = "break ";
                String string7 = String.format("%1$" + string6.length() + "s", " ");
                Iterator<String> iterator = linkedHashMap.keySet().iterator();
                int n = -1;
                while (iterator.hasNext()) {
                    String string8 = iterator.next();
                    ArrayList<String> arrayList = linkedHashMap.get(string8);
                    if (++n > 0) {
                        string6 = string6 + string7;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (i == 0) {
                            string6 = string6 + "on " + string8 + " ";
                        }
                        String string9 = arrayList.get(i);
                        string6 = string6 + string9 + " ";
                    }
                    string6 = string6 + m_lineSeparator;
                }
                scriptRunnerContext.write(string6);
            } else {
                scriptRunnerContext.write(Messages.getString("NOBREAKS") + m_lineSeparator);
            }
        } else {
            String string10 = string;
            String[] stringArray = new String[]{BREAK, ON, REPORT_ELEMENT, ACTION};
            for (int i = 0; i < stringArray.length; ++i) {
                Pattern pattern3 = Pattern.compile(stringArray[i]);
                Matcher matcher3 = pattern3.matcher(string10);
                if (matcher3.find()) {
                    if (stringArray[i].equals(REPORT_ELEMENT)) {
                        string10 = string10.replaceFirst(stringArray[i], "").trim();
                        continue;
                    }
                    string10 = string10.replaceAll(stringArray[i], "").trim();
                    continue;
                }
                if (stringArray[i].equals(ON)) {
                    scriptRunnerContext.write(Messages.getString("BRK_SPEC") + m_lineSeparator);
                } else {
                    if (!stringArray[i].equals(ACTION)) continue;
                    scriptRunnerContext.write(MessageFormat.format(Messages.getString("BRK_ACTN"), string10.split("\\s+")[0]) + m_lineSeparator);
                }
                break;
            }
        }
        return false;
    }

    private String getKeyForStr(LinkedHashMap<String, ArrayList<String>> linkedHashMap, String string) {
        String string2 = null;
        for (String string3 : linkedHashMap.keySet()) {
            if (!string.equalsIgnoreCase(string3)) continue;
            string2 = string3;
            return string2;
        }
        return string2;
    }

    public static boolean hasRowElement(LinkedHashMap<String, ArrayList<String>> linkedHashMap) {
        boolean bl = false;
        for (String string : linkedHashMap.keySet()) {
            if (!string.matches("(?i:row)")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

