/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class WrapListenBufferOutputStream
extends BufferedOutputStream {
    private BufferedOutputStream m_out = null;
    private ArrayList<BufferedOutputStream> m_alout = new ArrayList();
    private File m_fileOutput = null;
    private boolean m_removeForcePrint = false;
    private ScriptRunnerContext ctx = null;
    private ByteArrayOutputStream blankStore = null;
    private BufferedOutputStream blankBuff = null;
    private static String ENCODING = "UTF-8";
    private boolean bufferEmpty = true;

    public WrapListenBufferOutputStream(OutputStream outputStream) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
        assert (outputStream instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)outputStream;
        this.addToList((BufferedOutputStream)outputStream);
    }

    public WrapListenBufferOutputStream(OutputStream outputStream, int n) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()), n);
        assert (outputStream instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)outputStream;
        this.addToList((BufferedOutputStream)outputStream);
    }

    public WrapListenBufferOutputStream(OutputStream outputStream, ScriptRunnerContext scriptRunnerContext) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
        assert (outputStream instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)outputStream;
        this.addToList((BufferedOutputStream)outputStream);
        this.ctx = scriptRunnerContext;
    }

    public BufferedOutputStream getMainStream() {
        return this.m_out;
    }

    private boolean doIWrite(BufferedOutputStream bufferedOutputStream) {
        if (this.ctx != null && !this.ctx.getTopLevel() && this.ctx.isOutputSupressed()) {
            BufferedOutputStream bufferedOutputStream2 = (BufferedOutputStream)this.ctx.getProperty("Spool.out.buffer");
            return bufferedOutputStream2 != null && (this.equals(bufferedOutputStream2) || bufferedOutputStream.equals(bufferedOutputStream2));
        }
        return true;
    }

    public void replaceMainStream(BufferedOutputStream bufferedOutputStream) throws IOException {
        if (!this.m_out.equals(bufferedOutputStream)) {
            this.flush();
            this.removeFromList(this.m_out);
            this.addToList(bufferedOutputStream);
            this.m_out = bufferedOutputStream;
        }
    }

    public void addToList(BufferedOutputStream bufferedOutputStream) {
        this.m_alout.add(bufferedOutputStream);
    }

    public boolean removeFromList(BufferedOutputStream bufferedOutputStream) {
        return this.m_alout.remove(bufferedOutputStream);
    }

    @Override
    public void flush() throws IOException {
        IOException iOException = null;
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            try {
                bufferedOutputStream.flush();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 != 0) {
            if (this.ctx != null && (Boolean)this.ctx.getProperty("script.runner.settrimspool") != null && Boolean.valueOf(this.ctx.getProperty("script.runner.settrimspool").equals(Boolean.TRUE)).booleanValue() && this.ctx.getProperty("Spool.out.buffer") != null && this.ctx.getProperty("Spool.out.buffer").equals(this) || !this.bufferEmpty) {
                if (this.blankStore == null) {
                    this.blankStore = new ByteArrayOutputStream();
                }
                if (this.blankBuff == null) {
                    this.blankBuff = new BufferedOutputStream(this.blankStore);
                }
                StringBuffer stringBuffer = new StringBuffer("");
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                String string = new String(byArray2, ENCODING);
                block10: for (int i = 0; i < string.length(); ++i) {
                    String string2;
                    switch (string2 = string.substring(i, i + 1)) {
                        case "\r": 
                        case "\n": {
                            this.blankStore = new ByteArrayOutputStream();
                            this.blankBuff = new BufferedOutputStream(this.blankStore);
                            stringBuffer.append(string2);
                            this.bufferEmpty = true;
                            continue block10;
                        }
                        case "\t": 
                        case " ": {
                            this.blankStore.write(string2.getBytes(Charset.forName(ENCODING)));
                            this.bufferEmpty = false;
                            continue block10;
                        }
                        default: {
                            this.blankBuff.flush();
                            byte[] byArray3 = this.blankStore.toByteArray();
                            this.blankStore = new ByteArrayOutputStream();
                            this.blankBuff = new BufferedOutputStream(this.blankStore);
                            this.bufferEmpty = true;
                            if (byArray3.length > 0) {
                                stringBuffer.append(new String(byArray3, ENCODING));
                            }
                            stringBuffer.append(string2);
                        }
                    }
                }
                if (stringBuffer.length() > 0) {
                    byte[] byArray4 = stringBuffer.toString().getBytes(Charset.forName(ENCODING));
                    this.reallywrite(byArray4, 0, byArray4.length);
                }
            } else {
                this.reallywrite(byArray, n, n2);
            }
        }
    }

    public void reallywrite(byte[] byArray, int n, int n2) throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                if (this.doIWrite(bufferedOutputStream)) {
                    bufferedOutputStream.write(byArray, n, n2);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void close() throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.checkForExit();
        if (this.ctx != null && (Boolean)this.ctx.getProperty("script.runner.settrimspool") != null && Boolean.valueOf(this.ctx.getProperty("script.runner.settrimspool").equals(Boolean.TRUE)).booleanValue() && this.ctx.getProperty("Spool.out.buffer") != null && this.ctx.getProperty("Spool.out.buffer").equals(this) || !this.bufferEmpty) {
            if (!this.m_removeForcePrint || !Arrays.equals("force_print".getBytes("UTF8"), byArray) && !Arrays.equals(ScriptRunner.FORCE_PRINT_BYTES, byArray)) {
                this.write(byArray, 0, byArray.length);
            }
        } else {
            for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
                IOException iOException = null;
                try {
                    if ((!this.m_removeForcePrint || !Arrays.equals("force_print".getBytes("UTF8"), byArray) && !Arrays.equals(ScriptRunner.FORCE_PRINT_BYTES, byArray)) && this.doIWrite(bufferedOutputStream)) {
                        bufferedOutputStream.write(byArray);
                    }
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
                if (iOException == null) continue;
                throw iOException;
            }
        }
    }

    private void checkForExit() throws IOException {
        if (this.ctx != null && this.ctx.isCommandLine() && this.ctx.isInterrupted()) {
            throw new InterruptedIOException();
        }
    }

    public File getFileOutput() {
        return this.m_fileOutput;
    }

    public void setFileOutput(File file) {
        this.m_fileOutput = file;
    }

    public boolean isRemoveForcePrint() {
        return this.m_removeForcePrint;
    }

    public void setRemoveForcePrint(boolean bl) {
        this.m_removeForcePrint = bl;
    }
}

