/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrapBufferOutputStreamToWriter
extends BufferedOutputStream {
    private PipedOutputStream m_out = null;
    OutputRedirectorForSpool outputRedirectorForSpool = null;
    private String m_terminator = System.getProperty("line.separator");

    public WrapBufferOutputStreamToWriter(OutputStream outputStream) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
    }

    public WrapBufferOutputStreamToWriter(OutputStream outputStream, int n) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()), n);
    }

    public void setOut(BufferedWriter bufferedWriter) throws IOException {
        PipedOutputStream pipedOutputStream;
        this.flush();
        this.close();
        PipedInputStream pipedInputStream = new PipedInputStream();
        this.m_out = pipedOutputStream = new PipedOutputStream(pipedInputStream);
        this.outputRedirectorForSpool = new OutputRedirectorForSpool(pipedInputStream, bufferedWriter);
        this.outputRedirectorForSpool.start();
    }

    @Override
    public void flush() throws IOException {
        if (this.m_out != null) {
            this.m_out.flush();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(byArray, n, n2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(n);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_out != null) {
            this.flush();
            this.m_out.close();
            this.m_out = null;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(byArray);
        }
    }

    public void setTerminator(String string) {
        this.m_terminator = string;
    }

    public String getTerminator() {
        return this.m_terminator;
    }

    class OutputRedirectorForSpool
    extends Thread {
        private BufferedWriter m_bw = null;
        private PipedInputStream m_in = null;
        private BufferedReader m_reader;
        private String m_term = null;
        private String m_stringTerminator = System.getProperty("line.separator");

        public OutputRedirectorForSpool(PipedInputStream pipedInputStream, BufferedWriter bufferedWriter) {
            this.m_bw = bufferedWriter;
            this.m_in = pipedInputStream;
            this.m_term = this.getLineTerminator();
            try {
                this.m_reader = new BufferedReader(new InputStreamReader((InputStream)this.m_in, "UTF8"));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.m_reader.readLine()) != null) {
                    this.m_bw.write(string + this.m_term);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    if (this.m_reader != null) {
                        this.m_reader.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (this.m_bw != null) {
                        this.m_bw.flush();
                        this.m_bw.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public void setLineTerminator(String string) {
            this.m_stringTerminator = string;
        }

        String getLineTerminator() {
            return this.m_stringTerminator;
        }
    }
}

