/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ExecutePathCheckReturn;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.newscriptrunner.PathException;
import oracle.dbtools.raptor.newscriptrunner.ProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Pair;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class SQLPLUS
extends SQLCommandRunner {
    public static String PRODUCT_NAME = "SQL Developer";
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private String directory = null;
    public static ProviderForSQLPATH sqlpathProvider = null;
    private ScriptExecutor _runner = null;

    public SQLPLUS(ISQLCommand iSQLCommand, BufferedOutputStream bufferedOutputStream) {
        super(iSQLCommand, bufferedOutputStream);
    }

    public static void setProductName(String string) {
        PRODUCT_NAME = string;
    }

    @Override
    public void interrupt() {
        if (this._runner != null) {
            this._runner.interrupt();
        }
    }

    public void run() {
        String string = this.cmd.getSql().trim();
        if (string.endsWith(";") && string.length() > 1) {
            this.cmd.setSql(string.substring(0, string.length() - 1));
        }
        if (this.cmd.isSqlPlusSetCmd()) {
            this.runSetPlus();
        }
        switch (this.cmd.getStmtSubType()) {
            case G_S_UNKNOWN: {
                try {
                    if (this.runAliases()) break;
                    this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"), this.getScriptRunnerContext()) + "\n");
                    if (this.cmd.getSQLOrig().contains("\u200b")) {
                        this.report(ScriptRunnerDbArb.format("ORIGINAL_TEXT_CONTAINED", "Unicode u200B"));
                    }
                    this.cmd.setProperty("EXECUTEFAILED", "EXECUTEFAILED");
                }
                catch (ArgumentQuoteException argumentQuoteException) {
                    this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("QUOTEMISMATCH", argumentQuoteException.getMessage()), this.getScriptRunnerContext()));
                    this.doWhenever(false);
                }
                break;
            }
            case G_S_EXECUTE: {
                this.runExecute();
                break;
            }
            case G_S_VARIABLE: {
                this.runVariable();
                break;
            }
            case G_S_PRINT: {
                this.runPrint();
                break;
            }
            case G_S_DOC_PLUS: 
            case G_S_PROMPT: {
                this.runPrompt();
                break;
            }
            case G_S_START: 
            case G_S_AT: 
            case G_S_ATNESTED: {
                this.runExecuteFile();
                break;
            }
            case G_S_EXIT: 
            case G_S_QUIT: {
                this.runQuit();
                break;
            }
            case G_S_CONNECT: {
                this.runConnect();
                break;
            }
            case G_S_WHENEVER: {
                this.runWhenever();
                break;
            }
            case G_S_DEFINE: {
                this.runDefine();
                break;
            }
            case G_S_UNDEFINE: {
                this.runUndefine();
                break;
            }
            case G_S_ACCEPT: {
                break;
            }
            case G_S_COLUMN: {
                this.runColumn();
                break;
            }
            case G_S_PASSWORD: {
                this.runPassword();
                break;
            }
            case G_S_COPY: {
                this.runCopy();
                break;
            }
            case G_S_SET_CONSTRAINT: 
            case G_S_SET_ROLE: {
                break;
            }
            case G_S_DISCONNECT: {
                this.runDisconnect();
                break;
            }
            case G_S_COMMENT_PLUS: {
                break;
            }
            case G_S_SLASH: {
                this.runBuffer();
                break;
            }
            case G_S_RUN: {
                if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                    this.getScriptRunnerContext().write(this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().list());
                }
                this.runBuffer();
                break;
            }
            case G_S_ROLLBACK_PLUS: {
                try {
                    this.conn.rollback();
                    this.report("rollback complete.");
                    break;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
    }

    private void runBuffer() {
        if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn) && this.getScriptRunnerContext().getSQLPlusBuffer() != null) {
            IBuffer iBuffer = this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe();
            this._runner = new ScriptExecutor(iBuffer.getBuffer(), this.conn);
            this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
            this._runner.run();
        }
    }

    public static void disconnectMessage(Connection connection, ScriptRunnerContext scriptRunnerContext, BufferedOutputStream bufferedOutputStream) {
        if (connection != null && !SQLPLUS.isConnectionClosed(connection)) {
            String string = scriptRunnerContext.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
            if (scriptRunnerContext.getProperty("script.runner.sqlplus.silent") == null) {
                ScriptUtils.report(ScriptRunnerDbArb.format("DISCONNECTED_FROM", string), bufferedOutputStream);
            }
        }
    }

    private void runDisconnect() {
        if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn)) {
            if (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") == null || ((Boolean)this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.FALSE)) {
                SQLPLUS.disconnectMessage(this.conn, this.getScriptRunnerContext(), this.out);
                this.commitConnection(this.conn);
            }
            this.configureOldConnections(this.conn);
        }
        this.conn = null;
        this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
        this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
        this.getScriptRunnerContext().setCurrentConnection(this.conn);
        this.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void runCopy() {
        boolean bl;
        String string;
        String[] stringArray;
        block319: {
            this.cmd.setSql(SQLPLUS.removeDashNewline(this.cmd, this.cmd.getSql()));
            String string2 = this.cmd.getSql().trim();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            stringArray = this.nextWordAndRest(string2);
            string = null;
            boolean bl2 = false;
            bl = false;
            if (stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("COPY") && stringArray.length == 2 && stringArray[1] != null) {
                if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("FROM") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        string3 = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (string == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("TO") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        string4 = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (string == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("FROM") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        string3 = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (string == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("TO") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        string4 = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (string == null && stringArray != null && stringArray[0] != null && (stringArray[0].equalsIgnoreCase("APPEND") || stringArray[0].equalsIgnoreCase("APPEND_BYTE") || stringArray[0].equalsIgnoreCase("CREATE") || stringArray[0].equalsIgnoreCase("CREATE_BYTE") || stringArray[0].equalsIgnoreCase("INSERT") || stringArray[0].equalsIgnoreCase("REPLACE_BYTE") || stringArray[0].equalsIgnoreCase("REPLACE")) && stringArray.length == 2 && stringArray[1] != null) {
                    string5 = stringArray[0].toUpperCase();
                    if (string5.equals("CREATE_BYTE")) {
                        bl2 = true;
                        string5 = "CREATE";
                    }
                    if (string5.equals("APPEND_BYTE")) {
                        bl2 = true;
                        string5 = "APPEND";
                    }
                    if (string5.equals("REPLACE_BYTE")) {
                        bl2 = true;
                        string5 = "REPLACE";
                    }
                } else {
                    string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                }
                if (string == null && stringArray != null) {
                    stringArray = this.nextWordAndRestOrString(stringArray[1].trim(), "(");
                }
                if (string == null && stringArray != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                    string6 = stringArray[0];
                    string6 = string6.length() > 2 && string6.startsWith("\"") && string6.endsWith("\"") ? string6.substring(1, string6.length() - 1) : string6.toUpperCase();
                } else {
                    string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                }
                if (string == null && stringArray != null) {
                    String string9 = stringArray[1].trim();
                    if (string9.startsWith("(") && string9.indexOf(")") != -1) {
                        string7 = string9.substring(1, string9.indexOf(")"));
                        try {
                            string9 = string9.substring(string9.indexOf(")") + 1);
                        }
                        catch (Exception exception) {
                            string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                        }
                        string9 = string9.trim();
                    }
                    if (string == null && stringArray != null) {
                        stringArray = this.nextWordAndRest(string9);
                    }
                    if (string == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("USING") && stringArray.length == 2 && stringArray[1] != null) {
                        Object object;
                        Object object2;
                        Serializable serializable;
                        Object object3;
                        Object object422;
                        Object[] objectArray;
                        string8 = stringArray[1];
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (string7 != null) {
                            objectArray = string7.trim().split("\\s*,\\s*");
                            for (Object object422 : objectArray) {
                                Object object5 = null;
                                object5 = object422;
                                object5 = ((String)object5).length() > 2 && ((String)object5).startsWith("\"") && ((String)object5).endsWith("\"") ? ((String)object5).substring(1, ((String)object5).length() - 1) : ((String)object5).toUpperCase();
                                arrayList.add((String)object5);
                            }
                        }
                        objectArray = new Connection[]{null, null};
                        String[] stringArray2 = new String[]{string3, string4};
                        for (int i = 0; i < 2; ++i) {
                            if (string != null || stringArray2[i] == null) continue;
                            int n = 0;
                            object422 = ScriptUtils.getConnectionDetails("connect " + stringArray2[i]);
                            if (object422 != null && ((ConnectionDetails)object422).getRoleBad()) {
                                string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                                continue;
                            }
                            if (object422 != null && ((ConnectionDetails)object422).getConnectDB() != null && !((ConnectionDetails)object422).getConnectDB().equals("")) {
                                oracle.dbtools.db.ConnectionDetails connectionDetails = null;
                                try {
                                    connectionDetails = new oracle.dbtools.db.ConnectionDetails(((ConnectionDetails)object422).getConnectDB());
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
                                }
                                if (connectionDetails != null && connectionDetails.getDriver() != null) {
                                    n = 1;
                                }
                            }
                            boolean bl3 = false;
                            object3 = null;
                            serializable = new ArrayList<String>();
                            try {
                                if (n == 0 && object422 != null) {
                                    boolean bl4 = bl3 = !this.connectCallDialog((ConnectionDetails)object422);
                                }
                                if (!this.getScriptRunnerContext().getExited() && object422 != null && !bl3 && n == 0) {
                                    if (((ConnectionDetails)object422).getConnection() != null) {
                                        object3 = this.getConnection((ArrayList<String>)serializable, ((ConnectionDetails)object422).getConnectName(), ((ConnectionDetails)object422).getConnectPassword(), ((ConnectionDetails)object422).getConnectDB(), ((ConnectionDetails)object422).getRole());
                                    } else {
                                        object3 = ((ConnectionDetails)object422).getConnection();
                                        ((ConnectionDetails)object422).setConnection(null);
                                    }
                                }
                            }
                            finally {
                                if (object422 != null && ((ConnectionDetails)object422).getConnection() != null) {
                                    try {
                                        ((ConnectionDetails)object422).getConnection().close();
                                    }
                                    catch (SQLException sQLException) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                    }
                                }
                            }
                            if (!this.getScriptRunnerContext().getExited()) {
                                if (object422 != null && !bl3 && n == 0 && object3 == null) {
                                    object2 = ((ArrayList)serializable).iterator();
                                    while (object2.hasNext()) {
                                        object = (String)object2.next();
                                        if (this.getScriptRunnerContext().getOutputStream() != null) {
                                            this.getScriptRunnerContext().write((String)object);
                                            continue;
                                        }
                                        System.out.print((String)object);
                                    }
                                }
                                if (object3 != null) {
                                    objectArray[i] = object3;
                                }
                            }
                            if (object3 != null) continue;
                            if (objectArray[0] != null) {
                                try {
                                    objectArray[0].close();
                                }
                                catch (SQLException sQLException) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                }
                            }
                            string = ScriptRunnerDbArb.getString("COPY_CONNECTION_FAILED");
                        }
                        if (string == null && objectArray[0] == null && objectArray[1] == null) {
                            string = ScriptRunnerDbArb.getString("COPY_EITHER_FROM_OR_TO");
                        }
                        if (string == null) {
                            Object object6 = objectArray[0];
                            Object object7 = objectArray[1];
                            object422 = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.autocommit.checkbox");
                            try {
                                if (object422 == null || ((Boolean)object422).equals(Boolean.FALSE)) {
                                    if (object7 != null) {
                                        object7.setAutoCommit(false);
                                    }
                                    if (object6 != null) {
                                        object6.setAutoCommit(false);
                                    }
                                } else {
                                    if (object7 != null) {
                                        object7.setAutoCommit(true);
                                    }
                                    if (object6 != null) {
                                        object6.setAutoCommit(true);
                                    }
                                }
                            }
                            catch (SQLException sQLException) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                            }
                            if (object6 == null) {
                                object6 = this.getScriptRunnerContext().getCurrentConnection();
                            }
                            if (object7 == null) {
                                object7 = this.getScriptRunnerContext().getCurrentConnection();
                            }
                            int n = 0;
                            object3 = (String)this.getScriptRunnerContext().getProperty("script.runner.copycommit");
                            if (object3 != null) {
                                try {
                                    n = Integer.parseInt((String)object3);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n = 0;
                                }
                            }
                            serializable = null;
                            if (this.getScriptRunnerContext().getProperty("script.runner.arraysize") != null) {
                                serializable = Integer.valueOf((String)this.getScriptRunnerContext().getProperty("script.runner.arraysize"));
                            } else {
                                object2 = this.getConnectionInfo();
                                try {
                                    if (object2 != null) {
                                        serializable = Integer.valueOf(((Properties)object2).getProperty("PreferfedFetchSize"));
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    serializable = null;
                                }
                            }
                            object2 = ScriptRunnerDbArb.getString("COPY_DEFAULT");
                            if (serializable != null) {
                                object2 = ((Integer)serializable).toString();
                            }
                            object = serializable;
                            if (serializable == null) {
                                object = 0;
                            }
                            this.report(ScriptRunnerDbArb.format("COPY_ARRAY", new Integer((Integer)object).toString(), object2));
                            if (n == 0) {
                                this.report(ScriptRunnerDbArb.getString("COPY_COMMIT_WHEN_DONE"));
                            } else {
                                this.report(ScriptRunnerDbArb.format("COPY_COMMIT", new Integer(n).toString()));
                            }
                            Object[] objectArray2 = new Object[1];
                            ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
                            this.getScriptRunnerContext();
                            objectArray2[0] = scriptRunnerContext.getProperty("script.runner.setlong").toString();
                            this.report(ScriptRunnerDbArb.format("COPY_LONG", objectArray2));
                            Statement statement = null;
                            ResultSet resultSet = null;
                            Statement statement2 = null;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            ArrayList<Blob> arrayList2 = new ArrayList<Blob>();
                            ArrayList<Clob> arrayList3 = new ArrayList<Clob>();
                            try {
                                CharSequence charSequence;
                                CharSequence charSequence2;
                                Wrapper wrapper;
                                if (objectArray[0] == null || objectArray[1] == null) {
                                    if (this.getScriptRunnerContext().getCurrentConnection() != null) {
                                        bl5 = DBUtil.getConnectionResolver().lock(this.getScriptRunnerContext().getCurrentConnection());
                                    }
                                    if (!bl5) {
                                        string = ScriptRunnerDbArb.getString("COPY_FAILED_TO_LOCK_CONNECTION");
                                    }
                                }
                                boolean bl8 = false;
                                ArrayList<String> arrayList4 = new ArrayList<String>();
                                ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
                                ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
                                ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
                                ArrayList<String> arrayList8 = new ArrayList<String>();
                                ArrayList<String> arrayList9 = new ArrayList<String>();
                                ArrayList<Integer> arrayList10 = new ArrayList<Integer>();
                                ArrayList<Integer> arrayList11 = new ArrayList<Integer>();
                                ArrayList<Boolean> arrayList12 = new ArrayList<Boolean>();
                                StringBuilder stringBuilder = new StringBuilder("create table \"" + string6 + "\" (");
                                String string10 = null;
                                try {
                                    if (string == null) {
                                        this.commitIgnoreAutocommitError((Connection)object7);
                                        bl6 = true;
                                        statement = object6.createStatement();
                                        resultSet = statement.executeQuery(string8);
                                        wrapper = resultSet.getMetaData();
                                        int n2 = wrapper.getColumnCount();
                                        if (n2 != arrayList.size() && arrayList.size() != 0) {
                                            string = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                        } else {
                                            for (int i = 1; i <= n2; ++i) {
                                                arrayList7.add(wrapper.getColumnType(i));
                                                arrayList8.add(wrapper.getColumnName(i));
                                                arrayList9.add(wrapper.getColumnTypeName(i));
                                                if (wrapper.isNullable(i) != 1) {
                                                    arrayList12.add(Boolean.FALSE);
                                                } else {
                                                    arrayList12.add(Boolean.TRUE);
                                                }
                                                Integer n3 = wrapper.getPrecision(i);
                                                if ((n3 == 0 || n3 == -1) && (((String)arrayList9.get(i - 1)).equalsIgnoreCase("VARCHAR2") || ((String)arrayList9.get(i - 1)).equalsIgnoreCase("CHAR") || ((String)arrayList9.get(i - 1)).equalsIgnoreCase("NVARCHAR2") || ((String)arrayList9.get(i - 1)).equalsIgnoreCase("NCHAR") || ((String)arrayList9.get(i - 1)).equalsIgnoreCase("RAW"))) {
                                                    n3 = 1;
                                                }
                                                arrayList10.add(n3);
                                                arrayList11.add(wrapper.getScale(i));
                                                String string11 = (String)arrayList8.get(i - 1);
                                                if (arrayList.size() > 0) {
                                                    string11 = (String)arrayList.get(i - 1);
                                                }
                                                if (((String)arrayList9.get(i - 1)).equalsIgnoreCase("INTERVALDS")) {
                                                    charSequence2 = "";
                                                    if ((Integer)arrayList10.get(i - 1) > -1) {
                                                        charSequence2 = " (" + arrayList10.get(i - 1) + ")";
                                                    }
                                                    charSequence = "";
                                                    if ((Integer)arrayList11.get(i - 1) > -1) {
                                                        charSequence = "(" + arrayList11.get(i - 1) + ") ";
                                                    }
                                                    stringBuilder.append("\"" + string11 + "\" " + "INTERVAL DAY" + (String)charSequence2 + " TO SECOND " + (String)charSequence);
                                                } else if (((String)arrayList9.get(i - 1)).equalsIgnoreCase("INTERVALYM")) {
                                                    charSequence2 = "";
                                                    if ((Integer)arrayList10.get(i - 1) > -1) {
                                                        charSequence2 = " (" + arrayList10.get(i - 1) + ")";
                                                    }
                                                    stringBuilder.append("\"" + string11 + "\" " + "INTERVAL YEAR" + (String)charSequence2 + " TO MONTH ");
                                                } else {
                                                    stringBuilder.append("\"" + string11 + "\" " + (String)arrayList9.get(i - 1));
                                                    if ((Integer)arrayList10.get(i - 1) != 0 && (Integer)arrayList10.get(i - 1) != -1 && !((String)arrayList9.get(i - 1)).toUpperCase().startsWith("LONG")) {
                                                        stringBuilder.append("(" + arrayList10.get(i - 1));
                                                        if (((String)arrayList9.get(i - 1)).equalsIgnoreCase("VARCHAR2") || ((String)arrayList9.get(i - 1)).equalsIgnoreCase("CHAR")) {
                                                            if (bl2) {
                                                                stringBuilder.append(" BYTE");
                                                            } else {
                                                                stringBuilder.append(" CHAR");
                                                            }
                                                        }
                                                        if ((Integer)arrayList11.get(i - 1) != 0) {
                                                            stringBuilder.append(", " + arrayList11.get(i - 1));
                                                        }
                                                        stringBuilder.append(") ");
                                                    }
                                                }
                                                if (arrayList12.equals(Boolean.FALSE)) {
                                                    stringBuilder.append(" NOT NULL, ");
                                                    continue;
                                                }
                                                stringBuilder.append(", ");
                                            }
                                            string10 = stringBuilder.substring(0, stringBuilder.lastIndexOf(",")) + ")";
                                        }
                                    }
                                }
                                catch (SQLException sQLException) {
                                    string = sQLException.getLocalizedMessage();
                                }
                                finally {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                }
                                wrapper = null;
                                ResultSet resultSet2 = null;
                                try {
                                    ResultSetMetaData resultSetMetaData;
                                    int n4;
                                    if (string == null && (n4 = (resultSetMetaData = (resultSet2 = (wrapper = object7.createStatement()).executeQuery("select * from \"" + string6 + "\" where 1=2")).getMetaData()).getColumnCount()) != arrayList.size() && arrayList.size() != 0) {
                                        string = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                    }
                                }
                                catch (SQLException sQLException) {
                                    bl8 = true;
                                    if (string5.equals("INSERT")) {
                                        string = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_NOT_EXIST");
                                    }
                                }
                                finally {
                                    if (resultSet2 != null) {
                                        try {
                                            resultSet2.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                    if (wrapper != null) {
                                        try {
                                            wrapper.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                }
                                if (string == null && !bl8 && string5.equals("CREATE")) {
                                    string = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_EXIST");
                                }
                                String string12 = "";
                                try {
                                    if (string == null && string5.equals("REPLACE") && !bl8) {
                                        string12 = "drop table \"" + string6 + "\"";
                                        statement = object7.createStatement();
                                        statement.execute(string12);
                                        bl7 = true;
                                        statement.close();
                                    }
                                    if (string == null && string5.equals("APPEND") && bl8 || string5.equals("REPLACE") || string5.equals("CREATE") && bl8) {
                                        statement = object7.createStatement();
                                        string12 = string10;
                                        statement.execute(string12);
                                        bl7 = true;
                                        this.report(ScriptRunnerDbArb.format("COPY_TABLE_CREATED", string6));
                                    }
                                }
                                catch (SQLException sQLException) {
                                    bl8 = true;
                                    string = ScriptRunnerDbArb.format("COPY_CREATE_ERROR", string12, sQLException.getLocalizedMessage(), "COPY_DESTINATION_WAS_NOT_CREATED");
                                }
                                finally {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                }
                                if (string != null) break block319;
                                try {
                                    void var62_142;
                                    Object object4;
                                    Object object5;
                                    Object object8;
                                    int n5;
                                    ResultSetMetaData resultSetMetaData;
                                    int n6 = 0;
                                    int n7 = 0;
                                    charSequence2 = new StringBuilder("");
                                    charSequence = new StringBuilder("");
                                    String string13 = "";
                                    String string14 = "";
                                    try {
                                        statement = object7.createStatement();
                                        if (arrayList.size() == 0) {
                                            resultSet = statement.executeQuery("select * from \"" + string6 + "\"  where 1=2");
                                        } else {
                                            int n8 = 0;
                                            for (String string15 : arrayList) {
                                                charSequence2.append(string15 + ", ");
                                                ((StringBuilder)charSequence).append(":" + ++n8 + ", ");
                                            }
                                            string13 = charSequence2.substring(0, charSequence2.lastIndexOf(","));
                                            string14 = ((StringBuilder)charSequence).substring(0, ((StringBuilder)charSequence).lastIndexOf(","));
                                            resultSet = statement.executeQuery("select " + string13 + " from \"" + string6 + "\" where 1 = 2");
                                        }
                                        resultSetMetaData = resultSet.getMetaData();
                                        n6 = resultSetMetaData.getColumnCount();
                                        if (n6 != arrayList.size() && arrayList.size() != 0) {
                                            string = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                        } else {
                                            for (int i = 1; i <= n6; ++i) {
                                                arrayList4.add(resultSetMetaData.getColumnTypeName(i));
                                                arrayList5.add(resultSetMetaData.getPrecision(i));
                                                arrayList6.add(resultSetMetaData.getScale(i));
                                                if (arrayList.size() != 0) continue;
                                                ((StringBuilder)charSequence).append(":" + i + ", ");
                                            }
                                            if (arrayList.size() == 0 && ((StringBuilder)charSequence).length() != 0) {
                                                string14 = ((StringBuilder)charSequence).substring(0, ((StringBuilder)charSequence).lastIndexOf(","));
                                            }
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        bl8 = true;
                                        string = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_NOT_EXIST");
                                    }
                                    finally {
                                        if (resultSet != null) {
                                            try {
                                                resultSet.close();
                                            }
                                            catch (SQLException sQLException) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                            }
                                        }
                                        if (statement != null) {
                                            try {
                                                statement.close();
                                            }
                                            catch (SQLException sQLException) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                            }
                                        }
                                    }
                                    if (string != null) break block319;
                                    statement = object6.createStatement();
                                    resultSet = statement.executeQuery(string8);
                                    if (serializable != null) {
                                        resultSet.setFetchSize((Integer)serializable);
                                    }
                                    if ((n6 = (resultSetMetaData = resultSet.getMetaData()).getColumnCount()) != arrayList.size() && arrayList.size() != 0) {
                                        string = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                        break block319;
                                    }
                                    for (int i = 1; i <= n6; ++i) {
                                        if (!((String)arrayList9.get(i - 1)).toUpperCase().equals("LONG") && !((String)arrayList9.get(i - 1)).toUpperCase().equals("LONG RAW") && !((String)arrayList9.get(i - 1)).toUpperCase().equals("BLOB") && !((String)arrayList9.get(i - 1)).toUpperCase().equals("NCLOB") && !((String)arrayList9.get(i - 1)).toUpperCase().equals("CLOB")) continue;
                                        ++n7;
                                    }
                                    if (string != null) break block319;
                                    String string16 = "";
                                    string16 = string13.equals("") ? "insert into \"" + string6 + "\" values (" + string14 + ")" : "insert into \"" + string6 + "\" (" + string13 + ") values (" + string14 + ")";
                                    statement2 = object7.prepareStatement(string16);
                                    for (n5 = 1; n5 <= n6; ++n5) {
                                        if (!((String)arrayList9.get(n5 - 1)).toLowerCase().equals("nvarchar2") && !((String)arrayList9.get(n5 - 1)).toLowerCase().equals("nvarchar") && !((String)arrayList9.get(n5 - 1)).toLowerCase().equals("nchar") && !((String)arrayList9.get(n5 - 1)).toLowerCase().equals("nclob")) continue;
                                        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)statement2;
                                        oraclePreparedStatement.setFormOfUse(n5, (short)2);
                                    }
                                    n5 = 0;
                                    int n9 = 0;
                                    int n10 = 0;
                                    int n11 = 0;
                                    int n12 = 200;
                                    if (serializable != null) {
                                        n12 = (Integer)serializable;
                                    }
                                    if (n7 > 0 && n12 > 50 / n7) {
                                        n12 = 50 / n7;
                                        if (n12 == 0) {
                                            n12 = 1;
                                        }
                                    } else if (n12 > 200) {
                                        n12 = 200;
                                    }
                                    int n13 = 0;
                                    while (resultSet.next()) {
                                        for (int i = 1; i <= n6; ++i) {
                                            int n2;
                                            Object[] iOException;
                                            Closeable closeable;
                                            Closeable closeable2;
                                            Closeable closeable3;
                                            Object object9 = resultSet.getObject(i);
                                            if (resultSet.wasNull()) {
                                                statement2.setNull(i, (Integer)arrayList7.get(i - 1));
                                                continue;
                                            }
                                            int n3 = 2048;
                                            object8 = object9;
                                            if (object8 instanceof BigInteger) {
                                                object5 = new NUMBER((BigInteger)object8);
                                                ((OraclePreparedStatement)statement2).setNUMBER(i, (NUMBER)object5);
                                                continue;
                                            }
                                            if (object8 instanceof Blob) {
                                                object5 = null;
                                                object4 = null;
                                                closeable3 = null;
                                                closeable2 = null;
                                                closeable = null;
                                                try {
                                                    object5 = BLOB.createTemporary((Connection)object7, (boolean)false, (int)10);
                                                    arrayList2.add((Blob)object5);
                                                    ((BLOB)object5).open(1);
                                                    closeable2 = ((Blob)object8).getBinaryStream();
                                                    object4 = new BufferedInputStream((InputStream)closeable2);
                                                    iOException = new byte[n3];
                                                    closeable = object5.setBinaryStream(1L);
                                                    n2 = 0;
                                                    closeable3 = new BufferedOutputStream((OutputStream)closeable);
                                                    while ((n2 = ((BufferedInputStream)object4).read((byte[])iOException, 0, iOException.length)) != -1) {
                                                        ((BufferedOutputStream)closeable3).write((byte[])iOException, 0, n2);
                                                    }
                                                    ((BufferedOutputStream)closeable3).flush();
                                                }
                                                catch (IOException iOException2) {
                                                    throw new SQLException(iOException2);
                                                }
                                                finally {
                                                    if (closeable2 != null) {
                                                        try {
                                                            ((InputStream)closeable2).close();
                                                        }
                                                        catch (IOException iOException3) {}
                                                    }
                                                    if (closeable != null) {
                                                        try {
                                                            ((OutputStream)closeable).close();
                                                        }
                                                        catch (IOException iOException4) {}
                                                    }
                                                    if (object4 != null) {
                                                        try {
                                                            ((BufferedInputStream)object4).close();
                                                        }
                                                        catch (IOException iOException5) {}
                                                    }
                                                    if (closeable3 != null) {
                                                        try {
                                                            ((FilterOutputStream)closeable3).close();
                                                        }
                                                        catch (IOException iOException6) {}
                                                    }
                                                }
                                                statement2.setObject(i, object5);
                                                continue;
                                            }
                                            if (object8 instanceof Clob) {
                                                object5 = null;
                                                object4 = null;
                                                closeable3 = null;
                                                closeable2 = null;
                                                closeable = null;
                                                try {
                                                    object5 = ((String)arrayList9.get(i - 1)).toUpperCase().equals("NCLOB") ? CLOB.createTemporary((Connection)object7, (boolean)false, (int)10, (short)2) : CLOB.createTemporary((Connection)object7, (boolean)false, (int)10);
                                                    arrayList3.add((Clob)object5);
                                                    ((CLOB)object5).open(1);
                                                    closeable2 = ((Clob)object8).getCharacterStream();
                                                    object4 = new BufferedReader((Reader)closeable2);
                                                    iOException = new char[n3];
                                                    closeable = object5.setCharacterStream(1L);
                                                    n2 = 0;
                                                    closeable3 = new BufferedWriter((Writer)closeable);
                                                    while ((n2 = ((BufferedReader)object4).read((char[])iOException, 0, iOException.length)) != -1) {
                                                        ((BufferedWriter)closeable3).write((char[])iOException, 0, n2);
                                                    }
                                                    ((BufferedWriter)closeable3).flush();
                                                }
                                                catch (IOException iOException7) {
                                                    throw new SQLException(iOException7);
                                                }
                                                finally {
                                                    if (closeable2 != null) {
                                                        try {
                                                            ((Reader)closeable2).close();
                                                        }
                                                        catch (IOException iOException8) {}
                                                    }
                                                    if (closeable != null) {
                                                        try {
                                                            ((Writer)closeable).close();
                                                        }
                                                        catch (IOException iOException9) {}
                                                    }
                                                    if (object4 != null) {
                                                        try {
                                                            ((BufferedReader)object4).close();
                                                        }
                                                        catch (IOException iOException10) {}
                                                    }
                                                    if (closeable3 != null) {
                                                        try {
                                                            ((BufferedWriter)closeable3).close();
                                                        }
                                                        catch (IOException iOException11) {}
                                                    }
                                                }
                                                statement2.setObject(i, object5);
                                                continue;
                                            }
                                            statement2.setObject(i, object9);
                                        }
                                        ++n9;
                                        statement2.addBatch();
                                        if (n12 > 0 && ++n5 % n12 == 0) {
                                            statement2.executeBatch();
                                            ++n13;
                                            n11 = n5;
                                            for (Blob blob : arrayList2) {
                                                try {
                                                    ((BLOB)blob).freeTemporary();
                                                }
                                                catch (SQLException sQLException) {}
                                            }
                                            arrayList2 = new ArrayList();
                                            for (Clob clob : arrayList3) {
                                                try {
                                                    ((CLOB)clob).freeTemporary();
                                                }
                                                catch (SQLException sQLException) {}
                                            }
                                            arrayList3 = new ArrayList();
                                        }
                                        if (n == 0 || n13 % n != 0) continue;
                                        statement2.executeBatch();
                                        this.commitIgnoreAutocommitError((Connection)object7);
                                        bl7 = true;
                                        n10 += n9;
                                        n9 = 0;
                                        this.freelobs(arrayList2, arrayList3);
                                    }
                                    statement2.executeBatch();
                                    n11 = n5;
                                    this.commitIgnoreAutocommitError((Connection)object7);
                                    n10 += n9;
                                    bl7 = true;
                                    bl = true;
                                    Object object12 = "";
                                    this.freelobs(arrayList2, arrayList3);
                                    if (string4 == null) {
                                        object12 = ScriptRunnerDbArb.getString("COPY_DEFAULT_HOST");
                                    } else {
                                        ConnectionDetails connectionDetails = ScriptUtils.getConnectionDetails("connect " + string4);
                                        String string11 = ScriptRunnerDbArb.get("COPY_UNKNOWN");
                                        object8 = connectionDetails.getConnectName();
                                        object5 = connectionDetails.getConnectDB();
                                        if (object8 == null || ((String)object8).equals("")) {
                                            object8 = string11;
                                        }
                                        object12 = object8;
                                        if (object5 != null && !((String)object5).equals("")) {
                                            object12 = (String)object12 + "@" + (String)object5;
                                        }
                                    }
                                    String string15 = "";
                                    if (string3 == null) {
                                        String string17 = ScriptRunnerDbArb.getString("COPY_DEFAULT_HOST");
                                    } else {
                                        ConnectionDetails connectionDetails = ScriptUtils.getConnectionDetails("connect " + string3);
                                        object8 = ScriptRunnerDbArb.get("COPY_UNKNOWN");
                                        object5 = connectionDetails.getConnectName();
                                        object4 = connectionDetails.getConnectDB();
                                        if (object5 == null || ((String)object5).equals("")) {
                                            object5 = object8;
                                        }
                                        Object object10 = object5;
                                        if (object4 != null && !((String)object4).equals("")) {
                                            String string18 = (String)object10 + "@" + (String)object4;
                                        }
                                    }
                                    String string19 = "    ";
                                    this.report(string19 + ScriptRunnerDbArb.format("COPY_ROWS_SELECTED", new Integer(n5).toString(), var62_142));
                                    this.report(string19 + ScriptRunnerDbArb.format("COPY_ROWS_INSERTED", new Integer(n11).toString(), object12));
                                    this.report(string19 + ScriptRunnerDbArb.format("COPY_ROWS_COMMITED", new Integer(n10).toString(), object12));
                                }
                                catch (SQLException sQLException) {
                                    string = sQLException.getLocalizedMessage();
                                }
                            }
                            finally {
                                try {
                                    this.freelobs(arrayList2, arrayList3);
                                    if (statement2 != null) {
                                        try {
                                            statement2.close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                    try {
                                        if (string != null && bl6) {
                                            object7.rollback();
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                    }
                                    if (objectArray[0] != null) {
                                        try {
                                            objectArray[0].close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                    if (objectArray[1] != null) {
                                        try {
                                            objectArray[1].close();
                                        }
                                        catch (SQLException sQLException) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                        }
                                    }
                                }
                                finally {
                                    if (bl5) {
                                        try {
                                            DBUtil.getConnectionResolver().unlock(this.getScriptRunnerContext().getCurrentConnection());
                                        }
                                        catch (Exception exception) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (string == null && stringArray == null) {
            string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
        }
        if (string == null && !bl) {
            string = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
        }
        if (string != null) {
            this.report(string);
            this.doWhenever(true);
        }
    }

    private void commitIgnoreAutocommitError(Connection connection) throws SQLException {
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    private void freelobs(ArrayList<Blob> arrayList, ArrayList<Clob> arrayList2) {
        for (Blob object : arrayList) {
            try {
                ((BLOB)object).freeTemporary();
            }
            catch (SQLException sQLException) {}
        }
        arrayList.clear();
        for (Clob clob : arrayList2) {
            try {
                ((CLOB)clob).freeTemporary();
            }
            catch (SQLException sQLException) {}
        }
        arrayList2.clear();
    }

    private void runSetPlus() {
        this.cmd.setSql(this.cmd.getSql().toLowerCase());
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (stringArray != null) {
            if (this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.cmd.getSql());
                if (stringTokenizer.countTokens() >= 2) {
                    stringTokenizer.nextToken();
                    this.report(ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_SET_COMMAND", stringTokenizer.nextToken()));
                }
            } else if (this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_OBSOLETE)) {
                this.report(ScriptRunnerDbArb.format("SQLPLUS_COMMAND_OBSOLETE", new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig()));
            } else if ((stringArray = this.nextWordAndRest(stringArray[1])) != null) {
                String string = stringArray[0];
                if ((stringArray[0].equals("def") || stringArray[0].equals("defi") || stringArray[0].equals("defin") || stringArray[0].equals("define") || stringArray[0].equals("verify") || stringArray[0].equals("ver") || stringArray[0].equals("scan")) && (stringArray = this.nextWordAndRest(stringArray[1])) != null) {
                    String string2 = stringArray[0];
                    boolean bl = false;
                    String string3 = string2;
                    if (string2.startsWith("'") && string2.endsWith("'") && string2.length() == 3) {
                        string2 = string2.substring(1, 2);
                        bl = true;
                    }
                    if (string2.startsWith("\"") && string2.endsWith("\"") && string2.length() == 3) {
                        string2 = string2.substring(1, 2);
                        bl = true;
                    }
                    if (string2.equals("on")) {
                        if (string.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(true);
                            this.getScriptRunnerContext().setSubstitutionChar('&');
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(true);
                        return;
                    }
                    if (string2.equals("off")) {
                        if (string.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(false);
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(false);
                        return;
                    }
                    if (!(string2.length() != 1 || Character.isWhitespace(string2.charAt(0)) || Character.isLetterOrDigit(string2.charAt(0)) || string.equals("scan") || string2.charAt(0) == '\"' && !bl || string2.charAt(0) == '\'' && !bl || string3.equals("\"\"\"") || string3.equals("'''"))) {
                        this.getScriptRunnerContext().setSubstitutionOn(true);
                        this.getScriptRunnerContext().setSubstitutionChar(string2.charAt(0));
                        return;
                    }
                    String string4 = ScriptRunnerDbArb.format("INVALID_NAME_COMMAND", "set " + string);
                    this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), string4, this.getScriptRunnerContext()));
                    return;
                }
            }
        }
    }

    private void runColumn() {
    }

    private void runUndefine() {
        this.cmd.setSql(SQLPLUS.removeDashNewline(this.cmd, this.cmd.getSql()));
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (!stringArray[1].trim().equals("")) {
            String string = stringArray[1].trim();
            Map<String, String> map = this.getScriptRunnerContext().getMap();
            while (!string.trim().equals("")) {
                stringArray = this.nextWordAndRest(string);
                String string2 = stringArray[0].toUpperCase();
                string = stringArray[1];
                map.remove(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDefine() {
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (stringArray[1].trim().equals("")) {
            for (ScriptRunnerContext.SqlplusVariable sqlplusVariable : ScriptRunnerContext.SqlplusVariable.values()) {
                boolean bl;
                String string = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(sqlplusVariable.toString(), sqlplusVariable);
                String string2 = sqlplusVariable.toString();
                boolean bl2 = bl = string.equals("") ? false : Pattern.matches("^\\d*$", string);
                if (bl) {
                    this.report("DEFINE " + string2 + " =  " + string + " (NUMBER)");
                    continue;
                }
                this.report("DEFINE " + string2 + " =  \"" + string + "\"" + " (CHAR)");
            }
            Map<String, String> map = this.getScriptRunnerContext().getMap();
            Set set = map.keySet();
            Map<String, String> map2 = map;
            synchronized (map2) {
                for (String string : set) {
                    boolean bl;
                    boolean bl3 = true;
                    try {
                        ScriptRunnerContext.SqlplusVariable.valueOf(string.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl3 = false;
                    }
                    if (bl3) continue;
                    String string3 = (String)map.get(string);
                    boolean bl4 = string3.equals("") ? false : Pattern.matches("^\\d*$", string3);
                    boolean bl5 = bl = string3.equals("") ? false : Pattern.matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$|^[+-][iI][nN][fF]$", string3);
                    if (bl) {
                        this.report("DEFINE " + string + " =  " + string3 + " (BINARY_FLOAT)");
                        continue;
                    }
                    if (bl4) {
                        this.report("DEFINE " + string + " =  " + string3 + " (NUMBER)");
                        continue;
                    }
                    this.report("DEFINE " + string + " =  \"" + string3 + "\"" + " (CHAR)");
                }
            }
        }
        String string = "";
        if (stringArray[1].indexOf("=") == -1) {
            boolean bl;
            String string4;
            Map<String, String> map = this.getScriptRunnerContext().getMap();
            String string5 = map.get(string4 = stringArray[1].trim().toUpperCase());
            if (string5 == null || string4.equals(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString()) || string4.equals(ScriptRunnerContext.SqlplusVariable._DATE.toString())) {
                bl = true;
                ScriptRunnerContext.SqlplusVariable sqlplusVariable = null;
                try {
                    sqlplusVariable = ScriptRunnerContext.SqlplusVariable.valueOf(string4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                }
                if (bl) {
                    string5 = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(string4.toString(), sqlplusVariable);
                }
            }
            if (string5 == null) {
                this.report(ScriptRunnerDbArb.format("UNDEFINED_SYMBOL", string4));
            } else {
                boolean bl6;
                bl = string5.equals("") ? false : Pattern.matches("^\\d*$", string5);
                boolean bl7 = bl6 = string5.equals("") ? false : Pattern.matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$|^[+-][iI][nN][fF]$", string5);
                if (bl6) {
                    this.report("DEFINE " + string4 + " =  " + string5 + " (BINARY_FLOAT)");
                } else if (bl) {
                    this.report("DEFINE " + string4 + " =  " + string5 + " (NUMBER)");
                } else if (string4.equals(string5) && (string4.equals(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString()) || string4.equals(ScriptRunnerContext.SqlplusVariable._USER.toString()))) {
                    this.report("DEFINE " + string4 + " =  \"" + "\"" + " (CHAR)");
                } else {
                    this.report("DEFINE " + string4 + " =  \"" + string5 + "\"" + " (CHAR)");
                }
            }
        } else {
            Object object;
            string = stringArray[1].substring(0, stringArray[1].indexOf("=")).trim().toUpperCase();
            String string6 = "";
            boolean bl = false;
            if (stringArray[1].indexOf("=") != stringArray[1].length() - 1) {
                string6 = stringArray[1].substring(stringArray[1].indexOf("=") + 1).trim();
                if (string6.startsWith("\"")) {
                    string6 = this.getDefineValue(Character.valueOf('\"'), string6);
                } else if (string6.startsWith("'")) {
                    string6 = this.getDefineValue(Character.valueOf('\''), string6);
                }
                if (string6 != null) {
                    object = this.getScriptRunnerContext().getMap();
                    object.put(string, string6);
                } else {
                    bl = true;
                }
            }
            if (bl) {
                object = ScriptRunnerDbArb.getString("DEFINE_REQUIRES_VALUE");
                if (string6 == null) {
                    object = ScriptRunnerDbArb.getString("DEFINE_INVALID");
                }
                this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), object, this.getScriptRunnerContext()));
            }
        }
    }

    String getDefineValue(Character c, String string) {
        int n = -1;
        String string2 = null;
        String string3 = string + " ";
        StringBuilder stringBuilder = new StringBuilder("");
        char c2 = ' ';
        char c3 = ' ';
        char c4 = ' ';
        for (int i = 1; i < string.length(); ++i) {
            c2 = c3;
            c3 = string.charAt(i);
            c4 = string3.charAt(i + 1);
            if (!c.equals(Character.valueOf(c3))) {
                stringBuilder.append(c3);
                if (i != string.length() - 1) continue;
                stringBuilder = null;
                continue;
            }
            if ((!c.equals(Character.valueOf(c2)) || n == i - 1) && c.equals(Character.valueOf(c3)) && !c.equals(Character.valueOf(c4))) break;
            if ((!c.equals(Character.valueOf(c2)) || n == i - 1) && c.equals(Character.valueOf(c3)) && c.equals(Character.valueOf(c4))) {
                n = i + 1;
                continue;
            }
            if (c.equals(Character.valueOf(c2)) && c.equals(Character.valueOf(c3)) && n != i - 1) {
                stringBuilder.append(c3);
                if (i != string.length() - 1) continue;
                stringBuilder = null;
                continue;
            }
            stringBuilder = null;
            break;
        }
        string2 = string.length() == 1 ? null : (stringBuilder == null ? null : stringBuilder.toString());
        return string2;
    }

    private void runWhenever() {
        boolean bl = false;
        String string = this.cmd.getSql().toUpperCase();
        String string2 = ScriptUtils.stripFirstN(string, 9999, this.cmd.getProperty("STRIPPED_CONTINUATION") == null, true, true);
        if (string2 == null) {
            bl = true;
        } else {
            string = string2;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (!bl) {
            String string3 = string;
            if (string3.length() > 1 && (string3.endsWith(";") || string3.endsWith("/"))) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            String[] stringArray = this.nextWordAndRest(string3);
            if (!bl && stringArray != null && !stringArray[1].equals("")) {
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                if ((stringArray = this.nextWordAndRest(string5)) != null && !stringArray[1].equals("")) {
                    string4 = stringArray[0];
                    string5 = stringArray[1];
                    if (string4.equals("SQLERROR") || string4.equals("OSERROR")) {
                        bl3 = string4.equals("SQLERROR");
                        stringArray = this.nextWordAndRest(string5);
                        if (stringArray != null) {
                            string4 = stringArray[0];
                            string5 = stringArray[1];
                            if (string4.equals("CONTINUE") || string4.equals("EXIT")) {
                                n = string4.equals("EXIT") ? 4 : 0;
                                if (string5 == null) {
                                    string5 = "";
                                }
                                String string6 = "NONE";
                                String[] stringArray2 = string5.trim().split("\\s+");
                                if (n == 4) {
                                    string6 = "COMMIT";
                                }
                                if (stringArray2 != null) {
                                    int n2 = 0;
                                    for (String string7 : stringArray2) {
                                        if (n != 4) {
                                            if (++n2 > 2) {
                                                bl = true;
                                                break;
                                            }
                                            if (string7.equals("NONE")) {
                                                string6 = string7;
                                                break;
                                            }
                                        } else if (n2 > 1) {
                                            bl = true;
                                            break;
                                        }
                                        if (!string7.equals("COMMIT") && !string7.equals("ROLLBACK")) continue;
                                        string6 = string7;
                                        break;
                                    }
                                }
                                n = string6.equals("COMMIT") ? (n |= 1) : (string6.equals("ROLLBACK") ? (n |= 2) : (n |= 0));
                                bl2 = true;
                            }
                        }
                    }
                }
            }
        }
        if (bl2 && !bl) {
            if (bl3) {
                this.getScriptRunnerContext().setSqlError(n);
            } else {
                this.getScriptRunnerContext().setOsError(n);
            }
        } else {
            this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), HelpMessages.getString("WHENEVER"), this.getScriptRunnerContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPassword() {
        Boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (this.getScriptRunnerContext().getBaseConnection() == null) {
                this.report(ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
                this.doWhenever(true);
            } else {
                bl = DBUtil.getConnectionResolver().lock(this.getScriptRunnerContext().getBaseConnection());
                if (bl.booleanValue()) {
                    Pair<String, String> pair;
                    String string = null;
                    String string2 = this.cmd.getSql().replaceAll("^\\s+", "");
                    if (string2.split("\\s+").length > 1) {
                        string = string2.replaceFirst("^[^\\s]+\\s*", "").trim();
                    }
                    statement = this.conn.createStatement();
                    resultSet = statement.executeQuery("Select user from dual");
                    resultSet.next();
                    String string3 = resultSet.getString(1);
                    resultSet.close();
                    statement.close();
                    String string4 = null;
                    if (string != null && !string.equals("")) {
                        string4 = string;
                        string4 = string4.startsWith("\"") && string4.endsWith("\"") && string4.length() > 2 ? string4.substring(1, string4.length() - 1) : string4.toUpperCase();
                    }
                    if (string4 == null) {
                        string4 = string3;
                    }
                    if ((pair = this.getScriptRunnerContext().getPasswordFieldsProvider().passwordGetPassword(this.getScriptRunnerContext(), string3, string4)) != null) {
                        statement = this.conn.createStatement();
                        statement.execute("alter user \"" + string4 + "\" identified by \"" + pair.first() + "\" replace \"" + pair.second() + "\"");
                        this.report(ScriptRunnerDbArb.getString("PASSWORD_CHANGED"));
                    } else {
                        this.report(ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
                        this.doWhenever(true);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 65066) {
                this.report(sQLException.getMessage());
            } else {
                this.report(ScriptRunnerDbArb.getString("PDBPASSWORDERROR"));
            }
            this.report(ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
            this.doWhenever(true);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (bl.booleanValue()) {
                DBUtil.getConnectionResolver().unlock(this.getScriptRunnerContext().getBaseConnection());
            }
        }
    }

    private void configureOldConnections(Connection connection) {
        Object object = this.getScriptRunnerContext().getProperty("script.runner.jline");
        if (object == null) {
            if (!SQLPLUS.isConnectionClosed(connection)) {
                this.closeOldConnection(connection);
            }
            this.getScriptRunnerContext().setCloseConnection(true);
        } else {
            Boolean bl = this.getScriptRunnerContext().getBaseConnection() != null && connection != null && this.getScriptRunnerContext().getBaseConnection().equals(connection);
            this.getScriptRunnerContext().setCloseConnection(true);
            if (!SQLPLUS.isConnectionClosed(connection)) {
                this.closeOldConnection(connection);
            }
            if (bl.booleanValue()) {
                this.getScriptRunnerContext().setBaseConnection(null);
            }
            this.getScriptRunnerContext().setCloseConnection(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConnect() {
        this.cmd.setSql(ScriptUtils.checkforContinuationChars(this.cmd.getSql()));
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.cmd.getSql().trim();
        ConnectionDetails connectionDetails = ScriptUtils.getConnectionDetails(string2);
        if (connectionDetails != null && connectionDetails.getConnectName() != null && connectionDetails.getConnectName().indexOf(" ") != -1 && connectionDetails.getConnectName().indexOf("\"") == -1) {
            this.report(Messages.getString("SQLPLUS.INVALID_OPTION"));
            this.report(Messages.getString("SQLPLUS.1"));
            this.report(Messages.getString("SQLPLUS.LOGON_PROXY"));
            return;
        }
        if (connectionDetails.getRoleBad()) {
            this.report(Messages.getString("SQLPLUS.1"));
            return;
        }
        Connection connection = null;
        try {
            boolean bl = false;
            if (connectionDetails != null) {
                boolean bl2 = bl = !this.connectCallDialog(connectionDetails);
            }
            if (!this.getScriptRunnerContext().getExited() && connectionDetails != null && !bl) {
                if (connectionDetails.getConnection() != null) {
                    connection = connectionDetails.getConnection();
                    connectionDetails.setConnection(null);
                } else {
                    connection = this.getConnection(arrayList, connectionDetails.getConnectName(), connectionDetails.getConnectPassword(), connectionDetails.getConnectDB(), connectionDetails.getRole());
                }
            }
        }
        finally {
            if (connectionDetails != null && connectionDetails.getConnection() != null) {
                try {
                    connectionDetails.getConnection().close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
        }
        if (!this.getScriptRunnerContext().getExited()) {
            boolean bl;
            boolean bl3 = bl = this.getScriptRunnerContext().getBaseConnection() != null && this.conn != null && this.getScriptRunnerContext().getBaseConnection().equals(this.conn);
            if (connection != null) {
                string = connectionDetails.getConnectDB();
                if (string == null || string.equals("")) {
                    string = System.getProperty("os.name").startsWith("Windows") ? System.getenv("LOCAL") : System.getenv("TWO_TASK");
                }
                if (this.conn != null && this.conn instanceof OracleConnection && this.getScriptRunnerContext().getBaseConnection() != null && this.conn.equals(this.getScriptRunnerContext().getBaseConnection()) && this.getScriptRunnerContext().getMap().get(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString()) != "") {
                    this.getScriptRunnerContext().putProperty("script.runner.connection.id", this.getScriptRunnerContext().doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER));
                }
                if (this.conn != null) {
                    this.commitConnection(this.conn);
                    this.configureOldConnections(this.conn);
                } else {
                    if (this.getScriptRunnerContext().getBaseConnection() == null) {
                        this.getScriptRunnerContext().setBaseConnection(connection);
                    }
                    this.getScriptRunnerContext().setCurrentConnection(connection);
                }
                String string3 = connectionDetails.getRole();
                if (string3 == null) {
                    string3 = "NOTSYSDBA";
                }
                if ((string3 = string3.trim().toUpperCase()).equals("")) {
                    string3 = "NOTSYSDBA";
                }
                this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), string3);
                if (string != null && string.length() > 1 && string.length() < 81) {
                    this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), string);
                } else {
                    this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                    this.getScriptRunnerContext().doPromptReplaceSqlplusVar(connection, ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER);
                }
                this.conn = connection;
                if (this.getScriptRunnerContext().getProperty("script.runner.cmdline.login") != null) {
                    if (this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null && (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") == null || this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE))) {
                        this.report(MessageFormat.format(Messages.getString("SQLPLUS.10"), this.getScriptRunnerContext().doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION)) + "\n");
                    }
                    this.getScriptRunnerContext().getProperties().remove("script.runner.cmdline.login");
                } else if (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") == null || !this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE) || this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") != null) {
                    this.report(Messages.getString("SQLPLUS.0") + "\n");
                }
                if (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") != null && this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE) && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null) {
                    this.report(ScriptRunnerDbArb.getString("CONNECTIDLE"));
                }
                Boolean bl4 = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.autocommit.checkbox");
                try {
                    if (bl4 == null || bl4.equals(Boolean.FALSE)) {
                        this.conn.setAutoCommit(false);
                    } else {
                        this.conn.setAutoCommit(true);
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                this.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", false);
                Object object = this.getScriptRunnerContext().getProperty("DBConfig.GLOGIN");
                Object object2 = this.getScriptRunnerContext().getProperty("DBConfig.GLOGIN_FILE");
                if (object != null && ((Boolean)object).equals(new Boolean("true")) && object2 != null && !((String)object2).equals("")) {
                    this.runLoginSQL();
                }
            } else {
                String string4 = "";
                for (String string5 : arrayList) {
                    string4 = string4 + string5;
                }
                if (this.getScriptRunnerContext().isCommandLine() && this.getScriptRunnerContext().getTopLevel()) {
                    string4 = !string4.equals("") ? string4 + "\n" + ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED") : ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED");
                    this.report(string4);
                } else {
                    string4 = !string4.equals("") ? ScriptRunnerDbArb.getString("CONNECTION_FAILED") + "\n" + string4 : ScriptRunnerDbArb.getString("CONNECTION_FAILED");
                    this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), string4, this.getScriptRunnerContext()).trim());
                }
                this.doWhenever(true);
                if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn) && DBUtil.getConnectionResolver().lock(this.conn)) {
                    try {
                        if (this.conn != null) {
                            this.commitConnection(this.conn);
                            this.configureOldConnections(this.conn);
                        } else {
                            if (this.getScriptRunnerContext().getBaseConnection() == null) {
                                this.getScriptRunnerContext().setBaseConnection(connection);
                            }
                            this.getScriptRunnerContext().setCurrentConnection(connection);
                        }
                        if (!(this.getScriptRunnerContext().isCommandLine() && this.getScriptRunnerContext().getTopLevel() || this.conn == null)) {
                            this.report("Commit");
                        }
                    }
                    finally {
                        DBUtil.getConnectionResolver().unlock(this.conn);
                    }
                }
                this.conn = null;
                this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
                this.getScriptRunnerContext().setCurrentConnection(this.conn);
                this.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", true);
            }
        }
    }

    private void commitConnection(Connection connection) {
        block5: {
            try {
                if (connection == null || SQLPLUS.isConnectionClosed(connection) || !DBUtil.getConnectionResolver().lock(connection)) break block5;
                try {
                    connection.commit();
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    private static boolean isConnectionClosed(Connection connection) {
        boolean bl;
        block5: {
            bl = false;
            try {
                if (connection == null || !DBUtil.getConnectionResolver().lock(connection)) break block5;
                try {
                    bl = connection.isClosed();
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger("SQLPLUS").log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return bl;
    }

    private void closeOldConnection(Connection connection) {
        if (this.getScriptRunnerContext().getCloseConnection()) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoginSQL() {
        File file;
        Object object = this.getScriptRunnerContext().getProperty("DBConfig.GLOGIN_FILE");
        if (object != null && (file = new File((String)object)).exists()) {
            String string = this.getScriptRunnerContext().getSourceRef();
            try {
                this._runner = new ScriptExecutor(new FileInputStream(file), this.conn);
                this._runner.setOut(this.out);
                boolean bl = this.getScriptRunnerContext().getTopLevel();
                this.getScriptRunnerContext().setTopLevel(false);
                this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                String string2 = file.getCanonicalPath();
                this.getScriptRunnerContext().setSourceRef(string2);
                int n = string2.lastIndexOf(File.separator);
                string2 = string2.substring(0, n);
                this._runner.setDirectory(string2);
                this._runner.run();
                this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                this.getScriptRunnerContext().setTopLevel(bl);
                this.setConn(this._runner.getConn());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.report("No " + (String)object + " found");
            }
            catch (IOException iOException) {
                this.report("No " + (String)object + " found");
            }
            finally {
                this.getScriptRunnerContext().setSourceRef(string);
            }
        }
    }

    private boolean connectCallDialog(ConnectionDetails connectionDetails) {
        if (connectionDetails != null && connectionDetails.getConnectDB() != null && !connectionDetails.getConnectDB().equals("")) {
            oracle.dbtools.db.ConnectionDetails connectionDetails2 = null;
            try {
                connectionDetails2 = new oracle.dbtools.db.ConnectionDetails(connectionDetails.getConnectDB());
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
            }
            if (connectionDetails2 != null && connectionDetails2.getDriver() != null) {
                return true;
            }
        }
        for (int i = 0; i < 3; ++i) {
            Object object;
            if (i != 0 || connectionDetails.getSlash() == -1 || connectionDetails.getConnectName() == null || connectionDetails.getConnectPassword() == null || connectionDetails.getConnectDB() == null) {
                object = this.getScriptRunnerContext().getConnectFieldsProvider().get3Fields(this.getScriptRunnerContext(), connectionDetails.getConnectName(), connectionDetails.getConnectPassword(), connectionDetails.getConnectDB(), i > 0);
                if (object == null) {
                    return false;
                }
                connectionDetails.setConnectName(object[0]);
                connectionDetails.setConnectPassword(object[1]);
                connectionDetails.setConnectDB(object[2]);
            }
            object = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            if (i == 2) break;
            Connection connection = this.getConnection(arrayList, connectionDetails.getConnectName(), connectionDetails.getConnectPassword(), connectionDetails.getConnectDB(), connectionDetails.getRole());
            if (connection != null) {
                connectionDetails.setConnection(connection);
                connection = null;
                break;
            }
            for (String string : arrayList) {
                object = (String)object + string;
            }
            this.doWhenever(true);
            if (this.getScriptRunnerContext().getExited()) break;
            if (this.getScriptRunnerContext().isCommandLine() && this.getScriptRunnerContext().getTopLevel()) {
                this.report(("Z" + (String)object).trim().substring(1));
                continue;
            }
            this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("CONNECTION_FAILED_RETRY_ARG", ("Z" + (String)object).trim().substring(1)), this.getScriptRunnerContext()).trim());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuit() {
        block40: {
            String[] stringArray;
            String string = this.cmd.getSql().toUpperCase();
            if (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1).trim();
            }
            if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn) && this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") != null && !((Boolean)this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.TRUE)) {
                if (string.endsWith("ROLLBACK")) {
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), this.getScriptRunnerContext()));
                    }
                } else {
                    try {
                        this.conn.commit();
                    }
                    catch (SQLException sQLException) {
                        this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), this.getScriptRunnerContext()));
                    }
                }
            }
            this.getScriptRunnerContext().setExited(true);
            String string2 = "";
            if (string.length() > 4) {
                string2 = string.substring(4).trim();
                string2 = string2.replaceAll("ROLLBACK", "").replaceAll("COMMIT", "");
            }
            if ((stringArray = string2.trim().split("\\s+"))[0].toUpperCase().equals("FAILURE")) {
                this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
            } else {
                try {
                    Object object;
                    Map<String, String> map;
                    Object object2;
                    String string3;
                    if (stringArray[0].startsWith(":")) {
                        string3 = string2.substring(1);
                        object2 = this.getScriptRunnerContext().getVarMap();
                        Map<String, Bind> map2 = object2;
                        synchronized (map2) {
                            map = (Bind)object2.get(string3.toUpperCase());
                            if (map != null && (object = ((Bind)((Object)map)).getValue()) != null && !((String)object).equals("")) {
                                stringArray[0] = object;
                            }
                        }
                    }
                    if ((string3 = stringArray[0]) != null) {
                        string3 = string3.trim().toUpperCase();
                    }
                    if (!(stringArray[0] == null || string3.equals("SUCCESS") || string3.equals("FAILURE") || string3.equals("WARNING") || string3.equals("COMMIT") || string3.equals("ROLLBACK") || string3.startsWith("/*") || string3.startsWith("--") || string3.equals(""))) {
                        object2 = 0;
                        try {
                            object2 = Integer.parseInt(stringArray[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            map = this.getScriptRunnerContext().getMap();
                            object = map.keySet();
                            Map<String, String> map3 = map;
                            synchronized (map3) {
                                Iterator iterator = object.iterator();
                                boolean bl = false;
                                while (iterator.hasNext()) {
                                    String string4 = (String)iterator.next();
                                    if (!string3.equals(string4)) continue;
                                    try {
                                        String string5 = map.get(string4);
                                        try {
                                            object2 = Integer.parseInt(string5);
                                            bl = true;
                                        }
                                        catch (NumberFormatException numberFormatException2) {
                                        }
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {}
                                }
                                if (!bl) {
                                    this.report(MessageFormat.format(ScriptRunnerDbArb.get("EXIT_JUNK"), string2 != null ? string2.trim() : string2));
                                    this.report(ScriptRunnerDbArb.get("EXIT_JUNK2"));
                                }
                            }
                        }
                        this.getScriptRunnerContext().putProperty("script.runner.exit_int", object2);
                        break block40;
                    }
                    object2 = string3;
                    int n = 0;
                    switch (string3) {
                        case "WARNING": 
                        case "FAILURE": {
                            n = 1;
                        }
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.exit_int", n);
                }
                catch (Exception exception) {
                    this.report(ScriptRunnerDbArb.format("EXIT_VALUE_NOT_CALCULATED", string2));
                    this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
                }
            }
        }
        if (this.getScriptRunnerContext().getProperty("Spool.out.buffer") != null) {
            this.getScriptRunnerContext().stopSpool();
        }
        if (this.conn != null) {
            this.runDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    ExecutePathCheckReturn checkPath(boolean bl, boolean bl2, boolean bl3, String string, URL uRL, String string2, String string3, PathException pathException) {
        ExecutePathCheckReturn executePathCheckReturn;
        block67: {
            InputStream inputStream;
            BufferedReader bufferedReader;
            block63: {
                block64: {
                    Object object;
                    executePathCheckReturn = new ExecutePathCheckReturn();
                    bufferedReader = null;
                    inputStream = null;
                    int n = 1;
                    int n2 = 2;
                    int n3 = 3;
                    int n4 = 0;
                    if (bl3) {
                        n4 = n;
                    } else if (string != null) {
                        n4 = n2;
                    } else if (uRL != null) {
                        n4 = n3;
                    } else {
                        if (pathException != null) {
                            executePathCheckReturn.setLastException(pathException);
                        }
                        return executePathCheckReturn;
                    }
                    if (n4 == n3) {
                        if (uRL != null && (object = this.joinUrl(bl, uRL, string2)) != null && this.haveIBytes((URL)object)) {
                            URLConnection uRLConnection = null;
                            InputStream inputStream2 = null;
                            try {
                                uRLConnection = ((URL)object).openConnection();
                                inputStream2 = uRLConnection.getInputStream();
                                string2 = ((URL)object).toString();
                            }
                            catch (IOException iOException) {
                                object = null;
                            }
                            finally {
                                if (inputStream2 != null) {
                                    try {
                                        inputStream2.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            executePathCheckReturn.setUrl((URL)object);
                        }
                    } else {
                        object = null;
                        object = n4 == n ? string2 : string;
                        if (object != null && !((String)object).equals("")) {
                            String[] stringArray = new String[]{object};
                            if (bl2) {
                                stringArray = ((String)object).split(File.pathSeparator);
                            }
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String string4 = null;
                            for (String string5 : stringArray) {
                                String string6;
                                if (string5 == null) continue;
                                if (File.pathSeparator.equals(":")) {
                                    if (bl4) {
                                        string5 = "http:" + string5;
                                    }
                                    if (bl5) {
                                        string5 = "ftp:" + string5;
                                    }
                                    bl4 = false;
                                    bl4 = false;
                                    if (string5.toLowerCase().equals("http")) {
                                        bl4 = true;
                                        continue;
                                    }
                                    if (string5.toLowerCase().equals("ftp")) {
                                        bl5 = true;
                                        continue;
                                    }
                                    bl4 = false;
                                    bl4 = false;
                                }
                                if (this.startsWithHttpOrFtp(string5)) {
                                    string6 = n4 != n ? (string5.endsWith("\\") || string5.endsWith("/") ? string5 + string2 : string5 + "/" + string2) : string5;
                                    if (this.haveIBytes(string6)) {
                                        string4 = string6;
                                        break;
                                    }
                                    string6 = n4 != n ? (string5.endsWith("\\") || string5.endsWith("/") ? string5 + string2 : string5 + "\\" + string2) : string5;
                                    if (!this.haveIBytesRaw(string6)) continue;
                                    string4 = string6.replace("/", "\\");
                                    break;
                                }
                                string6 = null;
                                string6 = string5.endsWith("\\") || string5.endsWith("/") ? string5 + string2 : string5 + "/" + string2;
                                if (n4 == n) {
                                    string6 = string5;
                                }
                                if (new File(string6.replace("/", "\\")).exists()) {
                                    string4 = string6.replace("/", "\\");
                                    break;
                                }
                                if (!new File(string6.replace("\\", "/")).exists()) continue;
                                string4 = string6.replace("\\", "/");
                                break;
                            }
                            if (string4 != null) {
                                if (this.startsWithHttpOrFtp(string4) && (this.haveIBytes(string4) || this.haveIBytesRaw(string4))) {
                                    string4.replace("/", "\\");
                                    inputStream = this.getInputStream(string4);
                                    if (inputStream != null) {
                                        string2 = string4;
                                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string3));
                                        executePathCheckReturn.setOutputFile(string2);
                                    }
                                } else {
                                    string2 = string4;
                                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), string3));
                                    executePathCheckReturn.setOutputFile(string2);
                                }
                            }
                        }
                    }
                    if (bufferedReader != null) break block63;
                    if (inputStream == null) break block64;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
                if (executePathCheckReturn.getLastException() != null) {
                    if (pathException != null) {
                        executePathCheckReturn.setLastException(pathException);
                    } else {
                        executePathCheckReturn.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", string2)));
                    }
                }
                break block67;
            }
            executePathCheckReturn.setLiveReader(bufferedReader);
            break block67;
            catch (Exception exception) {
                block65: {
                    block66: {
                        try {
                            executePathCheckReturn.setLastException(new PathException(exception));
                            if (bufferedReader != null) break block65;
                            if (inputStream == null) break block66;
                        }
                        catch (Throwable throwable) {
                            if (bufferedReader == null) {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                                    }
                                }
                                if (executePathCheckReturn.getLastException() != null) {
                                    if (pathException != null) {
                                        executePathCheckReturn.setLastException(pathException);
                                    } else {
                                        executePathCheckReturn.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", string2)));
                                    }
                                }
                            } else {
                                executePathCheckReturn.setLiveReader(bufferedReader);
                            }
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                        }
                    }
                    if (executePathCheckReturn.getLastException() != null) {
                        if (pathException != null) {
                            executePathCheckReturn.setLastException(pathException);
                        } else {
                            executePathCheckReturn.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", string2)));
                        }
                    }
                }
                executePathCheckReturn.setLiveReader(bufferedReader);
            }
        }
        return executePathCheckReturn;
    }

    public ExecutePathCheckReturn checkMultiplePaths() {
        ExecutePathCheckReturn executePathCheckReturn;
        String string;
        String string2;
        block62: {
            String string3;
            boolean bl;
            int n;
            String string4;
            URL uRL;
            URL uRL2;
            String string5;
            block64: {
                block63: {
                    string2 = "";
                    string = null;
                    executePathCheckReturn = null;
                    string5 = this.getScriptRunnerContext().getEncoding();
                    uRL2 = (URL)this.getScriptRunnerContext().getProperty("script.runner.base.url");
                    if (this.getScriptRunnerContext().getTopLevel()) {
                        this.getScriptRunnerContext().putProperty("script.runner.topbase.url", uRL2);
                    }
                    uRL = (URL)this.getScriptRunnerContext().getProperty("script.runner.topbase.url");
                    boolean bl2 = false;
                    string4 = "";
                    n = 0;
                    if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_START) {
                        string4 = this.cmd.getSql();
                        if ((string4 = string4.trim()).toLowerCase().equals("start")) {
                            this.report(Messages.getString("SQLPLUS.3"));
                        } else {
                            bl = false;
                            for (n = 0; n < string4.length(); ++n) {
                                char c = string4.charAt(n);
                                if (!Character.isWhitespace(c) && c != '\'' && c != '\"') continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                string4 = string4.substring(n).trim();
                                bl2 = true;
                            }
                        }
                    } else if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_AT) {
                        if (this.cmd.getSql().trim().startsWith("@@")) {
                            this.cmd.setStmtId(SQLCommand.StmtSubType.G_S_ATNESTED);
                        } else {
                            string4 = this.cmd.getSql();
                            if ((string4 = string4.trim()).length() == 1) {
                                this.report(Messages.getString("SQLPLUS.3"));
                            } else {
                                if ((string4 = string4.substring(1).trim()).startsWith("~")) {
                                    string4 = string4.replaceFirst("~", System.getProperty("user.home"));
                                }
                                bl2 = true;
                            }
                        }
                    }
                    if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_ATNESTED) {
                        string4 = this.cmd.getSql();
                        if ((string4 = string4.trim()).length() != 2) {
                            string4 = string4.substring(2).trim();
                            bl2 = true;
                        }
                    }
                    if (!bl2) break block62;
                    bl = false;
                    string3 = null;
                    String string6 = "";
                    if (string4.length() <= 1 || !string4.startsWith("\"") && !string4.startsWith("'")) break block63;
                    string6 = new Character(string4.charAt(0)).toString();
                    int n2 = string4.substring(1).indexOf(string6);
                    if (n2 == -1) break block64;
                    string3 = string4.substring(1, n2 + 1);
                    n = n2 + 2;
                    break block64;
                }
                for (n = 0; n < string4.length(); ++n) {
                    if (!Character.isWhitespace(string4.charAt(n))) continue;
                    bl = true;
                    break;
                }
            }
            if (bl || string4.length() != 0) {
                String string7;
                int n3;
                String string8 = "";
                if (bl || string3 != null) {
                    if (string3 != null) {
                        string8 = string3;
                        if (string4.length() > n) {
                            string = string4.substring(n).trim();
                        }
                    } else {
                        string8 = string4.substring(0, n);
                        if (string4.length() > n + 1) {
                            string = string4.substring(n).trim();
                        }
                    }
                } else {
                    string8 = string4;
                }
                if (string8.startsWith("?") && string8.length() > 1) {
                    String string9 = System.getenv("ORACLE_HOME");
                    if (string9 == null) {
                        string9 = "?";
                    }
                    if (string9.endsWith(File.separator)) {
                        string9 = string9.substring(0, string9.length() - 1);
                    }
                    string8 = string9 + string8.substring(1);
                }
                int n4 = string8.lastIndexOf("/");
                int n5 = string8.lastIndexOf("\\");
                if (n5 > n4) {
                    n4 = n5;
                }
                if ((n3 = string8.lastIndexOf(46)) <= n4 && !this.getScriptRunnerContext().getProperty("script.runner.file.suffix").equals("")) {
                    string8 = string8 + "." + this.getScriptRunnerContext().getProperty("script.runner.file.suffix");
                }
                string2 = string8;
                boolean bl3 = false;
                if (!this.startsWithHttpOrFtp(string8)) {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        if (string8.length() <= 3 || (string8.charAt(1) != ':' || string8.charAt(2) != '/' && string8.charAt(2) != '\\') && (string8.charAt(0) != '/' || string8.charAt(2) != ':' || string8.charAt(3) != '/')) {
                            bl3 = true;
                        }
                    } else if (!string8.startsWith("/") && !string8.startsWith("\\")) {
                        bl3 = true;
                    }
                }
                if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_ATNESTED) {
                    string7 = null;
                    boolean bl4 = false;
                    if (bl3) {
                        int n6 = string8.indexOf("/");
                        int n7 = string8.indexOf("\\");
                        String string10 = null;
                        if (this.getDirectory() != null) {
                            string10 = this.getDirectory().endsWith("/") || this.getDirectory().endsWith("\\") ? this.getDirectory() + string8 : this.getDirectory() + File.separator + string8;
                        }
                        if (string10 != null && this.startsWithHttpOrFtp(string10)) {
                            if (this.haveIBytes(string10)) {
                                string7 = string10.replace("\\", "/");
                            } else if (this.getDirectory().indexOf("\\") != -1 && this.haveIBytesRaw(string10.replace("/", "\\"))) {
                                string7 = string10.replace("/", "\\");
                            } else {
                                bl3 = false;
                                bl4 = true;
                            }
                        } else if (string10 != null && new File(string10.replace("/", "\\")).exists()) {
                            bl3 = true;
                        } else if (string10 != null && new File(string10.replace("\\", "/")).exists()) {
                            bl3 = true;
                        } else {
                            bl3 = false;
                            bl4 = true;
                        }
                    }
                    if (string7 != null) {
                        string8 = string7;
                    } else if (bl3 && this.getDirectory() != null && !this.getDirectory().equals("")) {
                        string8 = this.getDirectory().endsWith("/") || this.getDirectory().endsWith("\\") ? this.getDirectory() + string8 : this.getDirectory() + File.separator + string8;
                    }
                    bl3 = false;
                    if (bl4) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    string7 = string5;
                    executePathCheckReturn = this.checkPath(false, false, false, (String)this.getScriptRunnerContext().getProperty("script.runner.cd_command"), null, string8, string7, null);
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(false, false, false, null, uRL2, string8, string7, null);
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(false, false, false, null, uRL, string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(false, false, false, null, this.useIfNotDirectoryOrNotFile(this.getScriptRunnerContext().getLastNodeForDirNameURL()), string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(true, false, false, null, this.useIfDirectoryOrNotFile(this.getScriptRunnerContext().getLastNodeForDirNameURL()), string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(false, false, false, null, this.useIfNotDirectoryOrNotFile(this.getScriptRunnerContext().getLastDirNameURL()), string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(true, false, false, null, this.useIfDirectoryOrNotFile(this.getScriptRunnerContext().getLastDirNameURL()), string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(false, true, false, (String)this.getScriptRunnerContext().getProperty("DBConfig.DEFAULT_PATH"), null, string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null && SQLPLUS.getSqlpathProvider() != null) {
                        executePathCheckReturn = this.checkPath(false, true, false, SQLPLUS.getSqlpathProvider().getSQLPATHsetting(), null, string8, string7, executePathCheckReturn.getLastException());
                    }
                    if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null && executePathCheckReturn.getLiveReader() == null && executePathCheckReturn.getUrl() == null) {
                        executePathCheckReturn = this.checkPath(false, false, true, null, null, string8, string7, executePathCheckReturn.getLastException());
                    }
                }
                if (executePathCheckReturn == null) {
                    executePathCheckReturn = this.checkPath(false, false, true, null, null, string8, string5, null);
                }
            }
        }
        if (executePathCheckReturn != null) {
            executePathCheckReturn.setArguments(string);
            executePathCheckReturn.setPreAppendInputFile(string2);
        }
        return executePathCheckReturn;
    }

    URL useIfDirectoryOrNotFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol() == null || !uRL.getProtocol().toLowerCase().endsWith("file")) {
            return uRL;
        }
        try {
            if (new File(uRL.getFile()).isDirectory()) {
                return uRL;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    URL useIfNotDirectoryOrNotFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol() == null || !uRL.getProtocol().toLowerCase().endsWith("file")) {
            return uRL;
        }
        try {
            if (new File(uRL.getFile()).isDirectory()) {
                return null;
            }
            return uRL;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecuteFile() {
        Integer n = 0;
        boolean bl = this.getScriptRunnerContext().getTopLevel();
        n = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
        URL uRL = (URL)this.getScriptRunnerContext().getProperty("script.runner.base.url");
        String string = this.getScriptRunnerContext().getSourceRef();
        ExecutePathCheckReturn executePathCheckReturn = this.checkMultiplePaths();
        if (executePathCheckReturn != null && (executePathCheckReturn.getLiveReader() != null || executePathCheckReturn.getUrl() != null)) {
            try {
                Object object;
                this._runner = executePathCheckReturn.getLiveReader() != null ? new ScriptExecutor(executePathCheckReturn.getLiveReader(), this.conn) : (this.getScriptRunnerContext().getEncoding() != null ? new ScriptExecutor(executePathCheckReturn.getUrl(), this.conn, this.getScriptRunnerContext().getEncoding()) : new ScriptExecutor(executePathCheckReturn.getUrl(), this.conn));
                String[] stringArray = ScriptUtils.executeArgs(executePathCheckReturn.getArguments());
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        object = this.getScriptRunnerContext().getMap();
                        object.put((String)Integer.toString(i + 1), (String)stringArray[i]);
                    }
                }
                this._runner.setOut(this.out);
                if (n < 21) {
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", n + 1);
                    this.getScriptRunnerContext().setTopLevel(false);
                    this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                    String string2 = null;
                    object = executePathCheckReturn.getOutputFile();
                    object = executePathCheckReturn.getUrl() == null ? executePathCheckReturn.getOutputFile() : executePathCheckReturn.getUrl().toString();
                    if (new File((String)object).exists()) {
                        string2 = new File((String)object).getCanonicalPath();
                        int n2 = string2.lastIndexOf("/");
                        int n3 = string2.lastIndexOf("\\");
                        if (n3 > n2) {
                            n2 = n3;
                        }
                        this._runner.getScriptRunnerContext().setSourceRef(string2);
                        string2 = string2.substring(0, n2);
                        this._runner.setDirectory(string2);
                    } else if (this.startsWithHttpOrFtp((String)object) && this.haveIBytes((String)object)) {
                        String string3 = ((String)object).replace("\\", "/");
                        this._runner.getScriptRunnerContext().setSourceRef(string3);
                        int n4 = string3.lastIndexOf("/");
                        int n5 = string3.lastIndexOf("\\");
                        if (n5 > n4) {
                            n4 = n5;
                        }
                        string3 = string3.substring(0, n4);
                        this._runner.setDirectory(string3);
                    } else if (this.startsWithHttpOrFtp((String)object) && this.haveIBytesRaw((String)object)) {
                        String string4 = ((String)object).replace("/", "\\");
                        this._runner.getScriptRunnerContext().setSourceRef(string4);
                        int n6 = string4.lastIndexOf("/");
                        int n7 = string4.lastIndexOf("\\");
                        if (n7 > n6) {
                            n6 = n7;
                        }
                        string4 = string4.substring(0, n6);
                        this._runner.setDirectory(string4);
                    } else {
                        this._runner.getScriptRunnerContext().setSourceRef("");
                        this._runner.setDirectory("");
                    }
                    ArrayList arrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
                    arrayList.add(executePathCheckReturn.getPreAppendInputFile());
                    this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", arrayList);
                    if (arrayList.size() != 0) {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)arrayList.get(arrayList.size() - 1), arrayList.size());
                    }
                    this._runner.run();
                    if (uRL != null) {
                        this.getScriptRunnerContext().putProperty("script.runner.base.url", uRL);
                    }
                    if ((arrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist")).size() != 0) {
                        arrayList.remove(arrayList.size() - 1);
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", arrayList);
                    if (arrayList.size() != 0) {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)arrayList.get(arrayList.size() - 1), arrayList.size());
                    } else {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), PRODUCT_NAME, 0);
                    }
                    this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                    this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                }
                this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("MAX_NEST"), this.getScriptRunnerContext()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", executePathCheckReturn.getPreAppendInputFile()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            catch (IOException iOException) {
                this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", executePathCheckReturn.getPreAppendInputFile()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            catch (ArgumentQuoteException argumentQuoteException) {
                this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("QUOTEMISMATCH", argumentQuoteException.getMessage()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            finally {
                this.getScriptRunnerContext().setTopLevel(bl);
                this.getScriptRunnerContext().putProperty("script.runner.script_depth", n);
                this.getScriptRunnerContext().setSourceRef(string);
                if (executePathCheckReturn != null && executePathCheckReturn.getLiveReader() != null) {
                    try {
                        executePathCheckReturn.getLiveReader().close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
            }
        } else if (executePathCheckReturn != null) {
            if (executePathCheckReturn.getLastException() != null) {
                String string5 = executePathCheckReturn.getLastException().getMessage();
                LOGGER.log(Level.FINE, executePathCheckReturn.getLastException().getStackTrace()[0].toString(), executePathCheckReturn.getLastException());
            }
            this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", executePathCheckReturn.getPreAppendInputFile()), this.getScriptRunnerContext()));
            this.doWhenever(false);
        } else if (this.cmd.getModifiedSQL().toLowerCase().equals("@@")) {
            this.report(ScriptRunnerDbArb.getString("INVALID_FILE_NAME"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL joinUrl(boolean bl, URL uRL, String string) {
        try {
            if (uRL == null || string == null) {
                return null;
            }
            String string2 = uRL.toString();
            int n = string2.lastIndexOf("/");
            int n2 = string2.lastIndexOf("\\");
            if (bl) {
                if (n2 > n) {
                    string2 = string2 + "\\" + string.replace("/", "\\");
                    return new URL(string2);
                } else {
                    if (n <= n2) return null;
                    string2 = string2 + "/" + string.replace("\\", "/");
                }
                return new URL(string2);
            } else if (n2 > n) {
                string2 = string2.substring(0, n2 + 1) + string.replace("/", "\\");
                return new URL(string2);
            } else {
                if (n <= n2) return null;
                string2 = string2.substring(0, n + 1) + string.replace("\\", "/");
            }
            return new URL(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean haveIBytes(URL uRL) {
        if (uRL != null) {
            InputStream inputStream = null;
            URLConnection uRLConnection = null;
            try {
                uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                if (inputStream.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (MalformedURLException malformedURLException) {
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }
        return false;
    }

    private boolean containsFile(String string) {
        String string2;
        boolean bl = false;
        if (string.indexOf(":") > 1 && (string2 = string.substring(0, string.indexOf(":"))).endsWith("file") && string2.indexOf("/") == -1 && string2.indexOf("\\") == -1) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean haveIBytes(String string) {
        if (!this.startsWithHttpOrFtp(string)) {
            return false;
        }
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        try {
            String string2 = string.toLowerCase();
            if (this.containsFile(string2)) {
                string = string.substring(string2.indexOf("file:"));
            }
            if ((inputStream = (uRLConnection = new URL(string.replaceAll("\\\\", "/")).openConnection()).getInputStream()).read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException malformedURLException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean haveIBytesRaw(String string) {
        if (!this.startsWithHttpOrFtp(string)) {
            return false;
        }
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        try {
            String string2 = string.toLowerCase();
            if (this.containsFile(string2)) {
                string = string.substring(string2.indexOf("file:"));
            }
            if (string.indexOf("\\") != -1) {
                string.replace("/", "\\");
                uRLConnection = new URL(string).openConnection();
                inputStream = uRLConnection.getInputStream();
                if (inputStream.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private InputStream getInputStream(String string) {
        if (!this.startsWithHttpOrFtp(string)) {
            return null;
        }
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        try {
            String string2 = string.toLowerCase();
            if (this.containsFile(string2)) {
                string = string.substring(string2.indexOf("file:"));
            }
            boolean bl = false;
            try {
                uRLConnection = new URL(string.replace("\\", "/")).openConnection();
            }
            catch (MalformedURLException malformedURLException) {
                bl = true;
            }
            catch (IOException iOException) {
                bl = true;
            }
            if (bl) {
                uRLConnection = new URL(string.replace("//", "\\")).openConnection();
            }
            inputStream = uRLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return inputStream;
    }

    private boolean startsWithHttpOrFtp(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        return string2.startsWith("http://") || string2.startsWith("http:\\\\") || this.containsFile(string2) || string2.startsWith("ftp:\\\\") || string2.startsWith("ftp://");
    }

    private void runPrompt() {
        String string = this.cmd.getSql();
        string = string.trim();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < string.length(); ++n) {
            if (!Character.isWhitespace(string.charAt(n))) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.report(string.substring(n).trim());
        } else {
            this.report("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPrint() {
        this.report("");
        char c = '\u0fa0';
        this.cmd.setSql(this.cmd.getSql().replaceAll(":", ""));
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (stringArray[1].trim().equals("")) {
            Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
            if (map.size() == 0) {
                this.report(Messages.getString("SQLPLUS.26"));
                return;
            }
            Set<String> set = map.keySet();
            Map<String, Bind> map2 = map;
            synchronized (map2) {
                for (String string : set) {
                    Bind bind = map.get(string);
                    if (bind != null) {
                        int n;
                        String string2 = bind.getValue();
                        if (bind.getType() != null && (bind.getType().equals("LONG") || bind.getType().equals("CLOB")) && string2 != null && string2.length() > (Integer)this.getScriptRunnerContext().getProperty("script.runner.setlong")) {
                            string2 = string2.substring(0, (Integer)this.getScriptRunnerContext().getProperty("script.runner.setlong"));
                        }
                        if (bind.getType() != null && (bind.getType().toUpperCase().startsWith("NUMBER") || bind.getType().toUpperCase().startsWith("BINARY_FLOAT") || bind.getType().toUpperCase().startsWith("BINARY_DOUBLE")) && string2 != null && string2.length() < 11 && string != null && string.length() < 11) {
                            string = "            ".substring(0, 10 - string.length()) + string;
                            string2 = "             ".substring(0, 10 - string2.length()) + string2;
                        }
                        if (string2 == null) {
                            this.report(string);
                            this.report("------\n");
                            continue;
                        }
                        this.report(string);
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n = 0; n < string2.length(); ++n) {
                            stringBuffer.append("-");
                            if (n % c != 0) continue;
                            this.getScriptRunnerContext().write(stringBuffer.toString());
                            stringBuffer = new StringBuffer();
                            try {
                                this.getScriptRunnerContext().getOutputStream().flush();
                                continue;
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                            }
                        }
                        this.report(stringBuffer.toString());
                        n = string2.length();
                        char c2 = '\u0000';
                        for (char c3 = c; c3 < n - 2; c3 += c) {
                            this.getScriptRunnerContext().write(string2.substring(c2, c3));
                            c2 = c3;
                            try {
                                this.getScriptRunnerContext().getOutputStream().flush();
                                continue;
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                            }
                        }
                        this.report(string2.substring(c2) + "\n");
                        continue;
                    }
                    this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", string));
                }
            }
        }
        Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
        String[] stringArray2 = stringArray[1].split("\\s");
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i].trim().toUpperCase();
            Bind bind = null;
            bind = map.get(string.toUpperCase());
            if (bind != null) {
                int n;
                CharSequence charSequence;
                char c4;
                int n2;
                String string3 = bind.getValue();
                if (bind.getType() != null && (bind.getType().equals("LONG") || bind.getType().equals("CLOB")) && string3 != null && string3.length() > (Integer)this.getScriptRunnerContext().getProperty("script.runner.setlong")) {
                    string3 = string3.substring(0, (Integer)this.getScriptRunnerContext().getProperty("script.runner.setlong"));
                }
                if (bind.getType() != null && bind.getType().toUpperCase().startsWith("NUMBER") && string3 != null && string3.length() < 11 && string != null && string.length() < 11) {
                    string = "            ".substring(0, 10 - string.length()) + string;
                    string3 = "             ".substring(0, 10 - string3.length()) + string3;
                }
                if (bind.getType() != null && (bind.getType().toUpperCase().startsWith("BINARY_FLOAT") || bind.getType().toUpperCase().startsWith("BINARY_DOUBLE")) && string3 != null && string3.length() < 11 && string != null && string.length() < 11) {
                    int n3 = 10;
                    string = "            ".substring(0, 10 - string.length()) + string;
                    if (string3.trim().equals("0")) {
                        string3 = "             ".substring(0, 10 - string3.length()) + string3;
                    } else {
                        Object object;
                        DecimalFormat decimalFormat = new DecimalFormat();
                        String string4 = "";
                        n2 = 8;
                        c4 = '#';
                        if (n3 < n2) {
                            object = new char[n3 + 1];
                            Arrays.fill((char[])object, c4);
                            string3 = String.valueOf((char[])object);
                        } else {
                            Object object2;
                            object = "0.{0}E000";
                            int n4 = n3 - n2;
                            String string5 = "";
                            if (n4 > 0) {
                                object2 = new char[n4];
                                Arrays.fill((char[])object2, c4);
                                string5 = String.valueOf((char[])object2);
                            } else {
                                string5 = "#";
                            }
                            decimalFormat = new DecimalFormat(MessageFormat.format((String)object, string5));
                            object2 = decimalFormat.format(Double.valueOf(string3));
                            String[] stringArray3 = ((String)object2).split("E");
                            String string6 = "+";
                            string6 = stringArray3[1].startsWith("-") ? "" : "+";
                            string3 = stringArray3[0] + "E" + string6 + stringArray3[1];
                            if (string3.length() <= 10) {
                                string3 = "             ".substring(0, 10 - string3.length()) + string3;
                            }
                        }
                    }
                }
                if (string3 == null) {
                    this.report(string);
                    charSequence = (String)this.getScriptRunnerContext().getProperty("script.runner.setnull");
                    if (charSequence != null && !((String)charSequence).equals("")) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < ((String)charSequence).length(); ++j) {
                            stringBuffer.append("-");
                        }
                        this.report(stringBuffer.toString());
                        this.report((String)charSequence + "\n");
                        continue;
                    }
                    if (bind.getType() != null && bind.getType().startsWith("BFILE")) {
                        string3 = "bfilename(NULL)";
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < string3.length(); ++j) {
                            stringBuffer.append("-");
                        }
                        this.report(stringBuffer.toString());
                        this.report(string3 + "\n");
                        continue;
                    }
                    this.report("------\n");
                    continue;
                }
                this.report(string);
                charSequence = new StringBuffer();
                for (n = 0; n < string.length(); ++n) {
                    ((StringBuffer)charSequence).append("-");
                    if (n % c != 0) continue;
                    this.getScriptRunnerContext().write(((StringBuffer)charSequence).toString());
                    charSequence = new StringBuffer();
                    try {
                        this.getScriptRunnerContext().getOutputStream().flush();
                        continue;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
                this.report(((StringBuffer)charSequence).toString());
                n = string3.length();
                char c5 = '\u0000';
                n2 = 0;
                if (string3 != null) {
                    n2 = string3.split("\r\n|\r|\n").length;
                }
                c4 = '\u0000';
                for (c4 = c; c4 < n - 2; c4 += c) {
                    this.getScriptRunnerContext().write(string3.substring(c5, c4));
                    try {
                        this.getScriptRunnerContext().getOutputStream().flush();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                    c5 = c4;
                }
                this.report(string3.substring(c5));
                if (n2 < 8 || this.getScriptRunnerContext().getFeedback() == -2) continue;
                this.report(MessageFormat.format(Messages.getString("SQLPLUS.28"), n2 - 2));
                continue;
            }
            this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", string));
        }
    }

    private int indexOfFirstWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runVariable() {
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (stringArray[1].trim().equals("")) {
            Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
            Set<String> set = map.keySet();
            Map<String, Bind> map2 = map;
            synchronized (map2) {
                Iterator<String> iterator = set.iterator();
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        String string = iterator.next();
                        Bind bind = map.get(string);
                        String string2 = bind.getType();
                        String string3 = bind.getBracket();
                        String string4 = string3 != null ? string3 : string2;
                        this.report("VARIABLE " + string + " " + " DATATYPE " + string4 + "\n");
                    }
                } else {
                    this.report(Messages.getString("SQLPLUS.4"));
                }
            }
        } else {
            String string = "";
            if (this.indexOfFirstWhitespace(stringArray[1]) == -1) {
                Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
                Set<String> set = map.keySet();
                Iterator<String> iterator = set.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    String string5 = iterator.next();
                    if (!stringArray[1].toLowerCase().equals(string5.toLowerCase())) continue;
                    Bind bind = map.get(string5);
                    String string6 = bind.getType();
                    String string7 = bind.getBracket();
                    String string8 = string7 != null ? string7 : string6;
                    this.report("VARIABLE " + string5 + " " + " DATATYPE " + string8 + "\n");
                    bl = true;
                }
                if (!bl) {
                    this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", stringArray[1]));
                }
            } else {
                string = stringArray[1].substring(0, this.indexOfFirstWhitespace(stringArray[1])).trim();
                String string9 = "";
                string9 = stringArray[1].substring(this.indexOfFirstWhitespace(stringArray[1]) + 1).trim();
                String string10 = this.validVariableDatatype(string9, true);
                string9 = this.validVariableDatatype(string9, false);
                if (Character.isLetter(string.charAt(0))) {
                    if (string10 == null || string9 == null || string10.replace(string9, "").trim().equals("(0)")) {
                        this.report(ScriptRunnerDbArb.format("ILLEGAL_USAGE", string));
                    } else {
                        Bind bind = new Bind(string.toUpperCase(), string9.toUpperCase(), string10.toUpperCase(), string, null, string);
                        Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
                        map.put(string.toUpperCase(), bind);
                    }
                } else {
                    this.report(ScriptRunnerDbArb.format("ILLEGAL_VARIABLE", string));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAliases() throws ArgumentQuoteException {
        String string = this.cmd.getSql();
        String[] stringArray = string.split("\\s+");
        String string2 = "";
        String string3 = "";
        if (stringArray.length > 0) {
            String string4 = "";
            if (stringArray.length > 1 && Aliases.getInstance().contains(stringArray[0] + stringArray[1])) {
                string2 = stringArray[0] + stringArray[1];
                if (stringArray.length > 2) {
                    string3 = this.cmd.getSql().trim().replaceAll("^\\s*" + stringArray[0] + "\\s+" + stringArray[1] + "\\s+", "");
                }
                System.out.println("Command=" + stringArray[0] + " " + stringArray[1]);
                string4 = Aliases.getInstance().get(string2).getQuery();
            } else if (Aliases.getInstance().contains(stringArray[0])) {
                string2 = stringArray[0];
                if (stringArray.length > 1) {
                    string3 = this.cmd.getSql().trim().replaceAll("^\\s*" + stringArray[0] + "\\s+", "");
                }
                System.out.println("Command=" + stringArray[0]);
                string4 = Aliases.getInstance().get(string2).getQuery();
            }
            if (string4 != null && !string4.equals("")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string5 = "";
                Integer n = 0;
                String string6 = this.getScriptRunnerContext().getSourceRef();
                boolean bl = this.getScriptRunnerContext().getTopLevel();
                n = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
                try {
                    ScriptParser scriptParser = new ScriptParser(string4);
                    Object object = ScriptUtils.executeArgs(string3);
                    if (object == null) {
                        object = new String[]{};
                    }
                    int n2 = 0;
                    ISQLCommand iSQLCommand = null;
                    while ((iSQLCommand = scriptParser.next()) != null) {
                        try {
                            ArrayList<Bind> arrayList2 = Parser.getInstance().getBinds(iSQLCommand.getSql(), false);
                            ArrayList object2 = new ArrayList();
                            Iterator iterator = arrayList2.iterator();
                            while (iterator.hasNext()) {
                                Bind bind = (Bind)iterator.next();
                                if (this.getScriptRunnerContext().getVarMap().containsKey(bind.getName().toUpperCase())) continue;
                                if (n2 < ((String[])object).length) {
                                    Bind bind2 = new Bind(bind.getName().toUpperCase(), "VARCHAR2", "VARCHAR2(1000)", bind.getName().toUpperCase(), object[n2], bind.getName().toUpperCase());
                                    ++n2;
                                    this.getScriptRunnerContext().getVarMap().put(bind.getName().toUpperCase(), bind2);
                                    arrayList.add(bind.getName().toUpperCase());
                                    continue;
                                }
                                string5 = ScriptRunnerDbArb.getString("ALIASWITHBINDS_NOTENOUGH");
                            }
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, throwable.getMessage());
                        }
                    }
                    if (n2 != ((String[])object).length) {
                        this.report(ScriptRunnerDbArb.getString("ALIASWITHBINDS_TOOMANY"));
                    }
                    if (n > 20) {
                        string5 = ScriptRunnerDbArb.getString("MAX_NEST");
                    }
                    if (string5.equals("")) {
                        this.getScriptRunnerContext().putProperty("script.runner.script_depth", n + 1);
                        this.getScriptRunnerContext().setTopLevel(false);
                        this._runner = new ScriptExecutor(string4, this.conn);
                        this._runner.setOut(this.out);
                        this.getScriptRunnerContext().setSourceRef("/ALIAS/" + stringArray[0]);
                        this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                        this._runner.setDirectory(this.getDirectory());
                        this._runner.run();
                        this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                        this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                    } else {
                        this.report(string5);
                        string5 = "";
                    }
                    for (String string7 : arrayList) {
                        this.getScriptRunnerContext().getVarMap().remove(string7);
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getLocalizedMessage());
                }
                finally {
                    for (String string7 : arrayList) {
                        this.getScriptRunnerContext().getVarMap().remove(string7);
                    }
                    this.getScriptRunnerContext().setTopLevel(bl);
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", n);
                    this.getScriptRunnerContext().setSourceRef(string6);
                }
                if (string5 != null && !string5.equals("")) {
                    this.report(string5);
                }
                return true;
            }
        }
        return false;
    }

    private void runExecute() {
        String string = this.cmd.getSql();
        string = string.trim();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < string.length(); ++n) {
            if (!Character.isWhitespace(string.charAt(n))) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (string.endsWith(";")) {
                this.cmd.setSql("BEGIN" + string.substring(n) + " END;");
            } else {
                this.cmd.setSql("BEGIN" + string.substring(n) + ";" + " END;");
            }
            PLSQL pLSQL = new PLSQL(this.cmd, this.out);
            pLSQL.setScriptRunnerContext(this.getScriptRunnerContext());
            pLSQL.setConn(this.conn);
            pLSQL.run();
            pLSQL = null;
        } else {
            this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("MALFORMED_EXECUTE_CONTENT", this.cmd.getSql()), this.getScriptRunnerContext()));
        }
    }

    protected String validVariableDatatype(String string, boolean bl) {
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NUMBER");
        stringBuilder.append("|CHAR([\\s]*\\([\\s]*\\d+[\\s]*[CHAR|BYTE]*[\\s]*\\))*");
        stringBuilder.append("|NCHAR([\\s]*\\([\\s]*\\d+[\\s]*\\))*");
        stringBuilder.append("|VARCHAR2([\\s]*\\([\\s]*\\d+[\\s]*[CHAR|BYTE]*[\\s]*\\))*");
        stringBuilder.append("|NVARCHAR2([\\s]*\\([\\s]*\\d+[\\s]*\\))*");
        stringBuilder.append("|CLOB");
        stringBuilder.append("|NCLOB");
        stringBuilder.append("|BLOB");
        stringBuilder.append("|BFILE");
        stringBuilder.append("|REFCURSOR");
        stringBuilder.append("|BINARY_FLOAT");
        stringBuilder.append("|BINARY_DOUBLE");
        string2 = stringBuilder.toString();
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string.toUpperCase());
        if (matcher.matches()) {
            String string3 = matcher.group();
            if (bl && string3.indexOf(")") > 0) {
                return string3.substring(0, string3.indexOf(")") + 1).trim().toUpperCase();
            }
            if (string3.indexOf("(") > 0) {
                return string3.substring(0, string3.indexOf("(")).trim().toUpperCase();
            }
            return string3.trim().toUpperCase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(ArrayList<String> arrayList, String string, String string2, String string3, String string4) {
        String string5;
        Connection connection;
        block91: {
            String[] stringArray;
            String string6;
            connection = null;
            string5 = null;
            Properties properties = new Properties();
            properties.setProperty("v$session.program", "SQL Command Line");
            if (string != null && string.length() > 0) {
                string6 = string;
                if (string4 != null && string4.length() > 1 && (stringArray = this.nextWordAndRest(string4))[0].trim().equalsIgnoreCase("as") && !stringArray[1].trim().equalsIgnoreCase("sysdba")) {
                    string6 = string6 + " as " + stringArray[1].trim().toLowerCase();
                }
                properties.setProperty("user", string6);
            }
            if (string2 != null && string2.length() > 0) {
                properties.setProperty("password", string2);
            }
            string6 = string3;
            if (string != null) {
                string6 = string2 != null ? "PASSWORD=" + string2 + "]" + string6 : "PASSWORD=]" + string6;
                string6 = "[USERNAME=" + string + "," + string6;
            }
            stringArray = null;
            try {
                stringArray = new oracle.dbtools.db.ConnectionDetails(string6);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
            }
            if (stringArray != null && stringArray.getDriver() != null) {
                connection = stringArray.getConn();
            } else {
                String string7;
                Object object;
                Object object2;
                if (string4 != null && string4.length() > 1 && (object2 = this.nextWordAndRest(string4))[0].trim().equalsIgnoreCase("as") && object2[1].trim().equalsIgnoreCase("sysdba")) {
                    properties.setProperty("internal_logon", "SYSDBA");
                }
                object2 = (String[])this.getScriptRunnerContext().getProperty("DBConfig.USE_THICK_DRIVER");
                if ((string3 == null || string3.equals("")) && this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                    object = "TWO_TASK";
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                        object = "LOCAL";
                    }
                    if ((string7 = System.getenv((String)object)) != null && !string7.equals("")) {
                        string3 = string7;
                    }
                }
                if (string3 == null || string3.equals("")) {
                    try {
                        object = this.getScriptRunnerContext().getBaseConnection();
                        if (this.getScriptRunnerContext().getCurrentConnection() != null) {
                            object = this.getScriptRunnerContext().getCurrentConnection();
                            if (this.getScriptRunnerContext() != null && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                                object = null;
                            }
                        }
                        if (object != null) {
                            string7 = "";
                            if (DBUtil.getConnectionResolver().lock((Connection)object)) {
                                try {
                                    string7 = object.getMetaData().getURL();
                                }
                                finally {
                                    DBUtil.getConnectionResolver().unlock((Connection)object);
                                }
                            }
                            connection = this.logConnectionURL(arrayList, string, string7, properties, true);
                            break block91;
                        }
                        connection = null;
                        try {
                            if (((Boolean)object2).booleanValue()) {
                                string7 = "jdbc:oracle:oci8:@";
                                connection = this.logConnectionURL(arrayList, string, string7, properties, (Boolean)object2, true);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (connection == null) {
                            try {
                                string7 = System.getenv("ORACLE_SID");
                                if (string7 != null && !string7.equals("")) {
                                    String string8 = "jdbc:oracle:thin:@127.0.0.1:1521:" + System.getenv("ORACLE_SID");
                                    connection = this.logConnectionURL(arrayList, string, string8, properties, true);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (connection != null) break block91;
                        try {
                            string7 = "jdbc:oracle:thin:@localhost:1521/orcl";
                            connection = this.logConnectionURL(arrayList, string, string7, properties, false);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (SQLException sQLException) {
                        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                        connection = null;
                    }
                    catch (Throwable throwable) {
                        connection = null;
                    }
                } else {
                    String string9;
                    int n = -1;
                    connection = null;
                    string7 = null;
                    if (this.getScriptRunnerContext().getProperty("script.runner.ldapcon") != null && ((String)this.getScriptRunnerContext().getProperty("script.runner.ldapcon")).contains("#ENTRY#")) {
                        string7 = ((String)this.getScriptRunnerContext().getProperty("script.runner.ldapcon")).replace("#ENTRY#", string3);
                    }
                    if (string7 == null && System.getenv("LDAPCON") != null && System.getenv("LDAPCON").contains("#ENTRY#")) {
                        string7 = System.getenv("LDAPCON").replace("#ENTRY#", string3);
                    }
                    if (string7 != null) {
                        try {
                            connection = this.logConnectionURL(arrayList, string, string7, properties, true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ArrayList<TCPTNSEntry> arrayList2 = null;
                    if (connection == null && (arrayList2 = TNSHelper.getTNSEntries()) != null) {
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            if (!arrayList2.get(i).getName().toUpperCase().equals(string3.toUpperCase())) continue;
                            n = i;
                            break;
                        }
                    }
                    if (n == -1 && string3.indexOf("/") == -1 && string3.indexOf("\\") == -1 && string3.indexOf(":") == -1) {
                        String string10;
                        String string11 = string3;
                        int n2 = string11.indexOf(".");
                        if (n2 != -1) {
                            string11 = string11.substring(0, n2);
                        }
                        if (arrayList2 != null) {
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                string9 = arrayList2.get(i).getName();
                                int n3 = string9.indexOf(".");
                                if (n3 != -1) {
                                    string9 = string9.substring(0, n3);
                                }
                                if (!string9.toUpperCase().equals(string11.toUpperCase())) continue;
                                n = i;
                                break;
                            }
                        }
                        if (n == -1 && this.getScriptRunnerContext().isCommandLine() && (this.getScriptRunnerContext().getProperty("script.runner.setnet") == null || (String)this.getScriptRunnerContext().getProperty("script.runner.setnet") != null && !((String)this.getScriptRunnerContext().getProperty("script.runner.setnet")).equals("OFF")) && (string10 = NetEntries.getInstance().get(string3)) != null) {
                            string9 = string10;
                            try {
                                if (!((Boolean)object2).booleanValue()) {
                                    throw new Exception();
                                }
                                String string12 = "jdbc:oracle:oci8:@" + string9;
                                connection = this.logConnectionURL(arrayList, string, string12, properties, true);
                            }
                            catch (Throwable throwable) {
                                try {
                                    String[] stringArray2 = "jdbc:oracle:thin:@" + string9;
                                    connection = this.logConnectionURL(arrayList, string, (String)stringArray2, properties, true);
                                }
                                catch (Throwable throwable2) {
                                    connection = null;
                                    this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", throwable2.getMessage());
                                }
                            }
                        }
                    }
                    if (object2 == null) {
                        object2 = Boolean.FALSE;
                    }
                    if (n == -1 && connection == null) {
                        String string13;
                        try {
                            if (!((Boolean)object2).booleanValue()) {
                                throw new Exception();
                            }
                            string13 = "jdbc:oracle:oci8:@" + string3;
                            connection = this.logConnectionURL(arrayList, string, string13, properties, true);
                            string5 = string3;
                        }
                        catch (Throwable throwable) {
                            try {
                                String string14 = "jdbc:oracle:thin:@" + string3;
                                connection = this.logConnectionURL(arrayList, string, string14, properties, true);
                                string5 = string3;
                            }
                            catch (Throwable throwable3) {
                                connection = null;
                                this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", throwable3.getMessage());
                            }
                        }
                        if (connection == null && string3.indexOf("(") == -1) {
                            string13 = string3;
                            if (!string3.matches("^[^:]+\\:[0-9]+\\/.*") && string3.indexOf("/") != -1 && string3.substring(string3.indexOf("/") + 1).indexOf("/") == -1) {
                                string3 = string3.replaceAll("/", ":1521/");
                                try {
                                    if (!((Boolean)object2).booleanValue()) {
                                        throw new Exception();
                                    }
                                    String string15 = "jdbc:oracle:oci8:@" + string3;
                                    connection = this.logConnectionURL(arrayList, string, string15, properties, true);
                                    string5 = string3;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        String string16 = "jdbc:oracle:thin:@" + string3;
                                        connection = this.logConnectionURL(arrayList, string, string16, properties, true);
                                        string5 = string3;
                                    }
                                    catch (Throwable throwable4) {
                                        connection = null;
                                    }
                                }
                            }
                            if (connection == null && (string13.indexOf(":") == -1 || !string13.endsWith(":") && string13.substring(string13.indexOf(":") + 1).indexOf(":") != -1 && string13.indexOf("/") == -1)) {
                                String[] stringArray3;
                                String string17 = null;
                                String string18 = null;
                                string9 = null;
                                try {
                                    stringArray3 = InetAddress.getByAddress(InetAddress.getByName(string13).getAddress());
                                    string9 = stringArray3.getCanonicalHostName();
                                }
                                catch (UnknownHostException unknownHostException) {
                                    string9 = null;
                                }
                                for (String string19 : stringArray3 = new String[]{string13, string9}) {
                                    String string20;
                                    if (string19 == null) continue;
                                    if (connection != null) break;
                                    string17 = string19.indexOf(".") == -1 ? string19 : string19.substring(0, string19.indexOf("."));
                                    boolean bl = true;
                                    try {
                                        Integer.parseInt(string17);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl = false;
                                    }
                                    try {
                                        if (!bl) {
                                            string20 = "jdbc:oracle:thin:@" + string19 + ":1521/" + string17;
                                            connection = this.logConnectionURL(arrayList, string, string20, properties, false);
                                            string5 = string19 + ":1521/" + string17;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        connection = null;
                                    }
                                    if (connection != null || string19.indexOf(".") == -1) continue;
                                    string18 = string19;
                                    try {
                                        if (bl) continue;
                                        string20 = "jdbc:oracle:thin:@" + string19 + ":1521/" + string18;
                                        connection = this.logConnectionURL(arrayList, string, string20, properties, false);
                                        string5 = string19 + ":1521/" + string18;
                                    }
                                    catch (Throwable throwable) {
                                        connection = null;
                                    }
                                }
                            }
                        }
                    } else if (connection == null) {
                        try {
                            if (!((Boolean)object2).booleanValue()) {
                                throw new Exception();
                            }
                            String string21 = "jdbc:oracle:oci8:@" + arrayList2.get(n).getSpecUrl();
                            connection = this.logConnectionURL(arrayList, string, string21, properties, true);
                        }
                        catch (Throwable throwable) {
                            try {
                                String string22 = "jdbc:oracle:thin:@" + arrayList2.get(n).getSpecUrl();
                                connection = this.logConnectionURL(arrayList, string, string22, properties, true);
                            }
                            catch (SQLException sQLException) {
                                if (((Boolean)object2).booleanValue()) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ScriptRunnerDbArb.getString("OCI_FAILED_TRYING_THIN"));
                                }
                                this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                                connection = null;
                            }
                            catch (Throwable throwable5) {
                                connection = null;
                            }
                        }
                    }
                }
            }
        }
        this.setupNLS(connection);
        if (connection != null) {
            if (string5 != null && this.getScriptRunnerContext().isCommandLine() && (this.getScriptRunnerContext().getProperty("script.runner.setnet") == null || (String)this.getScriptRunnerContext().getProperty("script.runner.setnet") != null && !((String)this.getScriptRunnerContext().getProperty("script.runner.setnet")).equals("READONLY"))) {
                NetCommand.add(this.getScriptRunnerContext(), (String)this.getScriptRunnerContext().getProperty("script.runner.setnetoverwrite"), string5, string5, false);
            }
            this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", null);
        }
        return connection;
    }

    private Connection connect(String string, Properties properties) throws SQLException {
        ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
        if (scriptRunnerContext != null) {
            scriptRunnerContext.putProperty("cli.conn.url", string);
            scriptRunnerContext.putProperty("cli.conn.props", properties);
        }
        return DriverManager.getConnection(string, properties);
    }

    private Connection logConnectionURL(ArrayList<String> arrayList, String string, String string2, Properties properties, boolean bl) throws Throwable {
        return this.logConnectionURL(arrayList, string, string2, properties, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection logConnectionURL(ArrayList<String> arrayList, String string, String string2, Properties properties, boolean bl, boolean bl2) throws Throwable {
        String string3 = "";
        boolean bl3 = false;
        Connection connection = null;
        if (bl2) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ScriptRunnerDbArb.format("CONNECTING", string2));
        }
        String string4 = ScriptRunnerDbArb.getString("NO_ERROR");
        try {
            connection = this.connect(string2, properties);
            this.getScriptRunnerContext().putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            return connection;
        }
        catch (Throwable throwable) {
            string4 = throwable.getLocalizedMessage();
            if (string4 == null) {
                string4 = throwable.getMessage();
            }
            string4 = string4 != null ? string4.trim() : "";
            string3 = properties.getProperty("user");
            if (string3 == null) {
                string3 = "";
            }
            try {
                String string5;
                String string6 = properties.getProperty("internal_logon");
                if (!bl || !this.getScriptRunnerContext().isCommandLine() || !(throwable instanceof SQLException) || ((SQLException)throwable).getErrorCode() != 1034 || !this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT) || string6 == null || !string6.equalsIgnoreCase("SYSDBA")) throw throwable;
                Properties properties2 = new Properties();
                String string7 = properties.getProperty("user");
                if (string7 != null) {
                    properties2.setProperty("user", string7);
                }
                if ((string5 = properties.getProperty("password")) != null) {
                    properties2.setProperty("password", string5);
                }
                properties2.setProperty("prelim_auth", "true");
                properties2.setProperty("internal_logon", "SYSDBA");
                ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
                try {
                    connection = DriverManager.getConnection(string2, properties2);
                    this.getScriptRunnerContext().putProperty("script.runner.PRELIM_AUTH", Boolean.TRUE);
                    if (scriptRunnerContext != null) {
                        scriptRunnerContext.putProperty("cli.conn.url", string2);
                        scriptRunnerContext.putProperty("cli.conn.props", properties);
                    }
                }
                catch (Throwable throwable2) {
                    if (bl2) {
                        arrayList.add(ScriptRunnerDbArb.format("URL_MESSAGE", string3, string2, string4));
                    }
                    string4 = "";
                    string4 = throwable2.getLocalizedMessage();
                    if (string4 == null) {
                        string4 = throwable.getMessage();
                    }
                    string4 = string4 != null ? string4.trim() : "";
                    bl3 = true;
                    throw throwable2;
                }
                if (string4 == null || string4.equals("")) return connection;
                string3 = properties.getProperty("user");
                if (string3 == null) {
                    string3 = "";
                }
                if (bl3) {
                    string3 = string3 + " prelim_auth";
                }
                if (!bl2) return connection;
            }
            catch (Throwable throwable3) {
                if (string4 == null || string4.equals("")) throw throwable3;
                string3 = properties.getProperty("user");
                if (string3 == null) {
                    string3 = "";
                }
                if (bl3) {
                    string3 = string3 + " prelim_auth";
                }
                if (!bl2) throw throwable3;
                arrayList.add(ScriptRunnerDbArb.format("URL_MESSAGE", string3, string2, string4));
                throw throwable3;
            }
            arrayList.add(ScriptRunnerDbArb.format("URL_MESSAGE", string3, string2, string4));
            return connection;
        }
    }

    private void setupNLS(Connection connection) {
        Map<String, String> map = this.getScriptRunnerContext().getNLSMap();
        if (connection != null && map != null && !map.isEmpty()) {
            OracleNLSProvider oracleNLSProvider = null;
            oracleNLSProvider = new OracleNLSProvider(connection);
            ((DefaultNLSProvider)oracleNLSProvider).initConnection();
            ((DefaultNLSProvider)oracleNLSProvider).updateDefaults(map);
        }
    }

    private String[] nextWordAndRest(String string) {
        return this.nextWordAndRestOrString(string, null);
    }

    private String[] nextWordAndRestOrString(String string, String string2) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = "";
        String string4 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\"') {
                bl = !bl;
            }
            if (!Character.isWhitespace(string.charAt(n)) && (string2 == null || string2.indexOf(string.charAt(n)) == -1) || bl) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            string3 = string.substring(n).trim();
            string4 = string.substring(0, n);
        } else {
            string4 = string;
        }
        String[] stringArray = new String[]{string4, string3};
        return stringArray;
    }

    public static String removeDashNewline(ISQLCommand iSQLCommand, String string) {
        if (iSQLCommand.getProperty("STRIPPED_CONTINUATION") != null) {
            return string;
        }
        return SQLPLUS.removeDashNewline(string);
    }

    public static String removeDashNewline(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((string = string.trim()).endsWith("-")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("-")) {
            string = string.substring(1, string.length());
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!(c != '\'' && c != '\"' || bl)) {
                stringBuffer.append(c);
                bl = true;
                continue;
            }
            if (bl) {
                string2 = "" + c;
                if (!string2.equals(m_lineSeparator)) {
                    stringBuffer.append(c);
                }
                if (c != '\'' && c != '\"') continue;
                bl = false;
                continue;
            }
            if (c == '-' || (string2 = "" + c).equals(m_lineSeparator)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public static ProviderForSQLPATH getSqlpathProvider() {
        return sqlpathProvider;
    }

    public static void setSqlpathProvider(ProviderForSQLPATH providerForSQLPATH) {
        sqlpathProvider = providerForSQLPATH;
    }
}

