/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.logging.Timer;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.jdbc.OracleConnection;

public class SQL
extends SQLCommandRunner {
    private String _format;

    public SQL(ISQLCommand iSQLCommand, BufferedOutputStream bufferedOutputStream) {
        super(iSQLCommand, bufferedOutputStream);
    }

    public void setFormat(String string) {
        this._format = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
        if (scriptRunnerContext != null) {
            scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
        }
        if (!this.lockConnection()) {
            return;
        }
        try {
            Timer timer = new Timer();
            timer.start();
            Debug.debug(this.cmd);
            if (this.cmd.getResultsType() == null) {
                this.execute(true);
            } else if (this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_DML)) {
                this.reportDML(this.cmd.getStmtId(), this.processDML());
            } else if (this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_QUERY)) {
                if (this.cmd.getRunnable()) {
                    this.executeQuery();
                }
            } else if (this.cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_COMMIT)) {
                String[] stringArray = this.cmd.getSql().trim().split("[ \t\n\r\f]+");
                int n = 0;
                if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("work")) {
                    n = 1;
                }
                boolean bl = false;
                if (stringArray.length > 1 + n && stringArray[1 + n].equalsIgnoreCase("force")) {
                    String string = this.cmd.getSql().trim();
                    if (stringArray.length > 2 + n && stringArray[2 + n].equalsIgnoreCase("CORRUPT_XID_ALL")) {
                        string = string.substring(0, string.toUpperCase().indexOf("CORRUPT_XID_ALL")) + "CORRUPT_XID_ALL";
                    } else if (stringArray.length > 2 + n && stringArray[2 + n].equalsIgnoreCase("CORRUPT_XID") || stringArray.length > 2 + n && stringArray[2 + n].startsWith("'")) {
                        int n2 = 0;
                        n2 = this.cmd.getSql().indexOf("'");
                        if (n2 == -1 || n2 == this.cmd.getSql().length() - 1) {
                            bl = true;
                        } else {
                            while (true) {
                                if ((n2 = this.cmd.getSql().indexOf("'", n2 + 1)) == -1) {
                                    bl = true;
                                    break;
                                }
                                if (n2 == this.cmd.getSql().length() - 1 || this.cmd.getSql().charAt(n2 + 1) != '\'') break;
                                ++n2;
                            }
                        }
                        if (!bl) {
                            string = this.cmd.getSql().substring(0, n2 + 1);
                        }
                        if (stringArray.length > 2 + n && stringArray[2 + n].startsWith("'")) {
                            String string2 = null;
                            if (!bl) {
                                if (++n2 < this.cmd.getSql().length() && this.cmd.getSql().substring(n2).trim().startsWith(",") && this.cmd.getSql().substring(n2).trim().length() > 1 && (string2 = this.cmd.getSql().substring(n2).trim().substring(1).trim().split("[^0-9]")[0]).equals("")) {
                                    bl = true;
                                }
                                if (!bl) {
                                    string = this.cmd.getSql().substring(0, n2);
                                    if (string2 != null) {
                                        string = string + "," + string2;
                                    }
                                }
                            }
                        }
                    } else {
                        bl = true;
                    }
                    if (!bl) {
                        Statement statement = null;
                        try {
                            statement = this.conn.createStatement();
                            statement.execute(string);
                        }
                        finally {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                } else {
                    this.conn.commit();
                }
                if (bl) {
                    this.report(ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", this.cmd.getSql()));
                } else if (this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report(ScriptRunnerDbArb.getString("COMMITCOMPLETE"));
                }
            } else if (this.cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_ROLLBACK_SQL)) {
                String[] stringArray = this.getStringToTokens(this.cmd.getSql());
                Savepoint savepoint = null;
                int n = 0;
                boolean bl = false;
                String[] stringArray2 = this.cmd.getSql().trim().split("[ \t\n\r\f]+");
                if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("work")) {
                    n = 1;
                }
                if (stringArray.length > 3 + n && stringArray[1 + n].toLowerCase().equals("to") && stringArray[2 + n].toLowerCase().equals("savepoint")) {
                    savepoint = scriptRunnerContext.getSavepoint(stringArray[3 + n]);
                    if (savepoint == null) {
                        throw new SQLException(ScriptRunnerDbArb.format("UNKNOWN_SAVEPOINT", stringArray[3 + n]));
                    }
                    this.conn.rollback(savepoint);
                } else if (stringArray.length > 2 + n && stringArray[1 + n].toLowerCase().equals("to")) {
                    savepoint = scriptRunnerContext.getSavepoint(stringArray[2 + n]);
                    if (savepoint == null) {
                        throw new SQLException(ScriptRunnerDbArb.format("UNKNOWN_SAVEPOINT", stringArray[2 + n]));
                    }
                    this.conn.rollback(savepoint);
                } else if (stringArray2.length > 2 + n && stringArray2[1 + n].equalsIgnoreCase("force")) {
                    int n3 = 0;
                    boolean bl2 = false;
                    n3 = this.cmd.getSql().indexOf("'");
                    if (n3 == -1 || n3 == this.cmd.getSql().length() - 1) {
                        bl2 = true;
                    } else {
                        while (true) {
                            if ((n3 = this.cmd.getSql().indexOf("'", n3 + 1)) == -1) {
                                bl2 = true;
                                break;
                            }
                            if (n3 == this.cmd.getSql().length() - 1 || this.cmd.getSql().charAt(n3 + 1) != '\'') break;
                            ++n3;
                        }
                    }
                    if (!bl2) {
                        Statement statement = null;
                        try {
                            statement = this.conn.createStatement();
                            statement.execute(this.cmd.getSql().substring(0, n3 + 1));
                        }
                        finally {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    bl = true;
                } else {
                    this.conn.rollback();
                }
                if (bl) {
                    this.report(ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", this.cmd.getSql()));
                } else if (this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report(ScriptRunnerDbArb.getString("ROLLED_BACK"));
                }
            } else if (this.cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_SAVEPOINT)) {
                String[] stringArray = this.getStringToTokens(this.cmd.getSql());
                if (stringArray.length > 1) {
                    Savepoint savepoint = this.conn.setSavepoint(stringArray[1]);
                    scriptRunnerContext.addSavepoint(savepoint);
                    if (this.getScriptRunnerContext().getFeedback() != -2) {
                        this.report(this.processMessage(this.cmd.getSql()));
                    }
                } else {
                    this.report(ScriptRunnerDbArb.getString("ORA03001"));
                }
            } else if (this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_THREE_WORD)) {
                this.execute(false);
                if (this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report(this.processMessage(this.cmd.getSql()));
                }
            } else if (this.conn != null && this.conn instanceof OracleConnection && this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_UNKNOWN)) {
                this.report(ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", this.cmd.getSql()));
            } else {
                this.execute(true);
            }
            timer.end();
            this.cmd.setTiming(timer.duration());
            if (this.getScriptRunnerContext().getTiming()) {
                this.report(ScriptRunnerDbArb.format("TIMINGELAPSED", timer.durationSQLPlus()));
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, scriptRunnerContext);
        }
        catch (IOException iOException) {
            if (scriptRunnerContext != null) {
                scriptRunnerContext.putProperty("sqldev.error", Boolean.TRUE);
            }
            if (scriptRunnerContext != null) {
                scriptRunnerContext.putProperty("script.runner.autocommit.errorFlag", Boolean.TRUE);
            }
            this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine()), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("IO_ERROR", iOException.getMessage()), this.getScriptRunnerContext()));
            if (scriptRunnerContext != null) {
                scriptRunnerContext.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine()), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("IO_ERROR", iOException.getMessage()), this.getScriptRunnerContext()));
            }
            this.doWhenever(false);
        }
        finally {
            this.unlockConnection();
        }
    }

    private void handleSQLException(SQLException sQLException, ScriptRunnerContext scriptRunnerContext) {
        String[] stringArray;
        ExceptionHandler.handleException((Exception)sQLException, this.connName, true, false);
        if (scriptRunnerContext != null) {
            scriptRunnerContext.putProperty("sqldev.error", Boolean.TRUE);
            scriptRunnerContext.putProperty("script.runner.autocommit.errorFlag", Boolean.TRUE);
            scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
        }
        boolean bl = true;
        SQLCommand.StmtSubType stmtSubType = this.cmd.getStmtId();
        int n = this.cmd.getStartLine();
        if ((SQLCommand.StmtResultType.G_R_QUERY.equals((Object)this.cmd.getResultsType()) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_INSERT) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_INSERT) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_UPDATE) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_DELETE) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_SELECT) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_MERGE) || stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_WITH)) && !this.cmd.getSQLOrig().toUpperCase().startsWith("DESC")) {
            int n2 = 0;
            if (!(sQLException instanceof SQLRecoverableException)) {
                n2 = DBUtil.getInstance(this.conn).getErrorOffset(this.cmd.getSql());
            }
            if (n2 >= 0) {
                stringArray = null;
                String string = this.cmd.getSql();
                if (string.length() >= n2) {
                    String string2 = "";
                    string2 = string.length() >= n2 + 1 ? string.substring(0, n2 + 1) : string.substring(0, n2);
                    stringArray = string2.split("\n");
                } else {
                    stringArray = new String[]{string};
                }
                int n3 = stringArray[stringArray.length - 1].length();
                int n4 = stringArray.length;
                Oerr oerr = new Oerr();
                String string3 = sQLException.getMessage();
                try {
                    string3 = string3 + oerr.oerr(string3);
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
                Object[] objectArray = new Object[]{new Integer(n + 1), this.cmd.getSql(), new Integer(n + 1 + (n4 - 1)), new Integer(n3), ScriptRunnerDbArb.format("SQL_ERROR", string3)};
                this.report(ScriptRunnerContext.lineColErr(ScriptRunnerDbArb.getString("LINE_COL_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_COL_FILE_COMMAND_ERR"), objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], scriptRunnerContext));
                if (scriptRunnerContext != null) {
                    scriptRunnerContext.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineColErr(ScriptRunnerDbArb.getString("LINE_COL_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_COL_FILE_COMMAND_ERR"), objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], scriptRunnerContext));
                }
                bl = false;
            }
        }
        if (bl) {
            String string = sQLException.getMessage();
            if (this.conn instanceof OracleConnection) {
                stringArray = new Oerr();
                try {
                    string = string + stringArray.oerr(string);
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
            }
            this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(n + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("SQL_ERROR", string), this.getScriptRunnerContext()));
            if (scriptRunnerContext != null) {
                scriptRunnerContext.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(n + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("SQL_ERROR", string), this.getScriptRunnerContext()));
            }
        }
        this.doWhenever(true);
    }

    public void reportDML(SQLCommand.StmtSubType stmtSubType, int n) throws IOException {
        String string = null;
        if (this.getScriptRunnerContext().getFeedback() != -2) {
            if (stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_INSERT)) {
                string = ScriptRunnerDbArb.getString("INSERTED");
            } else if (stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_UPDATE)) {
                string = ScriptRunnerDbArb.getString("UPDATED");
            } else if (stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_DELETE)) {
                string = ScriptRunnerDbArb.getString("DELETED");
            } else if (stmtSubType.equals((Object)SQLCommand.StmtSubType.G_S_MERGE)) {
                string = ScriptRunnerDbArb.getString("MERGED");
            }
            string = n == 1 ? MessageFormat.format(ScriptRunnerDbArb.getString("ACTION_RESULT1"), n, string) : MessageFormat.format(ScriptRunnerDbArb.getString("ACTION_RESULT"), n, string);
            this.report("\n" + string + "\n");
        }
    }

    public int processDML() throws SQLException {
        int n = 0;
        try {
            this.stmt = this.conn.prepareStatement(this.cmd.getSql());
            this.stmt.setEscapeProcessing(false);
            if (DBUtil.getBinds(this.cmd.getSql(), true) != null && DBUtil.getBinds(this.cmd.getSql(), true).size() > 0) {
                if (this.setBinds(this.stmt)) {
                    n = this.stmt.executeUpdate();
                }
            } else {
                n = this.stmt.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery() throws SQLException, IOException {
        ResultSet resultSet = null;
        boolean bl = true;
        try {
            this.stmt = this.conn.prepareStatement(this.cmd.getSql());
            this.stmt.setEscapeProcessing(false);
            if (DBUtil.getBinds(this.cmd.getSql(), true) != null && DBUtil.getBinds(this.cmd.getSql(), true).size() > 0 && !this.setBinds(this.stmt)) {
                bl = false;
            }
            if (bl) {
                resultSet = this.stmt.executeQuery();
                this.processResultSet(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void processResultSet(ResultSet resultSet) throws SQLException, IOException {
        String string = null;
        string = this.cmd.getSQLOrig().length() > 10 ? this.cmd.getSQLOrig().substring(0, 8).toLowerCase() : this.cmd.getSQLOrig().toLowerCase();
        boolean bl = true;
        if (string.startsWith("desc") || string.startsWith("xquery")) {
            bl = false;
        }
        this.report("");
        ResultSetFormatter resultSetFormatter = null;
        resultSetFormatter = bl ? (this.conn instanceof OracleConnection ? new SQLPLUSCmdFormatter(this.getScriptRunnerContext()) : new ResultSetFormatter(this.getScriptRunnerContext())) : (this.conn instanceof OracleConnection ? new SQLPLUSCmdFormatter() : new ResultSetFormatter());
        resultSetFormatter.setProgressUpdater(this.getScriptRunnerContext().getTaskProgressUpdater());
        int n = 0;
        Properties properties = this.getConnectionInfo();
        Integer n2 = null;
        try {
            if (this.getScriptRunnerContext().getProperty("script.runner.arraysize") != null) {
                n2 = Integer.valueOf((String)this.getScriptRunnerContext().getProperty("script.runner.arraysize"));
            } else if (properties != null) {
                String string2 = properties.getProperty("PreferfedFetchSize");
                n2 = Integer.valueOf(string2);
            } else {
                n2 = 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 != null) {
            resultSet.setFetchSize(n2);
        }
        if (this.conn instanceof OracleConnection && resultSetFormatter instanceof SQLPLUSCmdFormatter) {
            ((SQLPLUSCmdFormatter)resultSetFormatter).setSQL(this.cmd.getSql());
        }
        n = resultSetFormatter.formatResults(this.out, resultSet, this.cmd);
        int n3 = this.getScriptRunnerContext().getFeedback();
        if (n3 == -1 || n3 <= n && n3 != -2) {
            this.report(MessageFormat.format(ScriptRunnerDbArb.getString("SELECTED"), n));
        } else if (n3 != -2 && n3 != 0) {
            this.report("");
        }
    }

    public void execute(boolean bl) throws SQLException, IOException {
        block27: {
            try {
                String string;
                String string2;
                Object object;
                String[] stringArray;
                if (this.cmd.getSql().toLowerCase().startsWith("alter") && (stringArray = ScriptUtils.parseNameAndTypeUtil(this.cmd.getSql())) != null) {
                    object = stringArray[0];
                    string2 = stringArray[1];
                    string = stringArray[2];
                    this.getScriptRunnerContext().putProperty("sqldev.last.err.type", string == null ? "UNKNOWN" : string.toUpperCase());
                    this.getScriptRunnerContext().putProperty("sqldev.last.err.name", string2);
                }
                this.st = this.conn.createStatement();
                this.st.setEscapeProcessing(false);
                this.st.execute(this.cmd.getSql().trim());
                boolean bl2 = this.getConn() instanceof OracleConnection;
                if (!bl2 && this.st.getResultSet() != null) {
                    object = this.st.getResultSet();
                    this.processResultSet((ResultSet)object);
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block27;
                }
                if (this.cmd.getSql().toLowerCase().indexOf(" set nls") > 0) {
                    NLSUtils.populateNLS(this.conn);
                }
                if ((object = this.st.getWarnings()) == null && bl) {
                    if (this.getScriptRunnerContext().getFeedback() != -2) {
                        this.report(this.processMessage(this.cmd.getSql()));
                    }
                    break block27;
                }
                if (object == null) break block27;
                if (bl2) {
                    string2 = ScriptRunnerDbArb.format("SQL_COMMAND", this.processMessage(this.cmd.getSql(), false));
                    string = ((Throwable)object).getMessage();
                    if (this.conn instanceof OracleConnection) {
                        Oerr oerr = new Oerr();
                        try {
                            string = string + oerr.oerr(string);
                        }
                        catch (OerrException oerrException) {
                            // empty catch block
                        }
                    }
                    boolean bl3 = false;
                    boolean bl4 = false;
                    while (object != null) {
                        if (!bl2 || ((SQLException)object).getErrorCode() != 17110) {
                            string2 = string2 + "\n" + ScriptRunnerDbArb.format("FAILED", string);
                            bl3 = true;
                        } else if (!bl2 || ((SQLException)object).getErrorCode() != 17110 || this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_ALTER)) {
                            string2 = string2 + "\n" + string;
                            bl4 = true;
                        }
                        object = ((SQLWarning)object).getNextWarning();
                    }
                    if (bl3) {
                        this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), string2, this.getScriptRunnerContext()));
                    } else if (bl4) {
                        this.report(string);
                    } else if (bl) {
                        this.report(this.processMessage(this.cmd.getSql()));
                    }
                    break block27;
                }
                string2 = ((Throwable)object).getMessage();
                this.report(string2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (this.st != null) {
                    this.st.close();
                }
            }
        }
    }

    public void reportObjectAction() {
    }

    private String processMessage(String string) {
        return this.processMessage(string, true);
    }

    public String processMessage(String string, boolean bl) {
        string = ScriptUtils.stripFirstN(string, 1000, this.cmd.getProperty("STRIPPED_CONTINUATION") == null, false);
        string = string.replaceAll("[oO][rR]\\s+[rR][eE][pP][lL][Aa][Cc][Ee]", " ");
        string = string.replaceAll("\\s+[nN][oO][nN][eE][dD][iI][tT][iI][oO][nN][aA][bB][lL][eE]\\s", " ");
        string = string.replaceAll("\\s+[eE][dD][iI][tT][iI][oO][nN][aA][bB][lL][eE]\\s", " ");
        String[] stringArray = this.getStringToTokens(string);
        String string2 = "";
        if (stringArray == null || stringArray.length < 3) {
            return string;
        }
        stringArray[0] = this.capitalize(stringArray[0].toLowerCase());
        if (stringArray[0].toLowerCase().equals("grant") || stringArray[0].toLowerCase().equals("revoke") || stringArray[0].toLowerCase().equals("audit") || stringArray[0].toLowerCase().equals("lock") || stringArray[0].toLowerCase().equals("noaudit") || stringArray[0].toLowerCase().equals("call") || stringArray[0].toLowerCase().equals("flashback")) {
            string2 = stringArray[0];
        } else if (stringArray[0].toLowerCase().equals("rename")) {
            string2 = "";
        } else if (stringArray[0].toLowerCase().equals("savepoint")) {
            string2 = stringArray[0].toLowerCase() + " " + SQL.getQuotedName(stringArray[1], string);
        } else if (stringArray[1].toLowerCase().equals("on")) {
            string2 = stringArray[0] + " " + stringArray[1].toLowerCase() + " " + stringArray[2].toLowerCase() + " " + stringArray[3].toLowerCase() + " " + SQL.getQuotedName(stringArray[5], string);
        } else if (stringArray[0].toLowerCase().equals("purge") || stringArray[1].toLowerCase().equals("session")) {
            string2 = stringArray[1].toLowerCase();
        } else if (stringArray[1].toLowerCase().equals("materialized") || stringArray[1].toLowerCase().equals("bitmap") || stringArray[1].toLowerCase().equals("unique") || stringArray[1].toLowerCase().equals("public") || stringArray[1].toLowerCase().equals("database") || stringArray[1].toLowerCase().equals("force") || stringArray[1].toLowerCase().equals("shared") || stringArray[2].toLowerCase().equals("body") || stringArray[1].toLowerCase().equals("global")) {
            if (stringArray.length < 4) {
                if (stringArray.length == 3 && stringArray[0].toLowerCase().equals("alter") && stringArray[1].toLowerCase().equals("database") && (stringArray[2].toLowerCase().equals("mount") || stringArray[2].toLowerCase().equals("open"))) {
                    return "\n" + this.capitalize(ScriptRunnerDbArb.format("ALTERED", "Database")) + "\n";
                }
                return string;
            }
            if (stringArray[3].toLowerCase().equals("log") || stringArray[3].toLowerCase().equals("temporary")) {
                string2 = stringArray[1].toLowerCase() + " " + stringArray[2].toLowerCase() + " " + stringArray[3].toLowerCase() + " " + SQL.getQuotedName(stringArray[5], string);
            }
            string2 = stringArray[3].toLowerCase().equals("link") ? stringArray[1].toLowerCase() + " " + stringArray[2].toLowerCase() + " " + stringArray[3].toLowerCase() + " " + SQL.getQuotedName(stringArray[4], string) : (stringArray[1].toLowerCase().equals("force") ? stringArray[2].toLowerCase() + " " + SQL.getQuotedName(stringArray[3], string) : stringArray[1].toLowerCase() + " " + stringArray[2].toLowerCase() + " " + SQL.getQuotedName(stringArray[3], string));
        } else {
            string2 = stringArray[1].toLowerCase() + " " + SQL.getQuotedName(stringArray[2], string);
        }
        String string3 = this.getVerb(stringArray, bl);
        string2 = string3 != null ? MessageFormat.format(this.getVerb(stringArray, bl), string2) : string2;
        string2 = "\n" + this.capitalize(string2) + "\n";
        return string2;
    }

    private String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static String getQuotedName(String string, String string2) {
        String string3 = SQL.getQuotedNameComma(string, string2);
        if (string3.endsWith(",")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    private static String getQuotedNameComma(String string, String string2) {
        if (string.contains("\"") || string.contains("[") || string.contains("`")) {
            String string3;
            boolean bl = string.contains("[");
            String string4 = !bl ? "\"" : "[";
            String string5 = string3 = !bl ? "\"" : "]";
            if (string.contains("`")) {
                string4 = "`";
                string3 = "`";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[]\"`");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            if (n > 3 && stringArray[2].trim().equals(".")) {
                return string4 + stringArray[1] + string3 + "." + string4 + stringArray[3] + string3;
            }
            if (n > 2 && stringArray[2].trim().startsWith(".") && stringArray[2].trim().length() > 1) {
                return string4 + stringArray[1] + string3 + "." + stringArray[2].trim().substring(1).trim().split("[ \r\t\n]")[0].toUpperCase(Locale.US);
            }
            if (n > 1 && stringArray[0].trim().endsWith(".") && stringArray[0].trim().indexOf(" ") != -1) {
                String string6 = stringArray[0].trim();
                string6 = string6.substring(0, string6.length() - 1).trim();
                String[] stringArray2 = string6.split("[ \r\t\n]");
                String string7 = stringArray2[stringArray2.length - 1];
                return string7.toUpperCase(Locale.US) + "." + string4 + stringArray[1] + string3;
            }
            return string4 + stringArray[1] + string3;
        }
        String string8 = string;
        if (string8 != null) {
            string8 = string.toUpperCase(Locale.US);
        }
        return string8;
    }

    private String[] getStringToTokens(String string) {
        int n;
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f(");
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (bl) {
                int n4 = n3;
                stringArray2[n4] = stringArray2[n4] + " " + (String)stringArray;
                bl = false;
            } else {
                stringArray2[n3] = stringArray;
            }
            n = 0;
            while ((n = stringArray.indexOf("'", n)) != -1) {
                ++n2;
                if (++n != stringArray.length()) continue;
            }
            if (n2 % 2 == 1 && stringTokenizer.hasMoreTokens()) {
                bl = true;
                continue;
            }
            ++n3;
        }
        if (bl) {
            ++n3;
        }
        stringArray = new String[n3];
        for (n = 0; n < n3; ++n) {
            stringArray[n] = stringArray2[n];
        }
        return stringArray;
    }

    private String getVerb(String[] stringArray, boolean bl) {
        if (bl) {
            if (stringArray[0].toLowerCase().equals("create") || stringArray[0].toLowerCase().equals("savepoint")) {
                String string = stringArray[1].toLowerCase();
                if (string.equals("procedure") || string.equals("function") || string.equals("package") || string.equals("trigger")) {
                    return ScriptRunnerDbArb.get("COMPILED");
                }
                return ScriptRunnerDbArb.get("CREATED");
            }
            if (stringArray[0].toLowerCase().equals("drop")) {
                return ScriptRunnerDbArb.get("DROPPED");
            }
            if (stringArray[0].toLowerCase().equals("alter")) {
                return ScriptRunnerDbArb.get("ALTERED");
            }
            if (stringArray[0].toLowerCase().equals("truncate")) {
                return ScriptRunnerDbArb.get("TRUNCATED");
            }
            if (stringArray[0].toLowerCase().equals("analyze")) {
                return ScriptRunnerDbArb.get("ANALYZED");
            }
            if (stringArray[0].toLowerCase().equals("purge")) {
                return ScriptRunnerDbArb.get("PURGED");
            }
            if (stringArray[0].toLowerCase().equals("call")) {
                return ScriptRunnerDbArb.get("COMPLETED");
            }
            if (stringArray[0].toLowerCase().equals("rename")) {
                return ScriptRunnerDbArb.get("RENAMED");
            }
            return ScriptRunnerDbArb.get("SUCCEEDED");
        }
        return null;
    }
}

