/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;

public class FallbackParserProvider
implements Iterator<ISQLCommand> {
    private ScriptParser m_parser = null;
    private ISQLCommand m_nextCmd = null;
    private Logger m_logger = Logger.getLogger(this.getClass().getName());

    public FallbackParserProvider(Reader reader) {
        this.m_parser = new ScriptParser(reader);
    }

    @Override
    public boolean hasNext() {
        ISQLCommand iSQLCommand = null;
        try {
            if (this.m_nextCmd != null) {
                return true;
            }
            this.m_nextCmd = iSQLCommand = this.getNextValidCmd();
        }
        catch (Exception exception) {
            return false;
        }
        return iSQLCommand != null;
    }

    private ISQLCommand getNextValidCmd() {
        ISQLCommand iSQLCommand = null;
        try {
            iSQLCommand = this.m_parser.next();
        }
        catch (IOException iOException) {
            this.m_logger.log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
        }
        while (iSQLCommand != null && !this.isValidCommand(iSQLCommand)) {
            try {
                iSQLCommand = this.m_parser.next();
            }
            catch (IOException iOException) {
                this.m_logger.log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        if (iSQLCommand != null && this.isValidCommand(iSQLCommand)) {
            return iSQLCommand;
        }
        return null;
    }

    private boolean isValidCommand(ISQLCommand iSQLCommand) {
        return true;
    }

    @Override
    public ISQLCommand next() {
        ISQLCommand iSQLCommand = null;
        try {
            if (this.m_nextCmd != null) {
                iSQLCommand = this.m_nextCmd;
                this.m_nextCmd = null;
            } else {
                iSQLCommand = this.getNextValidCmd();
            }
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return iSQLCommand;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

