/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.newscriptrunner.commands.SetPause;
import oracle.dbtools.raptor.utils.AnsiColorListPrinter;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.sql.NUMBER;

public class ANSIConsoleFormatter
extends ResultsFormatter {
    public static final String TYPE = "ansiconsole";
    private List<List<?>> data = new ArrayList();
    private ArrayList<String> lastRow = null;
    private ArrayList<String> currRow = null;
    private ArrayList<String> colNames;
    boolean hasData = false;

    public ANSIConsoleFormatter() {
        super(TYPE, null, ".log");
    }

    @Override
    public void start() throws IOException {
        this.data.clear();
        this.lastRow = null;
        this.hasData = false;
        this.colNames = new ArrayList();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.colNames.add(this.getColumnName(i));
        }
    }

    @Override
    public void startRow() throws IOException {
        this.lastRow = this.currRow;
        this.currRow = new ArrayList();
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        this.hasData = true;
        String string = null;
        if (object instanceof NUMBER) {
            try {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
                decimalFormat.applyPattern("###,###.###########################################################################");
                string = decimalFormat.format(((NUMBER)object).bigDecimalValue());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (string == null) {
                string = NLSUtils.format(this.getConnection(), object);
            }
            this.currRow.add(string);
        } else if (object instanceof Clob) {
            Integer n3 = null;
            if (this.getScriptContext() != null) {
                n3 = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
            }
            string = n3 != null ? DataTypesUtil.stringValue(object, this.getConnection(), n3) : DataTypesUtil.stringValue(object, this.getConnection());
            this.currRow.add(string);
        } else {
            this.currRow.add(NLSUtils.format(this.getConnection(), object));
        }
    }

    @Override
    public void endRow() throws IOException {
        this.data.add(this.data.size(), this.currRow);
        int n = this.getPageSize();
        if (this.data.size() >= n) {
            this.getOutputStream().flush();
            SetPause.directWriteOut(this.getScriptContext(), new OutputStreamWriter(this.getOutputStream()));
            this.printDataList(n, "");
        }
    }

    @Override
    public void end() throws IOException {
        int n = this.getPageSize();
        if (this.data != null && !this.data.isEmpty()) {
            this.getOutputStream().flush();
            SetPause.directWriteOut(this.getScriptContext(), new OutputStreamWriter(this.getOutputStream()));
        }
        this.printDataList(n, "");
        ArrayList<String> arrayList = null;
        arrayList = this.currRow != null && !this.currRow.isEmpty() ? this.currRow : this.lastRow;
        if (this.getScriptContext() != null && this.getScriptContext().getColumnMap() != null && !this.getScriptContext().getColumnMap().isEmpty() && this.colNames != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("");
            for (String object : this.colNames) {
                arrayList2.add(object);
            }
            if (!this.hasData) {
                this.getScriptContext().updateColumn(arrayList2.toArray(new String[arrayList2.size()]), null);
            } else if (arrayList != null && this.getScriptContext() != null && this.colNames.size() == arrayList.size()) {
                ArrayList arrayList3 = new ArrayList();
                arrayList3.add("");
                for (String string : arrayList) {
                    arrayList3.add(string);
                }
                this.getScriptContext().updateColumn(arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]));
            }
        }
    }

    private void printDataList(int n, String string) throws IOException {
        this.data.add(0, this.colNames);
        AnsiColorListPrinter.print(this.getOutputStream(), this.getConnection(), this.data, n, string);
        this.data.clear();
    }

    private int getPageSize() {
        int n = 0;
        try {
            n = (Integer)this.getScriptContext().getProperty("script.runner.setpagesize");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public boolean isInternalOnly() {
        return true;
    }
}

