/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.xml.DataValueXMLMarshallHandler;
import oracle.dbtools.raptor.datatypes.xml.DataValueXMLUnmarshallHandler;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.sql.CLOB;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XMLUtil {
    public static final String XML_IS_NULL_ATTR_TAG = "is_null";
    public static final String XML_NULL = "";
    public static final String XML_CDATA = "CDATA";
    public static final String XML_NAME_ATT = "name";
    public static final String XML_DATAVALUE_ELEMENT = "DataValue";
    public static final String XML_ENCODING = "UTF-8";

    public static boolean isMarkedNull(String string) {
        Boolean bl;
        try {
            bl = string != null && string.length() > 0 ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
        }
        catch (Exception exception) {
            bl = null;
        }
        return bl == null ? false : bl;
    }

    public static void setAttribute(AttributesImpl attributesImpl, String string, String string2) {
        attributesImpl.addAttribute(XML_NULL, XML_NULL, string, XML_CDATA, string2);
    }

    public static String getAttribute(Attributes attributes, String string) {
        return attributes.getValue(string);
    }

    public static void markNull(AttributesImpl attributesImpl) {
        XMLUtil.setAttribute(attributesImpl, XML_IS_NULL_ATTR_TAG, Boolean.TRUE.toString());
    }

    public static void markNull(AttributesImpl attributesImpl, boolean bl) {
        XMLUtil.setAttribute(attributesImpl, XML_IS_NULL_ATTR_TAG, Boolean.valueOf(bl).toString());
    }

    public static void markNotNull(AttributesImpl attributesImpl) {
        XMLUtil.setAttribute(attributesImpl, XML_IS_NULL_ATTR_TAG, Boolean.FALSE.toString());
    }

    public static boolean isMarkedNull(Attributes attributes) {
        String string = XMLUtil.getAttribute(attributes, XML_IS_NULL_ATTR_TAG);
        return XMLUtil.isMarkedNull(string);
    }

    public static void setName(AttributesImpl attributesImpl, String string) {
        if (string != null) {
            XMLUtil.setAttribute(attributesImpl, XML_NAME_ATT, string);
        }
    }

    public static String getName(Attributes attributes) {
        return XMLUtil.getAttribute(attributes, XML_NAME_ATT);
    }

    public static void startDataValueElement(TransformerHandler transformerHandler, AttributesImpl attributesImpl) throws SAXException {
        transformerHandler.startElement(XML_NULL, XML_NULL, XML_DATAVALUE_ELEMENT, attributesImpl);
    }

    public static void endDataValueElement(TransformerHandler transformerHandler) throws SAXException {
        transformerHandler.endElement(XML_NULL, XML_NULL, XML_DATAVALUE_ELEMENT);
    }

    public static void marshallDataValue(TransformerHandler transformerHandler, DataValue dataValue) throws TransformerConfigurationException, SAXException {
        DataValueXMLMarshallHandler dataValueXMLMarshallHandler = new DataValueXMLMarshallHandler(transformerHandler);
        dataValue.marshallToXml(dataValueXMLMarshallHandler);
    }

    public static void marshallDataValue(TransformerHandler transformerHandler, DataValue dataValue, String string) {
        DataValueXMLMarshallHandler dataValueXMLMarshallHandler = new DataValueXMLMarshallHandler(transformerHandler);
        dataValue.marshallToXml(dataValueXMLMarshallHandler, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void marshallDataValue(OutputStream outputStream, DataValue dataValue, String string, boolean bl) throws TransformerConfigurationException, SAXException {
        try {
            StreamResult streamResult = new StreamResult(outputStream);
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("encoding", XML_ENCODING);
            transformer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(streamResult);
            DataValueXMLMarshallHandler dataValueXMLMarshallHandler = new DataValueXMLMarshallHandler(transformerHandler);
            transformerHandler.startDocument();
            try {
                if (bl) {
                    dataValue.marshallToXml(dataValueXMLMarshallHandler, string);
                } else {
                    dataValue.marshallToXml(dataValueXMLMarshallHandler);
                }
            }
            finally {
                try {
                    transformerHandler.endDocument();
                }
                catch (Exception exception) {
                    Logger.getLogger(XMLUtil.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
                }
            }
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                Logger.getLogger(XMLUtil.class.getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    public static void marshallDataValue(OutputStream outputStream, DataValue dataValue, String string) throws TransformerConfigurationException, SAXException {
        XMLUtil.marshallDataValue(outputStream, dataValue, string, true);
    }

    public static void marshallDataValue(OutputStream outputStream, DataValue dataValue) throws TransformerConfigurationException, SAXException {
        XMLUtil.marshallDataValue(outputStream, dataValue, null, false);
    }

    public static Clob marshallDataValue(Connection connection, DataValue dataValue, String string) throws TransformerConfigurationException, SAXException, SQLException {
        Clob clob = XMLUtil.getClobLocator(connection);
        XMLUtil.marshallDataValue(clob, dataValue, string);
        return clob;
    }

    public static Clob marshallDataValue(Connection connection, DataValue dataValue) throws TransformerConfigurationException, SAXException, SQLException {
        Clob clob = XMLUtil.getClobLocator(connection);
        XMLUtil.marshallDataValue(clob, dataValue);
        return clob;
    }

    public static void marshallDataValue(Clob clob, DataValue dataValue, String string) throws TransformerConfigurationException, SAXException, SQLException {
        OutputStream outputStream = clob.setAsciiStream(1L);
        XMLUtil.marshallDataValue(outputStream, dataValue, string);
    }

    public static void marshallDataValue(Clob clob, DataValue dataValue) throws TransformerConfigurationException, SAXException, SQLException {
        OutputStream outputStream = clob.setAsciiStream(1L);
        XMLUtil.marshallDataValue(outputStream, dataValue);
    }

    private static DataValue unmarshallDataValue(InputStream inputStream, DataType dataType, String string, boolean bl) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        DataValueXMLUnmarshallHandler dataValueXMLUnmarshallHandler = bl ? new DataValueXMLUnmarshallHandler(dataType, string) : new DataValueXMLUnmarshallHandler(dataType);
        xMLReader.setContentHandler(dataValueXMLUnmarshallHandler);
        xMLReader.setErrorHandler(dataValueXMLUnmarshallHandler);
        xMLReader.parse(new InputSource(inputStream));
        return dataValueXMLUnmarshallHandler.getDataValue();
    }

    public static DataValue unmarshallDataValue(InputStream inputStream, DataType dataType, String string) throws SAXException, IOException {
        return XMLUtil.unmarshallDataValue(inputStream, dataType, string, true);
    }

    public static DataValue unmarshallDataValue(InputStream inputStream, DataType dataType) throws SAXException, IOException {
        return XMLUtil.unmarshallDataValue(inputStream, dataType, null, false);
    }

    public static DataValue unmarshallDataValue(Clob clob, DataType dataType, String string) throws SAXException, IOException, SQLException {
        return XMLUtil.unmarshallDataValue(clob.getAsciiStream(), dataType, string, true);
    }

    public static DataValue unmarshallDataValue(Clob clob, DataType dataType) throws SAXException, IOException, SQLException {
        return XMLUtil.unmarshallDataValue(clob.getAsciiStream(), dataType, null, false);
    }

    private static Clob getClobLocator(Connection connection) throws SQLException {
        return CLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
    }

    public static String getQuery(Connection connection, String string) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("oracle/dbtools/raptor/datatypes/xml/DataTypeSql.xml");
        Query query = queryXMLSupport.getQuery(string, connection);
        return query.getSql();
    }
}

