/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallWriter;
import oracle.dbtools.raptor.datatypes.objects.LargeDatum;
import oracle.dbtools.raptor.datatypes.util.CappedFilterWriter;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.util.encoding.BASE64Encoding;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingFactory;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.HEXEncoding;
import oracle.dbtools.util.encoding.MimeType;
import org.xml.sax.SAXException;

public abstract class LargeBinary
extends LargeDatum {
    protected static final byte FILL_BYTE = 0;

    public LargeBinary() {
    }

    protected LargeBinary(Object object) {
        super(object);
    }

    protected LargeBinary(LargeBinary largeBinary) {
        super(largeBinary);
    }

    public OutputStream exportTo(OutputStream outputStream) throws IOException, SQLException {
        LargeBinary.copyBytes(this.getInputStream(), outputStream);
        outputStream.flush();
        return outputStream;
    }

    public Blob exportTo(Blob blob) throws IOException, SQLException {
        OutputStream outputStream = blob.setBinaryStream(1L);
        this.exportTo(outputStream);
        outputStream.close();
        return blob;
    }

    public File exportTo(File file) throws IOException, SQLException {
        this.exportToObject(file);
        return file;
    }

    public Object exportTo(Object object) throws IOException, SQLException {
        return this.exportToObject(object);
    }

    protected Object exportToObject(Object object) throws IOException, SQLException {
        if (object instanceof OutputStream) {
            return this.exportTo((OutputStream)object);
        }
        if (object instanceof Blob) {
            return this.exportTo((Blob)object);
        }
        if (object instanceof File) {
            return this.exportTo(new FileWriter((File)object));
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object object) {
        boolean bl = this == object;
        try {
            if (!bl && object instanceof LargeBinary) {
                LargeBinary largeBinary = (LargeBinary)object;
                bl = this.getLength() == largeBinary.getLength() && (this.getValue() == largeBinary.getValue() || this.getValue() == null && largeBinary.getValue() == null || this.getValue() != null && largeBinary.getValue() != null && LargeBinary.compareData(this.getInputStream(), largeBinary.getInputStream()));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return bl;
    }

    public abstract InputStream getInputStream() throws IOException, SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StringValue customStringValue(StringType stringType, int n) {
        switch (stringType) {
            case DEFAULT: {
                StringValue stringValue = null;
                try {
                    HEXEncoding hEXEncoding = (HEXEncoding)EncodingFactory.getEncoder(EncodingType.ENCODING_HEX, MimeType.MIME_TEXT);
                    StringWriter stringWriter = new StringWriter();
                    BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                    CappedFilterWriter cappedFilterWriter = new CappedFilterWriter(bufferedWriter, n);
                    InputStream inputStream = this.getInputStream();
                    try {
                        hEXEncoding.encode(inputStream, cappedFilterWriter);
                    }
                    finally {
                        try {
                            ((Writer)cappedFilterWriter).flush();
                            stringValue = new StringValue(stringWriter.toString(), hEXEncoding.getEncodeLength(this.getLength()));
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    if (stringValue == null || n < 0 || stringValue.toString().length() < n) {
                        throw new DataTypeSQLException(sQLException);
                    }
                }
                catch (IOException iOException) {
                    if (stringValue == null || n < 0 || stringValue.toString().length() < n) {
                        throw new DataTypeIOException(iOException);
                    }
                }
                catch (EncodingException encodingException) {
                    throw new DataTypeEncodingException(encodingException);
                }
                return stringValue;
            }
        }
        return super.customStringValue(stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        switch (valueType) {
            case TARGET: {
                return this.exportTo(object);
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshallToXml(DataType dataType, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        try {
            BASE64Encoding bASE64Encoding = (BASE64Encoding)EncodingFactory.getEncoder(EncodingType.ENCODING_BASE64, MimeType.MIME_TEXT);
            BufferedWriter bufferedWriter = new BufferedWriter(new DataValueMarshallWriter(dataType, dataValueMarshallHandler, string), 2400);
            InputStream inputStream = this.getInputStream();
            try {
                bASE64Encoding.encode(inputStream, bufferedWriter);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                }
            }
            bufferedWriter.flush();
        }
        catch (SQLException sQLException) {
            throw new DataTypeSQLException(sQLException);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
        catch (EncodingException encodingException) {
            throw new DataTypeEncodingException(encodingException);
        }
    }

    public static void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        LargeBinary.copyBytes(inputStream, outputStream, 2400);
    }

    public static void copyBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        while (n2 != -1) {
            outputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
    }

    public static boolean compareData(InputStream inputStream, InputStream inputStream2) throws IOException {
        byte[] byArray = new byte[2400];
        byte[] byArray2 = new byte[2400];
        Arrays.fill(byArray, (byte)0);
        Arrays.fill(byArray2, (byte)0);
        int n = inputStream.read(byArray);
        int n2 = inputStream2.read(byArray2);
        while (n != -1 && n2 != -1 && n == n2) {
            if (!Arrays.equals(byArray, byArray2)) {
                return false;
            }
            n = inputStream.read(byArray);
            n2 = inputStream2.read(byArray2);
        }
        return n == n2;
    }

    public abstract class LargeBinaryBuilder
    extends LargeDatum.LargeDatumBuilder {
        private char[] charBank;
        private int banked;
        protected final Decoder decoder;
        protected final int decoderBlockSize;
        protected OutputStream ostream;
        protected OutputStream switchableStream;

        protected LargeBinaryBuilder(EncodingType encodingType, int n) {
            super(LargeBinary.this, n);
            this.decoder = EncodingFactory.getDecoder(encodingType, MimeType.MIME_TEXT);
            this.decoderBlockSize = this.decoder.getDecodeBlocksize();
            this.charBank = new char[this.decoderBlockSize];
            this.banked = 0;
            this.ostream = new ByteArrayOutputStream();
            this.switchableStream = new FilterOutputStream(this.ostream){

                @Override
                public void write(int n) throws IOException {
                    LargeBinaryBuilder.this.checkForCutOver(1);
                    this.out = LargeBinaryBuilder.this.ostream;
                    super.write(n);
                    ++LargeBinaryBuilder.this.length;
                }

                @Override
                public void flush() throws IOException {
                    super.flush();
                    LargeBinaryBuilder.this.checkForCutOver(0);
                    this.out = LargeBinaryBuilder.this.ostream;
                    super.flush();
                }

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
        }

        public LargeBinaryBuilder write(char[] cArray, int n, int n2) throws IOException, EncodingException {
            int n3;
            int n4 = n + n2;
            int n5 = n;
            int n6 = n2;
            if (this.banked > 0) {
                if (this.banked < this.decoderBlockSize) {
                    while (this.banked < this.decoderBlockSize && n5 < n4) {
                        this.charBank[this.banked++] = cArray[n5++];
                        --n6;
                    }
                }
                if (this.banked >= this.decoderBlockSize) {
                    this.writeBank();
                } else {
                    return this;
                }
            }
            if ((n6 -= (n3 = n6 % this.decoderBlockSize)) > 0) {
                this.write(new CharArrayReader(cArray, n5, n6));
            }
            if (n3 > 0) {
                int n7 = n5 + n6;
                for (int i = 0; i < n3; ++i) {
                    this.charBank[this.banked++] = cArray[n7 + i];
                }
            }
            return this;
        }

        public LargeBinaryBuilder write(Reader reader) throws IOException, EncodingException {
            this.decoder.decodeStream(reader, this.switchableStream);
            return this;
        }

        public LargeBinaryBuilder write(byte[] byArray, int n, int n2) throws IOException {
            this.switchableStream.write(byArray, n, n2);
            return this;
        }

        public LargeBinaryBuilder write(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[2400];
            int n = inputStream.read(byArray);
            while (n != -1) {
                this.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            return this;
        }

        private void writeBank() throws IOException, EncodingException {
            if (this.banked > 0) {
                this.write(new CharArrayReader(this.charBank, 0, this.banked));
                this.banked = 0;
            }
        }
    }
}

