/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.Serializable;
import java.util.Map;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;

public class DocURL
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String pageParagraph;
    private final Manual man;

    public DocURL(Manual manual, String string) {
        this.pageParagraph = string;
        this.man = manual;
    }

    public String getPublicURL() {
        return this.man.getBasePublicURL() + this.pageParagraph;
    }

    public String getPrivateURL() {
        return this.man.getBasePrivateURL() + this.pageParagraph;
    }

    public String toString() {
        return this.getPublicURL();
    }

    public static void main(String[] stringArray) {
        Map<Integer, DocURL> map = HarvestDoc.getRailroads();
        for (Integer n : map.keySet()) {
            System.out.println(SqlEarley.getInstance().allSymbols[n] + " -> " + map.get(n).getPublicURL());
        }
    }

    public static enum Manual implements Serializable
    {
        SQL,
        PLSQL;


        public String getBasePrivateURL() {
            switch (this) {
                case SQL: {
                    return "http://st-doc.us.oracle.com/database/121/SQLRF/";
                }
                case PLSQL: {
                    return "http://st-doc.us.oracle.com/12/121/appdev.121/e17622/";
                }
            }
            throw new AssertionError((Object)"VT:impossible");
        }

        public String getBasePublicURL() {
            switch (this) {
                case SQL: {
                    return "http://docs.oracle.com/database/121/SQLRF/";
                }
                case PLSQL: {
                    return "http://docs.oracle.com/database/121/LNPLS/";
                }
            }
            throw new AssertionError((Object)"VT:impossible");
        }
    }
}

