/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class UnitTest {
    static int testNo = 0;
    private static TreeSet<Integer> failedTests = new TreeSet();
    private static int output = -1;
    private static int tree = -1;
    private static int node = -1;
    private static int range = -1;
    private static int digits = -1;
    private static int label = -1;
    private static int assertion = -1;
    private static int query = -1;
    private static int atest = -1;
    private static int sql_fragment = -1;
    private static int comment = -1;
    static Earley testParser = null;
    static Random random;
    protected static boolean introduceRandomError;
    static Parseable parser;

    public static void main(String[] stringArray) throws Exception {
        String string = "unit.test";
        UnitTest.test(string);
    }

    public static void test(String string) throws Exception {
        String string2 = Service.readFile(UnitTest.class, string);
        List<LexerToken> list = LexerToken.parse(string2, "`");
        Visual visual = null;
        Matrix matrix = new Matrix(testParser);
        testParser.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax(string2, new String[]{"atest"}, list, testParser, matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string3 : syntaxError.getSuggestions()) {
                System.out.print(string3 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = testParser.forest(list, matrix);
        UnitTest.atest(parseNode, list, string2);
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** FAILED " + failedTests.size() + " tests *** ");
        }
        int n = -1;
        for (int n2 : failedTests) {
            if (++n < 10) {
                System.out.print(n2 + ",");
                continue;
            }
            if (n == 10) {
                System.out.print(" ... ");
                continue;
            }
            if (failedTests.size() - 10 >= n) continue;
            System.out.print("," + n2);
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String string = Service.readFile(UnitTest.class, "unitTest.grammar");
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar(parseNode, list, treeSet);
        return treeSet;
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            UnitTest.assertion(parseNode, list, string);
            return;
        }
        if (parseNode.contains(output)) {
            Iterator<ParseNode> iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = iterator.next();
                ParseNode parseNode3 = UnitTest.query(parseNode2, list, string);
                System.out.println("TEST#" + testNo + ":  ---> ");
                parseNode3.printTree();
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            UnitTest.comment(parseNode, list, string);
        }
        for (ParseNode parseNode4 : parseNode.children()) {
            UnitTest.atest(parseNode4, list, string);
        }
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end - 1);
        testNo = Integer.parseInt(string2);
        return null;
    }

    private static ParseNode query(ParseNode parseNode, List<LexerToken> list, String string) {
        return UnitTest.parse(UnitTest.sql_fragment(parseNode, list, string));
    }

    private static ParseNode parse(String string) {
        int n;
        List<LexerToken> list = LexerToken.parse(string);
        if (introduceRandomError && 10 < (n = random.nextInt(list.size() - 1))) {
            LexerToken lexerToken = list.get(n);
            lexerToken.type = Token.OPERATION;
            lexerToken.content = "';'";
        }
        return parser.parse(list);
    }

    private static String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
        if (string2.charAt(0) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.charAt(0) == '`') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return " " + string2 + " ";
    }

    private static ParseNode assertion(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        ParseNode parseNode2 = null;
        ParseNode parseNode3 = null;
        for (ParseNode parseNode4 : parseNode.children()) {
            if (parseNode4.contains(query)) {
                parseNode2 = UnitTest.query(parseNode4, list, string);
                continue;
            }
            if (parseNode4.from + 1 == parseNode4.to && ("-".equals(parseNode4.content(list)) || ">".equals(parseNode4.content(list)) || ";".equals(parseNode4.content(list))) || !parseNode4.contains(tree)) continue;
            parseNode3 = UnitTest.tree(UnitTest.nodeList(parseNode4, list, string));
        }
        boolean bl = UnitTest.isSubtree(parseNode3, parseNode2);
        if (!bl) {
            failedTests.add(testNo);
            System.out.println("TEST#" + testNo + ":  broken");
        }
        return null;
    }

    private static ParseNode tree(Set<ParseNode> set) {
        for (ParseNode parseNode : set) {
            for (ParseNode parseNode2 : set) {
                if ((parseNode.from >= parseNode2.from || parseNode2.to > parseNode.to) && (parseNode.from > parseNode2.from || parseNode2.to >= parseNode.to)) continue;
                boolean bl = true;
                for (ParseNode parseNode3 : set) {
                    if ((parseNode.from >= parseNode3.from || parseNode3.to > parseNode.to) && (parseNode.from > parseNode3.from || parseNode3.to >= parseNode.to) || (parseNode3.from >= parseNode2.from || parseNode2.to > parseNode3.to) && (parseNode3.from > parseNode2.from || parseNode2.to >= parseNode3.to)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                parseNode.addTopLevel(parseNode2);
            }
        }
        return UnitTest.root(set);
    }

    private static ParseNode root(Set<ParseNode> set) {
        ParseNode parseNode = null;
        for (ParseNode parseNode2 : set) {
            if (parseNode == null) {
                parseNode = parseNode2;
                continue;
            }
            if ((parseNode2.from >= parseNode.from || parseNode.to > parseNode2.to) && (parseNode2.from > parseNode.from || parseNode.to >= parseNode2.to)) continue;
            parseNode = parseNode2;
        }
        return parseNode;
    }

    private static boolean isSubtree(ParseNode parseNode, ParseNode parseNode2) {
        if (parseNode.from != parseNode2.from || parseNode.to != parseNode2.to) {
            return false;
        }
        boolean bl = UnitTest.contentIsSubsetWithOneExc(parseNode, parseNode2);
        if (!bl) {
            System.out.println("Different content at nodes [" + parseNode.from + "," + parseNode.to + ") and [" + parseNode2.from + "," + parseNode2.to + ")");
        }
        if (parseNode.topLevel == null && parseNode2.children().size() == 0) {
            return bl;
        }
        if (parseNode.topLevel.size() != parseNode2.children().size()) {
            if (bl) {
                System.out.println("Children count mismatch at nodes [" + parseNode.from + "," + parseNode.to + ") and [" + parseNode2.from + "," + parseNode2.to + ")");
                System.out.println("a.topLevel.size()=" + parseNode.topLevel.size() + ", b.children().size()=" + parseNode2.children().size());
                for (ParseNode parseNode3 : parseNode.topLevel) {
                    System.out.println(parseNode3.toString());
                }
                for (ParseNode parseNode3 : parseNode2.children()) {
                    System.out.println(parseNode3.toString());
                }
            }
            return false;
        }
        for (ParseNode parseNode4 : parseNode.topLevel) {
            boolean bl2 = false;
            for (ParseNode parseNode5 : parseNode2.children()) {
                if (parseNode4.from != parseNode5.from || parseNode4.to != parseNode5.to || !UnitTest.isSubtree(parseNode4, parseNode5)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return bl;
    }

    private static boolean contentIsSubsetWithOneExc(ParseNode parseNode, ParseNode parseNode2) {
        if (parseNode instanceof LazyNode && !(parseNode2 instanceof LazyNode) || !(parseNode instanceof LazyNode) && parseNode2 instanceof LazyNode) {
            throw new AssertionError((Object)(parseNode.getClass() + "!=" + parseNode2.getClass()));
        }
        if (parseNode instanceof LazyNode && parseNode2 instanceof LazyNode) {
            String string = ((LazyNode)parseNode).startToken;
            if (string == null) {
                return true;
            }
            return string.equals(((LazyNode)parseNode2).startToken);
        }
        int n = 0;
        if (parseNode.content()[0] == -1) {
            ++n;
        }
        for (int i = 0; n < parseNode.content().length && i < parseNode2.content().length; ++n, ++i) {
            while (i < parseNode2.content().length && parseNode.content()[n] != parseNode2.content()[i]) {
                ++i;
            }
            if (i != parseNode2.content().length) continue;
            return false;
        }
        return true;
    }

    private static Set<ParseNode> nodeList(ParseNode parseNode, List<LexerToken> list, String string) {
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(node)) {
                treeSet.add(UnitTest.node(parseNode2, list, string));
            }
            if (!parseNode2.contains(tree)) continue;
            treeSet.addAll(UnitTest.nodeList(parseNode2, list, string));
        }
        if (treeSet == null) {
            treeSet = null;
        }
        return treeSet;
    }

    private static ParseNode node(ParseNode parseNode, List<LexerToken> list, String string) {
        ParseNode parseNode2 = null;
        if (parseNode.contains(range)) {
            long l = UnitTest.range(parseNode, list, string);
            if (parser instanceof SqlEarley) {
                parseNode2 = new ParseNode(Service.lX(l), Service.lY(l), -1, -1, SqlEarley.getInstance());
            } else {
                parseNode2 = new LazyNode(Service.lX(l), null, list);
                parseNode2.to = Service.lY(l);
            }
            return parseNode2;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode3.contains(label)) {
                String string2 = list.get((int)parseNode3.from).content;
                ((ParseNode)parseNode2).addContent(string2);
                continue;
            }
            if (!parseNode3.contains(node)) continue;
            parseNode2 = UnitTest.node(parseNode3, list, string);
        }
        if (parseNode2 == null) {
            parseNode2 = null;
        }
        return parseNode2;
    }

    private static long range(ParseNode parseNode, List<LexerToken> list, String string) {
        int n = -1;
        int n2 = -1;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(digits)) continue;
            if (n == -1) {
                n = Integer.parseInt(list.get((int)parseNode2.from).content);
                continue;
            }
            n2 = Integer.parseInt(list.get((int)parseNode2.from).content);
        }
        return Service.lPair(n, n2);
    }

    static {
        try {
            testParser = new Earley((Set)UnitTest.getRules()){

                @Override
                protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                    LexerToken lexerToken = list.get(n);
                    return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING || n2 == this.identifier && lexerToken.type == Token.BQUOTED_STRING;
                }
            };
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        output = (Integer)UnitTest.testParser.symbolIndexes.get("output");
        tree = (Integer)UnitTest.testParser.symbolIndexes.get("tree");
        assertion = (Integer)UnitTest.testParser.symbolIndexes.get("assertion");
        query = (Integer)UnitTest.testParser.symbolIndexes.get("query");
        atest = (Integer)UnitTest.testParser.symbolIndexes.get("atest");
        node = (Integer)UnitTest.testParser.symbolIndexes.get("node");
        range = (Integer)UnitTest.testParser.symbolIndexes.get("range");
        label = (Integer)UnitTest.testParser.symbolIndexes.get("label");
        digits = (Integer)UnitTest.testParser.symbolIndexes.get("digits");
        sql_fragment = (Integer)UnitTest.testParser.symbolIndexes.get("sql_fragment");
        comment = (Integer)UnitTest.testParser.symbolIndexes.get("comment");
        random = new Random();
        introduceRandomError = false;
        parser = SqlEarley.getInstance();
    }
}

