/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

public class DbObjectsDDL {
    static final String path = "/oracle/dbtools/parser/plsql/";
    private static Connection c = null;
    private static String query = null;
    private static ResultSet rs1 = null;
    private static PreparedStatement stmt2 = null;
    private static Map<String, Integer> objectTypeCounts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbObject next() throws Exception {
        DbObject dbObject = null;
        ResultSet resultSet = null;
        if (rs1.next()) {
            String string = rs1.getString(1);
            String string2 = rs1.getString(2);
            String string3 = rs1.getString(3);
            System.out.println(string3 + "." + string2 + " (" + string + ")");
            stmt2.setString(1, string);
            stmt2.setString(2, string2);
            stmt2.setString(3, string3);
            Integer n = objectTypeCounts.get(string);
            if (n == null) {
                n = 0;
            }
            if (10 < n) {
                return new DbObject("", "");
            }
            try {
                resultSet = stmt2.executeQuery();
                resultSet.next();
                dbObject = new DbObject(string, resultSet.getString(1));
            }
            catch (SQLException sQLException) {
                System.err.println(string3 + "." + string2 + " (" + string + ")");
                System.err.println(sQLException.getMessage());
                DbObject dbObject2 = new DbObject("", "");
                return dbObject2;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        return dbObject;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        SqlEarley sqlEarley = SqlEarley.getInstance();
        int n = 0;
        DbObject dbObject = null;
        while ((dbObject = DbObjectsDDL.next()) != null) {
            object = dbObject.definition;
            if (((String)object).length() == 0) continue;
            if (!((String)(object = ((String)object).trim())).endsWith(";")) {
                object = (String)object + ";";
            }
            if (((String)object).contains("***UNSUPPORTED DATA TYPE")) continue;
            boolean bl = false;
            List<LexerToken> list = LexerToken.parse((String)object);
            Matrix matrix = new Matrix(sqlEarley);
            sqlEarley.parse(list, matrix);
            if (((String)object).contains("CREATE OR REPLACE NONEDITIONABLE FUNCTION") && list.size() < 12) continue;
            ParseNode parseNode = null;
            try {
                parseNode = sqlEarley.forest(list, matrix);
            }
            catch (AssertionError assertionError) {
                System.err.println("AssertionError" + ((Throwable)((Object)assertionError)).getMessage());
                System.err.println((String)object);
                bl = true;
            }
            if (parseNode == null || parseNode.to < 2) {
                System.err.println((String)object);
                bl = true;
            }
            boolean bl2 = false;
            int n2 = list.size();
            if (parseNode != null && parseNode.topLevel != null) {
                for (ParseNode parseNode2 : parseNode.children()) {
                    if (parseNode2.from != 0) continue;
                    parseNode = parseNode2;
                    n2 = parseNode.to;
                }
                if (parseNode.topLevel != null) {
                    System.err.println((String)object);
                    bl = true;
                }
            }
            if (!bl) continue;
            stringBuilder.append("++");
            stringBuilder.append(n++);
            stringBuilder.append(";\n");
            stringBuilder.append('`');
            stringBuilder.append((String)object);
            stringBuilder.append("`->\n");
            stringBuilder.append("[0,0) dummy /*failed*/\n;\n\n");
            Object object2 = objectTypeCounts.get(dbObject.type);
            if (object2 == null) {
                object2 = 0;
            }
            objectTypeCounts.put(dbObject.type, (Integer)object2 + 1);
        }
        System.out.println("------------------------------");
        object = new FileWriter("common/src/oracle/dbtools/parser/plsql/dbobjects_sql.test");
        ((Writer)object).write(stringBuilder.toString());
        ((OutputStreamWriter)object).close();
    }

    static {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            c = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12GR1P.uk.oracle.com", "system", "dbtools");
            query = "select object_type,object_name,owner from all_objects \n where OWNER like 'SYS%' and object_type not like '%JAVA%' and object_type != 'VIEW'/*and rownum < 1000*/";
            PreparedStatement preparedStatement = c.prepareStatement(query);
            rs1 = preparedStatement.executeQuery();
            stmt2 = c.prepareStatement("select DBMS_METADATA.GET_DDL(:type,:name,:owner) from dual");
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to connect to database");
        }
        objectTypeCounts = new HashMap<String, Integer>();
    }

    static class DbObject {
        String type;
        String definition;

        public DbObject(String string, String string2) {
            this.type = string;
            this.definition = string2;
        }
    }
}

