/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.Token;

public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;

    public LexerToken(CharSequence charSequence, int n, int n2, Token token) {
        this.content = charSequence.toString().intern();
        this.begin = n;
        this.end = n2;
        this.type = token;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + (Object)((Object)this.type) + ">";
    }

    public static void print(List<LexerToken> list) {
        int n = 0;
        for (LexerToken lexerToken : list) {
            System.out.print(n + "    ");
            lexerToken.print();
            ++n;
        }
    }

    public static void print(List<LexerToken> list, int n, int n2) {
        LexerToken.print(list, n, n2, false);
    }

    public static void print(List<LexerToken> list, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            if (bl) {
                System.err.print(" " + list.get((int)i).content);
                continue;
            }
            System.out.print(" " + list.get((int)i).content);
        }
        if (bl) {
            System.err.println();
        } else {
            System.out.println();
        }
    }

    private static LinkedList<LexerToken> tokenize(String string, boolean bl, String string2, InterruptedException interruptedException) throws InterruptedException {
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        String string3 = "(){}[]^-|!*+.><='\",;:%@?/\\#~" + string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3 + " \n\r\t", true);
        int n = 0;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            if (interruptedException != null && Thread.interrupted()) {
                throw interruptedException;
            }
            String string4 = stringTokenizer.nextToken();
            n += string4.length();
            LexerToken lexerToken = null;
            if (linkedList.size() > 0) {
                lexerToken = linkedList.getLast();
            }
            if (bl2) {
                if ("/".equals(string4) && lexerToken != null && "\n".equals(lexerToken.content)) {
                    linkedList.add(new LexerToken("\"/\"", n - "\"/\"".length(), n, Token.IDENTIFIER));
                    bl2 = false;
                    continue;
                }
                if ("\n".equals(string4)) {
                    linkedList.add(new LexerToken(string4, n - string4.length(), n, Token.WS));
                    continue;
                }
                if (!"\n".equals(lexerToken.content)) continue;
                lexerToken.content = "?";
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.COMMENT && (!lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/"))) {
                lexerToken.content = "*".equals(string4) || "/".equals(string4) ? lexerToken.content + string4 : "/* ... ";
                lexerToken.end = n;
                if (lexerToken == null || lexerToken.type != Token.COMMENT || !lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/")) continue;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && !"\n".equals(string4)) {
                lexerToken.content = lexerToken.content + string4;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && "\n".equals(string4)) {
                lexerToken.end = n - string4.length();
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
            }
            if (lexerToken != null && lexerToken.type == Token.QUOTED_STRING && !lexerToken.isStandardLiteral() && !lexerToken.isAltLiteral()) {
                lexerToken.content = lexerToken.content + string4;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && !"\"".equals(string4) && (!lexerToken.content.endsWith("\"") || lexerToken.content.length() <= 1)) continue;
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && "\"".equals(string4)) {
                lexerToken.end = n;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.BQUOTED_STRING && !"`".equals(string4) && (!lexerToken.content.endsWith("`") || lexerToken.content.length() <= 1)) continue;
            if (lexerToken != null && lexerToken.type == Token.BQUOTED_STRING && "`".equals(string4)) {
                lexerToken.end = n;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if ("*".equals(string4) && lexerToken != null && "/".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string4;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                lexerToken.type = Token.COMMENT;
                continue;
            }
            if ("-".equals(string4) && lexerToken != null && "-".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string4;
                lexerToken.type = Token.LINE_COMMENT;
                continue;
            }
            if (("rem".equalsIgnoreCase(string4) || "rema".equalsIgnoreCase(string4) || "remar".equalsIgnoreCase(string4) || "remark".equalsIgnoreCase(string4)) && (lexerToken == null || "\n".equals(lexerToken.content) || "\r".equals(lexerToken.content))) {
                linkedList.add(new LexerToken(string4, n - 1, -9, Token.LINE_COMMENT));
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && lexerToken.end == -11 && lexerToken.content.startsWith("@") && !"\n".equals(string4) && !"\r".equals(string4)) {
                lexerToken.content = lexerToken.content + string4;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && lexerToken.end == -11 && lexerToken.content.startsWith("@") && ("\n".equals(string4) || "\r".equals(string4))) {
                lexerToken.end = n - 1;
                linkedList.add(new LexerToken(string4, n - 1, n, Token.WS));
                continue;
            }
            if (bl && "'".equals(string4)) {
                if (lexerToken != null && ("q".equalsIgnoreCase(lexerToken.content) || "N".equalsIgnoreCase(lexerToken.content) || "nq".equalsIgnoreCase(lexerToken.content))) {
                    lexerToken.content = lexerToken.content + string4;
                    lexerToken.type = Token.QUOTED_STRING;
                    continue;
                }
                linkedList.add(new LexerToken(string4, n - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if (bl && "\"".equals(string4)) {
                linkedList.add(new LexerToken(string4, n - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("`".equals(string4) && 0 <= string3.indexOf(96)) {
                linkedList.add(new LexerToken(string4, n - 1, -11, Token.BQUOTED_STRING));
                continue;
            }
            if (string3.contains(string4)) {
                linkedList.add(new LexerToken(string4, n - 1, n, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(string4)) {
                linkedList.add(new LexerToken(string4, n - 1, n, Token.WS));
                continue;
            }
            if ('0' <= string4.charAt(0) && string4.charAt(0) <= '9') {
                if (LexerToken.fixedExponent(string4, linkedList, n - string4.length())) continue;
                if (string4.charAt(string4.length() - 1) == 'K' || string4.charAt(string4.length() - 1) == 'k' || string4.charAt(string4.length() - 1) == 'M' || string4.charAt(string4.length() - 1) == 'm' || string4.charAt(string4.length() - 1) == 'G' || string4.charAt(string4.length() - 1) == 'g' || string4.charAt(string4.length() - 1) == 'T' || string4.charAt(string4.length() - 1) == 't' || string4.charAt(string4.length() - 1) == 'P' || string4.charAt(string4.length() - 1) == 'p' || string4.charAt(string4.length() - 1) == 'E' || string4.charAt(string4.length() - 1) == 'e') {
                    linkedList.add(new LexerToken(string4.substring(0, string4.length() - 1), n - string4.length(), n - 1, Token.DIGITS));
                    linkedList.add(new LexerToken(string4.substring(string4.length() - 1), n - 1, n, Token.DIGITS));
                    continue;
                }
                linkedList.add(new LexerToken(string4, n - string4.length(), n, Token.DIGITS));
                continue;
            }
            if ("WRAPPED".equalsIgnoreCase(string4) && lexerToken != null) {
                Iterator<LexerToken> iterator = linkedList.descendingIterator();
                boolean bl3 = false;
                while (iterator.hasNext()) {
                    LexerToken lexerToken2 = iterator.next();
                    if (bl3 && ("PROCEDURE".equalsIgnoreCase(lexerToken2.content) || "FUNCTION".equalsIgnoreCase(lexerToken2.content) || "TRIGGER".equalsIgnoreCase(lexerToken2.content) || "TYPE".equalsIgnoreCase(lexerToken2.content) || "PACKAGE".equalsIgnoreCase(lexerToken2.content) || "BODY".equalsIgnoreCase(lexerToken2.content))) {
                        bl2 = true;
                        break;
                    }
                    if (lexerToken2.type == Token.WS || lexerToken2.type == Token.COMMENT) continue;
                    if (lexerToken2.type != Token.IDENTIFIER) break;
                    bl3 = true;
                }
            }
            linkedList.add(new LexerToken(string4, n - string4.length(), n, Token.IDENTIFIER));
        }
        return linkedList;
    }

    private static boolean fixedExponent(String string, List<LexerToken> list, int n) {
        if (!(string.contains("e") || string.contains("f") || string.contains("d"))) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "efd", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n += string2.length();
            if ('0' <= string2.charAt(0) && string2.charAt(0) <= '9') {
                list.add(new LexerToken(string2, n - string2.length(), n, Token.DIGITS));
                continue;
            }
            list.add(new LexerToken(string2, n - string2.length(), n, Token.IDENTIFIER));
        }
        return true;
    }

    public static List<LexerToken> parse(String string) {
        return LexerToken.parse(string, false);
    }

    public static List<LexerToken> parse(String string, String string2) {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        try {
            LexerToken.parse(string, false, true, string2, arrayList, null);
        }
        catch (InterruptedException interruptedException) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
        return arrayList;
    }

    public static List<LexerToken> parse(String string, boolean bl) {
        return LexerToken.parse(string, bl, true);
    }

    public static List<LexerToken> parse(String string, boolean bl, boolean bl2) {
        try {
            return LexerToken.parse(string, bl, bl2, null);
        }
        catch (InterruptedException interruptedException) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
    }

    public static List<LexerToken> parse(String string, boolean bl, boolean bl2, InterruptedException interruptedException) throws InterruptedException {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        LexerToken.parse(string, bl, bl2, "", arrayList, interruptedException);
        return arrayList;
    }

    private static void parse(String string, boolean bl, boolean bl2, String string2, List<LexerToken> list, InterruptedException interruptedException) throws InterruptedException {
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : LexerToken.tokenize(string, bl2, string2, interruptedException)) {
            if (lexerToken2.type == Token.QUOTED_STRING) {
                if (lexerToken != null && lexerToken.type == Token.QUOTED_STRING) {
                    lexerToken.content = lexerToken.content + lexerToken2.content;
                    lexerToken.end = lexerToken2.end;
                    continue;
                }
                if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && "n".equalsIgnoreCase(lexerToken.content) && lexerToken.end == lexerToken2.begin) {
                    lexerToken.begin = lexerToken2.begin;
                    lexerToken.end = lexerToken2.end;
                    lexerToken.type = lexerToken2.type;
                    lexerToken.content = lexerToken2.content;
                    continue;
                }
            }
            if (lexerToken2.content.startsWith("@")) {
                lexerToken2.end = lexerToken2.begin + lexerToken2.content.length();
            }
            if ("#".equals(lexerToken2.content) && lexerToken != null && lexerToken.type == Token.IDENTIFIER) {
                ++lexerToken.end;
                lexerToken.content = lexerToken.content + "#";
                continue;
            }
            if ((lexerToken2.type == Token.IDENTIFIER || lexerToken2.type == Token.DIGITS) && lexerToken != null && lexerToken.content.endsWith("#") && lexerToken.type == Token.IDENTIFIER) {
                lexerToken.end += lexerToken2.content.length();
                lexerToken.content = lexerToken.content + lexerToken2.content;
                continue;
            }
            if (lexerToken2.content.startsWith("$$")) {
                lexerToken2.content = "$$VAR";
            }
            if (bl || lexerToken2.type != Token.WS && lexerToken2.type != Token.COMMENT && lexerToken2.type != Token.LINE_COMMENT) {
                list.add(lexerToken2);
            }
            lexerToken = lexerToken2;
        }
    }

    public static int scanner2parserOffset(List<LexerToken> list, int n) {
        int n2 = -1;
        for (LexerToken lexerToken : list) {
            ++n2;
            if (lexerToken.end <= n) continue;
            break;
        }
        return n2;
    }

    public static LexerToken getTokenAtCharOffset(List<LexerToken> list, int n) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            LexerToken lexerToken = list.get(0);
            if (n < lexerToken.begin || lexerToken.end <= n) {
                lexerToken = null;
            }
            return lexerToken;
        }
        int n2 = LexerToken.indexOf(list, 0, list.size() - 1, n);
        return list.get(n2);
    }

    public static int char2lex(List<LexerToken> list, int n) {
        if (list.size() == 0) {
            return 0;
        }
        int n2 = -1;
        for (LexerToken lexerToken : list) {
            ++n2;
            if (lexerToken.begin <= n && n <= lexerToken.end) {
                return n2;
            }
            if (n > lexerToken.begin) continue;
            return n2;
        }
        return n2 + 1;
    }

    private static int indexOf(List<LexerToken> list, int n, int n2, int n3) {
        if (n == n2) {
            throw new AssertionError((Object)("x == y (== " + n + ")"));
        }
        if (n + 1 == n2) {
            LexerToken lexerToken = list.get(n);
            if (lexerToken.begin <= n3 && n3 < lexerToken.end) {
                return n;
            }
            LexerToken lexerToken2 = list.get(n2);
            if (lexerToken2.begin <= n3 && n3 < lexerToken2.end) {
                return n2;
            }
            throw new AssertionError(n);
        }
        int n4 = (n + n2) / 2;
        if (n3 < list.get((int)n4).begin) {
            return LexerToken.indexOf(list, n, n4, n3);
        }
        return LexerToken.indexOf(list, n4, n2, n3);
    }

    private static char matchingDelimiter(char c) {
        if ('<' == c) {
            return '>';
        }
        if ('[' == c) {
            return ']';
        }
        if ('{' == c) {
            return '}';
        }
        if ('(' == c) {
            return ')';
        }
        return c;
    }

    private boolean isStandardLiteral() {
        if (this.content.length() < 2) {
            return false;
        }
        if (this.content.charAt(0) != '\'' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N') {
            return false;
        }
        String string = this.content;
        if (string.charAt(0) == 'n' || string.charAt(0) == 'N') {
            if (string.length() < 3) {
                return false;
            }
            string = string.substring(1);
        }
        if (string.length() < 2) {
            return false;
        }
        return string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    private boolean isAltLiteral() {
        if (this.content.length() < 5) {
            return false;
        }
        if (this.content.charAt(0) != 'q' && this.content.charAt(0) != 'Q' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N') {
            return false;
        }
        String string = this.content;
        if (this.content.charAt(0) == 'q' || this.content.charAt(0) == 'Q') {
            string = string.substring(1);
        } else if (!(this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' || this.content.charAt(1) != 'q' && this.content.charAt(1) != 'Q')) {
            if (string.length() < 6) {
                return false;
            }
            string = string.substring(2);
        } else {
            return false;
        }
        if (string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\'') {
            return false;
        }
        string = string.substring(1, string.length() - 1);
        return LexerToken.matchingDelimiter(string.charAt(0)) == string.charAt(string.length() - 1);
    }

    public static void moveInterval(List<LexerToken> list, int n) {
        for (LexerToken lexerToken : list) {
            lexerToken.begin += n;
            lexerToken.end += n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"q'#without it does not#'", "i# := 1; i#j := 2;"};
        List<LexerToken> list = LexerToken.parse("se");
        System.out.println(LexerToken.char2lex(list, 2));
    }

    private static void testInput(String string) {
        System.gc();
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        List<LexerToken> list = LexerToken.parse(string);
        long l4 = System.currentTimeMillis();
        l2 = Runtime.getRuntime().totalMemory();
        l3 = Runtime.getRuntime().freeMemory();
        LexerToken.print(list);
    }
}

