/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class Earley
extends Parser {
    public Tuple[] rules;
    public int identifier = -1;
    protected int string_literal = -1;
    protected int digits = -1;
    private boolean isCaseSensitive = false;
    public Map<Integer, long[]> predicts = new HashMap<Integer, long[]>();
    public boolean skipRanges = true;

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(Earley.class, "test.sql");
        List<LexerToken> list = LexerToken.parse(string);
        System.out.println("src.size()=" + list.size());
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        treeSet.add(new RuleTuple("P", new String[]{"S"}));
        treeSet.add(new RuleTuple("S", new String[]{"S", "'+'", "M"}));
        treeSet.add(new RuleTuple("S", new String[]{"M"}));
        treeSet.add(new RuleTuple("M", new String[]{"T", "'*'", "M"}));
        treeSet.add(new RuleTuple("M", new String[]{"T"}));
        treeSet.add(new RuleTuple("T", new String[]{"'('", "P", "')'"}));
        treeSet.add(new RuleTuple("T", new String[]{"digits"}));
        treeSet.add(new RuleTuple("T", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("T", new String[]{"string_literal"}));
        TreeSet treeSet2 = new TreeSet();
        treeSet2 = treeSet;
        Earley earley = new Earley((Set)treeSet2){};
        earley.isCaseSensitive = true;
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        visual = new Visual(list, earley);
        long l = System.currentTimeMillis();
        earley.parse(list, matrix);
        long l2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (l2 - l));
        System.out.println("#tokens=" + list.size());
        if (visual != null) {
            visual.draw(matrix);
        }
    }

    protected void initCell00(List<LexerToken> list, Matrix matrix) {
        long l = 0L;
        if (matrix.visual != null) {
            l = System.nanoTime();
        }
        long[] lArray = null;
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple tuple = this.rules[i];
            String string = this.allSymbols[tuple.head];
            if (string.charAt(string.length() - 1) == ')') continue;
            lArray = Array.insert(lArray, this.makeMatrixCellElem(i, 0, tuple));
        }
        matrix.initCells(list.size());
        matrix.put(0, 0, new EarleyCell(lArray));
        matrix.allXs = Array.insert(matrix.allXs, 0);
        if (matrix.visual != null) {
            long l2 = System.nanoTime();
            long[] lArray2 = matrix.visual.visited[0];
            lArray2[0] = lArray2[0] + (long)((int)(l2 - l));
        }
    }

    public void parse(List<LexerToken> list, Matrix matrix) {
        try {
            this.initCell00(list, matrix);
            this.predict(matrix);
            while (this.scan(matrix, list)) {
                this.complete(matrix);
                this.predict(matrix);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Earley(Set<RuleTuple> set) {
        this(set, true);
    }

    public Earley(Set<RuleTuple> set, boolean bl) {
        super(set);
        this.rules = new Tuple[set.size()];
        int n = 0;
        for (RuleTuple ruleTuple : set) {
            if (ruleTuple.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + ruleTuple.toString()));
            }
            int n2 = (Integer)this.symbolIndexes.get(ruleTuple.head);
            int[] nArray = new int[ruleTuple.rhs.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)this.symbolIndexes.get(ruleTuple.rhs[i]);
            }
            this.rules[n++] = new Tuple(n2, nArray);
        }
        this.identifier = (Integer)this.symbolIndexes.get("identifier");
        try {
            this.string_literal = (Integer)this.symbolIndexes.get("string_literal");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.digits = (Integer)this.symbolIndexes.get("digits");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (bl) {
            this.precomputePredictions();
        }
    }

    protected void precomputePredictionsSlower() {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        HashMap<Integer, int[]> hashMap2 = new HashMap<Integer, int[]>();
        for (int i = 0; i < this.rules.length; ++i) {
            Earley.addDependency(this.rules[i].head, this.rules[i].rhs[0], hashMap, hashMap2);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.predicts.put(n, this.convert((int[])hashMap.get(n)));
        }
    }

    protected void precomputePredictions() {
        Object object;
        int n;
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        HashMap<Integer, long[]> hashMap2 = new HashMap<Integer, long[]>();
        for (n = 0; n < this.rules.length; ++n) {
            object = (int[])hashMap.get(this.rules[n].head);
            long[] lArray = (long[])hashMap2.get(this.rules[n].head);
            object = Array.insert((int[])object, this.rules[n].rhs[0]);
            lArray = Array.insert(lArray, this.makeMatrixCellElem(n, 0, this.rules[n]));
            hashMap.put(this.rules[n].head, (int[])object);
            hashMap2.put(this.rules[n].head, lArray);
        }
        do {
            n = this.size(hashMap);
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                int n2 = (Integer)object.next();
                int[] nArray = (int[])hashMap.get(n2);
                int[] nArray2 = Array.merge(nArray, new int[0]);
                for (int n3 : nArray) {
                    nArray2 = Array.merge(nArray2, (int[])hashMap.get(n3));
                }
                hashMap.put(n2, nArray2);
            }
        } while (n != this.size(hashMap));
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            long[] lArray = (long[])hashMap2.get(n4);
            for (int n5 : (int[])hashMap.get(n4)) {
                lArray = Array.merge(lArray, (long[])hashMap2.get(n5));
            }
            this.predicts.put(n4, lArray);
        }
    }

    private static void addDependency(int n, int n2, Map<Integer, int[]> map, Map<Integer, int[]> map2) {
        int n3;
        int[] nArray = map2.get(n2);
        nArray = Array.insert(nArray, n2);
        map2.put(n2, nArray);
        int[] nArray2 = map.get(n);
        nArray2 = Array.insert(nArray2, n);
        map.put(n, nArray2);
        int[] nArray3 = map2.get(n);
        nArray3 = Array.insert(nArray3, n);
        map2.put(n, nArray3);
        int[] nArray4 = map.get(n2);
        nArray4 = Array.insert(nArray4, n2);
        map.put(n2, nArray4);
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        HashMap<Integer, int[]> hashMap2 = new HashMap<Integer, int[]>();
        for (int n4 : nArray3) {
            for (int n5 : nArray4) {
                int[] nArray5 = (int[])hashMap.get(n4);
                nArray5 = Array.insert(nArray5, n5);
                hashMap.put(n4, nArray5);
                int[] nArray6 = (int[])hashMap2.get(n5);
                nArray6 = Array.insert(nArray6, n4);
                hashMap2.put(n5, nArray6);
            }
        }
        Object object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            n3 = (Integer)object.next();
            int[] nArray7 = map.get(n3);
            if (nArray7 == null) {
                map.put(n3, (int[])hashMap.get(n3));
                continue;
            }
            nArray7 = Array.merge(nArray7, (int[])hashMap.get(n3));
            map.put(n3, nArray7);
        }
        object = hashMap2.keySet().iterator();
        while (object.hasNext()) {
            n3 = (Integer)object.next();
            int[] nArray8 = map2.get(n3);
            if (nArray8 == null) {
                map2.put(n3, (int[])hashMap2.get(n3));
                continue;
            }
            nArray8 = Array.merge(nArray8, (int[])hashMap2.get(n3));
            map2.put(n3, nArray8);
        }
    }

    private int size(Map<Integer, int[]> map) {
        int n = 0;
        for (int[] nArray : map.values()) {
            n += nArray.length;
        }
        return n;
    }

    protected boolean scan(Matrix matrix, List<LexerToken> list) {
        int n = matrix.lastY();
        if (list.size() <= n) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        Integer n2 = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? lexerToken.content : lexerToken.content.toUpperCase()) + "'");
        boolean bl = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int n3 = matrix.allXs[i];
            if (!this.scan(matrix, n, list, n3, n2)) continue;
            bl = true;
        }
        if (this.scan(matrix, n, list, n, n2)) {
            bl = true;
        }
        return bl;
    }

    private boolean scan(Matrix matrix, int n, List<LexerToken> list, int n2, Integer n3) {
        long l = 0L;
        if (matrix.visual != null) {
            l = System.nanoTime();
        }
        long[] lArray = null;
        Cell cell = matrix.get(n2, n);
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n4 = cell.getPosition(i);
            int n5 = cell.getRule(i);
            Tuple tuple = this.rules[n5];
            if (tuple.size() - 1 < n4 || !this.isScannedSymbol(n, list, n4, tuple, n3)) continue;
            lArray = Array.insert(lArray, this.makeMatrixCellElem(n5, n4 + 1, tuple));
        }
        if (matrix.visual != null) {
            long l2 = System.nanoTime();
            long[] lArray2 = matrix.visual.visited[n2];
            int n6 = n + 1;
            lArray2[n6] = lArray2[n6] + (long)((int)(l2 - l));
        }
        if (lArray == null) {
            return false;
        }
        matrix.put(n2, n + 1, new EarleyCell(lArray));
        matrix.allXs = Array.insert(matrix.allXs, n2);
        return true;
    }

    protected boolean isScannedSymbol(int n, List<LexerToken> list, int n2, Tuple tuple, Integer n3) {
        int n4 = tuple.content(n2);
        LexerToken lexerToken = list.get(n);
        if (n4 == this.digits && lexerToken.type == Token.DIGITS) {
            return true;
        }
        if (n4 == this.string_literal && lexerToken.type == Token.QUOTED_STRING) {
            return true;
        }
        return n3 != null && n3 == n4 || this.isIdentifier(n, list, n4, n3) && (n3 == null || this.notConfusedAsId(n3, tuple.head, n2));
    }

    protected boolean notConfusedAsId(int n, int n2, int n3) {
        return true;
    }

    protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
        if (n2 != this.identifier) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER;
    }

    protected void predict(Matrix matrix) {
        long l = 0L;
        if (matrix.visual != null) {
            l = System.nanoTime();
        }
        int n = matrix.lastY();
        EarleyCell earleyCell = (EarleyCell)matrix.get(n, n);
        long[] lArray = null;
        if (earleyCell != null) {
            lArray = earleyCell.content;
        }
        Map<Integer, Cell> map = matrix.getXRange(n);
        for (int n2 : map.keySet()) {
            Cell cell = matrix.get(n2, n);
            for (int i = 0; i < cell.size(); ++i) {
                int n3 = cell.getPosition(i);
                int n4 = cell.getRule(i);
                Tuple tuple = this.rules[n4];
                if (tuple.size() <= n3) continue;
                int n5 = tuple.content(n3);
                long[] lArray2 = this.predicts.get(n5);
                lArray = Array.merge(lArray, lArray2);
            }
        }
        if (matrix.visual != null) {
            long l2 = System.nanoTime();
            long[] lArray3 = matrix.visual.visited[n];
            int n6 = n;
            lArray3[n6] = lArray3[n6] + (long)((int)(l2 - l));
        }
        if (lArray == null || lArray.length <= 0) {
            return;
        }
        matrix.put(n, n, new EarleyCell(lArray));
    }

    protected void complete(Matrix matrix) {
        int n = matrix.lastY();
        block0: for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int n2 = matrix.allXs[i];
            long l = 0L;
            if (matrix.visual != null) {
                l = System.nanoTime();
            }
            EarleyCell earleyCell = null;
            int n3 = n;
            while (true) {
                int n4 = (earleyCell = (EarleyCell)matrix.get(n2, n)) == null ? 0 : earleyCell.size();
                Map<Integer, Cell> map = matrix.getXRange(n);
                for (int n5 : map.keySet()) {
                    Cell cell;
                    Cell cell2 = matrix.get(n2, n5);
                    if (cell2 == null || (cell = matrix.get(n5, n)) == null) continue;
                    for (int j = 0; j < cell.size(); ++j) {
                        int n6 = cell.getPosition(j);
                        int n7 = cell.getRule(j);
                        Tuple tuple = this.rules[n7];
                        if (tuple.size() != n6) continue;
                        long l2 = (long)tuple.head << 48;
                        int n8 = Array.indexOf(((EarleyCell)cell2).content, l2);
                        int n9 = Array.indexOf(((EarleyCell)cell2).content, l2 | 0xFFFFFFFFFFFFL) + 1;
                        boolean bl = false;
                        if (bl) continue;
                        for (int k = n8; k < n9 && k < cell2.size(); ++k) {
                            int n10;
                            int n11 = cell2.getPosition(k);
                            int n12 = cell2.getRule(k);
                            Tuple tuple2 = this.rules[n12];
                            if (tuple2.size() == n11 || (n10 = tuple2.content(n11)) != tuple.head || !this.lookaheadOK(tuple2, n11 + 1, matrix)) continue;
                            if (earleyCell == null) {
                                earleyCell = new EarleyCell(null);
                            }
                            long l3 = this.makeMatrixCellElem(n12, n11 + 1, tuple2);
                            earleyCell.content = Array.insert(earleyCell.content, l3);
                            if (!this.skipRanges || tuple2.rhs.length != n11 + 1 || n5 >= n3 || this.allSymbols[tuple2.head].charAt(0) == '\"') continue;
                            n3 = n5;
                        }
                    }
                }
                if (this.skipRanges && n2 < n3 && n3 < n) {
                    for (int j = n2 + 1; j < n3; ++j) {
                        matrix.allXs = Array.delete(matrix.allXs, j);
                    }
                }
                if (matrix.visual != null) {
                    long l4 = System.nanoTime();
                    matrix.visual.visited[n2][n] = Service.addlY(matrix.visual.visited[n2][n], (int)(l4 - l));
                }
                if (earleyCell == null || earleyCell.size() == n4) continue block0;
                matrix.put(n2, n, earleyCell);
            }
        }
    }

    protected boolean lookaheadOK(Tuple tuple, int n, Matrix matrix) {
        return true;
    }

    void toHtml(int n, int n2, boolean bl, int n3, int n4, int n5, Matrix matrix, StringBuffer stringBuffer) {
        block14: {
            int n6;
            Tuple tuple = this.rules[n];
            String string = "+1";
            if (bl) {
                stringBuffer.append("<b>");
                string = "+2";
            }
            stringBuffer.append("<font size=" + string + " color=blue>" + this.allSymbols[tuple.head] + ":</font> ");
            String string2 = "<font size=" + string + " bgcolor=rgb(150,200,150))>";
            String string3 = "<font size=" + string + " bgcolor=rgb(150,150,200))>";
            stringBuffer.append(string2);
            for (n6 = 0; n6 < tuple.rhs.length; ++n6) {
                if (n2 == n6) {
                    stringBuffer.append("</font>" + string3);
                }
                stringBuffer.append(this.allSymbols[tuple.rhs[n6]] + " ");
            }
            stringBuffer.append("</font>");
            if (bl) {
                stringBuffer.append("</b>");
            }
            if (n4 == -1) {
                return;
            }
            if (!bl || n3 + n5 == 0) break block14;
            if (n4 < n3 || n3 == n5) {
                stringBuffer.append("<i> predict from </i>");
                Cell cell = matrix.get(n4, n5);
                for (int i = 0; i < cell.size(); ++i) {
                    int n7 = cell.getPosition(i);
                    int n8 = cell.getRule(i);
                    Tuple tuple2 = this.rules[n8];
                    if (n7 >= tuple2.rhs.length || tuple2.rhs[n7] != tuple.head) continue;
                    this.toHtml(n8, n7, false, -1, -1, -1, null, stringBuffer);
                    return;
                }
            } else if (n5 < n4) {
                stringBuffer.append("<i> scan from </i>");
                Cell cell = matrix.get(n3, n5 - 1);
                for (int i = 0; i < cell.size(); ++i) {
                    int n9 = cell.getPosition(i);
                    int n10 = cell.getRule(i);
                    Tuple tuple3 = this.rules[n10];
                    if (n10 != n || n9 + 1 != n2) continue;
                    this.toHtml(n10, n9, false, -1, -1, -1, null, stringBuffer);
                    return;
                }
            } else {
                stringBuffer.append("<i> complete from </i>");
                n6 = 0;
                Cell cell = matrix.get(n3, n4);
                Cell cell2 = matrix.get(n4, n5);
                for (int i = 0; i < cell.size(); ++i) {
                    for (int j = 0; j < cell2.size(); ++j) {
                        int n11;
                        int n12 = cell.getPosition(i);
                        int n13 = cell2.getPosition(j);
                        int n14 = cell.getRule(i);
                        int n15 = cell2.getRule(j);
                        Tuple tuple4 = this.rules[n14];
                        Tuple tuple5 = this.rules[n15];
                        if (tuple4.size() != n12 && tuple5.size() != n13 || tuple5.size() != n13 || n14 != n || n12 + 1 != n2 || (n11 = tuple4.content(n12)) != tuple5.head) continue;
                        if (n6 != 0) {
                            stringBuffer.append("<b> or </b>");
                        }
                        this.toHtml(n14, n12, false, -1, -1, -1, null, stringBuffer);
                        stringBuffer.append("<i> and </i>");
                        this.toHtml(n15, n13, false, -1, -1, -1, null, stringBuffer);
                        n6 = 1;
                    }
                }
            }
        }
    }

    void toString(int n, int n2, StringBuffer stringBuffer) {
        Tuple tuple = this.rules[n];
        stringBuffer.append(tuple.toString(n2));
    }

    public void initCell(Matrix matrix, int[] nArray, int n) {
        long[] lArray = null;
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Tuple tuple = this.rules[i];
            for (int n2 : nArray) {
                if (tuple.head != n2) continue;
                lArray = Array.insert(lArray, this.makeMatrixCellElem(i, 0, tuple));
                continue block0;
            }
        }
        matrix.put(n, n, new EarleyCell(lArray));
        matrix.allXs = Array.insert(matrix.allXs, n);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> list, Matrix matrix, Cell cell, int n, int n2, Map<Long, ParseNode> map) {
        map = new HashMap<Long, ParseNode>();
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < cell.size(); ++i) {
            n3 = cell.getRule(i);
            n4 = cell.getPosition(i);
            if (this.rules[n3].rhs.length != n4) continue;
            return this.tree(list, matrix, n, n2, n3, n4, map);
        }
        if (n3 != -1 && n4 != -1 && n + 1 == n2) {
            return this.tree(list, matrix, n, n2, n3, n4, map);
        }
        return null;
    }

    private long encode(int n, int n2, int n3, int n4) {
        return (long)n4 << 49 | (long)n3 << 44 | (long)n2 << 22 | (long)n;
    }

    protected ParseNode tree(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4, Map<Long, ParseNode> map) {
        long l = this.encode(n, n2, n3, n4);
        ParseNode parseNode = map.get(l);
        if (parseNode != null) {
            return parseNode;
        }
        ParseNode parseNode2 = this.followScan(list, matrix, n, n2, n3, n4, map);
        if (parseNode2 == null) {
            parseNode2 = this.followComplete(list, matrix, n, n2, n3, n4, map);
        }
        map.put(l, parseNode2);
        return parseNode2;
    }

    private ParseNode followScan(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4, Map<Long, ParseNode> map) {
        Cell cell = matrix.get(n, n2 - 1);
        if (cell == null) {
            return null;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n5 = cell.getRule(i);
            int n6 = cell.getPosition(i);
            if (n5 != n3 || n6 + 1 != n4) continue;
            Tuple tuple = this.rules[n3];
            LexerToken lexerToken = list.get(n2 - 1);
            Integer n7 = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? lexerToken.content : lexerToken.content.toUpperCase()) + "'");
            if (!this.isScannedSymbol(n2 - 1, list, n6, tuple, n7)) continue;
            ParseNode parseNode = new ParseNode(n2 - 1, n2, this.rules[n5].rhs[n6], this.rules[n5].rhs[n6], this);
            if (n + 1 == n2) {
                if (this.rules[n5].rhs.length == 1) {
                    parseNode.addContent(this.rules[n5].head);
                }
                return parseNode;
            }
            int n8 = this.rules[n5].head;
            if (n4 != this.rules[n5].rhs.length) {
                n8 = -1;
            }
            ParseNode parseNode2 = new ParseNode(n, n2, n8, n8, this);
            parseNode2.lft = this.tree(list, matrix, n, n2 - 1, n5, n6, map);
            parseNode2.lft.parent = parseNode2;
            parseNode2.rgt = parseNode;
            parseNode2.rgt.parent = parseNode2;
            return parseNode2;
        }
        return null;
    }

    private ParseNode followComplete(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4, Map<Long, ParseNode> map) {
        for (int i = n2 - 1; n <= i; --i) {
            Cell cell;
            Cell cell2 = matrix.get(n, i);
            if (cell2 == null || (cell = matrix.get(i, n2)) == null) continue;
            for (int j = 0; j < cell2.size(); ++j) {
                int n5 = cell2.getRule(j);
                int n6 = cell2.getPosition(j);
                if (n5 != n3 || n6 + 1 != n4) continue;
                for (int k = cell.size() - 1; 0 <= k; --k) {
                    int n7 = cell.getRule(k);
                    int n8 = cell.getPosition(k);
                    if (this.rules[n7].rhs.length != n8 || this.rules[n5].rhs.length <= n6 || this.rules[n7].head != this.rules[n5].rhs[n6]) continue;
                    int n9 = this.rules[n5].head;
                    if (this.rules[n5].rhs.length != n6 + 1) {
                        n9 = -1;
                    }
                    ParseNode parseNode = new ParseNode(n, n2, n9, n9, this);
                    try {
                        if (n != i) {
                            parseNode.lft = this.tree(list, matrix, n, i, n5, n6, map);
                            parseNode.lft.parent = parseNode;
                            parseNode.rgt = this.tree(list, matrix, i, n2, n7, n8, map);
                            parseNode.rgt.parent = parseNode;
                        } else if (n7 != n3 || n8 != n4) {
                            parseNode = this.tree(list, matrix, i, n2, n7, n8, map);
                            if (n9 != -1) {
                                parseNode.addContent(n9);
                            }
                        }
                    }
                    catch (AssertionError assertionError) {
                        if (((Throwable)((Object)assertionError)).getMessage().startsWith("unwind")) continue;
                        throw assertionError;
                    }
                    return parseNode;
                }
            }
        }
        throw new AssertionError((Object)("unwind " + this.rules[n3].toString(n4) + " @[" + n + "," + n2 + ")"));
    }

    protected long makeMatrixCellElem(int n, int n2, Tuple tuple) {
        long l = 0L;
        if (n2 < tuple.rhs.length) {
            l = tuple.rhs[n2];
        }
        return Service.lPair(n, n2) | l << 48;
    }

    private long[] convert(int[] nArray) {
        long[] lArray = new long[]{};
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.rules.length; ++j) {
                if (this.rules[j].head != nArray[i]) continue;
                lArray = Array.insert(lArray, this.makeMatrixCellElem(j, 0, this.rules[j]));
            }
        }
        return lArray;
    }

    public static int ruleFromEarleyCell(long l) {
        return Service.lX(l);
    }

    public class EarleyCell
    implements Cell {
        long[] content = null;

        public EarleyCell(long[] lArray) {
            this.content = lArray;
        }

        @Override
        public int getSymbol(int n) {
            throw new AssertionError((Object)"N/A");
        }

        @Override
        public int getRule(int n) {
            return Service.lX(this.content[n]);
        }

        @Override
        public int getPosition(int n) {
            int n2 = Service.lY(this.content[n]) & 0xFFFF;
            return n2;
        }

        public long getElement(int n) {
            return this.content[n];
        }

        @Override
        public int size() {
            if (this.content == null) {
                return 0;
            }
            return this.content.length;
        }

        @Override
        public int[] getContent() {
            throw new AssertionError((Object)"Legacy CYK method called by Earley");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{ ");
            for (int i = 0; i < this.content.length; ++i) {
                if (0 < i) {
                    stringBuilder.append(" , ");
                }
                Tuple tuple = Earley.this.rules[this.getRule(i)];
                stringBuilder.append(tuple.toString(this.getPosition(i)));
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }

    public class Tuple
    implements Comparable<Tuple> {
        public int head;
        public int[] rhs;

        public Tuple(int n, int[] nArray) {
            this.head = n;
            this.rhs = nArray;
        }

        public int size() {
            return this.rhs.length;
        }

        public int content(int n) {
            return this.rhs[n];
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Tuple && this.compareTo((Tuple)object) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconsistent with equals");
        }

        @Override
        public int compareTo(Tuple tuple) {
            if (this.head == 0 || tuple.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int n = this.head - tuple.head;
            if (n != 0) {
                return n;
            }
            n = this.rhs.length - tuple.rhs.length;
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < this.rhs.length; ++i) {
                n = this.rhs[i] - tuple.rhs[i];
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Earley.this.allSymbols[this.head] + ":");
            for (int n : this.rhs) {
                stringBuilder.append("  " + Earley.this.allSymbols[n]);
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        public String toString(int n) {
            StringBuilder stringBuilder = new StringBuilder(Earley.this.allSymbols[this.head] + ":");
            for (int i = 0; i < this.rhs.length; ++i) {
                stringBuilder.append(' ');
                if (n == i) {
                    stringBuilder.append('!');
                }
                stringBuilder.append(Earley.this.allSymbols[this.rhs[i]]);
            }
            if (n == this.rhs.length) {
                stringBuilder.append('!');
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }
    }
}

