/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleCallableStatement;

final class OracleUtil
extends DBUtil {
    private static QueryXMLSupport s_xml;
    private static Set<String> s_reservedWords;
    private static final Version LG_BUFFER_REQ_VERSION;

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(DBUtil.class.getClassLoader(), "oracle/dbtools/db/dbutilsql.xml"));
        }
        return s_xml;
    }

    public static synchronized Set<String> getReservedWords() {
        if (s_reservedWords == null) {
            String[] stringArray = new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
            s_reservedWords = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(stringArray)));
        }
        return s_reservedWords;
    }

    OracleUtil(String string, Connection connection) {
        super(string, connection);
    }

    @Override
    public ResultSet executeQuery(String string, Map<String, ?> map) {
        return this.executeOracleQuery(string, map);
    }

    @Override
    protected PreparedStatement prepareQuery(String string) throws SQLException {
        return this.m_conn.prepareCall(string);
    }

    @Override
    protected String fetchDbVersionImpl() throws SQLException {
        String string = "10.1";
        String string2 = this.executeReturnOneCol("select * from v$version where banner like '%Oracle%'");
        String[] stringArray = string2.split(" ");
        String string3 = ".*[0-9]\\.+[0-9]\\.+.*";
        for (String string4 : stringArray) {
            if (!Pattern.matches(string3, string4)) continue;
            string = string4;
            break;
        }
        return string;
    }

    @Override
    public void setDBAction(String string) {
        Query query = OracleUtil.getXMLQueries().getQuery("ACTION", this.m_conn);
        this.execute(query.getSql(), Collections.singletonList(string == null ? "" : string));
    }

    @Override
    public void setDBModuleAction(String string) {
        Query query = OracleUtil.getXMLQueries().getQuery("MODULE", this.m_conn);
        this.execute(query.getSql(), Arrays.asList(s_prodName, string == null ? "" : string));
    }

    private boolean largeBuffer(Connection connection) {
        return LG_BUFFER_REQ_VERSION.compareTo(OracleUtil.getDbVersion(connection)) <= 0;
    }

    @Override
    public String getDBMSOUTPUT() {
        DBUtil.OperImpl<String> operImpl = new DBUtil.OperImpl<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                StringBuilder stringBuilder = new StringBuilder();
                Statement statement = null;
                try {
                    Query query = OracleUtil.getXMLQueries().getQuery("GET_DBMSOUTPUT", OracleUtil.this.m_conn);
                    statement = OracleUtil.this.m_conn.prepareCall(query.getSql());
                    if (OracleUtil.this.largeBuffer(OracleUtil.this.m_conn)) {
                        statement.registerOutParameter(2, 4);
                        statement.registerOutParameter(3, 12);
                        statement.registerOutParameter(4, 12);
                    } else {
                        statement.registerOutParameter(2, 4);
                        statement.registerOutParameter(3, 12);
                    }
                    do {
                        statement.setInt(1, 1000);
                        statement.executeUpdate();
                        if (OracleUtil.this.largeBuffer(OracleUtil.this.m_conn)) {
                            String string = statement.getString(3);
                            if (string != null) {
                                stringBuilder.append(string);
                            }
                            if ((string = statement.getString(4)) != null) {
                                stringBuilder.append(string + "\n");
                                continue;
                            }
                            stringBuilder.append("\n");
                            continue;
                        }
                        stringBuilder.append(statement.getString(3));
                    } while (statement.getInt(2) != 1);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                return stringBuilder.toString();
            }
        };
        return this.lockForOperation(operImpl, "");
    }

    @Override
    protected boolean isOracleConnectionAlive() {
        Query query = OracleUtil.getXMLQueries().getQuery("IS_ALIVE", this.m_conn);
        return this.execute(query.getSql(), Collections.EMPTY_LIST);
    }

    @Override
    public int getErrorOffset(final String string) {
        DBUtil.OperImpl<Integer> operImpl = new DBUtil.OperImpl<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws SQLException {
                Statement statement = null;
                if (DBUtil.s_conns.lock(OracleUtil.this.m_conn)) {
                    try {
                        Query query = OracleUtil.getXMLQueries().getQuery("ERR_SQL", OracleUtil.this.m_conn);
                        statement = OracleUtil.this.m_conn.prepareCall(query.getSql());
                        DBUtil.LOGGER.info(Messages.getString("DBUtil.55") + query.getSql());
                        statement.setString(1, string);
                        statement.setString(2, string);
                        statement.registerOutParameter(3, 4);
                        statement.execute();
                        Integer n = statement.getInt(3);
                        return n;
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        DBUtil.s_conns.unlock(OracleUtil.this.m_conn);
                    }
                }
                return 0;
            }
        };
        return this.lockForOperation(operImpl, 0);
    }

    @Override
    protected boolean hasTransaction() {
        DBUtil.OperImpl<Boolean> operImpl = new DBUtil.OperImpl<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                if (OracleUtil.this.m_conn == null || OracleUtil.this.m_conn.isClosed()) {
                    return false;
                }
                Query query = OracleUtil.getXMLQueries().getQuery("TRANSACTION", OracleUtil.this.m_conn);
                String string = OracleUtil.this.executeOracleReturnOneCol(query.getSql(), Collections.EMPTY_MAP);
                return ModelUtil.hasLength(string);
            }
        };
        return this.lockForOperation(operImpl, Boolean.FALSE);
    }

    @Override
    public Map<String, String> resolveName(String string) {
        return this.resolveName(string, false);
    }

    @Override
    public Map<String, String> resolveName(String string, boolean bl) {
        Object obj;
        String string2 = "N";
        if (bl) {
            string2 = "Y";
        }
        String[] stringArray = string.split("\\.");
        String string3 = null;
        String string4 = null;
        if (stringArray.length == 2) {
            string3 = stringArray[1];
            string4 = stringArray[0];
        } else {
            string3 = stringArray.length == 1 ? stringArray[0] : string;
        }
        String string5 = null;
        string3 = this.scrubObjectName(string3);
        if (string4 != null) {
            string4 = this.scrubObjectName(string4);
        }
        String[] stringArray2 = OracleUtil.resolveDBLink(string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string6 = DBUtil.getInstance(this.m_conn).executeReturnOneCol("select UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) from dual");
        if (stringArray2 != null) {
            string5 = "select object_type,owner,object_name,rank from (    select object_type,owner,object_name,0 rank    from all_objects@" + stringArray2[1] + "  where object_name = :NAME  " + "  and UPPER(owner) = nvl(:OWNER,:SCHEMA_CONTEXT)  " + "  and object_type not in ( 'SYNONYM' )   " + "  union all  " + "  select ao.object_type,ao.owner,ao.object_name,decode(UPPER(syn.owner), nvl(:OWNER,:SCHEMA_CONTEXT),10,20)  " + "  from all_objects@" + stringArray2[1] + " ao,all_synonyms syn  " + "  where ao.owner = syn.table_owner  " + "  and   ao.object_name = syn.table_name  " + "  and   syn.synonym_name = :NAME  " + " ) where ((:BODY_WHERE='Y') OR  (object_type not in ('PACKAGE BODY'))) AND rownum < 100 order by rank," + "  CASE object_type " + "    WHEN 'TABLE' " + "    THEN 0 " + "    WHEN 'VIEW' " + "    THEN 1 " + "    WHEN 'INDEX' " + "    THEN 2 " + "    WHEN 'PACKAGE' " + "    THEN 3 " + "    WHEN 'PACKAGE BODY' " + "    THEN 4 " + "    ELSE 6 " + "  END";
            hashMap.put("NAME", stringArray2[0]);
            hashMap.put("OWNER", string4);
            hashMap.put("SCHEMA_CONTEXT", string6);
            hashMap.put("BODY_WHERE", string2);
        } else {
            string5 = "select object_type,owner,object_name,rank from (    select object_type,owner,object_name,0 rank    from all_objects    where object_name = :NAME    and UPPER(owner) = nvl(:OWNER,:SCHEMA_CONTEXT)    and object_type not in ( 'SYNONYM' )     union all    select ao.object_type,ao.owner,ao.object_name,decode(UPPER(syn.owner), nvl(:OWNER,:SCHEMA_CONTEXT),10,20)    from all_objects ao,all_synonyms syn    where ao.owner = syn.table_owner    and   ao.object_name = syn.table_name    and   syn.synonym_name = :NAME    and ( UPPER(syn.owner) = nvl(:OWNER,:SCHEMA_CONTEXT) \n        OR UPPER(syn.owner) = nvl(:OWNER,'PUBLIC') ) ) where ((:BODY_WHERE='Y') OR  (object_type not in ('PACKAGE BODY'))) AND rownum < 100 order by rank,  CASE object_type     WHEN 'TABLE'     THEN 0     WHEN 'VIEW'     THEN 1     WHEN 'INDEX'     THEN 2     WHEN 'PACKAGE'     THEN 3     WHEN 'PACKAGE BODY'     THEN 4     ELSE 5   END";
            hashMap.put("NAME", string3);
            hashMap.put("OWNER", string4);
            hashMap.put("SCHEMA_CONTEXT", string6);
            hashMap.put("BODY_WHERE", string2);
        }
        List<Map<String, ?>> list = this.executeReturnList(string5, hashMap);
        if (list.size() == 0 && string3 != null && string4 == null) {
            string5 = "select 'SCHEMA' object_type , :OWNER owner , :OWNER object_name from all_users where username = :OWNER";
            hashMap.put("OWNER", string3);
            list = this.executeReturnList(string5, hashMap);
        }
        Map<String, ?> map = null;
        if (list.size() > 0) {
            map = list.get(0);
        }
        if (map != null && (obj = map.get("OBJECT_TYPE")) != null && ((String)obj).indexOf("TABLE PARTITION") != -1) {
            map.put("OBJECT_TYPE", "TABLE");
        }
        return map;
    }

    @Override
    public String executeReturnOneCol(String string, Map<String, ? extends Object> map) {
        return this.executeOracleReturnOneCol(string, map);
    }

    @Override
    public String executeReturnOneCol(String string) {
        return this.executeOracleReturnOneCol(string, null);
    }

    @Override
    protected PreparedStatement prepareExecuteImpl(String string, Map<String, ?> map) throws SQLException {
        CallableStatement callableStatement = this.m_conn.prepareCall(string);
        LOGGER.info(Messages.getString("DBUtil.17") + string);
        if (map != null) {
            OracleUtil.bind((PreparedStatement)callableStatement, map);
        }
        return callableStatement;
    }

    @Override
    protected boolean checkAccess(String string) {
        boolean bl = false;
        if (this.m_conn != null) {
            Query query = OracleUtil.getXMLQueries().getQuery("ORACLE_NAME_RESOLVE", this.m_conn);
            try (CallableStatement callableStatement = this.m_conn.prepareCall(query.getSql());){
                ((OracleCallableStatement)callableStatement).setStringAtName("obj_name", string);
                callableStatement.execute();
                bl = true;
            }
            catch (SQLException sQLException) {
                LOGGER.info(string + oracle.dbtools.raptor.query.Messages.getString("QueryUtils.31"));
            }
        }
        return bl;
    }

    static {
        LG_BUFFER_REQ_VERSION = new Version("10.2");
    }
}

