/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.readservice;

import java.util.Locale;
import java.util.logging.Logger;
import oracle.dbtools.data.common.TranslatableMessage;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.data.readservice.ReadResources;

public abstract class ReadService {
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private Iterable<Locale> _responseLocales;

    public abstract String getType();

    public abstract String getFormat();

    public abstract String[] getColumnNames() throws DataFormatException;

    public abstract void open();

    public abstract void start();

    public abstract boolean hasMoreRows();

    public abstract Object[] readline() throws DataFormatException;

    public abstract void close();

    protected Iterable<Locale> getResponseLocales() {
        return this._responseLocales;
    }

    protected void setResponseLocales(Iterable<Locale> iterable) {
        this._responseLocales = iterable;
    }

    protected void setLogger(Logger logger) {
        this.LOGGER = logger;
    }

    protected final String translate(String string, Object[] objectArray) {
        if (this._responseLocales == null) {
            return ReadResources.format(string, objectArray);
        }
        return new TranslatableMessage(LoadResources.class, string, ReadResources.format(string, objectArray), objectArray).toString(this._responseLocales);
    }

    protected final String translate(String string) {
        if (this._responseLocales == null) {
            return ReadResources.getString(string);
        }
        return new TranslatableMessage(ReadResources.class, string, ReadResources.getString(string), new Object[0]).toString(this._responseLocales);
    }
}

