/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.model.LoadField;

public class LoadFile {
    private List<LoadField> _fields;
    private String _name;
    private String _shortName;
    private String _canonicalName;
    private String _type;

    public LoadFile() {
        this._fields = new ArrayList<LoadField>();
        this._type = "csv";
    }

    public LoadFile(String string) {
        this.setName(string);
        this._fields = new ArrayList<LoadField>();
    }

    public void addField(LoadField loadField) {
        if (loadField != null) {
            this._fields.add(loadField);
        }
    }

    public List<LoadField> getFields() {
        return this._fields;
    }

    public int getFieldCount() {
        return this._fields.size();
    }

    private void setFields(List<LoadField> list) {
        this._fields = list;
    }

    public void setFields(LoadField[] loadFieldArray) {
        ArrayList<LoadField> arrayList = new ArrayList<LoadField>();
        for (int i = 0; i < loadFieldArray.length; ++i) {
            if (loadFieldArray[i] == null) continue;
            arrayList.add(loadFieldArray[i]);
        }
        this.setFields(arrayList);
    }

    public String getName() {
        return this._name;
    }

    public URL getURL() {
        try {
            return new File(this._name).toURI().toURL();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    public String getShortName() {
        return this._shortName;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public void setName(String string) {
        this._name = string;
        try {
            this._canonicalName = new File(this._name).getCanonicalPath();
            this._type = this._name.substring(this._name.lastIndexOf(".", this._name.length()) + 1);
            this._shortName = new File(this._name).getName();
            if (this._shortName.lastIndexOf(".") > -1) {
                this._shortName = this._shortName.substring(0, this._shortName.lastIndexOf("."));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String getType() {
        return this._type;
    }

    public LoadField getField(int n) {
        if (n < this._fields.size()) {
            return this._fields.get(n);
        }
        return null;
    }

    public LoadField getFieldByName(String string) {
        for (LoadField loadField : this._fields) {
            if (!string.trim().equals(loadField.getName().trim())) continue;
            return loadField;
        }
        return null;
    }

    public LoadField getFirstField() {
        Iterator<LoadField> iterator = this._fields.iterator();
        if (iterator.hasNext()) {
            LoadField loadField = iterator.next();
            return loadField;
        }
        return null;
    }
}

