/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.ArrayList;
import java.util.Locale;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.db.DBUtil;

public class LoadSql {
    private Locale _locale;
    private boolean _useQuotedNames = true;
    private String _schemaName;
    private String _tableName;

    public LoadSql(String string, String string2) {
        this(string, string2, null);
    }

    public LoadSql(String string, String string2, Locale locale) {
        this._schemaName = string;
        this._tableName = string2;
        this._locale = locale;
    }

    public void useQuotedNames(boolean bl) {
        this._useQuotedNames = bl;
    }

    public void setSchemaName(String string) {
        this._schemaName = string;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public String getDeleteStatement() {
        return "delete from " + this.addUser(this.addTableName(this._tableName));
    }

    public String getTruncateStatement() {
        return "truncate table " + this.addUser(this.addTableName(this._tableName));
    }

    public String getInsertStatement(Column[] columnArray, Object[] objectArray, INSERT_FORMAT iNSERT_FORMAT) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (iNSERT_FORMAT != INSERT_FORMAT.SCRIPT) {
            if (iNSERT_FORMAT == INSERT_FORMAT.PREPARE) {
                bl = true;
            } else if (iNSERT_FORMAT == INSERT_FORMAT.ERROR) {
                bl2 = true;
            } else {
                stringBuffer.append("--");
            }
        }
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.addUser(this.addTableName(this._tableName)));
        stringBuffer.append("(");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (i < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        ITypeFormattor iTypeFormattor = null;
        for (n = 0; n < columnArray.length; ++n) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            if (this._useQuotedNames) {
                stringBuffer.append(DBUtil.addDoubleQuote(columnArray[n].getName()));
                continue;
            }
            stringBuffer.append(columnArray[n].getName());
        }
        if (iNSERT_FORMAT == INSERT_FORMAT.COMMENT) {
            stringBuffer.append(")\n-- VALUES ");
        } else if (bl) {
            stringBuffer.append(") VALUES ");
        } else {
            stringBuffer.append(")\nVALUES ");
        }
        if (!bl2) {
            stringBuffer.append("(");
            for (n = 0; n < objectArray2.length; ++n) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                if (bl) {
                    stringBuffer.append("?");
                    continue;
                }
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[n].getType());
                if (iTypeFormattor == null) {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                iTypeFormattor.setLocale(this._locale);
                stringBuffer.append(iTypeFormattor.formatData(objectArray2[n], columnArray[n]));
            }
        }
        if (!bl2) {
            stringBuffer.append(")");
        }
        if (!bl2 && !bl) {
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    private String addUser(String string) {
        return this._schemaName != null && this._schemaName.length() > 0 ? DBUtil.addDoubleQuote(this._schemaName) + "." + string : string;
    }

    protected String addTableName(String string) {
        if (this._useQuotedNames) {
            String[] stringArray = string.split("@");
            String string2 = DBUtil.addDoubleQuote(stringArray[0]);
            if (stringArray.length > 1) {
                string2 = string2 + "@" + stringArray[1];
            }
            return string2;
        }
        return string;
    }

    protected String addDoubleQuote(String string) {
        if (this._useQuotedNames) {
            return DBUtil.addDoubleQuote(string);
        }
        return string;
    }

    public static enum INSERT_FORMAT {
        SCRIPT,
        PREPARE,
        ERROR,
        COMMENT;

    }
}

