/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.LoadService;
import oracle.dbtools.data.loadservice.LoadServiceJdbcBatch;

public class LoadServicesRegistry {
    private static Map<String, Class<? extends LoadService>> s_registry = new HashMap<String, Class<? extends LoadService>>();

    public static synchronized void registerService(LoadService loadService) {
        s_registry.put(loadService.getType().toLowerCase(), loadService.getClass());
    }

    public static synchronized void unregisterService(LoadService loadService) {
        s_registry.remove(loadService.getType().toLowerCase());
    }

    public static synchronized LoadService getService(String string) {
        try {
            return s_registry.get(string.toLowerCase()).newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(LoadServicesRegistry.class.getName()).log(Level.SEVERE, "Unable to instantiate the Data Reader");
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(LoadServicesRegistry.class.getName()).log(Level.SEVERE, "Unable to instantiate the Data Reader");
        }
        return null;
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        return arrayList;
    }

    public static boolean isServiceRegistered(String string) {
        return s_registry.get(string.toLowerCase()) != null;
    }

    static {
        LoadServicesRegistry.registerService(new LoadServiceJdbcBatch());
    }
}

