/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.DataLoadException;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.loadservice.LoadService;
import oracle.dbtools.data.loadservice.LoadSql;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.jdbc.OraclePreparedStatement;

public class LoadServiceJdbcBatch
extends LoadService {
    public static final String SERVICE_TYPE = "JDBC_BATCH";
    private String _insertForErrSql;
    Column[] _loadCols;
    boolean _batchErrInit = false;

    @Override
    public String getType() {
        return SERVICE_TYPE;
    }

    @Override
    protected void doLoad() {
        this.getLogger().log(Level.INFO, "load start");
        int n = this.getLoadParms().getBatchRows();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = this.getLoadParms().getBatchesPerCommit();
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        StringBuffer stringBuffer = null;
        boolean bl = false;
        try {
            int[] nArray;
            Object object2;
            int n6;
            Object[] objectArray;
            LoadSql loadSql = new LoadSql(this.getSchemaName(), this.getTableName(), this.getLoadParms().getLocale());
            loadSql.useQuotedNames(true);
            this.getReader().start();
            if (!this.getReaderParms().isHeader()) {
                objectArray = new String[this.getTable().getColumnCount()];
            } else {
                try {
                    objectArray = this.getReader().getColumnNames();
                }
                catch (DataFormatException dataFormatException) {
                    throw new DataLoadException(dataFormatException.getMessage(), ExitCode.EXIT_SEVERE);
                }
                if (objectArray == null || objectArray.length == 0) {
                    throw new DataLoadException(this.translate("HEADER_NOT_FOUND"), ExitCode.EXIT_SEVERE);
                }
            }
            this._loadCols = new Column[objectArray.length];
            for (n6 = 0; n6 < objectArray.length; ++n6) {
                Object object = object2 = this.getReaderParms().isHeader() ? this.getTable().getColumnByName(this.getColumnName(objectArray[n6])) : this.getTable().getColumnByIndex(n6);
                if (object2 == null) {
                    if (!this.getLoadParms().isUnknownColumnsFail()) continue;
                    throw new DataLoadException(this.translate("UNKNOWN_COL", new Object[]{(String)objectArray[n6]}), ExitCode.EXIT_SEVERE);
                }
                ((Column)object2).setSourceColID(n6);
                if (((Column)object2).getType().equals("DATE")) {
                    ((Column)object2).setFormat(this.getLoadParms().getDataFormat());
                    continue;
                }
                if (((Column)object2).getType().equals("TIMESTAMP")) {
                    ((Column)object2).setFormat(this.getLoadParms().getTimestampFormat());
                    continue;
                }
                if (!((Column)object2).getType().equals("TIMESTAMP WITH TIME ZONE") && !((Column)object2).getType().equals("TIMESTAMP WITH LOCAL TIME ZONE")) continue;
                ((Column)object2).setFormat(this.getLoadParms().getTimestampTZFormat());
            }
            n6 = 0;
            for (Column object4 : this.getTable().getColumns()) {
                if (object4.getSourceColID() != -1) {
                    this._loadCols[n6++] = object4;
                    continue;
                }
                if (!object4.isNullable()) continue;
                throw new DataLoadException(this.translate("OMITTED_COLS"), ExitCode.EXIT_SEVERE);
            }
            object2 = "";
            if (this.getLoadParms().getDeleteRows() != LoadParmsAPI.DELETE_ROWS.FALSE) {
                object2 = this.getLoadParms().getDeleteRows() == LoadParmsAPI.DELETE_ROWS.TRUE ? loadSql.getDeleteStatement() : loadSql.getTruncateStatement();
                PreparedStatement preparedStatement = this.getConnection().prepareStatement((String)object2);
                preparedStatement.executeUpdate();
            }
            object2 = loadSql.getInsertStatement(this._loadCols, objectArray, LoadSql.INSERT_FORMAT.PREPARE);
            if (this.getLoadParms().getResponseFormat() == LoadParmsAPI.RESPONSE_FORMAT.RESPONSE_SQL) {
                this._insertForErrSql = loadSql.getInsertStatement(this._loadCols, objectArray, LoadSql.INSERT_FORMAT.ERROR);
            }
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement((String)object2);
            while (this.checkCanProceed() && this.getReader().hasMoreRows()) {
                stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                try {
                    if (this.isCancelled()) break;
                    try {
                        objectArray = this.getReader().readline();
                    }
                    catch (DataFormatException dataFormatException) {
                        stringBuffer.append("--" + dataFormatException.getMessage() + "\n");
                        objectArray = dataFormatException.getColumns();
                    }
                    if (objectArray != null && (bl = this.getBatchForInsert(this.getTableName(), this._loadCols, objectArray, stringBuffer2, oraclePreparedStatement, stringBuffer))) {
                        arrayList.add(stringBuffer2.toString());
                        ++n3;
                        this.addRowsProcessed();
                    }
                    if (n3 == n || stringBuffer.length() > 0 && n3 > 0) {
                        n5 = n4 + n3 - 1;
                        nArray = oraclePreparedStatement.executeBatch();
                        this.processUpdateCounts(nArray, n3, n4, arrayList);
                        n3 = 0;
                        n5 = n4 = n5 + 1;
                        arrayList.clear();
                        if (--n2 < 1) {
                            this.commitConn();
                            n2 = this.getLoadParms().getBatchesPerCommit();
                        }
                    }
                    if (stringBuffer.length() <= 0) continue;
                    arrayList.add(stringBuffer2.toString());
                    n5 = n4;
                    this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n4, n5, arrayList);
                    arrayList.clear();
                    n5 = ++n4;
                }
                catch (BatchUpdateException batchUpdateException) {
                    this.handleBatchUpdateException(batchUpdateException, n3, n4, n5, arrayList);
                    n3 = 0;
                    n4 = n5 + 1;
                    arrayList.clear();
                    if (stringBuffer == null || stringBuffer.length() <= 0) continue;
                    arrayList.add(stringBuffer2.toString());
                    n5 = n4;
                    this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n4, n5, arrayList);
                    arrayList.clear();
                    n5 = ++n4;
                }
            }
            if (n3 != 0) {
                n5 = n4 + n3 - 1;
                nArray = oraclePreparedStatement.executeBatch();
                this.processUpdateCounts(nArray, n3, n4, arrayList);
            }
        }
        catch (BatchUpdateException batchUpdateException) {
            this.handleBatchUpdateException(batchUpdateException, n3, n4, n5, arrayList);
        }
        catch (SQLException sQLException) {
            this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
            this.getLogger().log(Level.WARNING, sQLException.getMessage());
            this.signalCancel();
        }
        catch (DataLoadException dataLoadException) {
            if (dataLoadException.getMessage() != null & dataLoadException.getMessage().length() > 0) {
                try {
                    this.responseErrorMsg(new String[]{dataLoadException.getMessage()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getLogger().log(Level.WARNING, dataLoadException.getMessage());
            this.setExitCodeHighest(dataLoadException.getExitCode());
            this.signalCancel();
        }
        catch (Exception exception) {
            this.getLogger().log(Level.WARNING, exception.getMessage());
            this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
            this.signalCancel();
        }
    }

    private void handleBatchUpdateException(BatchUpdateException batchUpdateException, int n, int n2, int n3, ArrayList<Object> arrayList) {
        this.setExitCodeHighest(ExitCode.EXIT_WARNING);
        try {
            int[] nArray = batchUpdateException.getUpdateCounts();
            String[] stringArray = new String[2];
            stringArray[0] = this.translate("LOAD_PROGRESS_INS_FAIL2", new Object[]{" " + n2 + " ", " " + n3 + " "});
            if (n == 1) {
                stringArray[0] = this.translate("LOAD_PROGRESS_INS_FAIL", new Object[]{" " + n2 + " "});
            }
            stringArray[1] = batchUpdateException.getMessage().substring(0, batchUpdateException.getMessage().length() - 1);
            this.responseErrorMsg(stringArray);
            this.getLogger().log(Level.INFO, stringArray[0]);
            this.getLogger().log(Level.INFO, stringArray[1]);
            this.processUpdateCounts(nArray, n, n2, arrayList);
            if (!this.checkCanProceed()) {
                this.signalCancel();
            }
        }
        catch (IOException iOException) {
            this.getLogger().log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
            this.signalCancel();
        }
    }

    private void processUpdateCounts(int[] nArray, int n, int n2, ArrayList<Object> arrayList) throws IOException {
        if (nArray == null || nArray.length < 1) {
            int n3 = 0;
            while (n3 < n) {
                this.responseWriteErrRow(n2, (String)arrayList.get(n3));
                ++n3;
                ++n2;
            }
            return;
        }
        boolean bl = false;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] < 0 && nArray[n4] != -2 && nArray[n4] == -3) {
                if (!bl) {
                    bl = true;
                }
                this.responseWriteErrRow(n2, (String)arrayList.get(n4));
            }
            ++n4;
            ++n2;
        }
        if (nArray.length < n) {
            n4 = nArray.length;
            while (n4 < n) {
                this.responseWriteErrRow(n2, (String)arrayList.get(n4));
                ++n4;
                ++n2;
            }
            return;
        }
    }

    private void responseWriteErrRow(int n, String string) throws IOException {
        this.addRowsError();
        String string2 = this.translate("ROW", new Object[]{n});
        if (this.getLoadParms().isResponseFormatSql()) {
            this.responseWrite("--" + string2);
            this.responseWrite(this._insertForErrSql + string);
        } else if (this.getLoadParms().isResponseFormatRaw()) {
            this.responseWrite("#" + this.translate("ERROR") + " " + string2);
            this.responseWrite(string.substring(1, string.length() - 2));
        }
    }

    private boolean getBatchForInsert(String string, Column[] columnArray, Object[] objectArray, StringBuffer stringBuffer, OraclePreparedStatement oraclePreparedStatement, StringBuffer stringBuffer2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (i < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String string2 = "(";
        ITypeFormattor iTypeFormattor = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            String string3;
            iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[i].getType());
            if (iTypeFormattor == null) {
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            iTypeFormattor.setLocale(this.getLoadParms().getLocale());
            iTypeFormattor.setConnection(this.getConnection());
            try {
                stringBuffer.append(string2);
                stringBuffer.append(this.getLoadParms().isResponseFormatRaw() ? objectArray2[i].toString() : iTypeFormattor.formatData(objectArray2[i], columnArray[i]));
                Object object = iTypeFormattor.formatDataForJava(objectArray2[i], columnArray[i]);
                if (object != null && object instanceof String) {
                    string3 = (String)object;
                    if (string3 == null || string3.length() == 0 || string3.equals("''") || string3.equals("NULL")) {
                        oraclePreparedStatement.setNull(i + 1, iTypeFormattor.getSqlType(columnArray[i].getType()));
                    } else {
                        if (columnArray[i].getType().equals("NCHAR") || columnArray[i].getType().equals("NVARCHAR2")) {
                            oraclePreparedStatement.setFormOfUse(i + 1, (short)2);
                        }
                        oraclePreparedStatement.setString(i + 1, string3);
                    }
                } else {
                    oraclePreparedStatement.setObject(i + 1, object, iTypeFormattor.getSqlType(columnArray[i].getType()));
                }
            }
            catch (Exception exception) {
                string3 = exception.getMessage() == null || exception.getMessage().equals("null") ? LoadResources.getString("FMT_ERR") : exception.getMessage();
                stringBuffer2.append(columnArray[i].getName() + ": " + string3 + " ");
            }
            string2 = ",";
        }
        stringBuffer.append(");");
        if (stringBuffer2.length() == 0) {
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                stringBuffer2.append(exception.getMessage());
            }
        }
        return stringBuffer2.length() == 0;
    }
}

