/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dbtools.data.common.Iterables;
import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.data.common.Translatable;

public abstract class Translatables {
    private static final Locale DEFAULT_LOCALIZAITON = new Locale("en");

    private Translatables() {
    }

    public static Locale choose(Iterable<Locale> iterable, Iterable<Locale> iterable2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterables.add(linkedHashSet, iterable2);
        Iterator<Locale> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Locale locale;
            Locale locale2 = locale = iterator.next();
            while (locale2 != Locale.ROOT) {
                if (DEFAULT_LOCALIZAITON.equals(locale2)) {
                    return DEFAULT_LOCALIZAITON;
                }
                if (linkedHashSet.contains(locale2)) {
                    return locale2;
                }
                locale2 = Translatables.parent(locale2);
            }
        }
        return Locale.ROOT;
    }

    public static String format(Translatable translatable, Iterable<Locale> iterable, Object ... objectArray) {
        String string = translatable.toString(iterable);
        return MessageFormat.format(string, objectArray);
    }

    public static ResourceBundle getBundle(Class<?> clazz, Iterable<Locale> iterable) {
        return Translatables.getBundle(clazz.getName(), iterable);
    }

    public static ResourceBundle getBundle(String string, Iterable<Locale> iterable) {
        LinkedHashSet<Locale> linkedHashSet = new LinkedHashSet<Locale>();
        for (Locale locale : iterable) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            Locale locale2 = resourceBundle.getLocale();
            if (NullOrEmpty.nullOrEmpty(locale2.getLanguage())) {
                locale2 = Locale.ROOT;
            }
            linkedHashSet.add(locale2);
        }
        Locale locale = Translatables.choose(iterable, linkedHashSet);
        return ResourceBundle.getBundle(string, locale);
    }

    public static Translatable notTranslatable(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return new NotTranslated(charSequence);
    }

    private static Locale parent(Locale locale) {
        if (!NullOrEmpty.nullOrEmpty(locale.getVariant())) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!NullOrEmpty.nullOrEmpty(locale.getCountry())) {
            return new Locale(locale.getLanguage());
        }
        return Locale.ROOT;
    }

    private static final class NotTranslated
    implements Translatable {
        private final String text;

        private NotTranslated(CharSequence charSequence) {
            this.text = charSequence.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NotTranslated notTranslated = (NotTranslated)object;
            return !(this.text == null ? notTranslated.text != null : !this.text.equals(notTranslated.text));
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public String toString() {
            return this.text;
        }

        @Override
        public String toString(Iterable<Locale> iterable) {
            return this.toString();
        }
    }
}

