/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.dbtools.data.common.HasSize;
import oracle.dbtools.data.common.Iterators;

public class Iterables {
    private Iterables() {
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> iterable) {
        Iterables.add(collection, iterable, false);
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> iterable, boolean bl) {
        Iterators.add(collection, iterable == null ? null : iterable.iterator(), bl);
    }

    public static String asString(Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(Iterables.join(iterable, ", "));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static <T> int compare(Iterable<? extends T> iterable, Iterable<? extends T> iterable2) {
        return Iterators.compare(iterable.iterator(), iterable2.iterator());
    }

    public static <T> int compare(Iterable<T> iterable, Iterable<T> iterable2, Comparator<T> comparator) {
        return Iterators.compare(iterable.iterator(), iterable2.iterator(), comparator);
    }

    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> boolean equals(Iterable<? extends T> iterable, Iterable<? extends T> iterable2) {
        return Iterators.equals(iterable.iterator(), iterable2.iterator());
    }

    public static final <T> T first(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        return Iterators.nextOrNull(iterable.iterator());
    }

    public static final <T> Iterable<T> iterable(Iterator<? extends T> iterator) {
        ArrayList arrayList = new ArrayList();
        Iterators.add(arrayList, iterator);
        return arrayList;
    }

    public static final <T> Iterable<T> iterable(T ... TArray) {
        return new ArrayIterable(TArray);
    }

    public static String join(Iterable<?> iterable, String string) {
        return Iterators.join(iterable.iterator(), string);
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> iterable, Iterable<? extends T> iterable2) {
        ArrayList arrayList = new ArrayList();
        Iterables.add(arrayList, iterable2);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterables.add(linkedHashSet, iterable);
        for (T t : iterable) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                boolean bl = t == e || t.equals(e);
                if (!bl) continue;
                iterator.remove();
            }
        }
        linkedHashSet.addAll(arrayList);
        return linkedHashSet;
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof HasSize) {
            return ((HasSize)((Object)iterable)).size();
        }
        int n = 0;
        for (Object obj : iterable) {
            ++n;
        }
        return n;
    }

    public static final <T> Iterable<T> sort(Iterable<T> iterable, Comparator<T> comparator) {
        ArrayList arrayList = new ArrayList();
        Iterables.add(arrayList, iterable);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private static final class ArrayIterable<T>
    implements Iterable<T>,
    HasSize {
        private final T[] items;

        private ArrayIterable(T[] TArray) {
            this.items = TArray;
        }

        public boolean equals(Object object) {
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                return Iterables.equals(this, iterable);
            }
            return super.equals(object);
        }

        public int hashCode() {
            return Arrays.hashCode(this.items);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.iterator(this.items);
        }

        @Override
        public int size() {
            return this.items.length;
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }
}

