/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class MetaResource {
    private final String m_resourcePath;
    private final ClassLoader m_classLoader;
    private URL m_resourceURL;

    public MetaResource(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        if (string == null) {
            throw new NullPointerException("null resource path");
        }
        this.m_classLoader = classLoader;
        this.m_resourcePath = string;
    }

    public URL toURL() {
        if (this.m_resourceURL == null) {
            this.m_resourceURL = this.m_classLoader.getResource(this.m_resourcePath);
        }
        return this.m_resourceURL;
    }

    public InputStream getInputStream() throws IOException {
        URL uRL = this.toURL();
        if (uRL != null) {
            return uRL.openStream();
        }
        return null;
    }

    public String getResourcePath() {
        return this.m_resourcePath;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public void setUrl(URL uRL) {
        this.m_resourceURL = uRL;
    }
}

