/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IndependentAttribute;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.util.Service;

public class MaterializedPredicate
extends IndependentAttribute
implements Predicate {
    private Map<String, Integer> attributePositions = new HashMap<String, Integer>();
    ArrayList<String> attributes;
    ArrayList<ParseNode[]> tuples = new ArrayList();
    List<LexerToken> src;

    public MaterializedPredicate(ArrayList<String> arrayList, List<LexerToken> list, String string) {
        super(string, null);
        this.attributes = arrayList;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.attributePositions.put(arrayList.get(i), i);
        }
        this.src = list;
    }

    public MaterializedPredicate(String string, MaterializedPredicate materializedPredicate) {
        super(string, null);
        this.attributes = materializedPredicate.attributes;
        this.attributePositions = materializedPredicate.attributePositions;
        this.tuples = materializedPredicate.tuples;
        this.src = materializedPredicate.src;
    }

    @Override
    public MaterializedPredicate getContent() {
        return this;
    }

    @Override
    public boolean eval(Map<String, ParseNode> map, List<LexerToken> list) {
        throw new AssertionError((Object)"N/A");
    }

    @Override
    public void variables(Set<String> set, boolean bl) {
        set.addAll(this.attributes);
    }

    @Override
    public Predicate isRelated(String string, String string2, Map<String, Attribute> map) {
        throw new AssertionError((Object)"N/A");
    }

    public void add(Map<String, ParseNode> map) {
        ParseNode[] parseNodeArray = new ParseNode[this.attributes.size()];
        for (int i = 0; i < parseNodeArray.length; ++i) {
            parseNodeArray[i] = map.get(this.attributes.get(i));
        }
        this.addContent(parseNodeArray);
    }

    private void add(ParseNode[] parseNodeArray) {
        this.addContent(parseNodeArray);
    }

    void addContent(ParseNode[] parseNodeArray) {
        for (ParseNode[] parseNodeArray2 : this.tuples) {
            boolean bl = true;
            for (int i = 0; i < parseNodeArray2.length; ++i) {
                if (parseNodeArray2[i].from == parseNodeArray[i].from && parseNodeArray2[i].to == parseNodeArray[i].to) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return;
        }
        this.tuples.add(parseNodeArray);
    }

    public ParseNode getAttribute(int n, String string) {
        ParseNode[] parseNodeArray = this.tuples.get(n);
        Integer n2 = this.attributePositions.get(string);
        if (n2 == null) {
            throw new AssertionError((Object)("Missing " + this.name + "." + string));
        }
        return parseNodeArray[n2];
    }

    public String getAttribute(int n) {
        return this.attributes.get(n);
    }

    public Integer getAttribute(String string) {
        return this.attributePositions.get(string);
    }

    public int arity() {
        return this.attributes.size();
    }

    public int cardinality() {
        return this.tuples.size();
    }

    @Override
    public void initContent(ParseNode parseNode, List<LexerToken> list, Map<String, Attribute> map, String string) {
    }

    @Override
    int getLimits() {
        return this.tuples.size();
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("[");
        for (n2 = 0; n2 < this.attributes.size(); ++n2) {
            stringBuilder.append((n2 > 0 ? "         " : "") + this.attributes.get(n2));
        }
        stringBuilder.append("]\n");
        for (n2 = 0; n2 < this.tuples.size(); ++n2) {
            boolean bl = true;
            for (int i = 0; i < this.attributes.size(); ++i) {
                String string = "N/A (null)";
                ParseNode parseNode = this.tuples.get(n2)[i];
                if (parseNode != null) {
                    string = "[" + this.tuples.get((int)n2)[i].from + "," + this.tuples.get((int)n2)[i].to + ")";
                }
                stringBuilder.append(bl ? Service.identln(n, " ") : "  ");
                stringBuilder.append(string);
                stringBuilder.append(" ");
                if (parseNode != null) {
                    stringBuilder.append(this.mnemonics(parseNode.from, parseNode.to));
                }
                bl = false;
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String mnemonics(int n, int n2) {
        if (n + 1 == n2) {
            return Service.padln(8 < this.src.get((int)n).content.length() ? this.src.get((int)n).content.substring(0, 8) : this.src.get((int)n).content, 8);
        }
        StringBuilder stringBuilder = new StringBuilder("\"");
        for (int i = n; i < n2 && i < n + 8; ++i) {
            stringBuilder.append(this.src.get((int)i).content.charAt(0));
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    @Override
    public MaterializedPredicate eval(Parsed parsed) {
        return this;
    }

    public static MaterializedPredicate union(MaterializedPredicate materializedPredicate, MaterializedPredicate materializedPredicate2) {
        ParseNode[] parseNodeArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(materializedPredicate.attributes);
        arrayList.retainAll(materializedPredicate2.attributes);
        MaterializedPredicate materializedPredicate3 = new MaterializedPredicate(arrayList, materializedPredicate.src, null);
        for (ParseNode[] parseNodeArray2 : materializedPredicate.tuples) {
            parseNodeArray = new ParseNode[arrayList.size()];
            for (String string : materializedPredicate3.attributes) {
                parseNodeArray[materializedPredicate3.attributePositions.get((Object)string).intValue()] = parseNodeArray2[materializedPredicate.attributePositions.get(string)];
            }
            materializedPredicate3.addContent(parseNodeArray);
        }
        for (ParseNode[] parseNodeArray2 : materializedPredicate2.tuples) {
            parseNodeArray = new ParseNode[arrayList.size()];
            for (String string : materializedPredicate3.attributes) {
                parseNodeArray[materializedPredicate3.attributePositions.get((Object)string).intValue()] = parseNodeArray2[materializedPredicate2.attributePositions.get(string)];
            }
            materializedPredicate3.addContent(parseNodeArray);
        }
        return materializedPredicate3;
    }

    public static MaterializedPredicate join(MaterializedPredicate materializedPredicate, MaterializedPredicate materializedPredicate2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(materializedPredicate.attributes);
        for (String object : materializedPredicate2.attributes) {
            if (materializedPredicate.attributes.contains(object)) continue;
            arrayList.add(object);
        }
        MaterializedPredicate materializedPredicate3 = new MaterializedPredicate(arrayList, materializedPredicate.src, null);
        for (ParseNode[] parseNodeArray : materializedPredicate.tuples) {
            for (ParseNode[] parseNodeArray2 : materializedPredicate2.tuples) {
                ParseNode[] parseNodeArray3 = new ParseNode[arrayList.size()];
                for (String string : materializedPredicate3.attributes) {
                    Integer n;
                    Integer n2;
                    Integer n3 = n2 = materializedPredicate.attributePositions.get(string);
                    Integer n4 = n = materializedPredicate2.attributePositions.get(string);
                    Integer n5 = materializedPredicate3.attributePositions.get(string);
                    if (n3 == null) {
                        parseNodeArray3[n5.intValue()] = parseNodeArray2[n];
                        continue;
                    }
                    if (n4 == null) {
                        parseNodeArray3[n5.intValue()] = parseNodeArray[n2];
                        continue;
                    }
                    if (parseNodeArray2[n.intValue()].from != parseNodeArray[n2.intValue()].from || parseNodeArray2[n.intValue()].to != parseNodeArray[n2.intValue()].to) {
                        parseNodeArray3 = null;
                        break;
                    }
                    parseNodeArray3[n5.intValue()] = parseNodeArray[n2];
                }
                if (parseNodeArray3 == null) continue;
                materializedPredicate3.addContent(parseNodeArray3);
            }
        }
        return materializedPredicate3;
    }

    public static MaterializedPredicate difference(MaterializedPredicate materializedPredicate, MaterializedPredicate materializedPredicate2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(materializedPredicate.attributes);
        MaterializedPredicate materializedPredicate3 = new MaterializedPredicate(arrayList, materializedPredicate.src, null);
        for (ParseNode[] parseNodeArray : materializedPredicate.tuples) {
            boolean bl = false;
            for (ParseNode[] parseNodeArray2 : materializedPredicate2.tuples) {
                boolean bl2 = true;
                for (String string : materializedPredicate2.attributes) {
                    Integer n = materializedPredicate2.attributePositions.get(string);
                    Integer n2 = materializedPredicate.attributePositions.get(string);
                    if (n2 == null || parseNodeArray2[n.intValue()].from == parseNodeArray[n2.intValue()].from && parseNodeArray2[n.intValue()].to == parseNodeArray[n2.intValue()].to) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            materializedPredicate3.addContent(parseNodeArray);
        }
        return materializedPredicate3;
    }

    public void trimAttributes() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            String string = this.attributes.get(i);
            int n = string.lastIndexOf(46);
            if (0 < n) {
                string = string.substring(n + 1);
            }
            if (hashMap.containsKey(string) && 0 < n) {
                return;
            }
            hashMap.put(string, i);
            arrayList.add(string);
        }
        this.attributePositions = hashMap;
        this.attributes = arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static MaterializedPredicate filteredCartesianProduct(MaterializedPredicate materializedPredicate, MaterializedPredicate materializedPredicate2, Predicate predicate, Map<String, Attribute> map, ParseNode parseNode) {
        ParseNode[] parseNodeArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String object : map.keySet()) {
            parseNodeArray2 = map.get(object);
            for (String string : materializedPredicate.attributes) {
                void var10_13;
                if (materializedPredicate.name != null && string.indexOf(46) < 0) {
                    String string2 = materializedPredicate.name + '.' + string;
                }
                if (!parseNodeArray2.isDependent((String)var10_13, map)) continue;
                arrayList.add(object);
                continue block0;
            }
        }
        block2: for (String string : map.keySet()) {
            if (arrayList.contains(string)) continue;
            parseNodeArray2 = map.get(string);
            for (String string3 : materializedPredicate2.attributes) {
                void var10_19;
                if (materializedPredicate2.name != null && string3.indexOf(46) < 0) {
                    String string4 = materializedPredicate2.name + '.' + string3;
                }
                if (!parseNodeArray2.isDependent((String)var10_19, map)) continue;
                arrayList.add(string);
                continue block2;
            }
        }
        MaterializedPredicate materializedPredicate3 = new MaterializedPredicate(arrayList, materializedPredicate.src, null);
        for (ParseNode[] parseNodeArray2 : materializedPredicate.tuples) {
            block5: for (ParseNode[] parseNodeArray3 : materializedPredicate2.tuples) {
                Integer n;
                HashMap<String, ParseNode> hashMap = new HashMap<String, ParseNode>();
                ParseNode[] parseNodeArray4 = new ParseNode[arrayList.size()];
                for (String string : materializedPredicate3.attributes) {
                    if (materializedPredicate.name != null && string.startsWith(materializedPredicate.name)) {
                        n = materializedPredicate.attributePositions.get(string.substring(materializedPredicate.name.length() + 1));
                        if (n == null) continue;
                        hashMap.put(string, parseNodeArray2[n]);
                        continue;
                    }
                    if (materializedPredicate2.name != null && string.startsWith(materializedPredicate2.name)) {
                        n = materializedPredicate2.attributePositions.get(string.substring(materializedPredicate2.name.length() + 1));
                        if (n == null) continue;
                        hashMap.put(string, parseNodeArray3[n]);
                        continue;
                    }
                    n = materializedPredicate.attributePositions.get(string);
                    if (n != null) {
                        hashMap.put(string, parseNodeArray2[n]);
                        continue;
                    }
                    n = materializedPredicate2.attributePositions.get(string);
                    if (n == null) continue;
                    hashMap.put(string, parseNodeArray3[n]);
                }
                for (String string : materializedPredicate3.attributes) {
                    if (!MaterializedPredicate.assignDependencyChain(string, hashMap, map, parseNode)) continue block5;
                    n = materializedPredicate3.attributePositions.get(string);
                    parseNodeArray4[n.intValue()] = (ParseNode)hashMap.get(string);
                }
                if (!predicate.eval(hashMap, materializedPredicate.src)) continue;
                materializedPredicate3.addContent(parseNodeArray4);
            }
        }
        return materializedPredicate3;
    }

    /*
     * WARNING - void declaration
     */
    public static MaterializedPredicate filter(MaterializedPredicate materializedPredicate, Predicate predicate, Map<String, Attribute> map, ParseNode parseNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String object : map.keySet()) {
            ParseNode[] parseNodeArray = map.get(object);
            for (String string : materializedPredicate.attributes) {
                void var9_10;
                if (materializedPredicate.name != null && string.indexOf(46) < 0) {
                    String string2 = materializedPredicate.name + '.' + string;
                }
                if (!parseNodeArray.isDependent((String)var9_10, map)) continue;
                arrayList.add(object);
                continue block0;
            }
        }
        MaterializedPredicate materializedPredicate2 = new MaterializedPredicate(arrayList, materializedPredicate.src, null);
        for (ParseNode[] parseNodeArray : materializedPredicate.tuples) {
            HashMap hashMap = new HashMap();
            ParseNode[] parseNodeArray2 = new ParseNode[arrayList.size()];
            for (String string : materializedPredicate2.attributes) {
                Object object;
                if (materializedPredicate.name != null && string.startsWith(materializedPredicate.name)) {
                    object = materializedPredicate.attributePositions.get(string.substring(materializedPredicate.name.length() + 1));
                    if (object == null) continue;
                    hashMap.put(string, parseNodeArray[(Integer)object]);
                    continue;
                }
                object = materializedPredicate.attributePositions.get(string);
                if (object == null) continue;
                hashMap.put(string, parseNodeArray[(Integer)object]);
            }
            boolean bl = false;
            for (Object object : materializedPredicate2.attributes) {
                if (!MaterializedPredicate.assignDependencyChain((String)object, hashMap, map, parseNode)) {
                    bl = true;
                    break;
                }
                Integer n = materializedPredicate2.attributePositions.get(object);
                parseNodeArray2[n.intValue()] = (ParseNode)hashMap.get(object);
            }
            if (bl || !predicate.eval(hashMap, materializedPredicate.src)) continue;
            materializedPredicate2.addContent(parseNodeArray2);
        }
        return materializedPredicate2;
    }

    static boolean assignDependencyChain(String string, Map<String, ParseNode> map, Map<String, Attribute> map2, ParseNode parseNode) {
        ParseNode parseNode2 = map.get(string);
        if (parseNode2 != null) {
            return true;
        }
        Attribute attribute = map2.get(string);
        if (attribute instanceof MaterializedPredicate) {
            return true;
        }
        Attribute attribute2 = attribute.referredTo(map2);
        if (attribute2 == null) {
            return true;
        }
        if (!MaterializedPredicate.assignDependencyChain(attribute2.name, map, map2, parseNode)) {
            return false;
        }
        ParseNode parseNode3 = attribute.navigate(map, parseNode);
        if (parseNode3 == null) {
            return false;
        }
        map.put(attribute.name, parseNode3);
        return true;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        throw new AssertionError((Object)"Not supposed to be called");
    }
}

