/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.PosType;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

public class IndependentAttribute
extends Attribute {
    Map<String, Predicate> db;
    private MaterializedPredicate content;
    private Predicate failfastFilter = null;

    public IndependentAttribute(String string, Map<String, Predicate> map) {
        this.name = string;
        this.db = map;
    }

    public MaterializedPredicate getContent() {
        return this.content;
    }

    public void initContent(ParseNode parseNode, List<LexerToken> list, Map<String, Attribute> map, String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name);
        for (String object2 : map.keySet()) {
            object = map.get(object2);
            if (arrayList.contains(object2) || !((Attribute)object).isDependent(this.name, map)) continue;
            arrayList.add(object2);
        }
        this.content = new MaterializedPredicate(arrayList, list, null);
        block1: for (ParseNode parseNode2 : parseNode.descendants()) {
            object = new HashMap();
            object.put(this.name, parseNode2);
            for (String string2 : arrayList) {
                if (MaterializedPredicate.assignDependencyChain(string2, (Map<String, ParseNode>)object, map, parseNode)) continue;
                continue block1;
            }
            if (!this.evalUnaryPredicates(map, string, (Map<String, ParseNode>)object, parseNode, list)) continue;
            this.content.add((Map<String, ParseNode>)object);
        }
    }

    int getLimits() {
        return this.content.cardinality();
    }

    void putFilter(Predicate predicate) {
        this.failfastFilter = predicate;
    }

    private boolean evalUnaryPredicates(Map<String, Attribute> map, String string, Map<String, ParseNode> map2, ParseNode parseNode, List<LexerToken> list) {
        if (this.failfastFilter == null) {
            Predicate predicate = this.db.get(string);
            this.failfastFilter = this.unaryConjunctedPred(map, predicate);
        }
        return this.failfastFilter.eval(map2, list);
    }

    private Predicate unaryConjunctedPred(Map<String, Attribute> map, Predicate predicate) {
        LinkedList<Predicate> linkedList = new LinkedList<Predicate>();
        for (String object : map.keySet()) {
            Attribute attribute = map.get(object);
            if (!attribute.isDependent(this.name, map)) continue;
            this.findUnaryConjuncts(linkedList, predicate, attribute.name);
        }
        Object object = new True();
        for (Predicate predicate2 : linkedList) {
            object = this.appendProposition(predicate2, (Predicate)object);
        }
        return object;
    }

    private Predicate appendProposition(Predicate predicate, Predicate predicate2) {
        return new CompositeExpr(predicate, predicate2, Oper.CONJUNCTION);
    }

    private void findUnaryConjuncts(List<Predicate> list, Predicate predicate, String string) {
        if (predicate instanceof CompositeExpr) {
            CompositeExpr compositeExpr = (CompositeExpr)predicate;
            if (compositeExpr.oper == Oper.CONJUNCTION) {
                this.findUnaryConjuncts(list, compositeExpr.lft, string);
                this.findUnaryConjuncts(list, compositeExpr.rgt, string);
            }
            if (compositeExpr.oper == Oper.DISJUNCTION) {
                this.addDisjunct(compositeExpr, list, string);
            }
        } else if (predicate instanceof NodeContent) {
            NodeContent nodeContent = (NodeContent)predicate;
            if (nodeContent.nodeVar.equals(string)) {
                list.add(nodeContent);
            }
        } else if (predicate instanceof PositionalRelation) {
            PositionalRelation positionalRelation = (PositionalRelation)predicate;
            if (positionalRelation.tA == PosType.BINDVAR && positionalRelation.b.equals(string) || positionalRelation.tB == PosType.BINDVAR && positionalRelation.a.equals(string)) {
                list.add(positionalRelation);
            }
        } else if (predicate instanceof NodeMatchingSrc) {
            NodeMatchingSrc nodeMatchingSrc = (NodeMatchingSrc)predicate;
            if (nodeMatchingSrc.nodeVar.equals(string)) {
                list.add(nodeMatchingSrc);
            }
        }
    }

    private void addDisjunct(CompositeExpr compositeExpr, List<Predicate> list, String string) {
        IdentedPredicate identedPredicate;
        IdentedPredicate identedPredicate2 = null;
        IdentedPredicate identedPredicate3 = null;
        if (compositeExpr.lft instanceof NodeContent) {
            identedPredicate = (NodeContent)compositeExpr.lft;
            if (identedPredicate.nodeVar.equals(string)) {
                identedPredicate2 = identedPredicate;
            }
        }
        if (compositeExpr.lft instanceof PositionalRelation) {
            identedPredicate = (PositionalRelation)compositeExpr.lft;
            if (((PositionalRelation)identedPredicate).tA == PosType.BINDVAR && ((PositionalRelation)identedPredicate).b.equals(string) || ((PositionalRelation)identedPredicate).tB == PosType.BINDVAR && ((PositionalRelation)identedPredicate).a.equals(string)) {
                identedPredicate2 = identedPredicate;
            }
        }
        if (compositeExpr.lft instanceof NodeMatchingSrc) {
            identedPredicate = (NodeMatchingSrc)compositeExpr.lft;
            if (((NodeMatchingSrc)identedPredicate).nodeVar.equals(string)) {
                identedPredicate2 = identedPredicate;
            }
        }
        if (compositeExpr.rgt instanceof NodeContent) {
            identedPredicate = (NodeContent)compositeExpr.rgt;
            if (identedPredicate.nodeVar.equals(string)) {
                identedPredicate3 = identedPredicate;
            }
        }
        if (compositeExpr.rgt instanceof PositionalRelation) {
            identedPredicate = (PositionalRelation)compositeExpr.rgt;
            if (((PositionalRelation)identedPredicate).tA == PosType.BINDVAR && ((PositionalRelation)identedPredicate).b.equals(string) || ((PositionalRelation)identedPredicate).tB == PosType.BINDVAR && ((PositionalRelation)identedPredicate).a.equals(string)) {
                identedPredicate3 = identedPredicate;
            }
        }
        if (compositeExpr.rgt instanceof NodeMatchingSrc) {
            identedPredicate = (NodeMatchingSrc)compositeExpr.rgt;
            if (((NodeMatchingSrc)identedPredicate).nodeVar.equals(string)) {
                identedPredicate3 = identedPredicate;
            }
        }
        if (identedPredicate2 != null && identedPredicate3 != null) {
            list.add(new CompositeExpr(compositeExpr.lft, compositeExpr.rgt, Oper.DISJUNCTION));
        }
    }

    @Override
    ParseNode navigate(Map<String, ParseNode> map, ParseNode parseNode) {
        return null;
    }

    @Override
    Attribute referredTo(Map<String, Attribute> map) {
        return null;
    }
}

