/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PerThread;
import oracle.dbtools.common.util.Throwables;

public abstract class ResourceTracker {
    private static boolean enabled = false;
    private static final Log LOG = Log.get(ResourceTracker.class);
    private static final PerThread<Resources> resources = new PerThread();

    public static void dumpAndClearLeaks() {
        try {
            ResourceTracker.dumpLeaks(System.err);
        }
        catch (IOException e) {
            LOG.fine(e);
        }
        resources.teardownThread();
    }

    public static void dumpLeaks(PrintStream s) throws IOException {
        if (enabled && !ResourceTracker.getResources().isEmpty()) {
            s.println(ResourceTracker.getResources().size() + " resources not closed in thread: " + Thread.currentThread());
            HashSet<Map.Entry<Object, Resource>> entries = new HashSet<Map.Entry<Object, Resource>>(ResourceTracker.getResources().entrySet());
            for (Map.Entry entry : entries) {
                Object r = entry.getKey();
                s.print("Resource:\n\t");
                try {
                    if (r != null && Proxy.isProxyClass(r.getClass())) {
                        Class<?>[] interfaces = r.getClass().getInterfaces();
                        if (interfaces != null && interfaces.length > 0) {
                            s.println(interfaces[0].getName());
                        } else {
                            s.println(r);
                        }
                    } else {
                        s.println(r);
                    }
                }
                catch (Exception e) {
                    s.println(r.getClass().getName() + "@" + Integer.toHexString(r.hashCode()));
                }
                s.print("Id:\n\t");
                if (entry != null && entry.getValue() != null) {
                    s.print(((Resource)entry.getValue()).first());
                }
                s.println("\nCreated at:\n");
                Throwables.stackTrace((Appendable)s, (StackTraceElement[])((Resource)entry.getValue()).second());
                Closeables.close(r);
            }
        }
    }

    public static void release(Object resource) {
        if (resource != null && resources.isSetup()) {
            ResourceTracker.getResources().remove(resource);
        }
    }

    public static void reset() {
        resources.teardownThread();
        resources.setupThread(new Resources());
    }

    public static void setup() {
    }

    public static void teardown() {
    }

    public static InputStream track(InputStream in) {
        if (enabled) {
            return new TrackedInputStream(in);
        }
        return in;
    }

    public static void track(Object resource) {
        if (enabled) {
            ResourceTracker.getResources().put(resource, Thread.currentThread().getStackTrace());
        }
    }

    public static OutputStream track(OutputStream out) {
        return new TrackedOuputStream(out);
    }

    private static Resources getResources() {
        return resources.get();
    }

    private static long id(Object in) {
        if (in instanceof TrackedResource) {
            return ((TrackedResource)in).id();
        }
        return ResourceTracker.getResources().id(in);
    }

    private static class TrackedOuputStream
    extends FilterOutputStream
    implements TrackedResource {
        TrackedOuputStream(OutputStream out) {
            super(out);
            ResourceTracker.track((Object)out);
        }

        @Override
        public void close() throws IOException {
            ResourceTracker.release(this.out);
            super.close();
        }

        @Override
        public long id() {
            return ResourceTracker.id(this.out);
        }
    }

    private static class TrackedInputStream
    extends FilterInputStream
    implements TrackedResource {
        protected TrackedInputStream(InputStream in) {
            super(in);
            ResourceTracker.track((Object)in);
        }

        @Override
        public void close() throws IOException {
            ResourceTracker.release(this.in);
            super.close();
        }

        @Override
        public long id() {
            return ResourceTracker.id(this.in);
        }
    }

    private static final class Resources
    implements Closeable {
        private long id = 0L;
        private final Map<Object, Resource> resources = new IdentityHashMap<Object, Resource>();

        private Resources() {
        }

        @Override
        public void close() {
            this.resources.clear();
        }

        public Set<Map.Entry<Object, Resource>> entrySet() {
            return this.resources.entrySet();
        }

        public long id(Object in) {
            Resource r = this.resources.get(in);
            return r == null ? -1L : (Long)r.first();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void remove(Object resource) {
            Resource removed = this.resources.remove(resource);
            if (removed != null && LOG.isLoggable(Level.FINEST)) {
                LOG.finest("released" + resource);
            }
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            return "Resources [id=" + this.id + ", resources=" + this.resources + "]";
        }

        void put(Object resource, StackTraceElement[] stack) {
            this.resources.put(resource, new Resource(++this.id, stack));
        }
    }

    private static final class Resource
    extends Pair<Long, StackTraceElement[]> {
        Resource(long id, StackTraceElement[] stack) {
            super(id, stack);
        }
    }

    public static interface TrackedResource {
        public long id();
    }
}

