/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private T item;
    private final boolean nullIndicatesEnd;
    private boolean finished = false;
    private boolean started = false;

    protected AbstractIterator() {
        this(true);
    }

    protected AbstractIterator(boolean nullIndicatesEnd) {
        this.nullIndicatesEnd = nullIndicatesEnd;
    }

    @Override
    public final boolean hasNext() {
        this.start();
        return !this.finished;
    }

    @Override
    public final T next() {
        this.start();
        T next = this.item;
        this.item = this._advance();
        return next;
    }

    @Override
    @Deprecated
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract T advance();

    protected final T eos() {
        this.finished = true;
        return null;
    }

    private final T _advance() {
        T item = this.advance();
        if (item == null && this.nullIndicatesEnd) {
            return this.eos();
        }
        return item;
    }

    private void start() {
        if (!this.started) {
            this.item = this._advance();
            this.started = true;
        }
    }
}

