/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.EdgeFormatter;
import oracle.dbtools.common.graph.TextRenderer;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.Visitor;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Transform;

public class GraphVizDiagram<V, E>
extends TextRenderer<V, E> {
    public GraphVizDiagram(EdgeChecker<V, E> edgeChecker, EdgeFormatter<V, E> edgeFormatter, Transform<V, String> vertexFormatter) {
        super(edgeChecker, edgeFormatter, vertexFormatter);
    }

    @Override
    protected Visitor<V, E> newInstance() {
        return new Renderer(this);
    }

    private static class Renderer<V, E>
    extends TextRenderer.RendererBase<V, E> {
        private final Set<Vertex<V, E>> orphans = new LinkedHashSet<Vertex<V, E>>();
        private final StringBuilder text = new StringBuilder();

        private Renderer(GraphVizDiagram<V, E> diagram) {
            super(diagram);
            this.text.append("digraph g {\n");
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder(this.text);
            for (Vertex<V, E> orphan : this.orphans) {
                b.append("\t");
                b.append(this.vertexToString(orphan.value()));
                b.append(";\n");
            }
            b.append("}");
            return b.toString();
        }

        @Override
        public void visit(Vertex<V, E> vertex) {
            if (NullOrEmpty.nullOrEmpty(vertex.edges())) {
                this.orphans.add(vertex);
            }
            V from = vertex.value();
            for (Edge<V, E> edge : vertex.edges()) {
                this.orphans.remove(edge.destination());
                E using = edge.value();
                V to = edge.destination().value();
                this.text.append("\t");
                this.text.append(this.vertexToString(from));
                this.text.append(" -> ");
                this.text.append(this.vertexToString(to));
                this.text.append(" [");
                if (!this.edgeChecker.follow(from, using, to)) {
                    this.text.append("style=dashed, ");
                }
                this.text.append("label=\"");
                this.text.append(this.edgeToString(using, to));
                this.text.append("\"];\n");
            }
        }
    }
}

