/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.common.builder.BuilderBase;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.graph.DepthFirstTraversal;
import oracle.dbtools.common.graph.DirectedGraphCycleException;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.EdgeFormatter;
import oracle.dbtools.common.graph.EdgeImpl;
import oracle.dbtools.common.graph.GraphPaths;
import oracle.dbtools.common.graph.GraphVizDiagram;
import oracle.dbtools.common.graph.Path;
import oracle.dbtools.common.graph.TextRenderer;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.VertexImpl;
import oracle.dbtools.common.graph.Visitor;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.HasSize;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;

public class DirectedGraph<V, E>
implements Iterable<Vertex<V, E>>,
HasSize,
GraphPaths<V, E> {
    private final Iterable<Path<V, E>> NO_PATHS = Iterables.empty();
    private final Set<Vertex<V, E>> roots;
    private final TextRenderer<V, E> textRenderer;
    private final AssociativeArray<V, Vertex<V, E>> vertices;
    private static final Pair<?, ?> NOTHING = Pair.pair(null, null);

    DirectedGraph(AssociativeArray<V, Vertex<V, E>> vertices, Set<Vertex<V, E>> roots, TextRenderer<V, E> textRenderer) {
        this.vertices = vertices;
        this.roots = roots;
        this.textRenderer = textRenderer;
    }

    public void accept(Visitor<V, E> visitor, V start) {
        Vertex<V, E> vertex = this.internalVertex(start);
        if (visitor == null || vertex == null) {
            throw new IllegalArgumentException();
        }
        new DepthFirstTraversal<V, E>(visitor, this.textRenderer).accept(vertex);
    }

    public boolean contains(V value) {
        return this.vertex(value) != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedGraph other = (DirectedGraph)obj;
        return !(this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Vertex<V, E>> iterator() {
        return this.roots().iterator();
    }

    @Override
    public Path.Builder<V, E> pathBuilder(V start) {
        return this.pathBuilder(this.internalVertex(start));
    }

    @Override
    public Path.Builder<V, E> pathBuilder(Vertex<V, E> start) {
        Vertex<V, E> vertex = start;
        return new Path.Builder<V, E>(vertex, this.textRenderer);
    }

    @Override
    public Iterable<Path<V, E>> paths(V from, V to) {
        return this.paths(from, to, this.textRenderer.edgeChecker());
    }

    @Override
    public Iterable<Path<V, E>> paths(V from, V to, EdgeChecker<V, E> edgeChecker) {
        ArrayList<Path<V, E>> paths = new ArrayList<Path<V, E>>();
        Vertex<V, E> start = this.internalVertex(from);
        Vertex<V, E> finish = this.internalVertex(to);
        if (start == null || finish == null) {
            return this.NO_PATHS;
        }
        Path.Builder<V, E> currentPath = this.pathBuilder(start);
        this.paths(paths, currentPath, start, finish, edgeChecker);
        return paths;
    }

    public Set<Vertex<V, E>> roots() {
        return this.roots;
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    public TextRenderer<V, E> textRenderer() {
        return this.textRenderer;
    }

    public String toString() {
        Visitor<V, E> renderer = this.textRenderer.renderer();
        DepthFirstTraversal<V, E> traversal = new DepthFirstTraversal<V, E>(renderer, this.textRenderer);
        traversal.accept(AssociativeArrays.values(this.vertices));
        return renderer.toString();
    }

    public Vertex<V, E> vertex(V value) {
        return this.internalVertex(value);
    }

    public Iterable<Vertex<V, E>> vertices() {
        return AssociativeArrays.values(this.vertices);
    }

    Vertex<V, E> internalVertex(V value) {
        return this.vertices.get(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paths(List<Path<V, E>> paths, Path.Builder<V, E> current, Vertex<V, E> start, Vertex<V, E> finish, EdgeChecker<V, E> edgeChecker) {
        for (Edge<V, E> edge : start.edges()) {
            if (!edgeChecker.follow(start.value(), edge.value(), edge.destination().value())) continue;
            Vertex<V, E> target = edge.destination();
            if (current.contains(target.value())) {
                return;
            }
            if (finish.equals(target)) {
                paths.add(current.push(edge).build());
                current.pop();
                continue;
            }
            try {
                current.push(edge);
                this.paths(paths, current, target, finish, edgeChecker);
            }
            finally {
                current.pop();
            }
        }
    }

    public static final <V, E> EdgeChecker<V, E> alwaysFollow() {
        return new AlwaysFollow();
    }

    public static <V, E> Builder<V, E> builder() {
        return new Builder(null);
    }

    public static <V, E> Builder<V, E> builder(DirectedGraph<V, E> graph) {
        return new Builder(graph);
    }

    private static <V, E> boolean isConnectedToNothing(MultiAssociativeArray<V, E> vertices, V vertex) {
        return NOTHING == Iterables.first(vertices.values(vertex));
    }

    private static class BuilderState<V, E> {
        private CyclePolicy cyclePolicy = CyclePolicy.IGNORE;
        private EdgeChecker<V, E> edgeChecker = new AlwaysFollow();
        private EdgeFormatter<V, E> edgeFormatter;
        private Transform<V, String> vertexFormatter;
        private final MultiAssociativeArrays.Builder<V, Pair<V, E>> vertices = MultiAssociativeArrays.builder();

        private BuilderState(AssociativeArray<V, Vertex<V, E>> existing) {
            for (V from : existing) {
                Vertex<V, E> vertex = existing.get(from);
                for (Edge<V, E> edge : vertex.edges()) {
                    this.connect(from, edge.destination().value(), edge.value());
                }
            }
        }

        void connect(V from, V to, E using) {
            this.vertices.add((Pair<V, E>)from, (Pair<Pair<V, E>, E>)Pair.pair(to, using));
        }

        void vertex(V value) {
            Pair nothing = NOTHING;
            this.vertices.add((Pair)value, nothing);
        }
    }

    private static final class AlwaysFollow<V, E>
    implements EdgeChecker<V, E> {
        private AlwaysFollow() {
        }

        @Override
        public boolean follow(V origin, E edge, V destination) {
            return true;
        }
    }

    public static enum CyclePolicy {
        IGNORE,
        REPORT;

    }

    public static class Builder<V, E>
    extends BuilderBase<DirectedGraph<V, E>, BuilderState<V, E>> {
        private Builder(DirectedGraph<V, E> existing) {
            super(existing);
        }

        public Builder<V, E> connect(V from, V to, E using) {
            ((BuilderState)this.state()).connect(from, to, using);
            this.modified();
            return this;
        }

        public boolean contains(V value) {
            return ((DirectedGraph)this.current()).contains(value);
        }

        public Builder<V, E> cyclePolicy(CyclePolicy cyclePolicy) {
            ((BuilderState)this.state()).cyclePolicy = cyclePolicy;
            this.modified();
            return this;
        }

        public Builder<V, E> edgeChecker(EdgeChecker<V, E> edgeChecker) {
            ((BuilderState)this.state()).edgeChecker = edgeChecker;
            this.modified();
            return this;
        }

        public Builder<V, E> edgeFormatter(EdgeFormatter<V, E> edgeFormatter) {
            ((BuilderState)this.state()).edgeFormatter = edgeFormatter;
            this.modified();
            return this;
        }

        public Builder<V, E> vertex(V value) {
            ((BuilderState)this.state()).vertex(value);
            this.modified();
            return this;
        }

        public Builder<V, E> vertexFormatter(Transform<V, String> vertexFormatter) {
            ((BuilderState)this.state()).vertexFormatter = vertexFormatter;
            this.modified();
            return this;
        }

        @Override
        protected BuilderState<V, E> existingState(DirectedGraph<V, E> instance) {
            BuilderState existing = new BuilderState(((DirectedGraph)instance).vertices);
            existing.edgeChecker = ((DirectedGraph)instance).textRenderer.edgeChecker();
            existing.edgeFormatter = ((DirectedGraph)instance).textRenderer.edgeFormatter();
            existing.vertexFormatter = ((DirectedGraph)instance).textRenderer.vertexFormatter();
            return existing;
        }

        @Override
        protected DirectedGraph<V, E> newInstance(BuilderState<V, E> state, Version version) {
            GraphVizDiagram textRenderer = new GraphVizDiagram(((BuilderState)state).edgeChecker, ((BuilderState)state).edgeFormatter, ((BuilderState)state).vertexFormatter);
            Pair<AssociativeArray<V, Vertex<V, E>>, Set<Vertex<V, E>>> verticesAndRoots = this.vertices(state);
            AssociativeArray<V, Vertex<V, E>> vertices = verticesAndRoots.first();
            Set<Vertex<V, E>> roots = verticesAndRoots.second();
            if (CyclePolicy.REPORT.equals((Object)((BuilderState)state).cyclePolicy)) {
                this.checkForCycles(vertices, roots, ((BuilderState)state).edgeChecker, textRenderer);
            }
            return new DirectedGraph<V, E>(vertices, roots, textRenderer);
        }

        private void checkForCycles(AssociativeArray<V, Vertex<V, E>> vertices, Set<Vertex<V, E>> roots, EdgeChecker<V, E> edgeChecker, TextRenderer<V, E> textRenderer) {
            Iterable<Vertex<V, E>> start = AssociativeArrays.values(vertices);
            DepthFirstTraversal<V, E> traverser = new DepthFirstTraversal<V, E>(new Visitor<V, E>(){

                @Override
                public void visit(Vertex<V, E> vertex) {
                }
            }, textRenderer);
            traverser.accept(start);
            ArrayList cycles = new ArrayList();
            for (Path<V, E> cycle : traverser.cycles()) {
                Path<V, E> verified = this.checkPath(cycle, edgeChecker);
                if (verified == null) continue;
                cycles.add(verified);
            }
            if (!cycles.isEmpty()) {
                throw new DirectedGraphCycleException(cycles);
            }
        }

        private Path<V, E> checkPath(Path<V, E> cycle, EdgeChecker<V, E> edgeChecker) {
            if (cycle.direct(edgeChecker)) {
                return cycle;
            }
            return null;
        }

        @Override
        protected BuilderState<V, E> newState(BuilderState<V, E> existing) {
            if (existing == null) {
                return new BuilderState(AssociativeArrays.empty());
            }
            BuilderState newState = new BuilderState(this.vertices(existing).first());
            newState.edgeChecker = ((BuilderState)existing).edgeChecker;
            newState.edgeFormatter = ((BuilderState)existing).edgeFormatter;
            newState.vertexFormatter = ((BuilderState)existing).vertexFormatter;
            return newState;
        }

        private Pair<AssociativeArray<V, Vertex<V, E>>, Set<Vertex<V, E>>> vertices(BuilderState<V, E> state) {
            AssociativeArrays.Builder vertices = AssociativeArrays.builder();
            LinkedHashSet roots = new LinkedHashSet();
            MultiAssociativeArray connections = ((BuilderState)state).vertices.build();
            for (Object from : connections) {
                if (DirectedGraph.isConnectedToNothing(connections, from)) {
                    VertexImpl origin = (VertexImpl)vertices.get(from);
                    if (origin != null) continue;
                    origin = new VertexImpl(from);
                    vertices.add(from, origin);
                    roots.add(origin);
                    continue;
                }
                Iterable targets = connections.values(from);
                for (Pair target : targets) {
                    VertexImpl destination;
                    Object to = target.first();
                    Object using = target.second();
                    VertexImpl origin = (VertexImpl)vertices.get(from);
                    if (origin == null) {
                        origin = new VertexImpl(from);
                        vertices.add(from, origin);
                        roots.add(origin);
                    }
                    if ((destination = (VertexImpl)vertices.get(to)) == null) {
                        destination = new VertexImpl(to);
                        vertices.add(to, destination);
                    } else {
                        roots.remove(destination);
                    }
                    EdgeImpl edge = new EdgeImpl(using, destination);
                    origin.add(edge);
                }
            }
            return Pair.pair(vertices.build(), roots);
        }
    }
}

