/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import oracle.dbtools.common.logging.LogSink;
import oracle.dbtools.common.util.CallStacks;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.logging.Log;

@Provides
public class LogPipe
implements Log {
    private final Iterable<LogSink> sinks;
    private static final int CALLER_STACK_DEPTH = 4;

    @Inject
    public LogPipe(Iterable<LogSink> sinks) {
        this.sinks = sinks;
    }

    public void fine(String msg) {
        this.log(FINE, msg);
    }

    public void fine(Throwable t) {
        this.log(FINE, t);
    }

    public void finer(String msg) {
        this.log(FINER, msg);
    }

    public void finer(Throwable t) {
        this.log(FINER, t);
    }

    public void finest(String msg) {
        this.log(FINEST, msg);
    }

    public void finest(Throwable t) {
        this.log(FINEST, t);
    }

    public void info(String msg) {
        this.log(INFO, msg);
    }

    public void info(Throwable t) {
        this.log(INFO, t);
    }

    public boolean isLoggable(Level level) {
        for (LogSink sink : this.sinks()) {
            if (!sink.isLoggable(level)) continue;
            return true;
        }
        return false;
    }

    public void severe(String msg) {
        this.log(SEVERE, msg);
    }

    public void severe(Throwable t) {
        this.log(SEVERE, t);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LogPipe [sinks=");
        builder.append(this.sinks);
        builder.append("]");
        return builder.toString();
    }

    public void warning(String msg) {
        this.log(WARNING, msg);
    }

    public void warning(Throwable t) {
        this.log(WARNING, t);
    }

    private void log(Level level, Throwable t) {
        LogRecord lr = this.logRecord(level, "");
        lr.setMessage(t == null ? "" : t.getMessage());
        lr.setThrown(t);
        for (LogSink sink : this.sinks()) {
            sink.log(lr);
        }
    }

    private void log(Level level, String msg) {
        LogRecord lr = this.logRecord(level, msg);
        for (LogSink sink : this.sinks()) {
            sink.log(lr);
        }
    }

    private LogRecord logRecord(Level level, String msg) {
        LogRecord lr = new LogRecord(level, msg);
        this.inferCaller(lr);
        return lr;
    }

    private void inferCaller(LogRecord lr) {
        int stackDepth = 4;
        StackTraceElement methodCaller = CallStacks.caller(4);
        lr.setSourceClassName(methodCaller.getClassName());
        lr.setSourceMethodName(methodCaller.getMethodName());
    }

    private Iterable<LogSink> sinks() {
        return this.sinks;
    }
}

