/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import javax.inject.Qualifier;
import oracle.dbtools.common.builder.BuilderBase;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MaybeEmpty;
import oracle.dbtools.plugin.api.di.Annotations;

public class DependencyConstraints
implements MaybeEmpty {
    private final Annotation[] constraints;
    public static final DependencyConstraints NO_CONSTRAINTS = new DependencyConstraints(new Annotation[0]){

        @Override
        public String toString() {
            return "no constraints";
        }
    };
    private static final Annotations ANNOTATIONS = Annotations.INSTANCE;

    private DependencyConstraints(Annotation ... constraints) {
        this.constraints = this.onlyQualifiers(constraints);
    }

    private Annotation[] onlyQualifiers(Annotation ... annotations) {
        if (annotations.length == 0) {
            return annotations;
        }
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>(annotations.length);
        for (Annotation annotation : annotations) {
            boolean isQualifier;
            boolean bl = isQualifier = annotation.annotationType().getAnnotation(Qualifier.class) != null;
            if (!isQualifier) continue;
            qualifiers.add(annotation);
        }
        return qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    public Annotation[] constraints() {
        return this.constraints;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyConstraints other = (DependencyConstraints)obj;
        return Arrays.equals(this.constraints, other.constraints);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.constraints);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.constraints.length == 0;
    }

    public boolean matches(Annotation ... other) {
        return ANNOTATIONS.matches(this.constraints, other);
    }

    public boolean matches(DependencyConstraints other) {
        return ANNOTATIONS.matches(this.constraints, other.constraints);
    }

    public boolean equals(DependencyConstraints other) {
        return ANNOTATIONS.equals(this.constraints, other.constraints);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Annotation constraint : this.constraints) {
            String text = constraint.toString();
            int lastDot = text.lastIndexOf(46);
            if (lastDot == -1) continue;
            b.append("@");
            b.append(text.substring(lastDot + 1));
        }
        return b.toString();
    }

    public static Builder builder() {
        return DependencyConstraints.builder(DependencyConstraints.constraints(new Annotation[0]));
    }

    public static Builder builder(Annotation ... constraints) {
        return DependencyConstraints.builder(DependencyConstraints.constraints(constraints));
    }

    public static Builder builder(DependencyConstraints existing) {
        return new Builder(existing);
    }

    public static DependencyConstraints constraints(Annotation ... constraints) {
        if (constraints.length == 0) {
            return NO_CONSTRAINTS;
        }
        return new DependencyConstraints(constraints);
    }

    private static class InjectionConstraintsState {
        private final List<Annotation> constraints = new ArrayList<Annotation>();

        InjectionConstraintsState(Iterable<Annotation> constraints) {
            Iterables.add(this.constraints, constraints);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InjectionConstraintsState other = (InjectionConstraintsState)obj;
            return !(this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
            return result;
        }

        Annotation[] constraints() {
            Annotation[] constraints = new Annotation[this.constraints.size()];
            return this.constraints.toArray(constraints);
        }
    }

    public static class Builder
    extends BuilderBase<DependencyConstraints, InjectionConstraintsState> {
        protected Builder(DependencyConstraints existing) {
            super(existing);
        }

        public Builder constraint(Annotation constraint) {
            if (Builder.isQualifier(constraint.annotationType())) {
                ((InjectionConstraintsState)this.state()).constraints.add(constraint);
                this.modified();
                return this;
            }
            throw new IllegalArgumentException(constraint.annotationType().getName());
        }

        public <T extends Annotation> Builder constraint(Class<T> type, Object value) {
            return this.constraint(ANNOTATIONS.literal(type, value));
        }

        public <T extends Annotation> Annotations.Builder<T> create(Class<T> constraintType) {
            if (Builder.isQualifier(constraintType)) {
                return ANNOTATIONS.create(constraintType);
            }
            throw new IllegalArgumentException(constraintType.getName());
        }

        public Builder named(String name) {
            return this.constraint(ANNOTATIONS.literal(Named.class, (Object)name));
        }

        @Override
        protected InjectionConstraintsState existingState(DependencyConstraints instance) {
            return new InjectionConstraintsState(Iterables.iterable(instance.constraints));
        }

        @Override
        protected DependencyConstraints newInstance(InjectionConstraintsState state, Version version) {
            if (((InjectionConstraintsState)this.state()).constraints.isEmpty()) {
                return NO_CONSTRAINTS;
            }
            return new DependencyConstraints(state.constraints());
        }

        @Override
        protected InjectionConstraintsState newState(InjectionConstraintsState existing) {
            if (existing == null) {
                return new InjectionConstraintsState(Iterables.empty());
            }
            return new InjectionConstraintsState(existing.constraints);
        }

        private static boolean isQualifier(Class<? extends Annotation> annotation) {
            return annotation.getAnnotation(Qualifier.class) != null;
        }
    }
}

