/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.dbtools.common.config.ConfigurationBase;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.SortedProperties;

public class PropertiesConfiguration
extends ConfigurationBase {
    private final AssociativeArray<String, String> values;

    public PropertiesConfiguration(InputStream content) throws IOException {
        this(PropertiesConfiguration.properties(content));
    }

    public PropertiesConfiguration(Properties properties) {
        this.values = ConfigFiles.asArray(properties);
    }

    @Override
    public Iterable<String> propertyNames() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    protected AssociativeArray<String, String> values() {
        return this.values;
    }

    private static Properties properties(InputStream content) throws IOException {
        SortedProperties props = new SortedProperties();
        ConfigFiles.load(props, content, true);
        return props;
    }
}

