/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.buffers;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.buffers.DiskBuffer;
import oracle.dbtools.common.buffers.MemoryBuffer;
import oracle.dbtools.common.buffers.StreamBuffer;

class DiskOrMemoryBuffer
implements StreamBuffer {
    private DiskBuffer disk = null;
    private MemoryBuffer memory = new MemoryBuffer();
    private OutputStream output = null;

    DiskOrMemoryBuffer() {
    }

    @Override
    public BufferHandle acquire() {
        if (this.output == null) {
            throw new IllegalStateException("No buffer yet created");
        }
        if (this.disk == null) {
            return this.memory.acquire();
        }
        return this.disk.acquire();
    }

    @Override
    public OutputStream open() throws IOException {
        this.output = new DMOutputStream();
        return this.output;
    }

    public String toString() {
        if (this.disk == null && this.memory == null) {
            return super.toString();
        }
        if (this.disk == null) {
            return this.memory.toString();
        }
        return this.disk.toString();
    }

    private class DMOutputStream
    extends FilterOutputStream {
        private long size;

        public DMOutputStream() throws IOException {
            super(DiskOrMemoryBuffer.this.memory.open());
            this.size = 0L;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += (long)b.length;
            super.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.size += (long)len;
            this.checkSize();
            super.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
            super.write(b);
        }

        private void checkSize() throws IOException {
            if (DiskOrMemoryBuffer.this.disk == null && this.size > 4096L) {
                DiskOrMemoryBuffer.this.disk = new DiskBuffer();
                this.out.close();
                byte[] bytes = DiskOrMemoryBuffer.this.memory.bytes();
                this.out = DiskOrMemoryBuffer.this.disk.open();
                this.out.write(bytes);
                DiskOrMemoryBuffer.this.memory.acquire().close();
                DiskOrMemoryBuffer.this.memory = null;
            }
        }
    }
}

