/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.wiz;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public abstract class WizardSummary
extends DefaultTraversablePanel {
    private final JLabel m_headerLabel = new JLabel();
    private final JMultiLineLabel m_hintText = new JMultiLineLabel();
    private final JTree m_summaryTree = new JTree();

    public WizardSummary() {
        this.initLayout();
        this.initRes();
        this.initControls();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add(this.m_headerLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.m_hintText, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add(new JScrollPane(this.m_summaryTree), gbc);
    }

    protected final JLabel getHeaderLabel() {
        return this.m_headerLabel;
    }

    protected final JMultiLineLabel getHintText() {
        return this.m_hintText;
    }

    protected DefaultMutableTreeNode newNode(String text) {
        return new DefaultMutableTreeNode(text);
    }

    protected abstract void initRes();

    private void initControls() {
        this.m_summaryTree.setOpaque(false);
        this.m_summaryTree.setBackground(this.getBackground());
        this.m_summaryTree.setShowsRootHandles(true);
        this.m_summaryTree.setRootVisible(false);
        Font labelFont = this.m_hintText.getFont();
        Font headerFont = new Font(labelFont.getName(), labelFont.getStyle(), (int)((double)labelFont.getSize() * 1.5));
        this.m_headerLabel.setFont(headerFont);
        this.m_summaryTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.setBackgroundNonSelectionColor(tree.getBackground());
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(null);
                return c;
            }
        });
    }

    protected abstract DefaultTreeModel buildTree(TraversableContext var1);

    public final void onEntry(TraversableContext tc) {
        DefaultTreeModel tm = this.buildTree(tc);
        this.m_summaryTree.setModel(tm);
        this.m_summaryTree.repaint();
        WizardSummary.expandAll(this.m_summaryTree);
    }

    private static final void expandAll(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }
}

