/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.util;

import java.util.Collection;
import java.util.List;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceTemplates {
    public static String getSubmitTemplate(List submitFiles, String comment) {
        StringBuilder writeComment = PerforceTemplates.getSubmitTemplate(comment);
        for (int i = 0; i < submitFiles.size(); ++i) {
            writeComment.append("\t" + (String)submitFiles.get(i));
            writeComment.append('\n');
        }
        return writeComment.toString();
    }

    public static String getChangeListTemplate(String description, String changelistNo, ChangelistStatus stat, Collection<ChangeListFile> files, PerforceConnectionProfile connection) throws Exception {
        StringBuilder buf = new StringBuilder("Change: ");
        if (changelistNo.equals(PerforceUtil.getDefaultChangelist(connection))) {
            buf.append("new");
        } else {
            buf.append(changelistNo);
        }
        buf.append("\n");
        buf.append("Client:");
        buf.append(connection.getClient());
        buf.append("\n");
        buf.append("User:");
        buf.append(connection.getUser());
        buf.append("\n");
        buf.append("Status: ");
        buf.append(stat.getStatus());
        buf.append("\n");
        buf.append("Description:");
        buf.append(description);
        buf.append("\n");
        buf.append("Files:");
        buf.append("\n");
        if (!files.isEmpty()) {
            for (ChangeListFile fileCL : files) {
                buf.append("\t");
                buf.append(fileCL.getDepotFile());
                buf.append("  # ");
                buf.append(fileCL.getAction());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static String getSubmitListTemplate(String description, String changelistNo, ChangelistStatus stat, Collection<ChangeListFile> files, PerforceConnectionProfile connection) throws Exception {
        StringBuilder buf = new StringBuilder("Change: ");
        if (changelistNo.equals(PerforceUtil.getDefaultChangelist(connection))) {
            buf.append("new");
        } else {
            buf.append(changelistNo);
        }
        buf.append("\n");
        buf.append("Client:");
        buf.append(connection.getClient());
        buf.append("\n");
        buf.append("User:");
        buf.append(connection.getUser());
        buf.append("\n");
        buf.append("Status: ");
        buf.append(stat.getStatus());
        buf.append("\n");
        buf.append("Description:");
        buf.append(description);
        buf.append("\n");
        buf.append("Files:");
        buf.append("\n");
        if (!files.isEmpty()) {
            for (ChangeListFile fileCL : files) {
                buf.append("\t");
                buf.append(fileCL.getDepotFile());
                buf.append("  # ");
                buf.append(fileCL.getAction());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static String getSubmitTemplate(String submitFile, String comment) {
        StringBuilder writeComment = PerforceTemplates.getSubmitTemplate(comment);
        writeComment.append("\t" + submitFile);
        writeComment.append('\n');
        return writeComment.toString();
    }

    private static StringBuilder getSubmitTemplate(String comment) {
        String[] lines = comment.split("\n");
        StringBuilder writeComment = new StringBuilder();
        writeComment.append("Change: new");
        writeComment.append('\n');
        writeComment.append("Description:");
        writeComment.append('\n');
        for (String line : lines) {
            writeComment.append("\t");
            writeComment.append(line);
            writeComment.append("\n");
        }
        writeComment.append('\n');
        writeComment.append("Files:");
        writeComment.append('\n');
        return writeComment;
    }

    public static enum ChangelistStatus {
        NEW("new"),
        PENDING("pending"),
        SUBMITTED("submitted");

        private String status;

        private ChangelistStatus(String value) {
            this.status = value;
        }

        String getStatus() {
            return this.status;
        }
    }
}

