/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceOperationException;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.ClientInfo;
import oracle.jdevimpl.vcs.perforce2.util.PerforceLoginProcess;
import oracle.jdevimpl.vcs.perforce2.util.PerforceSubmitted;
import oracle.jdevimpl.vcs.perforce2.util.PerforceTemplates;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceCommands {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceCommands.class.getName());

    public static PerforceLoginProcess getTestConnectionLogin(String username, char[] password, String server) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("-p");
        cmds.add(server);
        cmds.add("-u");
        cmds.add(username);
        cmds.add("login");
        PerforceLoginProcess login = new PerforceLoginProcess(cmds, username);
        login.setCmdPasswd(password);
        login.execAndWait();
        return login;
    }

    public static boolean logout(String server, String username) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        StringBuilder sb = new StringBuilder();
        sb.append("-p ");
        sb.append(server);
        sb.append(" -u ");
        sb.append(username);
        sb.append(" logout");
        runner.setCommand(sb.toString());
        runner.setQuiet(true);
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    public static Map<String, ClientInfo> getUserClientSpec(String user, String port, boolean clientUser) throws Exception {
        PerforceShellRunner client = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        PerforceCommands.globalOptPort(port, cmds);
        if (user != null && user.length() > 0) {
            cmds.add("-u");
            cmds.add(user);
        }
        cmds.add("clients");
        if (clientUser && user != null && user.length() > 0) {
            cmds.add("-u");
            cmds.add(user);
        }
        client.setCmdList(cmds);
        client.setQuiet(true);
        client.exec();
        if (client.getExitCode() == null || client.getExitCode() != 0) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_CLIENTS_FAILED_TITLE"), PerforceArb.get("ERROR_CLIENTS_FAILED"), client.getErrorText());
        }
        return PerforceCommands.getClients(client.getOutputText());
    }

    public static Map<String, ClientInfo> getUserClientSpecForNamedFilter(String server, String user, String filter) throws Exception {
        PerforceShellRunner client = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        PerforceCommands.globalOptPort(server, cmds);
        cmds.add("clients");
        cmds.add("-e");
        cmds.add(filter);
        client.setCmdList(cmds);
        client.setQuiet(true);
        client.exec();
        if (client.getExitCode() == null || client.getExitCode() != 0) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_CLIENTS_FAILED_TITLE"), PerforceArb.get("ERROR_CLIENTS_FAILED"), client.getErrorText());
        }
        return PerforceCommands.getClients(client.getOutputText());
    }

    public static void submit(PerforceShellRunner runner, String comment, PerforceConnectionProfile connect) throws Exception {
        PerforceFstatResult[] results = PerforceGetStatus.fstat(connect, runner.getFiles());
        ArrayList<String> reopenFiles = new ArrayList<String>();
        ArrayList<String> submitFiles = new ArrayList<String>();
        for (PerforceFstatResult result : results) {
            String changelist = result.getChangelist();
            if (changelist != null && !changelist.equals("default")) {
                reopenFiles.add(result.getDepotFile());
            }
            submitFiles.add(result.getDepotFile());
        }
        if (reopenFiles.size() > 0) {
            PerforceShellRunner reopen = new PerforceShellRunner();
            reopen.setConnection(connect);
            reopen.setCmdArray(new String[]{"reopen", "-c", "default"});
            reopen.setFiles(reopenFiles);
            reopen.exec();
        }
        PerforceCommands.writeComment(runner, submitFiles, comment);
        try {
            runner.setFiles(null);
            runner.exec();
        }
        catch (IOException ioe) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_SUBMIT_COMMAND_TITLE"), PerforceArb.get("ERROR_SUBMIT_COMMAND_FAILED"), ioe.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_SUBMIT_FAILED_TITLE"), PerforceArb.get("ERROR_SUBMIT_FAILED"), runner.getErrorText());
        }
    }

    public static PerforceSubmitted submitChangelist(String changelistNo, String comment, PerforceConnectionProfile connect) throws PerforceProcessException {
        PerforceSubmitted submitted = new PerforceSubmitted();
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        runner.setConnection(connect);
        cmds.add("submit");
        cmds.add("-c");
        cmds.add(changelistNo);
        cmds.add("-i");
        runner.setCmdList(cmds);
        runner.addOutputMonitor(submitted);
        try {
            runner.setInputData(PerforceTemplates.getSubmitListTemplate(comment, changelistNo, PerforceTemplates.ChangelistStatus.PENDING, Collections.EMPTY_LIST, connect));
            runner.exec();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Failed to submit changelist " + changelistNo, e);
            throw new PerforceProcessException(PerforceArb.get("CHANGELIST_ERROR_TITLE"), PerforceArb.format("SUBMIT_CHANGELIST_ERROR", changelistNo), e.getMessage() != null ? e.getMessage() : "");
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            String errTxt = runner.getErrorText();
            sLogger.log(Level.WARNING, "Failed to submit changelist " + changelistNo + ". Error " + errTxt);
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("CHANGELIST_ERROR_TITLE"));
            throw new PerforceProcessException(PerforceArb.get("CHANGELIST_ERROR_TITLE"), PerforceArb.format("SUBMIT_CHANGELIST_ERROR", changelistNo), errTxt != null ? errTxt : "");
        }
        return submitted;
    }

    public static boolean existInRepository(URL exist, PerforceConnectionProfile connect) throws PerforceProcessException {
        URL root = PerforceSessionManager.getInstance().getClientRootFolder(connect);
        String folder = URLFileSystem.toRelativeSpec((URL)exist, (URL)root) + "...";
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>(2);
        cmds.add(folder);
        runner.setCommand("files ");
        runner.setConnection(connect);
        runner.setOptionDirURL(root);
        runner.setFiles(cmds);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                throw new PerforceProcessException(PerforceArb.get("ERROR_FILES_EXIST_TITLE"), PerforceArb.format("ERROR_FILE_EXIST", folder), runner.getErrorText());
            }
            String message = runner.getOutputText();
            String[] lines = message.split("\n");
            if (lines.length > 1) {
                return true;
            }
            if (lines.length == 1 && lines[0].startsWith("//")) {
                return true;
            }
        }
        catch (Exception e) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_FILES_EXIST_TITLE"), PerforceArb.format("ERROR_FILE_EXIST", folder), runner.getErrorText());
        }
        return false;
    }

    public static String getPreviousRevision(URL url, String revision) throws Exception {
        int previous;
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        PerforceShellRunner runner = new PerforceShellRunner();
        String filename = PerforceUtil.convertToAscii(URLFileSystem.getPlatformPathName((URL)url));
        boolean found = false;
        try {
            previous = Integer.parseInt(revision);
        }
        catch (NumberFormatException fe) {
            throw new PerforceOperationException(PerforceArb.get("ERROR_TITLE_DIFF"), PerforceArb.format("ERROR_DIFF_PREVIOUS", filename));
        }
        runner.setCommand("fstat");
        runner.setConnection(connect);
        runner.setQuiet(true);
        while (!found) {
            ArrayList<String> cmds = new ArrayList<String>(1);
            StringBuffer buffer = new StringBuffer();
            buffer.append(filename);
            buffer.append('#');
            buffer.append(--previous);
            cmds.add(buffer.toString());
            runner.setFiles(cmds);
            try {
                runner.exec();
            }
            catch (Exception e) {
                throw new PerforceOperationException(PerforceArb.get("ERROR_TITLE_DIFF"), PerforceArb.format("ERROR_DIFF_PREVIOUS", filename));
            }
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                throw new PerforceProcessException(PerforceArb.get("ERROR_TITLE_DIFF"), PerforceArb.format("ERROR_DIFF_PREVIOUS", filename), runner.getErrorText());
            }
            if (previous == 0) {
                throw new PerforceOperationException(PerforceArb.get("ERROR_TITLE_DIFF"), PerforceArb.format("ERROR_DIFF_PREVIOUS", filename));
            }
            String[] output = runner.getOutputText().split("\\.\\.\\.");
            if (output.length <= 0) continue;
            found = true;
        }
        return String.valueOf(previous);
    }

    public static boolean isLocallyModified(URL url) {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        PerforceShellRunner runner = new PerforceShellRunner();
        String filename = URLFileSystem.getPlatformPathName((URL)url);
        ArrayList<String> cmds = new ArrayList<String>(2);
        cmds.add("-sa");
        cmds.add(filename);
        runner.setCommand("diff");
        runner.setConnection(connect);
        runner.setQuiet(true);
        runner.setFiles(cmds);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                return false;
            }
            String output = runner.getOutputText();
            if (output != null && output.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Collection<ChangeListFile> getFilesOnChangelist(PerforceConnectionProfile connect, String changelistNo) throws PerforceOperationException {
        PerforceShellRunner runner = new PerforceShellRunner();
        ChangelistMonitor monitor = new ChangelistMonitor();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("describe");
        cmds.add("-s");
        cmds.add(changelistNo);
        runner.setCmdList(cmds);
        runner.setConnection(connect);
        runner.addOutputMonitor(monitor);
        runner.setQuiet(false);
        try {
            runner.exec();
        }
        catch (Exception ex) {
            sLogger.log(Level.WARNING, " Failed to find files on changelist ");
            throw new PerforceOperationException(PerforceArb.format("ERROR_FILES_DEFAULT_CHANGE_LIST", changelistNo));
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            sLogger.log(Level.WARNING, " Failed to find files on changelist " + runner.getErrorText());
            throw new PerforceOperationException(runner.getErrorText());
        }
        return monitor.getChangelistFiles();
    }

    public static Collection<ChangeListFile> getOpenFilesOnChangelist(PerforceConnectionProfile connect, String changelistNo) throws PerforceOperationException {
        PerforceShellRunner runner = new PerforceShellRunner();
        ChangelistOpenFileMonitor monitor = new ChangelistOpenFileMonitor();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("opened");
        cmds.add("-c");
        cmds.add(changelistNo);
        runner.setCmdList(cmds);
        runner.setConnection(connect);
        runner.addOutputMonitor(monitor);
        runner.setQuiet(false);
        try {
            runner.exec();
        }
        catch (Exception ex) {
            sLogger.log(Level.WARNING, " Failed to find open files on changelist ");
            throw new PerforceOperationException(PerforceArb.format("ERROR_FILES_DEFAULT_CHANGE_LIST", changelistNo));
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            sLogger.log(Level.WARNING, " Failed to find open files on changelist " + runner.getErrorText());
            throw new PerforceOperationException(runner.getErrorText());
        }
        return monitor.getChangelistFiles();
    }

    public static String createChangeList(PerforceConnectionProfile connect, String description, Collection<ChangeListFile> files) throws Exception {
        String[] s = description.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]);
            if (i + 1 >= s.length) continue;
            sb.append('\n');
            sb.append('\t');
        }
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("change");
        cmds.add("-i");
        runner.setConnection(connect);
        runner.setCmdList(cmds);
        runner.setInputData(PerforceTemplates.getChangeListTemplate(sb.toString(), PerforceUtil.getDefaultChangelist(connect), PerforceTemplates.ChangelistStatus.NEW, files, connect));
        runner.setQuiet(true);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                sLogger.log(Level.WARNING, " Failed to create pending changelist " + runner.getErrorText());
                throw new PerforceOperationException(runner.getErrorText());
            }
        }
        catch (Exception ex) {
            sLogger.log(Level.WARNING, " Failed to create pending changelist ");
            throw new PerforceOperationException(PerforceArb.get("ERROR_CHANGE_LIST"));
        }
        return PerforceCommands.extractChangeListNo(runner.getOutputText());
    }

    private static void writeComment(PerforceShellRunner runner, List submitFiles, String comment) {
        runner.setInputData(PerforceTemplates.getSubmitTemplate(submitFiles, comment));
    }

    private static void globalOptPort(String port, List cmds) {
        if (port != null && port.length() > 0) {
            cmds.add("-p");
            cmds.add(port);
        }
    }

    private static void globalOptUser(String user, List cmds) {
        if (user != null && user.length() > 0) {
            cmds.add("-u");
            cmds.add(user);
        }
    }

    private static Map<String, ClientInfo> getClients(String log) {
        if (log == null) {
            return null;
        }
        Pattern separatorRE = Pattern.compile("\\n", 8);
        String[] clients = separatorRE.split(log);
        if (clients[0].isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ClientInfo> perforceClients = new HashMap<String, ClientInfo>(clients.length);
        String root = "root";
        for (int c = 0; c < clients.length; ++c) {
            String folder = null;
            String description = null;
            int pos = clients[c].indexOf("root");
            int pos2 = clients[c].indexOf("'", pos += "root".length());
            if (pos2 > -1 && pos2 + 1 < clients[c].length()) {
                folder = clients[c].substring(pos, pos2).trim();
                ++pos2;
                int dpos = clients[c].lastIndexOf("'");
                if (dpos > 0) {
                    description = clients[c].substring(pos2, dpos).trim();
                }
            }
            ClientInfo cInfo = new ClientInfo(PerforceCommands.getClientName(clients[c]), folder);
            cInfo.setDescription(description);
            perforceClients.put(cInfo.getName(), cInfo);
        }
        return perforceClients;
    }

    public static Locatable[] getPendingChangelistNodes(VCSProfile profile, Context context) {
        if (context.getSelection() == null || context.getSelection().length == 0) {
            return new Locatable[0];
        }
        Element[] elements = context.getSelection();
        ArrayList<Locatable> loc = new ArrayList<Locatable>(elements.length);
        URLFilter filter = profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.PENDING_CHANGELIST");
        for (Element elm : elements) {
            if (!filter.accept(((Locatable)elm).getURL())) continue;
            loc.add((Locatable)elm);
        }
        return loc.toArray(new Locatable[0]);
    }

    public static URL createUniqueURL(URL parent, String file) throws PerforceProcessException {
        try {
            String revisionFile;
            URL tempURL;
            URL dir = parent;
            if (!URLFileSystem.canWrite((URL)parent)) {
                dir = URLFactory.newURL((String)Ide.getUserSettingsDirectory());
            }
            if (URLFileSystem.exists((URL)(tempURL = URLFactory.newURL((URL)dir, (String)(revisionFile = file.replaceFirst("#", "-Revision#")))))) {
                tempURL = URLFileSystem.createTempFile((String)revisionFile, (String)"tmp", (URL)dir);
            }
            return tempURL;
        }
        catch (IOException e) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_RESOLVE_TITLE"), PerforceArb.format("ERROR_CREATE_LOCAL_FILE", file), e.getMessage());
        }
    }

    private static String getClientName(String log) {
        String client = "Client";
        int pos = log.indexOf("Client");
        int possp = log.indexOf(" ", pos += "Client".length() + 1);
        return log.substring(pos, possp);
    }

    private static String extractChangeListNo(String outputText) {
        String[] parts = outputText.split(" ");
        if (parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    private static class ChangelistOpenFileMonitor
    extends VCSStreamMonitor {
        private Collection<ChangeListFile> _files = new ArrayList<ChangeListFile>();

        private ChangelistOpenFileMonitor() {
        }

        Collection getChangelistFiles() {
            return this._files;
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            String[] sections = line.split(" - ");
            if (sections.length == 2) {
                ChangeListFile clFile = new ChangeListFile();
                clFile.setDepotFile(sections[0]);
                String[] actions = sections[1].split(" ");
                clFile.setAction(actions[0]);
                this._files.add(clFile);
            }
        }
    }

    private static class ChangelistMonitor
    extends VCSStreamMonitor {
        private Collection<ChangeListFile> _files = new ArrayList<ChangeListFile>();

        private ChangelistMonitor() {
        }

        Collection getChangelistFiles() {
            return this._files;
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            if (line.startsWith("...")) {
                int hash = line.lastIndexOf("#");
                int space = line.indexOf(" ", hash);
                ChangeListFile clFile = new ChangeListFile();
                clFile.setDepotFile(line.substring(line.indexOf("//"), space).trim());
                clFile.setAction(line.substring(space).trim());
                this._files.add(clFile);
            }
        }
    }
}

