/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.util;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.generic.util.AbstractIdentifiable;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;

public class HeadRevisionURLFilter
extends AbstractIdentifiable
implements URLFilter {
    private static Logger slogger = PerforceProfile.getQualifiedLogger(HeadRevisionURLFilter.class.getName());

    public boolean accept(URL url) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        try {
            VCSStatus stat = (VCSStatus)profile.getPolicyStatusCache().get(url);
            if (stat.isVersioned()) {
                PerforceRevisionNumber rev = PerforceURLInfoCache.getInstance().getRevisionInfo(url);
                return rev.isHead();
            }
        }
        catch (Exception e) {
            slogger.log(Level.WARNING, "Failed to determine if " + url.getPath() + " is at head revision");
        }
        return false;
    }
}

