/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdevimpl.vcs.generic.util.AbstractIdentifiable;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class ExistRemoteURLFilter
extends AbstractIdentifiable
implements URLFilter {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(ExistRemoteURLFilter.class.getName());

    public boolean accept(URL url) {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        URL root = PerforceSessionManager.getInstance().getClientRootFolder(connect);
        String folder = URLFileSystem.toRelativeSpec((URL)url, (URL)root) + "...";
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>(2);
        cmds.add(folder);
        runner.setCommand("files ");
        runner.setConnection(connect);
        runner.setOptionDirURL(root);
        runner.setFiles(cmds);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                sLogger.log(Level.SEVERE, PerforceArb.format("ERROR_FILE_EXIST", folder) + runner.getErrorText());
            } else {
                String message = runner.getOutputText();
                String[] lines = message.split("\n");
                if (lines.length > 1) {
                    return true;
                }
                if (lines.length == 1 && lines[0].startsWith("//")) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.SEVERE, PerforceArb.format("ERROR_FILE_EXIST", folder) + runner.getErrorText());
        }
        return false;
    }
}

