/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLDetail;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceChangelistSelectionListener;
import oracle.jdevimpl.vcs.perforce2.ui.SelectionEvent;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class SelectChangelistPanel
extends JPanel {
    private JLabel _lblChangelist = new JLabel();
    private CheckBoxList _cblChangelist;
    private JScrollPane _scPane;
    private Collection<PerforceChangelistSelectionListener> _listeners = new HashSet<PerforceChangelistSelectionListener>();

    public SelectChangelistPanel(Collection<CLDetail> changelists) {
        try {
            this.initComponents(changelists);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getDefaultComponent() {
        return this._cblChangelist;
    }

    public CLDetail getSelectedChangelist() {
        CheckBoxListModel model = (CheckBoxListModel)this._cblChangelist.getModel();
        List select = model.getSelectionList();
        if (select == null) {
            return null;
        }
        return (CLDetail)select.get(0);
    }

    public int getSelectionCount() {
        CheckBoxListModel model = (CheckBoxListModel)this._cblChangelist.getModel();
        List select = model.getSelectionList();
        if (select == null) {
            return 0;
        }
        return select.size();
    }

    public void addChangelistListener(PerforceChangelistSelectionListener listener) {
        this._listeners.add(listener);
    }

    public void removeChangelistListener(PerforceChangelistSelectionListener listener) {
        this._listeners.remove(listener);
    }

    private void jbInit() throws Exception {
        Insets ins = new Insets(2, 5, 2, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._lblChangelist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this._scPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    private CheckBoxListModel createCheckboxModel(Collection<CLDetail> changelist) {
        CheckBoxListModel model = new CheckBoxListModel();
        for (CLDetail cl : changelist) {
            try {
                String label = PerforceUtil.getLongLabel(cl.getConnectionProfile(), cl.getChangelistNo());
                if (PerforceConnectionManager.getInstance().list().size() > 1) {
                    label = label + " - " + cl.getConnectionProfile().toString();
                }
                model.addElement((Object)cl, null, true, true, label);
            }
            catch (Exception exception) {}
        }
        return model;
    }

    private void initComponents(Collection changelists) {
        CheckBoxListModel model = this.createCheckboxModel(changelists);
        this._cblChangelist = new CheckBoxList(model);
        this._scPane = new JScrollPane((Component)this._cblChangelist);
        ResourceUtils.resLabel((JLabel)this._lblChangelist, (Component)this._cblChangelist, (String)PerforceArb.get("CHANGELIST_MORE_ONE_PROMPT"));
        model.addCheckBoxStateListener(new CheckBoxListItemStateListener(){

            public void stateChanged(Object source) {
                Iterator it = SelectChangelistPanel.this._listeners.iterator();
                SelectionEvent event = new SelectionEvent(SelectChangelistPanel.this.getSelectionCount());
                while (it.hasNext()) {
                    ((PerforceChangelistSelectionListener)it.next()).stateChanged(event);
                }
            }
        });
    }
}

