/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceOtherFstat;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforcePropertiesPanelUI
extends JPanel {
    private JLabel lbldepot = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField fldDepot = new JTextField();
    private JLabel lblclient = new JLabel();
    private JTextField fldclient = new JTextField();
    private JLabel lbltype = new JLabel();
    private JTextField fldtype = new JTextField();
    private JLabel lblheadrevision = new JLabel();
    private JTextField fldheadrevison = new JTextField();
    private JLabel lblhaverevision = new JLabel();
    private JTextField fldhaverevision = new JTextField();
    private JLabel lblheadaction = new JLabel();
    private JTextField fldheadaction = new JTextField();
    private JLabel lblmodified = new JLabel();
    private JTextField fldmodified = new JTextField();
    private JLabel lblLocked = new JLabel();
    private JTextField fldLocked = new JTextField();
    private JLabel lblChangelist = new JLabel();
    private JTextField fldChangelist = new JTextField();
    private JLabel lblopenby = new JLabel();
    private GenericTable tlbopenby = new GenericTable();

    public PerforcePropertiesPanelUI() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getDefaultComponent() {
        return this.fldDepot;
    }

    public void populate(PerforceFstatResult status) {
        this.fldDepot.setText(status.getDepotFile());
        this.fldclient.setText(status.getClientFile());
        this.fldtype.setText(status.getHeadType());
        this.fldheadrevison.setText(String.valueOf(status.getHeadRev()));
        this.fldhaverevision.setText(String.valueOf(status.getHaveRev()));
        this.fldheadaction.setText(status.getHeadAction());
        this.fldLocked.setText(String.valueOf(status.isLocked()));
        this.fldChangelist.setText(status.getChangelist());
        Date modified = new Date(status.getHeadTime() * 1000L);
        this.fldmodified.setText(DateFormat.getDateTimeInstance().format(modified));
        OpenTableModel model = new OpenTableModel();
        if (status.getActionOwner() != null) {
            model.add(status.getActionOwner(), status.getAction());
        }
        for (PerforceOtherFstat other : status.getOtherDetails()) {
            model.add(other.getOpenUser(), other.getAction());
        }
        this.tlbopenby.setModel((TableModel)((Object)model));
        this.tlbopenby.autoSizeColumnsToFit();
    }

    private void jbInit() throws Exception {
        Insets ins = new Insets(5, 5, 2, 5);
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.lbldepot, (Component)this.fldDepot, (String)PerforceArb.get("PROPERTIES_DEPOT"));
        this.fldDepot.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lblclient, (Component)this.fldclient, (String)PerforceArb.get("PROPERTIES_CLIENT"));
        this.fldclient.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lbltype, (Component)this.fldtype, (String)PerforceArb.get("PROPERTIES_FILE_TYPE"));
        this.fldtype.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lblheadrevision, (Component)this.fldheadrevison, (String)PerforceArb.get("PROPERTIES_HEAD_REVISION"));
        this.fldheadrevison.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lblhaverevision, (Component)this.fldhaverevision, (String)PerforceArb.get("PROPERTIES_HAVE_REVISION"));
        this.fldhaverevision.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lblheadaction, (Component)this.fldheadaction, (String)PerforceArb.get("PROPERTIES_HEAD_ACTION"));
        this.fldheadaction.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lblmodified, (Component)this.fldmodified, (String)PerforceArb.get("PROPERTIES_MODIFIED"));
        this.fldmodified.setEditable(false);
        ResourceUtils.resLabel((JLabel)this.lblopenby, (Component)this.tlbopenby, (String)PerforceArb.get("PROPERTIES_OPEN_BY"));
        ResourceUtils.resLabel((JLabel)this.lblLocked, (Component)this.fldLocked, (String)PerforceArb.get("PROPERTIES_IS_LOCKED"));
        ResourceUtils.resLabel((JLabel)this.lblChangelist, (Component)this.fldChangelist, (String)PerforceArb.get("PROPERTIES_CHANGELIST"));
        this.fldLocked.setEditable(false);
        this.fldChangelist.setEditable(false);
        JScrollPane tablePane = new JScrollPane((Component)this.tlbopenby);
        tablePane.setPreferredSize(new Dimension(100, 80));
        this.add((Component)this.lbldepot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldDepot, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblclient, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldclient, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lbltype, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldtype, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblheadrevision, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldheadrevison, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblhaverevision, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldhaverevision, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblheadaction, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldheadaction, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblmodified, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldmodified, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblLocked, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldLocked, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblChangelist, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldChangelist, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblopenby, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, ins, 0, 0));
        this.add((Component)tablePane, new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    private static class OpenTableModel
    extends GenericBaseTableModel {
        private List data = new ArrayList();
        private String[] colName = new String[]{PerforceArb.get("PROPERTIES_USER_COLUMN"), PerforceArb.get("PROPERTIES_ACTION_COLUMN")};

        public void add(String col1, String col2) {
            this.data.add(new String[]{col1, col2});
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex > this.data.size()) {
                return null;
            }
            String[] row = (String[])this.data.get(rowIndex);
            return row[columnIndex];
        }

        public String getColumnName(int column) {
            return this.colName[column];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return null;
        }
    }
}

